/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow;

import ilog.views.IlvManagerView;
import ilog.views.IlvPoint;
import ilog.views.sdm.IlvSDMEngine;
import ilog.views.sdm.IlvSDMModel;
import ilog.views.sdm.model.IlvSDMNode;
import java.awt.Component;
import java.awt.Window;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.diagram.core.context.IdeContextPlugin;
import oracle.diagram.core.editor.Diagram;
import oracle.diagram.sdm.context.SDMDiagramContextUtil;
import oracle.diagram.sdm.palette.interactor.MakeSDMNodeInteractor;
import oracle.diagram.sdm.undo.SDMAddObjectCommand;
import oracle.diagram.sdm.undo.SDMEngineAdjustingCommand;
import oracle.diagram.sdm.undo.SDMEngineCommand;
import oracle.diagram.sdm.undo.SDMUndoFilter;
import oracle.dmt.dataminer.CommonLrb;
import oracle.dmt.dataminer.navigator.ProjectFolder;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.WorkflowEditor;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.WorkflowUtils;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.AbstractObject;
import oracle.dmt.dataminer.workflow.model.ApplyChainNode;
import oracle.dmt.dataminer.workflow.model.ApplyTextNode;
import oracle.dmt.dataminer.workflow.model.BuildTextNode;
import oracle.dmt.dataminer.workflow.model.BuildTextNodeRef;
import oracle.dmt.dataminer.workflow.model.GeneralLink;
import oracle.dmt.dataminer.workflow.model.WorkflowModel;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.BuildTextNodeRefType;
import oracle.dmt.dataminer.workflow.xmlschema.BuildTextNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.DataNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeReference;
import oracle.dmt.dataminer.workflow.xmlschema.NodeStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.StoplistType;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationSourceAttribute;
import oracle.dmt.dataminer.workflow.xmlschema.TransformedAttributesType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.Pair;

public class ApplyChainGenerator {
    private static final Logger theLogger = Logger.getLogger(ApplyChainGenerator.class.getName());
    private WorkflowEditor view;
    private Diagram diagram;
    private IlvManagerView mgrView;
    private IlvSDMEngine engine;
    private SDMUndoFilter filterModel;
    private WorkflowModel wfModel;

    public ApplyChainGenerator(WorkflowEditor workflowEditor, Diagram diagram) {
        this.view = workflowEditor;
        this.diagram = diagram;
        this.mgrView = workflowEditor.getActiveManagerView();
        this.engine = SDMDiagramContextUtil.getSDMEngine((IlvManagerView)this.mgrView);
        this.filterModel = (SDMUndoFilter)this.engine.getModel();
        this.wfModel = WorkflowUtils.getFilteredModel(this.filterModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateApplyChain() throws Exception {
        ArrayList<AbstractNode> arrayList = new ArrayList<AbstractNode>();
        ArrayList<GeneralLink> arrayList2 = new ArrayList<GeneralLink>();
        HashMap<AbstractObject, Pair> hashMap = new HashMap<AbstractObject, Pair>();
        ArrayList<AbstractObject> arrayList3 = new ArrayList<AbstractObject>();
        ArrayList<Object> arrayList4 = new ArrayList<Object>();
        HashMap<AbstractNode, AbstractObject> hashMap2 = new HashMap<AbstractNode, AbstractObject>();
        if (this.engine != null) {
            Iterator<Object> iterator = this.engine.getSelectedObjects();
            while (iterator.hasMoreElements()) {
                Object object = iterator.nextElement();
                if (object instanceof AbstractNode) {
                    arrayList.add((AbstractNode)object);
                    continue;
                }
                if (!(object instanceof GeneralLink)) continue;
                arrayList2.add((GeneralLink)object);
            }
        } else {
            throw new RuntimeException("Unexpected state encountered");
        }
        if (!this.validateSelectionChain(this.wfModel, arrayList, arrayList2)) {
            return;
        }
        CommandProcessor.getInstance().beginTrans(WorkflowEditorLrb.get("GENERATE_APPLY_CHAIN"));
        this.invokeCommand((Command)new SDMEngineAdjustingCommand(this.engine, true));
        try {
            AbstractObject abstractObject;
            for (AbstractNode abstractNode : arrayList) {
                NodeType nodeType;
                abstractObject = null;
                IlvPoint ilvPoint = WorkflowUtils.getViewPoint(abstractNode, this.mgrView);
                ilvPoint.translate(20.0f, 20.0f);
                if (!(abstractNode instanceof BuildTextNode)) {
                    abstractObject = (AbstractNode)this.filterModel.createNode(abstractNode.getTag());
                    nodeType = (NodeType)MetaDataHelper.copyMetadataObject(abstractNode.getData());
                    nodeType.setId(((AbstractNode)abstractObject).getData().getId());
                    nodeType.setName(((AbstractNode)abstractObject).getData().getName());
                    if (nodeType instanceof DataNodeType) {
                        ((DataNodeType)nodeType).setSQLExpression(null);
                    }
                    hashMap.put(abstractObject, new Pair((Object)ilvPoint, (Object)nodeType));
                    hashMap2.put(abstractNode, abstractObject);
                    continue;
                }
                nodeType = this.generateApplyTextPair((BuildTextNode)abstractNode, this.filterModel);
                IlvPoint ilvPoint2 = new IlvPoint(ilvPoint);
                ilvPoint2.translate(0.0f, 100.0f);
                hashMap.put((AbstractNode)nodeType.getFirst(), new Pair((Object)ilvPoint, null));
                hashMap.put((AbstractNode)nodeType.getSecond(), new Pair((Object)ilvPoint2, null));
                GeneralLink generalLink = this.generateApplyTextLink((Pair<ApplyTextNode, BuildTextNodeRef>)nodeType, this.filterModel);
                arrayList3.add(generalLink);
                hashMap2.put(abstractNode, (AbstractNode)nodeType.getFirst());
            }
            for (GeneralLink generalLink : arrayList2) {
                abstractObject = (GeneralLink)this.filterModel.createLink(generalLink.getTag());
                ((GeneralLink)abstractObject).setFrom((IlvSDMNode)hashMap2.get(generalLink.getFrom()));
                ((GeneralLink)abstractObject).setTo((IlvSDMNode)hashMap2.get(generalLink.getTo()));
                arrayList3.add(abstractObject);
            }
            for (Map.Entry entry : hashMap.entrySet()) {
                this.invokeCommand((Command)new SDMAddObjectCommand((IlvSDMModel)this.filterModel, entry.getKey(), null, null));
                abstractObject = (NodeType)((Pair)entry.getValue()).getSecond();
                if (abstractObject == null) continue;
                ((AbstractNode)entry.getKey()).setProperty("nodetype", abstractObject);
            }
            for (GeneralLink generalLink : arrayList3) {
                this.invokeCommand((Command)new SDMAddObjectCommand((IlvSDMModel)this.filterModel, (Object)generalLink, null, null));
            }
            for (AbstractNode abstractNode : hashMap.keySet()) {
                if (abstractNode instanceof ApplyChainNode) {
                    ((ApplyChainNode)((Object)abstractNode)).refactorForApply();
                    continue;
                }
                if (abstractNode instanceof ApplyTextNode || abstractNode instanceof BuildTextNodeRef) continue;
                throw new RuntimeException("Invalid node type selected");
            }
            for (AbstractNode abstractNode : hashMap.keySet()) {
                abstractNode.validate(false);
            }
            for (Map.Entry entry : hashMap.entrySet()) {
                this.invokeMoveObjectTo((AbstractNode)entry.getKey(), (IlvPoint)((Pair)entry.getValue()).getFirst(), this.engine);
            }
        }
        catch (Exception exception) {
            CommandProcessor.getInstance().abortTrans();
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception, (String)CommonLrb.get("MSG_EXCEPTION"));
        }
        finally {
            this.invokeCommand((Command)new SDMEngineAdjustingCommand(this.engine, false));
            if (CommandProcessor.getInstance().isTransactionActive()) {
                CommandProcessor.getInstance().endTrans();
                this.engine.deselectAllObjects();
                arrayList4.addAll(hashMap.keySet());
                arrayList4.addAll(arrayList3);
                this.engine.setSelected(arrayList4.toArray(new Object[arrayList4.size()]), true);
                arrayList4.clear();
                arrayList3.clear();
                hashMap.clear();
                arrayList2.clear();
                arrayList.clear();
                hashMap2.clear();
            }
        }
    }

    private Pair<ApplyTextNode, BuildTextNodeRef> generateApplyTextPair(BuildTextNode buildTextNode, SDMUndoFilter sDMUndoFilter) {
        ApplyTextNode applyTextNode = (ApplyTextNode)sDMUndoFilter.createNode(ApplyTextNode.class.getSimpleName());
        BuildTextNodeRef buildTextNodeRef = (BuildTextNodeRef)sDMUndoFilter.createNode(BuildTextNodeRef.class.getSimpleName());
        Pair pair = new Pair((Object)applyTextNode, (Object)buildTextNodeRef);
        this.copyTextNodeAttrs((BuildTextNodeType)buildTextNode.getData(), (BuildTextNodeRefType)buildTextNodeRef.getData());
        this.setReferenceNode((BuildTextNodeType)buildTextNode.getData(), (BuildTextNodeRefType)buildTextNodeRef.getData());
        return pair;
    }

    private void copyTextNodeAttrs(BuildTextNodeType buildTextNodeType, BuildTextNodeRefType buildTextNodeRefType) {
        AttributeType attributeType;
        int n;
        buildTextNodeRefType.getCaseAttributes().getAttribute().clear();
        for (n = 0; n < buildTextNodeType.getCaseAttributes().getAttribute().size(); ++n) {
            attributeType = (AttributeType)MetaDataHelper.copyMetadataObject(buildTextNodeType.getCaseAttributes().getAttribute().get(n));
            buildTextNodeRefType.getCaseAttributes().getAttribute().add(attributeType);
        }
        buildTextNodeRefType.getStoplists().getStoplist().clear();
        for (n = 0; n < buildTextNodeType.getStoplists().getStoplist().size(); ++n) {
            attributeType = (StoplistType)MetaDataHelper.copyMetadataObject(buildTextNodeType.getStoplists().getStoplist().get(n));
            buildTextNodeRefType.getStoplists().getStoplist().add(attributeType);
        }
        buildTextNodeRefType.getTransformationSourceAttributes().getTransformationSourceAttributeType().clear();
        for (n = 0; n < buildTextNodeType.getTransformationSourceAttributes().getTransformationSourceAttributeType().size(); ++n) {
            attributeType = (TransformationSourceAttribute)buildTextNodeType.getTransformationSourceAttributes().getTransformationSourceAttributeType().get(n);
            TransformationSourceAttribute transformationSourceAttribute = (TransformationSourceAttribute)MetaDataHelper.copyMetadataObject(attributeType);
            buildTextNodeRefType.getTransformationSourceAttributes().getTransformationSourceAttributeType().add(transformationSourceAttribute);
        }
        buildTextNodeRefType.getTransformedAttributes().getMapTextTransformedSource().clear();
        TransformedAttributesType transformedAttributesType = (TransformedAttributesType)MetaDataHelper.copyMetadataObject(buildTextNodeType.getTransformedAttributes());
        buildTextNodeRefType.setTransformedAttributes(transformedAttributesType);
    }

    private void setReferenceNode(BuildTextNodeType buildTextNodeType, BuildTextNodeRefType buildTextNodeRefType) {
        NodeReference nodeReference = buildTextNodeRefType.getNodeReference();
        if (nodeReference == null) {
            nodeReference = new NodeReference();
        }
        WorkflowNode workflowNode = this.view.getWorkflowNode();
        ProjectFolder projectFolder = ProjectFolder.getProjectFolder(this.view.getContext());
        nodeReference.setNodeId(BigInteger.valueOf(Long.parseLong(buildTextNodeType.getId())));
        nodeReference.setNodeName(buildTextNodeType.getName());
        nodeReference.setProjectId(BigInteger.valueOf(projectFolder.getId().longValue()));
        nodeReference.setProjectName(projectFolder.getLabel());
        nodeReference.setWorkflowId(BigInteger.valueOf(workflowNode.getId().longValue()));
        nodeReference.setWorkflowName(workflowNode.getLabel());
        buildTextNodeRefType.setNodeReference(nodeReference);
        buildTextNodeRefType.setStatus(NodeStatusType.COMPLETE);
    }

    private GeneralLink generateApplyTextLink(Pair<ApplyTextNode, BuildTextNodeRef> pair, SDMUndoFilter sDMUndoFilter) {
        GeneralLink generalLink = (GeneralLink)sDMUndoFilter.createLink(GeneralLink.class.getSimpleName());
        generalLink.setTo((IlvSDMNode)pair.getFirst());
        generalLink.setFrom((IlvSDMNode)pair.getSecond());
        return generalLink;
    }

    private void invokeMoveObjectTo(final AbstractNode abstractNode, final IlvPoint ilvPoint, final IlvSDMEngine ilvSDMEngine) {
        this.invokeCommand((Command)new SDMEngineCommand(Ide.findOrCreateCmdID((String)(MakeSDMNodeInteractor.class.getName() + ".moveObject")), 0, "", ilvSDMEngine){

            protected int doitImpl() throws Exception {
                ilvSDMEngine.moveObject((Object)abstractNode, ApplyChainGenerator.this.mgrView, ilvPoint.x, ilvPoint.y, false, 16, true);
                return 0;
            }

            protected int undoImpl() throws Exception {
                return 0;
            }
        });
    }

    private boolean validateSelectionChain(WorkflowModel workflowModel, List<AbstractNode> list, List<GeneralLink> list2) {
        if (list.size() == 1 && list2.size() > 0) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)WorkflowEditorLrb.get("GENERATE_CODE_VALIDATION_MESG_1"), (String)WorkflowEditorLrb.get("GENERATE_CODE_VALIDATION_TITLE"), (String)"generateApplyChainHelp");
            return false;
        }
        if (list.size() > 1 && list2.size() == 0) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)WorkflowEditorLrb.get("GENERATE_CODE_VALIDATION_MESG_1"), (String)WorkflowEditorLrb.get("GENERATE_CODE_VALIDATION_TITLE"), (String)"generateApplyChainHelp");
            return false;
        }
        for (AbstractNode object2 : list) {
            if (!(object2 instanceof ApplyChainNode)) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)WorkflowEditorLrb.get("GENERATE_CODE_VALIDATION_MESG_2"), (String)WorkflowEditorLrb.get("GENERATE_CODE_VALIDATION_TITLE"), (String)"generateApplyChainHelp");
                return false;
            }
            if (object2.getState() != NodeStatusType.FAILURE && object2.getState() != NodeStatusType.READY && object2.getState() != NodeStatusType.INVALID) continue;
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)WorkflowEditorLrb.get("GENERATE_CODE_VALIDATION_MESG_3"), (String)WorkflowEditorLrb.get("GENERATE_CODE_VALIDATION_TITLE"), (String)"generateApplyChainHelp");
            return false;
        }
        for (GeneralLink generalLink : list2) {
            if (list.contains(generalLink.getFrom()) && list.contains(generalLink.getTo())) continue;
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)WorkflowEditorLrb.get("GENERATE_CODE_VALIDATION_MESG_1"), (String)WorkflowEditorLrb.get("GENERATE_CODE_VALIDATION_TITLE"), (String)"generateApplyChainHelp");
            return false;
        }
        List<AbstractNode> list3 = AbstractNode.findAllRootNodes(list);
        Iterator iterator = list3.iterator();
        while (iterator.hasNext()) {
            AbstractNode abstractNode = (AbstractNode)iterator.next();
            if (this.validateChain(workflowModel, abstractNode, list.contains(abstractNode), list, list2)) continue;
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)WorkflowEditorLrb.get("GENERATE_CODE_VALIDATION_MESG_1"), (String)WorkflowEditorLrb.get("GENERATE_CODE_VALIDATION_TITLE"), (String)"generateApplyChainHelp");
            return false;
        }
        return true;
    }

    private boolean validateChain(WorkflowModel workflowModel, AbstractNode abstractNode, boolean bl, List<AbstractNode> list, List<GeneralLink> list2) {
        List<AbstractNode> list3 = abstractNode.findChildNodes();
        for (AbstractNode abstractNode2 : list3) {
            boolean bl2 = list.contains(abstractNode2);
            if (bl && bl2 && !this.isLinkSelected(abstractNode, abstractNode2, list2, workflowModel)) {
                return false;
            }
            if (bl && !bl2) {
                List<AbstractNode> list4 = abstractNode2.findAllChildNodes();
                for (AbstractNode abstractNode3 : list4) {
                    if (!list.contains(abstractNode3)) continue;
                    return false;
                }
                continue;
            }
            if (this.validateChain(workflowModel, abstractNode2, bl2, list, list2)) continue;
            return false;
        }
        return true;
    }

    private boolean isLinkSelected(AbstractNode abstractNode, AbstractNode abstractNode2, List<GeneralLink> list, WorkflowModel workflowModel) {
        List<GeneralLink> list2 = workflowModel.findLinksFromNode((IlvSDMNode)abstractNode);
        for (GeneralLink generalLink : list2) {
            if (generalLink.getTo() != abstractNode2 || !list.contains(generalLink)) continue;
            return true;
        }
        return false;
    }

    private void invokeCommand(Command command) {
        Context context = ((IdeContextPlugin)this.diagram.getDiagramContext().getPlugin(IdeContextPlugin.class)).getContext();
        command.setContext(context);
        try {
            CommandProcessor.getInstance().invoke(command);
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
    }
}

