/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.wizard.workflow;

import java.awt.Component;
import java.awt.Dimension;
import java.sql.SQLException;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import oracle.bali.ewt.dialog.DialogHeader;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dmt.dataminer.DataminerGUIPanel;
import oracle.dmt.dataminer.controls.TextFieldLimit;
import oracle.dmt.dataminer.controls.dialog.DialogDisplayable;
import oracle.dmt.dataminer.controls.dialog.DialogExecutionException;
import oracle.dmt.dataminer.controls.dialog.Dialogable;
import oracle.dmt.dataminer.controls.dialog.DialogableExecutableAdapter;
import oracle.dmt.dataminer.exception.DataMinerException;
import oracle.dmt.dataminer.navigator.BaseDeferredFilter;
import oracle.dmt.dataminer.navigator.BaseTreeNode;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.ProjectFolder;
import oracle.dmt.dataminer.navigator.ProjectFolderFilter;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.dmt.dataminer.repository.Workflow;
import oracle.dmt.dataminer.res.DataMinerIcons;
import oracle.dmt.dataminer.res.Icons;
import oracle.dmt.dataminer.wizard.workflow.WorkflowDialogState;
import oracle.dmt.dataminer.wizard.workflow.WorkflowLrb;
import oracle.dmt.dataminer.workflow.WorkflowUtils;
import oracle.ide.Context;
import oracle.ide.dialogs.ProgressException;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.ide.explorer.TNode;
import oracle.ide.explorer.TreeExplorer;
import oracle.ide.model.Element;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ide.util.ResourceUtils;

public class WorkflowPanel
extends JPanel
implements DataminerGUIPanel,
DialogDisplayable {
    private Context context;
    private WorkflowDialogState state;
    private boolean editMode;
    private JTextField _jName;
    private JLabel _jNameLabel;

    public WorkflowPanel(Context context) {
        this.context = context;
        this.state = new WorkflowDialogState(context);
        this.editMode = this.state.isWorkflowModelEditMode();
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this._jNameLabel = new JLabel();
        this._jName = new JTextField();
        this.setMinimumSize(new Dimension(330, 50));
        this.setPreferredSize(new Dimension(330, 50));
        this._jNameLabel.setDisplayedMnemonic('N');
        this._jNameLabel.setLabelFor(this._jName);
        this._jNameLabel.setText("Name:");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this._jNameLabel, -2, 50, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._jName, -1, 300, Short.MAX_VALUE).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._jNameLabel).addComponent(this._jName, -2, -1, -2)).addContainerGap()));
        this._jName.getAccessibleContext().setAccessibleDescription("Project name");
    }

    @Override
    public void initUI() {
        this._jName.setText(this.state.getName());
    }

    @Override
    public void initRes() {
        ResourceUtils.resLabel((JLabel)this._jNameLabel, (Component)this._jName, (String)WorkflowLrb.get("CREATE_WORKFLOW_NAME"));
        this._jNameLabel.getAccessibleContext().setAccessibleDescription(WorkflowLrb.get("CREATE_WORKFLOW_NAME_ADA"));
        this._jNameLabel.getAccessibleContext().setAccessibleName(WorkflowLrb.get("CREATE_WORKFLOW_NAME"));
        this._jName.getAccessibleContext().setAccessibleDescription(WorkflowLrb.get("CREATE_WORKFLOW_NAME_ADA"));
        this._jName.getAccessibleContext().setAccessibleName(WorkflowLrb.get("CREATE_WORKFLOW_NAME"));
        this._jName.setDocument(new TextFieldLimit(30));
    }

    public void validateAndWriteToState() {
        String string = this.editMode ? WorkflowLrb.get("EDIT_WORKFLOW_FAILURE_TITLE") : WorkflowLrb.get("CREATE_WORKFLOW_FAILURE_TITLE");
        boolean bl = false;
        try {
            Workflow workflow;
            ConnectionFolder connectionFolder;
            Object object;
            ValidateWriteThread validateWriteThread = new ValidateWriteThread();
            if (!this.editMode) {
                object = this._jName.getText().trim();
                connectionFolder = ConnectionFolder.getConnectionFolder(this.context);
                if (!WorkflowUtils.validateWorkflowName(connectionFolder, (String)object, this.context)) {
                    throw new DataMinerException(string, WorkflowLrb.get("ERROR_MSG_INVALID_NAME"));
                }
                this.state.setName((String)object);
                workflow = this.state.finish();
                bl = true;
            } else {
                validateWriteThread.setTitle(WorkflowLrb.get("WIZARD_EDITING_WORKFLOW_TITLE"));
                validateWriteThread.setMessage(WorkflowLrb.get("WIZARD_EDITING_WORKFLOW_MESG"));
                validateWriteThread.setCancelable(false);
                validateWriteThread.start(true);
                bl = validateWriteThread.getValidation();
                if (bl) {
                    workflow = validateWriteThread.getWorkflowObj();
                } else {
                    throw new DataMinerException(string, WorkflowLrb.get("ERROR_MSG_VALIDATION_ERROR"));
                }
            }
            if (!this.editMode) {
                if (workflow == null) {
                    throw new DataMinerException(string, WorkflowLrb.get("ERROR_MSG_NULL_OBJ"));
                }
                object = (BaseTreeNode)this.context.getElement();
                connectionFolder = ((NavigatorWindow)this.context.getView()).getTreeExplorer();
                TNode tNode = this.findProjectFolder((TreeExplorer)connectionFolder, (BaseTreeNode)object, this.context);
                WorkflowNode workflowNode = this.createWorkflowNode(tNode, workflow);
                this.addWorkflowNode(this.context, workflowNode);
            }
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException.getMessage(), sQLException);
        }
        catch (ProgressException progressException) {
            String string2 = this.editMode ? WorkflowLrb.get("EDIT_WORKFLOW_FAILURE_MESG") : WorkflowLrb.get("CREATE_WORKFLOW_FAILURE_MESG");
            throw new RuntimeException(string2, progressException.getCause());
        }
    }

    private WorkflowNode createWorkflowNode(TNode tNode, Workflow workflow) {
        ProjectFolder projectFolder = (ProjectFolder)tNode.getData();
        WorkflowNode workflowNode = ProjectFolderFilter.getWorkflowNode(projectFolder.getURL().getPath() + "/" + workflow.getName(), true);
        workflowNode.setRepositoryData(workflow);
        workflowNode.setId(workflow.getId());
        workflowNode.setParent(tNode);
        return workflowNode;
    }

    private TNode findProjectFolder(TreeExplorer treeExplorer, BaseTreeNode baseTreeNode, Context context) {
        TNode tNode = null;
        TNode tNode2 = null;
        if (!(baseTreeNode instanceof ConnectionFolder)) {
            if (baseTreeNode instanceof ProjectFolder) {
                tNode = treeExplorer.searchTNode((Element)baseTreeNode, treeExplorer.getRoot(), context);
                tNode2 = tNode.getAncestorTNode(ProjectFolder.class, false);
                assert (tNode2 != null) : "Did not find TNode for ConnectionFolder!";
            } else {
                tNode2 = baseTreeNode.getParent();
            }
        } else {
            tNode2 = treeExplorer.searchTNode((Element)baseTreeNode, baseTreeNode.getParent(), context);
        }
        BaseDeferredFilter.getChildTreeNodes(tNode2);
        return tNode2;
    }

    private void addWorkflowNode(Context context, WorkflowNode workflowNode) {
        ProjectFolder projectFolder = ProjectFolder.getProjectFolder(context);
        projectFolder.add((Element)workflowNode, true);
        projectFolder.markDirty(false);
        workflowNode.selectAndOpen(context);
    }

    @Override
    public Dialogable asDialog() {
        return new DialogableExecutableAdapter(){

            @Override
            public void onOK() throws DialogExecutionException {
                WorkflowPanel.this.validateAndWriteToState();
            }

            @Override
            public String getTitle() {
                return WorkflowLrb.get("CREATE_WORKFLOW_DIALOG_TITLE");
            }

            @Override
            public String getHelpTopic() {
                return "workflows.htm";
            }

            @Override
            public JComponent getContent() {
                return WorkflowPanel.this;
            }

            @Override
            public void customizeDialogProperties(JEWTDialog jEWTDialog) {
                super.customizeDialogProperties(jEWTDialog);
                DialogHeader dialogHeader = new DialogHeader();
                dialogHeader.setHeaderImage(DataMinerIcons.get(Icons.CREATE_WORKFLOW_DIALOG).getImage());
                dialogHeader.setHeaderDescription(WorkflowLrb.get("CREATE_WORKFLOW_DESCRIPTION"));
                jEWTDialog.setDialogHeader((Component)dialogHeader);
            }
        };
    }

    class ValidateWriteThread
    extends ProgressRunnable {
        private boolean validated = true;
        private Workflow _workflowObj;
        private String workflowName;

        ValidateWriteThread() {
        }

        public boolean getValidation() {
            return this.validated;
        }

        public Workflow getWorkflowObj() {
            return this._workflowObj;
        }

        protected Object doWork() throws Exception {
            ConnectionFolder connectionFolder;
            boolean bl = false;
            this.workflowName = WorkflowPanel.this._jName.getText();
            this.workflowName = this.workflowName.trim();
            if (WorkflowPanel.this.editMode && WorkflowPanel.this.state.getName().equals(this.workflowName)) {
                bl = true;
            }
            if (!bl && !WorkflowUtils.validateWorkflowName(connectionFolder = ConnectionFolder.getConnectionFolder(WorkflowPanel.this.context), this.workflowName, WorkflowPanel.this.context)) {
                this.validated = false;
            }
            if (!this.validated) {
                return this.validated;
            }
            WorkflowPanel.this.state.setName(this.getProjectName());
            this._workflowObj = WorkflowPanel.this.state.finish();
            return this.validated;
        }

        public String getProjectName() {
            return this.workflowName;
        }
    }
}

