/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.wizard;

import java.awt.Component;
import oracle.dmt.dataminer.wizard.WizardModel;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.javatools.dialogs.ExceptionDialog;

public abstract class AbstractWizardPage
extends DefaultTraversablePanel {
    protected TraversableContext _context;
    protected boolean _onPage = false;
    protected boolean _uiInitialized = false;

    protected boolean canGoBack() {
        return true;
    }

    public final void completeValueChanged() {
        if (this._onPage && this._context != null) {
            this.updateWizardButtons();
        }
    }

    protected void pageSelected(TraversableContext traversableContext) {
        if (this.isUiInitialized() && !this.getDirty(this.getPageDirtyKey())) {
            this.onEntryAfterInit(traversableContext);
            return;
        }
        this.initUI();
        this.setUiInitialized(true);
    }

    protected void save(TraversableContext traversableContext) {
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        try {
            if (!this.doValidation(traversableContext)) {
                throw new TraversalException(null);
            }
        }
        catch (TraversalException traversalException) {
            throw traversalException;
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)((Object)this), (Throwable)exception);
            throw new TraversalException(null);
        }
        this.save(traversableContext);
        this.pageDeselected(traversableContext);
        if (traversableContext.getDirection() == 1 && this.getDirty(this.getPageDirtyKey())) {
            this.setDirty(false, this.getPageDirtyKey());
        }
        this._onPage = false;
    }

    protected void pageDeselected(TraversableContext traversableContext) throws TraversalException {
    }

    protected final TraversableContext getTraversableContext() {
        return this._context;
    }

    public void setUiInitialized(boolean bl) {
        this._uiInitialized = bl;
    }

    public Component getInitialFocus() {
        return null;
    }

    public final boolean getDirty(String string) {
        Object object = this.getTraversableContext().get(string);
        return object != null;
    }

    protected void onEntryAfterInit(TraversableContext traversableContext) {
    }

    public void onEntry(TraversableContext traversableContext) {
        this._onPage = true;
        this._context = traversableContext;
        Component component = this.getInitialFocus();
        if (component != null) {
            traversableContext.getWizardCallbacks().wizardSetInitialFocus(component);
        }
        this.pageSelected(traversableContext);
    }

    public boolean isComplete() {
        return true;
    }

    protected void updateWizardButtons() {
        boolean bl = this.isComplete();
        this._context.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(this.canGoBack()), Boolean.valueOf(bl), Boolean.valueOf(this.canFinish()));
    }

    protected WizardModel getModel(TraversableContext traversableContext) {
        return (WizardModel)traversableContext.get("wizardModel");
    }

    public boolean isUiInitialized() {
        return this._uiInitialized;
    }

    public final void setDirty(boolean bl, String string) {
        TraversableContext traversableContext = this.getTraversableContext();
        if (bl) {
            traversableContext.put(string, new Object());
        } else {
            traversableContext.remove(string);
        }
    }

    public boolean canFinish() {
        return false;
    }

    public abstract void initUI();

    public abstract String getPageDirtyKey();

    protected abstract boolean doValidation(TraversableContext var1);
}

