/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.utils;

import java.awt.Component;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.utils.UtilsLrb;
import oracle.dmt.dataminer.workflow.WorkflowEditor;
import oracle.dmt.dataminer.workflow.WorkflowUtils;
import oracle.dmt.dataminer.workflow.inspect.table.TablePIPropertyLrb;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;

public class TableNameValidator {
    private static final int MAXIMUM = 30;
    private static final int MAXIMUM_EX = 128;

    public static boolean validateTableName(String string, List<String> list, Context context, boolean bl) {
        boolean bl2 = true;
        if (string.length() != 0) {
            if (!StringUtils.isDoubleQuotedString(string) && !TableNameValidator.isNameValidNonQuoted(string, bl)) {
                return false;
            }
            if (!TableNameValidator.isNameValid(string = !StringUtils.isDoubleQuotedString(string) ? string.toUpperCase() : StringUtils.trimDoubleQuotes(string), bl)) {
                return false;
            }
            if (!TableNameValidator.isNameUnique(string, list, bl)) {
                return false;
            }
            if (!TableNameValidator.isNameLengthValidInDB(context, string, bl)) {
                return false;
            }
            if (TableNameValidator.isDuplicateName(string)) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)TablePIPropertyLrb.get("PI_CREATE_TABLE_NOT_UNIQUE_MSG"), (String)TablePIPropertyLrb.get("PI_CREATE_TABLE_SYSTEM_ERROR_TITLE"), null);
                return false;
            }
        }
        return bl2;
    }

    private static boolean isDuplicateName(String string) {
        boolean bl = false;
        Editor editor = EditorManager.getEditorManager().getCurrentEditor();
        if (editor instanceof WorkflowEditor) {
            WorkflowEditor workflowEditor = (WorkflowEditor)editor;
            bl = workflowEditor.doesNodeNameAlreadyExist(string);
        }
        return bl;
    }

    public static boolean isNameValidNonQuoted(String string, boolean bl) {
        if (StringUtils.isValidNonQuotedDBObjectName(string)) {
            return true;
        }
        if (bl) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)UtilsLrb.get("TABLE_NAME_ERROR_NAME_UNQUOTED_INVALID"), (String)UtilsLrb.get("TABLE_NAME_ERROR_TITLE"), null);
        }
        return false;
    }

    public static boolean isNameValid(String string, boolean bl) {
        if (StringUtils.isDoubleQuotedString(string) && bl) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)UtilsLrb.get("TABLE_NAME_ERROR_NAME_INVALID"), (String)UtilsLrb.get("TABLE_NAME_ERROR_TITLE"), null);
            return false;
        }
        if (WorkflowUtils.validateDBObjectName(string)) {
            return true;
        }
        if (bl) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)UtilsLrb.get("TABLE_NAME_ERROR_NAME_INVALID"), (String)UtilsLrb.get("TABLE_NAME_ERROR_TITLE"), null);
        }
        return false;
    }

    public static boolean isNameLengthValidInDB(Context context, String string, boolean bl) {
        boolean bl2;
        boolean bl3 = false;
        ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(context);
        bl3 = StringUtils.checkStringDBLengthMax(string, connectionFolder, (bl2 = SQLHelper.isExpandedObjNameEnabled(context)) ? 128 : 30, false);
        if (!bl3 && bl) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)UtilsLrb.get("TABLE_NAME_ERROR_NAME_INVALID"), (String)UtilsLrb.get("TABLE_NAME_ERROR_TITLE"), null);
        }
        return bl3;
    }

    public static boolean isNameUnique(String string, List<String> list, boolean bl) {
        if (list == null) {
            return true;
        }
        for (String string2 : list) {
            if (string2 == null || string2.compareTo(string) != 0) continue;
            if (bl) {
                return MessageDialog.confirmOrCancel((Component)Ide.getMainWindow(), (Object)UtilsLrb.get("TABLE_NAME_ERROR_NAME_DUPLICATE"), (String)UtilsLrb.get("TABLE_NAME_ERROR_TITLE"), null) == 1;
            }
            return false;
        }
        return true;
    }

    public static boolean isTableNameUnique(Context context, String string) {
        boolean bl = false;
        try {
            ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(context);
            Collection<String> collection = WorkflowUtils.getAllKnownTableNames(connectionFolder, context);
            if (!collection.contains(string)) {
                bl = true;
            }
        }
        catch (SQLException sQLException) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)sQLException, (String)UtilsLrb.get("TABLE_NAME_ERROR_TITLE"), (String)UtilsLrb.get("NAME_ERROR_UNEXPECTED_FAILURE_MESG"), null);
        }
        return bl;
    }
}

