/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.utils;

import java.awt.Component;
import java.util.concurrent.ExecutionException;
import javax.swing.JComponent;
import javax.swing.SwingWorker;
import oracle.dmt.dataminer.CommonLrb;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.utils.TableMessages;
import oracle.dmt.dataminer.utils.UITools;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.ui.BlockingComponent;

public abstract class ODMrSwingWorker<T, V>
extends SwingWorker<T, V> {
    private JComponent component;
    private DataMinerTable[] tables;
    private BlockingComponent overlayPanel;

    public ODMrSwingWorker(JComponent jComponent) {
        this(jComponent, null, new DataMinerTable[0]);
    }

    public ODMrSwingWorker(JComponent jComponent, BlockingComponent blockingComponent) {
        this(jComponent, blockingComponent, new DataMinerTable[0]);
    }

    public ODMrSwingWorker(JComponent jComponent, BlockingComponent blockingComponent, DataMinerTable ... dataMinerTableArray) {
        assert (dataMinerTableArray != null) : "Tables list cant be null";
        this.component = jComponent;
        this.overlayPanel = blockingComponent;
        this.tables = dataMinerTableArray;
        this.init();
    }

    private void init() {
        this.setTableMessage(TableMessages.LOADING.getMessage());
        this.beforeExecute();
        this.displayOverlay();
    }

    protected void beforeExecute() {
    }

    private void displayOverlay() {
        if (this.overlayPanel != null) {
            this.overlayPanel.setState(BlockingComponent.State.BLOCKED);
            this.overlayPanel.setMessage(BlockingComponent.Message.LOADING);
        }
    }

    @Override
    protected final void done() {
        try {
            this.onDone();
        }
        catch (InterruptedException | ExecutionException exception) {
            this.setTableMessage(TableMessages.ERROR.getMessage());
            this.onFailure(exception.getCause());
        }
        catch (Exception exception) {
            this.setTableMessage(TableMessages.ERROR.getMessage());
            this.onFailureOnSuccess(exception);
        }
        finally {
            this.hideOverlay();
            this.onFinally();
        }
    }

    private void onDone() throws Exception {
        this.setTableMessage(TableMessages.NO_RESULTS.getMessage());
        this.preSuccess();
        this.onSuccess(this.get());
    }

    protected void onFailure(Throwable throwable) {
        ExceptionDialog.showExceptionDialog((Component)UITools.getParentWindow(this.component), (Throwable)throwable, (String)CommonLrb.get("ERROR"), (String)CommonLrb.get("MSG_EXCEPTION"), null);
    }

    protected void onFailureOnSuccess(Exception exception) {
        this.onFailure(exception);
    }

    private void hideOverlay() {
        if (this.overlayPanel != null) {
            this.overlayPanel.setState(BlockingComponent.State.UNBLOCKED);
        }
    }

    protected void onFinally() {
    }

    protected void preSuccess() {
    }

    protected abstract void onSuccess(T var1) throws Exception;

    protected void setTableMessage(String string) {
        boolean bl = TableMessages.SUCCESS.getMessage().equals(string) || TableMessages.NO_RESULTS.getMessage().equals(string);
        for (DataMinerTable dataMinerTable : this.tables) {
            if (bl) {
                dataMinerTable.setNoEntryInstructionText(string);
                continue;
            }
            dataMinerTable.displayMessage(string);
        }
    }
}

