/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.utils;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.sql.Connection;
import javax.swing.JDialog;
import oracle.dmt.dataminer.utils.ConfigUtils;
import oracle.dmt.dataminer.utils.ConfigurationWorkerPanel;
import oracle.dmt.dataminer.utils.UtilsLrb;
import oracle.ide.Context;
import oracle.ide.Ide;

public class ConfigurationWorkerDialog
extends JDialog {
    private ConfigUtils.RunMode runMode;
    private Context context;
    private boolean success;
    private ConfigurationWorkerPanel dialogPanel = null;
    private static String sysAccountName;
    private Connection conn;
    private String connName;
    private boolean migrateWorkflowORToBinary = false;
    private String migrationASMTableSpace = null;

    public ConfigurationWorkerDialog(Connection connection, String string, ConfigUtils.RunMode runMode, String string2, String string3, boolean bl, String string4, Context context) {
        super((Frame)Ide.getMainWindow(), true);
        ConfigUtils.closeConnectionFolder(context);
        this.conn = connection;
        this.connName = string;
        sysAccountName = "SYS";
        this.runMode = runMode;
        this.context = context;
        this.migrateWorkflowORToBinary = bl;
        this.migrationASMTableSpace = string4;
        this.success = false;
        if (runMode == ConfigUtils.RunMode.INSTALLSCHEMA_OR || runMode == ConfigUtils.RunMode.INSTALLSCHEMA_BINARY) {
            this.setTitle(UtilsLrb.get("CONFIG_TITLE_INSTALLER"));
        } else if (runMode == ConfigUtils.RunMode.GRANTS) {
            this.setTitle(UtilsLrb.get("CONFIG_TITLE_GRANTOR"));
        } else if (runMode == ConfigUtils.RunMode.DROP_REPOS) {
            this.setTitle(UtilsLrb.get("CONFIG_DROP_REPOS"));
        } else if (runMode == ConfigUtils.RunMode.UPGRADE_REPOS_OR || runMode == ConfigUtils.RunMode.UPGRADE_REPOS_BINARY) {
            this.setTitle(UtilsLrb.get("CONFIG_MIGRATE_REPOS"));
        }
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                if (ConfigurationWorkerDialog.this.dialogPanel.isDone()) {
                    ConfigurationWorkerDialog.this.setVisible(false);
                    return;
                }
            }
        });
        this.dialogPanel = new ConfigurationWorkerPanel(this, connection, string, runMode, string2, string3, bl, string4, sysAccountName, context);
        this.getContentPane().add(this.dialogPanel);
        this.pack();
        this.setLocationRelativeTo((Component)Ide.getMainWindow());
        this.setVisible(true);
    }

    public boolean getResult() {
        return this.success;
    }
}

