/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.tviewer.matrix;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.dmt.dataminer.controls.models.SimpleBaseTableModel;
import oracle.dmt.dataminer.tviewer.TestViewerLrb;

class PMatrixSummaryTableModel
extends SimpleBaseTableModel {
    private static final String[] COLUMNS = new String[]{TestViewerLrb.get("PMATRIX_TARGET_VALUE"), TestViewerLrb.get("PMATRIX_TOTAL_ACTUALS"), TestViewerLrb.get("PMATRIX_CORRECT_PERC_PREDICTED"), TestViewerLrb.get("PMATRIX_COST"), TestViewerLrb.get("PMATRIX_COST_PERC")};
    private Map<Integer, Integer> columnMap = new HashMap<Integer, Integer>();
    private Double totalActuals;
    private Double totalPredited;
    private Double totalCost;
    private String resultName;
    private List[] summaryInfo;

    public PMatrixSummaryTableModel(String string, List[] listArray, Double d, Double d2, Double d3) {
        this.totalActuals = d;
        this.totalPredited = d2;
        this.totalCost = d3;
        this.resultName = string;
        this.columnMap = new HashMap<Integer, Integer>();
        this.columnMap.put(0, 0);
        this.columnMap.put(1, 1);
        this.columnMap.put(2, 5);
        this.columnMap.put(3, 3);
        this.columnMap.put(4, 7);
        this.summaryInfo = listArray;
        this.setColumnIdentifiers(COLUMNS);
        if (null == listArray[0]) {
            this.setRowCount(0);
        } else {
            this.setRowCount(listArray[0].size());
        }
    }

    public String getResultName() {
        return this.resultName;
    }

    public List[] getSummaryInfo() {
        return this.summaryInfo;
    }

    public Double getTotalActuals() {
        return this.totalActuals;
    }

    public Double getTotalPredicted() {
        return this.totalPredited;
    }

    public Double getTotalCost() {
        return this.totalCost;
    }

    public Double getCorrectPredictionPercentage() {
        if (this.totalActuals == 0.0) {
            return 0.0;
        }
        return this.totalPredited / this.totalActuals * 100.0;
    }

    public Object getValueAt(int n, int n2) {
        List list = this.summaryInfo[this.columnMap.get(n2)];
        if (list == null) {
            return null;
        }
        Object e = list.get(n);
        if (n2 == 0) {
            return e;
        }
        if (e == null) {
            if (n2 == 1) {
                return 0;
            }
            if (n2 == 2) {
                return 0.0;
            }
            return null;
        }
        if (e instanceof BigDecimal) {
            return ((BigDecimal)e).doubleValue();
        }
        return e;
    }
}

