/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.tviewer;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import oracle.dmt.dataminer.core.model.common.build.partition.CompareMode;
import oracle.dmt.dataminer.core.model.common.build.partition.PartitionVO;
import oracle.dmt.dataminer.navigator.AbstractTestNode;
import oracle.dmt.dataminer.navigator.BaseTreeNode;
import oracle.dmt.dataminer.navigator.TestResultNode;
import oracle.dmt.dataminer.partition.AbstractPartitionToolbar;
import oracle.dmt.dataminer.partition.PartitionsLrb;
import oracle.dmt.dataminer.repository.TestResult;
import oracle.dmt.dataminer.tviewer.TestCompareNode;
import oracle.ide.Context;
import oracle.ide.editor.Editor;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.HyperlinkButton;

public class TestViewerPartitionToolbar
extends AbstractPartitionToolbar<TestViewerPartitionToolbar> {
    private static final Map<String, TestViewerVirtualInstance> TOOLBAR_MAP = new HashMap<String, TestViewerVirtualInstance>();
    private JPanel componentsPanel;
    private ButtonGroup jCompareGroup;
    private JLabel jCompareLevel;
    private JRadioButton jModelRadio;
    private HyperlinkButton jPartitionHyperlink;
    private JRadioButton jPartitionRadio;
    private JButton jSearchPartitionButton;

    public TestViewerPartitionToolbar() {
        super(new TestViewerVirtualInstance(CompareMode.MODEL, null, null, null));
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.jCompareGroup = new ButtonGroup();
        this.jCompareLevel = new JLabel();
        this.componentsPanel = new JPanel();
        this.jModelRadio = new JRadioButton();
        this.jPartitionRadio = new JRadioButton();
        this.jPartitionHyperlink = new HyperlinkButton();
        this.jSearchPartitionButton = new JButton();
        FlowLayout flowLayout = new FlowLayout(0, 0, 0);
        flowLayout.setAlignOnBaseline(true);
        this.setLayout(flowLayout);
        this.jCompareLevel.setText("Comparison Level:");
        this.jCompareLevel.setHorizontalTextPosition(2);
        this.add(this.jCompareLevel);
        this.componentsPanel.setLayout(new FlowLayout(1, 5, 0));
        this.jCompareGroup.add(this.jModelRadio);
        this.jModelRadio.setSelected(true);
        this.jModelRadio.setText("Model");
        this.componentsPanel.add(this.jModelRadio);
        this.jCompareGroup.add(this.jPartitionRadio);
        this.jPartitionRadio.setText("Partition");
        this.componentsPanel.add(this.jPartitionRadio);
        this.jPartitionHyperlink.setText("None");
        this.jPartitionHyperlink.setEnabled(false);
        this.jPartitionHyperlink.setHorizontalTextPosition(4);
        this.jPartitionHyperlink.setMaximumSize(new Dimension(400, 23));
        this.jPartitionHyperlink.setPreferredSize(new Dimension(45, 23));
        GroupLayout groupLayout = new GroupLayout((Container)this.jPartitionHyperlink);
        this.jPartitionHyperlink.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 25, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 21, Short.MAX_VALUE));
        this.componentsPanel.add((Component)this.jPartitionHyperlink);
        this.jSearchPartitionButton.setEnabled(false);
        this.jSearchPartitionButton.setIconTextGap(2);
        this.jSearchPartitionButton.setPreferredSize(new Dimension(28, 24));
        this.componentsPanel.add(this.jSearchPartitionButton);
        this.add(this.componentsPanel);
    }

    private void initRes() {
        this.jSearchPartitionButton.setIcon(OracleIcons.getIcon((String)"search.png"));
        this.jCompareLevel.setText(PartitionsLrb.get("TOOLBAR_COMPARE_LEVEL"));
        this.jModelRadio.setText(PartitionsLrb.get("TOOLBAR_COMPARE_MODEL"));
        this.jPartitionRadio.setText(PartitionsLrb.get("TOOLBAR_COMPARE_PARTITION"));
    }

    private void initUI() {
        this.jModelRadio.addActionListener(new ModelRadioActionListener());
        this.jPartitionRadio.addActionListener(new PartitionRadioActionListener());
        this.jSearchPartitionButton.addActionListener(new AbstractPartitionToolbar.SearchPartitionActionListener());
        this.jPartitionHyperlink.addActionListener((ActionListener)new AbstractPartitionToolbar.PartitionDetailsActionListener());
        this.partitionLink = this.jPartitionHyperlink;
    }

    @Override
    public String getSelectedPartitionID() {
        if (this.getCompareMode() == CompareMode.MODEL) {
            return null;
        }
        return super.getSelectedPartitionID();
    }

    @Override
    public String getSelectedPartitionName() {
        if (this.getCompareMode() == CompareMode.MODEL) {
            return null;
        }
        return super.getSelectedPartitionName();
    }

    public CompareMode getCompareMode() {
        return this.getVirtualInstance().compareMode;
    }

    @Override
    protected void initVirtualInstance() {
        String string = this.node.getLongLabel();
        TestViewerVirtualInstance testViewerVirtualInstance = TOOLBAR_MAP.get(string);
        if (testViewerVirtualInstance != null) {
            this.setVirtualInstance(testViewerVirtualInstance);
        } else {
            TOOLBAR_MAP.put(string, this.getVirtualInstance());
        }
    }

    @Override
    protected void initModelInformation() {
        if (this.node instanceof TestCompareNode) {
            List<TestResult> list = ((TestCompareNode)this.node).getTestResults();
            String[] stringArray = new String[list.size()];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = list.get(i).getName();
            }
            this.getVirtualInstance().setModels(stringArray);
        } else if (this.node instanceof TestResultNode) {
            String[] stringArray = new String[]{((TestResultNode)this.node).getResultName()};
            this.getVirtualInstance().setModels(stringArray);
        } else assert (false) : "Invalid node type";
    }

    @Override
    protected void hideToolbar() {
        super.hideToolbar();
        this.getVirtualInstance().setCompareMode(CompareMode.NOT_PARTITIONED);
    }

    @Override
    protected void showToolbar(List<PartitionVO> list) {
        this.checkPartition(list);
        this.getVirtualInstance().setNode(this.node);
        this.getVirtualInstance().getRelatedToolbars().add(this);
        SwingUtilities.invokeLater(() -> this.setVisible(true));
    }

    private void checkPartition(List<PartitionVO> list) {
        boolean bl;
        PartitionVO partitionVO = this.getVirtualInstance().getPartition();
        boolean bl2 = bl = !list.contains(partitionVO);
        if (bl) {
            this.getVirtualInstance().setPartition(null, false);
            this.getVirtualInstance().setCompareMode(CompareMode.MODEL);
        }
        SwingUtilities.invokeLater(() -> this.updatePartitionHyperlink());
    }

    @Override
    public void setEditor(Editor editor) {
        super.setEditor(editor);
        assert (this.node instanceof TestCompareNode || this.node instanceof TestResultNode) : "Unexpected node type";
        String string = this.node.getLongLabel();
        TestViewerVirtualInstance testViewerVirtualInstance = TOOLBAR_MAP.get(string);
        if (testViewerVirtualInstance != null) {
            this.setVirtualInstance(testViewerVirtualInstance);
            switch (testViewerVirtualInstance.compareMode) {
                case NOT_PARTITIONED: 
                case MODEL: {
                    this.jModelRadio.setSelected(true);
                    break;
                }
                case PARTITION: {
                    this.jPartitionRadio.setSelected(true);
                    this.jPartitionHyperlink.setEnabled(true);
                    this.jSearchPartitionButton.setEnabled(true);
                    break;
                }
                default: {
                    assert (false) : "Not a valid compare mode";
                    break;
                }
            }
            this.updatePartitionHyperlink();
        } else {
            TOOLBAR_MAP.put(string, this.getVirtualInstance());
        }
        this.getVirtualInstance().setNode(this.node);
        this.getVirtualInstance().getRelatedToolbars().add(this);
        if (this.node instanceof TestCompareNode) {
            List<TestResult> list = ((TestCompareNode)this.node).getTestResults();
            String[] stringArray = new String[list.size()];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = list.get(i).getName();
            }
            this.getVirtualInstance().setModels(stringArray);
        } else if (this.node instanceof TestResultNode) {
            String[] stringArray = new String[]{((TestResultNode)this.node).getResultName()};
            this.getVirtualInstance().setModels(stringArray);
        }
    }

    protected TestViewerVirtualInstance getVirtualInstance() {
        AbstractPartitionToolbar.VirtualInstance virtualInstance = super.getVirtualInstance();
        assert (virtualInstance instanceof TestViewerVirtualInstance);
        return (TestViewerVirtualInstance)virtualInstance;
    }

    @Override
    protected void displayPartitionFilterDialog(Context context, String[] stringArray) {
        super.displayPartitionFilterDialog(context, stringArray);
        TestViewerVirtualInstance testViewerVirtualInstance = this.getVirtualInstance();
        if (testViewerVirtualInstance.getPartition() == null && this.getCompareMode() == CompareMode.PARTITION) {
            this.getVirtualInstance().setCompareMode(CompareMode.MODEL);
        }
    }

    @Override
    protected int getComponentsWidth() {
        if (this.componentsWidth == -1) {
            Font font = this.jCompareLevel.getFont();
            FontMetrics fontMetrics = this.jCompareLevel.getFontMetrics(font);
            this.componentsWidth = fontMetrics.stringWidth(this.jCompareLevel.getText()) + fontMetrics.stringWidth(this.jModelRadio.getText()) + fontMetrics.stringWidth(this.jPartitionRadio.getText()) + this.jSearchPartitionButton.getPreferredSize().width;
        }
        return this.componentsWidth;
    }

    public static void pinPartition(AbstractTestNode abstractTestNode, PartitionVO partitionVO) {
        TestViewerVirtualInstance testViewerVirtualInstance = TOOLBAR_MAP.get(abstractTestNode.getLongLabel());
        testViewerVirtualInstance.setCompareMode(CompareMode.PARTITION);
        testViewerVirtualInstance.setPartition(partitionVO, true);
    }

    public static String getPingedPartitionForNode(AbstractTestNode abstractTestNode) {
        TestViewerVirtualInstance testViewerVirtualInstance = TOOLBAR_MAP.get(abstractTestNode.getLongLabel());
        PartitionVO partitionVO = testViewerVirtualInstance.getPartition();
        return partitionVO != null ? partitionVO.getPartitionName() : null;
    }

    static class TestViewerVirtualInstance
    extends AbstractPartitionToolbar.VirtualInstance<TestViewerPartitionToolbar> {
        private CompareMode compareMode;

        private TestViewerVirtualInstance(CompareMode compareMode, String[] stringArray, PartitionVO partitionVO, BaseTreeNode baseTreeNode) {
            super(stringArray, partitionVO, baseTreeNode);
            this.compareMode = compareMode;
        }

        private void setCompareMode(CompareMode compareMode) {
            if (this.compareMode != compareMode) {
                this.compareMode = compareMode;
                for (TestViewerPartitionToolbar testViewerPartitionToolbar : this.getRelatedToolbars()) {
                    if (compareMode == CompareMode.MODEL) {
                        testViewerPartitionToolbar.jModelRadio.setSelected(true);
                        testViewerPartitionToolbar.jSearchPartitionButton.setEnabled(false);
                        testViewerPartitionToolbar.jPartitionHyperlink.setEnabled(false);
                        continue;
                    }
                    boolean bl = this.getPartition() != null;
                    testViewerPartitionToolbar.jPartitionHyperlink.setEnabled(bl);
                    testViewerPartitionToolbar.jPartitionRadio.setSelected(true);
                    testViewerPartitionToolbar.jSearchPartitionButton.setEnabled(true);
                }
            }
        }
    }

    public class PartitionRadioActionListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TestViewerVirtualInstance testViewerVirtualInstance = TestViewerPartitionToolbar.this.getVirtualInstance();
            if (TestViewerPartitionToolbar.this.jPartitionRadio.isSelected() && TestViewerPartitionToolbar.this.getCompareMode() == CompareMode.MODEL) {
                testViewerVirtualInstance.setCompareMode(CompareMode.PARTITION);
                if (testViewerVirtualInstance.getPartition() == null) {
                    TestViewerPartitionToolbar.this.displayPartitionFilterDialog(TestViewerPartitionToolbar.this.context, testViewerVirtualInstance.getModels());
                } else {
                    testViewerVirtualInstance.sendUpdateMessage();
                }
            }
        }
    }

    public class ModelRadioActionListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl;
            TestViewerVirtualInstance testViewerVirtualInstance = TestViewerPartitionToolbar.this.getVirtualInstance();
            boolean bl2 = bl = TestViewerPartitionToolbar.this.jModelRadio.isSelected() && TestViewerPartitionToolbar.this.getCompareMode() == CompareMode.PARTITION;
            if (bl) {
                testViewerVirtualInstance.setCompareMode(CompareMode.MODEL);
                testViewerVirtualInstance.sendUpdateMessage();
            }
        }
    }
}

