/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.tviewer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.CommonLrb;
import oracle.dmt.dataminer.DataMinerViewEvent;
import oracle.dmt.dataminer.DataMinerViewGUI;
import oracle.dmt.dataminer.controls.LegendsNiceTable;
import oracle.dmt.dataminer.controls.models.SimpleBaseTableModel;
import oracle.dmt.dataminer.core.model.common.ServerConstants;
import oracle.dmt.dataminer.legend.LegendConsumer;
import oracle.dmt.dataminer.legend.LegendWindowGUI;
import oracle.dmt.dataminer.repository.Test;
import oracle.dmt.dataminer.repository.TestResult;
import oracle.dmt.dataminer.tviewer.AbstractTestEditor;
import oracle.dmt.dataminer.tviewer.AbstractTestEditorAddin;
import oracle.dmt.dataminer.tviewer.SharedTestEditorState;
import oracle.dmt.dataminer.tviewer.TestResultsSelectorPanel;
import oracle.dmt.dataminer.tviewer.TestTrendNode;
import oracle.dmt.dataminer.tviewer.TestViewerLrb;
import oracle.ide.util.ResourceUtils;
import oracle.ide.view.View;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;

public class TestLegendsPanel
extends LegendWindowGUI {
    private View _consumerView;
    private boolean _loaded;
    private SharedTestEditorState _sharedTestEdiorState = null;
    private AbstractTestEditorAddin.MeasureType _measureType;
    private JButton _jBT_AddOrRemove;
    private JLabel jLB_Target;
    private JLabel jLB_TargetValue;
    private ComponentWithTitlebar jLegendsPanel;

    public TestLegendsPanel(AbstractTestEditorAddin.MeasureType measureType) {
        this._measureType = measureType;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    public TestLegendsPanel() {
        this._measureType = null;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.jLB_Target = new JLabel();
        this.jLB_TargetValue = new JLabel();
        this.jLegendsPanel = new ComponentWithTitlebar();
        this.jLB_Target.setText("Target:");
        this.jLB_TargetValue.setText("targetValue");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.jLegendsPanel, -1, 188, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addComponent(this.jLB_Target).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLB_TargetValue))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLB_Target).addComponent(this.jLB_TargetValue)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.jLegendsPanel, -1, 141, Short.MAX_VALUE).addContainerGap()));
    }

    @Override
    public void initRes() {
        this._jBT_AddOrRemove = new JButton(TestViewerLrb.get("ADD_REMOVE_BTN"), OracleIcons.getIcon((String)"compare.png"));
        this._jBT_AddOrRemove.setDisabledIcon(OracleIcons.getIcon((String)"compare.png"));
        ResourceUtils.resLabel((JLabel)this.jLB_Target, (Component)this.jLB_TargetValue, (String)TestViewerLrb.get("TARGET_ATTRIBUTE"));
    }

    @Override
    public void initUI() {
        this._jBT_AddOrRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (TestLegendsPanel.this._measureType == null) {
                    TestLegendsPanel.this._jBT_Trend_AddOrRemove_actionPerformed(actionEvent);
                } else {
                    TestLegendsPanel.this._jBT_Compare_AddOrRemove_actionPerformed(actionEvent);
                }
            }
        });
        this.enableAllControls(false);
    }

    protected void _jBT_Compare_AddOrRemove_actionPerformed(ActionEvent actionEvent) {
        TestResultsSelectorPanel testResultsSelectorPanel = new TestResultsSelectorPanel(null, this._sharedTestEdiorState);
        if (testResultsSelectorPanel.showAsDialog(this)) {
            List<TestResult> list = testResultsSelectorPanel.getSelectedTestResults();
            this._sharedTestEdiorState.setTestResults(list);
            Container container = ((AbstractTestEditor)this._consumerView).getParent();
            container.remove(((AbstractTestEditor)this._consumerView).getCurrentGUI());
            container.add(this._consumerView.getGUI());
            if (this._measureType == null) {
                this.setupTrendUIDetail();
            } else {
                this.setupCompareUIDetail();
            }
        }
    }

    protected void _jBT_Trend_AddOrRemove_actionPerformed(ActionEvent actionEvent) {
    }

    @Override
    public void setupUI(View view) {
        if (this._consumerView == view) {
            return;
        }
        if (view == null) {
            return;
        }
        LegendConsumer legendConsumer = (LegendConsumer)view;
        this._consumerView = view;
        DataMinerViewGUI dataMinerViewGUI = (DataMinerViewGUI)this._consumerView.getGUI();
        dataMinerViewGUI.addDataMinerViewListener(this);
        if (!legendConsumer.isLoaded()) {
            this._consumerView = view;
            if (this._measureType == null) {
                this.setupTrendUIDetail();
            } else {
                this.setupCompareUIDetail();
            }
            return;
        }
        if (this._measureType == null) {
            this.setupTrendUIDetail();
        } else {
            this.setupCompareUIDetail();
        }
    }

    private void setupCompareUIDetail() {
        Object object;
        this._sharedTestEdiorState = ((AbstractTestEditor)this._consumerView).getCachedLegendState();
        List<TestResult> list = this._sharedTestEdiorState.getTestResults();
        List<Color> list2 = this._sharedTestEdiorState.getTestResultGraphColors();
        boolean bl = false;
        Object[][] objectArray = new Object[0][2];
        if (list != null) {
            int n;
            if (AbstractTestEditorAddin.MeasureType.LIFT.equals((Object)this._measureType)) {
                if (list.size() == 1) {
                    objectArray = new Object[list.size() + 2][4];
                    objectArray[list.size()][0] = new LegendsNiceTable.LegendColumn(SharedTestEditorState.LIFT_IDEAL_LINE, TestViewerLrb.get("IDEAL_LINE"));
                    objectArray[list.size()][1] = null;
                    objectArray[list.size()][2] = null;
                    objectArray[list.size()][3] = null;
                    n = list.size() + 1;
                } else {
                    objectArray = new Object[list.size() + 1][4];
                    n = list.size();
                }
                objectArray[n][0] = new LegendsNiceTable.LegendColumn(SharedTestEditorState.LIFT_RANDOM_LINE, TestViewerLrb.get("RANDOM_LINE"));
                objectArray[n][1] = null;
                objectArray[n][2] = null;
                objectArray[n][3] = null;
            } else if (AbstractTestEditorAddin.MeasureType.PROFIT.equals((Object)this._measureType)) {
                objectArray = new Object[list.size() + 1][4];
                objectArray[list.size()][0] = new LegendsNiceTable.LegendColumn(SharedTestEditorState.PROFIT_BUDGET_LINE, TestViewerLrb.get("BUDGET_LINE"));
                objectArray[list.size()][1] = null;
                objectArray[list.size()][2] = null;
                objectArray[list.size()][3] = null;
            } else {
                objectArray = new Object[list.size()][4];
            }
            n = 0;
            for (TestResult object22 : list) {
                if (!bl) {
                    this.jLB_TargetValue.setText(object22.getColumnName());
                    bl = true;
                }
                objectArray[n][0] = object = new LegendsNiceTable.LegendColumn(list2.get(n), object22.getName());
                objectArray[n][1] = object22.getCreationTimestamp();
                objectArray[n][2] = object22.getModelName();
                objectArray[n][3] = ServerConstants.Algorithm.getUIAlgorithmName((String)object22.getMiningAlgorithm());
                ++n;
            }
        }
        Object[] objectArray2 = new String[]{CommonLrb.get("NAME"), TestViewerLrb.get("CREATION_DATE"), TestViewerLrb.get("MODEL_NAME"), TestViewerLrb.get("ALGORITHM")};
        Object object3 = new LegendsTableModel(objectArray, objectArray2);
        LegendsNiceTable legendsNiceTable = new LegendsNiceTable((TableModel)object3);
        legendsNiceTable.setHiddenColumns(2, 3);
        object = new JScrollPane((Component)((Object)legendsNiceTable));
        this.jLegendsPanel.setComponent((JComponent)object);
        ControlBar controlBar = new ControlBar();
        controlBar.add((Component)this._jBT_AddOrRemove);
        this.jLegendsPanel.setControlBar(controlBar);
        if (list.size() <= 1) {
            this.enableAllControls(false);
        } else {
            this.enableAllControls(true);
        }
        this.setLoaded(true);
        this.updateUI();
    }

    private void setupTrendUIDetail() {
        Object object;
        TestTrendNode testTrendNode = (TestTrendNode)((LegendConsumer)this._consumerView).getCachedLegendState();
        List<Test> list = testTrendNode.getTests();
        List<Color> list2 = testTrendNode.getTestGraphColors();
        boolean bl = false;
        Object[][] objectArray = new Object[0][2];
        if (list != null) {
            objectArray = new Object[list.size()][3];
            int n = 0;
            for (Test object22 : list) {
                if (!bl) {
                    this.jLB_TargetValue.setText(object22.getTarget());
                    bl = true;
                }
                objectArray[n][0] = object = new LegendsNiceTable.LegendColumn(list2.get(n), object22.getName());
                objectArray[n][1] = ServerConstants.Algorithm.getUIAlgorithmName((String)object22.getAlgorithm());
                objectArray[n][2] = object22.getTestResultsWithinTimeframe().size();
                ++n;
            }
        }
        Object[] objectArray2 = new String[]{CommonLrb.get("NAME"), TestViewerLrb.get("ALGORITHM"), TestViewerLrb.get("NUMBER_OF_RESULTS")};
        Object object3 = new LegendsTableModel(objectArray, objectArray2);
        LegendsNiceTable legendsNiceTable = new LegendsNiceTable((TableModel)object3);
        legendsNiceTable.setHiddenColumns(2);
        object = new JScrollPane((Component)((Object)legendsNiceTable));
        this.jLegendsPanel.setComponent((JComponent)object);
        ControlBar controlBar = new ControlBar();
        controlBar.add((Component)this._jBT_AddOrRemove);
        this.jLegendsPanel.setControlBar(controlBar);
        this.enableAllControls(true);
        this.setLoaded(true);
        this.updateUI();
    }

    @Override
    public void unloadUI() {
        if (this._consumerView == null) {
            return;
        }
        DataMinerViewGUI dataMinerViewGUI = (DataMinerViewGUI)this._consumerView.getGUI();
        dataMinerViewGUI.removeDataMinerViewListener(this);
        this.setLoaded(false);
    }

    private void enableAllControls(boolean bl) {
        this._jBT_AddOrRemove.setEnabled(bl);
    }

    @Override
    public boolean isLoaded() {
        return this._loaded;
    }

    private void setLoaded(boolean bl) {
        this._loaded = bl;
    }

    @Override
    public void viewReady(DataMinerViewEvent dataMinerViewEvent) {
    }

    @Override
    public void viewBusy(DataMinerViewEvent dataMinerViewEvent) {
    }

    public void addLegend(String string, Color color) {
        ((DefaultTableModel)((LegendsNiceTable)((Object)this.jLegendsPanel.getComponent())).getModel()).addRow(new Object[]{new LegendsNiceTable.LegendColumn(color, string), null, null, null});
    }

    public void removeLegend(int n) {
        ((DefaultTableModel)((LegendsNiceTable)((Object)this.jLegendsPanel.getComponent())).getModel()).removeRow(n);
    }

    private static class LegendsTableModel
    extends SimpleBaseTableModel {
        public LegendsTableModel(Object[][] objectArray, Object[] objectArray2) {
            super(objectArray, objectArray2);
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }
}

