/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.tviewer;

import java.io.IOException;
import java.net.URL;
import java.util.List;
import javax.swing.Icon;
import oracle.dmt.dataminer.navigator.AbstractTestNode;
import oracle.dmt.dataminer.repository.ClassTestResult;
import oracle.dmt.dataminer.repository.TestResult;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.NodeFactory;
import oracle.javatools.icons.OracleIcons;

public class TestCompareNode
extends AbstractTestNode {
    private static Icon icon;
    private boolean showROC;
    private boolean showLiftProfit;
    private boolean showTestMetrics;
    private boolean showConfusionMatrix;
    private String parentNodeId;
    private List<TestResult> testResults;

    public TestCompareNode() {
        this.getAttributes().set(ElementAttributes.CLOSEABLE);
    }

    public void setTestResults(List<TestResult> list) {
        this.testResults = list;
        for (TestResult testResult : list) {
            if (!(testResult instanceof ClassTestResult)) continue;
            if (((ClassTestResult)testResult).isROCResult()) {
                this.showROC = true;
            }
            if (((ClassTestResult)testResult).isAccuracyMetricsResult()) {
                this.showTestMetrics = true;
            }
            if (((ClassTestResult)testResult).isConfusionMatrixResult()) {
                this.showConfusionMatrix = true;
            }
            if (!((ClassTestResult)testResult).isLiftProfitResult()) continue;
            this.showLiftProfit = true;
        }
    }

    @Override
    public List<TestResult> getTestResults() {
        return this.testResults;
    }

    public boolean isDirty() {
        return false;
    }

    protected void closeImpl() throws IOException {
        super.closeImpl();
        NodeFactory.uncache((URL)this.getURL());
    }

    @Override
    public Icon getIcon() {
        if (icon == null) {
            icon = OracleIcons.getIcon((String)"compare.png");
        }
        return icon;
    }

    public boolean isShowTestMetrics() {
        return this.showTestMetrics;
    }

    public boolean isShowConfusionMatrix() {
        return this.showConfusionMatrix;
    }

    public boolean isShowLiftProfit() {
        return this.showLiftProfit;
    }

    public boolean isShowROC() {
        return this.showROC;
    }

    public String getParentNodeId() {
        return this.parentNodeId;
    }

    public void setParentNodeId(String string) {
        this.parentNodeId = string;
    }
}

