/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.teditor.data;

import java.awt.Component;
import java.util.List;
import java.util.Vector;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.SwingWorker;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.DataMinerEditor;
import oracle.dmt.dataminer.DataMinerViewGUI;
import oracle.dmt.dataminer.controls.models.SimpleBaseTableModel;
import oracle.dmt.dataminer.core.model.ds.Table;
import oracle.dmt.dataminer.navigator.BaseTreeNode;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.dmt.dataminer.teditor.data.DataEditor;
import oracle.dmt.dataminer.teditor.data.DataLrb;
import oracle.dmt.dataminer.teditor.data.DataSourceViewOption;
import oracle.dmt.dataminer.teditor.data.DataViewerState;
import oracle.dmt.dataminer.teditor.data.ODMrResultSetTable;
import oracle.dmt.dataminer.teditor.data.ODMrResultSetTableModelBase;
import oracle.dmt.dataminer.utils.ODMrSwingWorker;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.Node;
import oracle.dmt.dataminer.workflow.model.WorkflowModel;
import oracle.dmt.dataminer.workflow.xmlschema.DataSourceNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.explorer.TNode;
import oracle.ide.help.HelpInfo;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.ui.BlockingComponent;

public class DataViewerPanel
extends DataMinerViewGUI {
    private static final String SYN_SELECTED_TABLE = "syn_selected_table";
    private int fetchSize;
    private boolean initialLoad;
    private boolean loadFromNode;
    private boolean loadFromSQLExpression;
    private String sqlExpression;
    private Table selectedTable;
    private JViewport viewRows;
    private DataViewerState state;
    private LoadingTableModel loadingModel;
    private ODMrResultSetTableModelBase resultSetTableModel;
    private JTable dataTable;
    private JScrollPane scrollPane;

    public DataViewerPanel(DataEditor dataEditor, Context context) {
        super(dataEditor, context);
        assert (context != null) : "Context cannot be passed into constructor as a null.";
        this.initialLoad = true;
        this.loadFromNode = true;
        this.initializePanel();
    }

    public DataViewerPanel(Context context, boolean bl) {
        super(null, context);
        assert (context != null) : "Context cannot be passed into constructor as a null.";
        this.initialLoad = true;
        this.loadFromNode = bl;
        this.initializePanel();
    }

    public DataViewerPanel(Context context, String string) throws Exception {
        super(null, context);
        assert (context != null) : "Context cannot be passed into constructor as a null.";
        this.initialLoad = true;
        this.loadFromNode = false;
        this.loadFromSQLExpression = true;
        this.sqlExpression = string;
        this.initializePanel();
    }

    private void initializePanel() {
        this.initComponents();
        this.getTableData().setContext(this.getContext());
        this.initUI();
    }

    private void initComponents() {
        this.scrollPane = new JScrollPane();
        this.dataTable = new ODMrResultSetTable();
        this.scrollPane.setViewportView(this.dataTable);
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.scrollPane, -1, 170, Short.MAX_VALUE).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.scrollPane, -1, 112, Short.MAX_VALUE).addContainerGap()));
    }

    public ODMrResultSetTable getTableData() {
        return (ODMrResultSetTable)this.dataTable;
    }

    public void initUI() {
        assert (this.getContext() != null) : "Context cannot be null.";
        this.initializeControls(this.loadFromNode || this.loadFromSQLExpression);
        this.state = this.loadFromSQLExpression ? new DataViewerState(this.getContext(), (DataEditor)this.getEditor(), this.sqlExpression) : new DataViewerState(this.getContext(), (DataEditor)this.getEditor(), this.loadFromNode);
        ((ODMrResultSetTable)this.dataTable).setState(this.state);
        this.setLoading(true);
    }

    private void initializeControls(boolean bl) {
        ODMrResultSetTable oDMrResultSetTable = this.getTableData();
        oDMrResultSetTable.setParentPanel(this);
        this.loadingModel = new LoadingTableModel(DataLrb.get("DATA_VIEWER_EDITOR_LOADING"));
        oDMrResultSetTable.setSuperModel((TableModel)((Object)this.loadingModel));
        JTable jTable = oDMrResultSetTable.getDummyRowHeader();
        this.viewRows = new JViewport();
        this.viewRows.setView(jTable);
        this.viewRows.setPreferredSize(jTable.getMaximumSize());
        jTable.setFillsViewportHeight(true);
        this.scrollPane.setRowHeader(this.viewRows);
        if (!bl) {
            this.loadingModel.showSelectionRequired();
        } else {
            this.loadingModel.showLoading();
        }
        this.dataTable.setFillsViewportHeight(true);
    }

    @Override
    public void load() {
        if (this.loadFromNode || this.loadFromSQLExpression) {
            LoadUI loadUI = new LoadUI();
            loadUI.execute();
        }
    }

    @Override
    public HelpInfo getHelpInfo() {
        return new HelpInfo("dm_datasourceviewer_data");
    }

    public DataViewerState getState() {
        return this.state;
    }

    public void setDataSourceViewOption(DataSourceViewOption dataSourceViewOption) throws Exception {
        this.state.setCurrentSourceOption(dataSourceViewOption);
    }

    public void loadTable(Table table) {
        this.setLoading(true);
        this.initializeControls(true);
        Table table2 = this.getSelectedTable();
        if (table != table2) {
            this.state.closeRS();
        }
        this.setSelectedTable(table);
        LoadUISync loadUISync = new LoadUISync(table != null ? table.getSchema() : "", table != null ? table.getName() : "");
        loadUISync.execute();
    }

    public void loadTable(String string) {
        this.setLoading(true);
        this.initializeControls(true);
        this.setSelectedSQLExpression(string);
        LoadUISync loadUISync = new LoadUISync(string);
        loadUISync.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Table getSelectedTable() {
        String string = SYN_SELECTED_TABLE;
        synchronized (SYN_SELECTED_TABLE) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.selectedTable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedTable(Table table) {
        String string = SYN_SELECTED_TABLE;
        synchronized (SYN_SELECTED_TABLE) {
            this.selectedTable = table;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedSQLExpression(String string) {
        String string2 = SYN_SELECTED_TABLE;
        synchronized (SYN_SELECTED_TABLE) {
            this.sqlExpression = string;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void reloadUI() {
        if (this.overLayPanel != null) {
            this.overLayPanel.setState(BlockingComponent.State.BLOCKED);
        }
        this.setLoading(true);
        this.initializeControls(this.loadFromNode || this.loadFromSQLExpression);
        assert (this.getContext() != null) : "Context cannot be null.";
        this.state = this.loadFromSQLExpression ? new DataViewerState(this.getContext(), (DataEditor)this.getEditor(), this.sqlExpression) : new DataViewerState(this.getContext(), (DataEditor)this.getEditor(), this.loadFromNode);
        ((ODMrResultSetTable)this.dataTable).setState(this.state);
        if (this.loadFromNode || this.loadFromSQLExpression) {
            ReloadUI reloadUI = new ReloadUI();
            reloadUI.execute();
        }
    }

    public void headerSortClicked(int n, boolean bl) {
        if (this.dataTable.getModel() instanceof ODMrResultSetTableModelBase) {
            ODMrResultSetTableModelBase oDMrResultSetTableModelBase = (ODMrResultSetTableModelBase)this.dataTable.getModel();
            if (oDMrResultSetTableModelBase.isSorting()) {
                return;
            }
            if (this.overLayPanel != null) {
                this.overLayPanel.setState(BlockingComponent.State.BLOCKED);
            }
            oDMrResultSetTableModelBase.setSorting(true);
            if (((ODMrResultSetTable)this.dataTable).isColSortable(n)) {
                int n2 = oDMrResultSetTableModelBase.getLoadedCount();
                int n3 = this.dataTable.convertColumnIndexToModel(n);
                ODMrResultSetTableModelBase oDMrResultSetTableModelBase2 = ((ODMrResultSetTable)this.dataTable).resetModelSorting();
                oDMrResultSetTableModelBase2.setSortColumn(n3);
                if (bl) {
                    oDMrResultSetTableModelBase2.setSortDirection(" asc");
                } else {
                    oDMrResultSetTableModelBase2.setSortDirection(" desc");
                }
                this.launchProcess(oDMrResultSetTableModelBase2, n2);
            } else {
                oDMrResultSetTableModelBase.setSorting(false);
                if (this.overLayPanel != null) {
                    this.overLayPanel.setState(BlockingComponent.State.UNBLOCKED);
                }
            }
        }
    }

    private void launchProcess(ODMrResultSetTableModelBase oDMrResultSetTableModelBase, int n) {
        this.resultSetTableModel = oDMrResultSetTableModelBase;
        this.fetchSize = n;
        SortWorker sortWorker = new SortWorker();
        sortWorker.execute();
    }

    public void sort2() {
        if (this.dataTable.getModel() instanceof ODMrResultSetTableModelBase) {
            ODMrResultSetTableModelBase oDMrResultSetTableModelBase = (ODMrResultSetTableModelBase)this.dataTable.getModel();
            if (oDMrResultSetTableModelBase.isSorting()) {
                return;
            }
            oDMrResultSetTableModelBase.setSorting(true);
            int n = oDMrResultSetTableModelBase.getLoadedCount();
            ODMrResultSetTableModelBase oDMrResultSetTableModelBase2 = ((ODMrResultSetTable)this.dataTable).resetModelSorting();
            this.launchProcess(oDMrResultSetTableModelBase2, n);
        }
    }

    public void close() {
        this.state.setClosing(true);
        ((ODMrResultSetTable)this.dataTable).interruptSorting();
        this.state.close();
    }

    public static class LoadingTableModel
    extends SimpleBaseTableModel {
        private Vector<String> _data = new Vector();
        public static final int _COLUMN_NAME = 0;

        public LoadingTableModel(String string) {
            Vector<String> vector = new Vector<String>();
            vector.add("");
            this.setColumnIdentifiers(vector);
            this._data.add(string);
            this.setRowCount(this._data.size());
            this.setColumnCount(vector.size());
        }

        public void showSelectionRequired() {
            this._data.clear();
            String string = DataLrb.get("DATA_VIEWER_EDITOR_SELECTION_REQUIRED");
            this._data.add(string);
            this.setRowCount(this._data.size());
            this.fireTableDataChanged();
        }

        public void showLoading() {
            this._data.clear();
            String string = DataLrb.get("DATA_VIEWER_EDITOR_LOADING");
            this._data.add(string);
            this.setRowCount(this._data.size());
            this.fireTableDataChanged();
        }

        public void showError(String string) {
            this._data.clear();
            this._data.add(string);
            this.setRowCount(this._data.size());
            this.fireTableDataChanged();
        }

        public Object getValueAt(int n, int n2) {
            assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds!";
            assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
            String string = this._data.get(n);
            String string2 = null;
            switch (n2) {
                case 0: {
                    string2 = string;
                    break;
                }
                default: {
                    assert (false) : "Out of bounds";
                    break;
                }
            }
            return string2 != null ? string2 : "";
        }
    }

    private class SortWorker
    extends ODMrSwingWorker<Void, Void> {
        public SortWorker() {
            super(DataViewerPanel.this);
        }

        @Override
        protected Void doInBackground() throws Exception {
            ((ODMrResultSetTable)DataViewerPanel.this.dataTable).setModel(DataViewerPanel.this.resultSetTableModel, DataViewerPanel.this.fetchSize);
            return null;
        }

        @Override
        protected void onSuccess(Void void_) throws Exception {
            JTable jTable = ((ODMrResultSetTable)DataViewerPanel.this.dataTable).getRowHeader();
            DataViewerPanel.this.viewRows.setView(jTable);
            DataViewerPanel.this.viewRows.setPreferredSize(jTable.getMaximumSize());
            jTable.setFillsViewportHeight(true);
            ((ODMrResultSetTable)DataViewerPanel.this.dataTable).applyDefaultSettings();
            DataViewerPanel.this.setLoaded(true);
            DataViewerPanel.this.resultSetTableModel.setSorting(false);
        }
    }

    private class ReloadUI
    extends ODMrSwingWorker<Void, Void> {
        public ReloadUI() {
            super(DataViewerPanel.this, DataViewerPanel.this.overLayPanel);
        }

        @Override
        protected Void doInBackground() throws Exception {
            DataViewerPanel.this.state.load();
            DataViewerPanel.this.state.loadModel();
            return null;
        }

        @Override
        protected void onSuccess(Void void_) throws Exception {
            DataViewerPanel.this.dataTable.setModel(DataViewerPanel.this.state.getResultSetModel());
            DataViewerPanel.this.state.getResultSetModel().fireTableStructureChanged();
            JTable jTable = ((ODMrResultSetTable)DataViewerPanel.this.dataTable).getRowHeader();
            DataViewerPanel.this.viewRows.setView(jTable);
            DataViewerPanel.this.viewRows.setPreferredSize(jTable.getMaximumSize());
            jTable.setFillsViewportHeight(true);
            DataViewerPanel.this.scrollPane.setRowHeader(DataViewerPanel.this.viewRows);
            DataViewerPanel.this.setLoaded(true);
        }

        @Override
        protected void onFailure(Throwable throwable) {
            if (DataViewerPanel.this.state.getResultSetModel() != null) {
                DataViewerPanel.this.dataTable.setModel(new DefaultTableModel(new Object[][]{{DataLrb.get("DATA_VIEWER_FAILURE_MESG")}}, new String[]{" "}));
            }
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)throwable, (String)DataLrb.get("DATA_VIEWER_FAILURE_TITLE"), (String)DataLrb.get("DATA_VIEWER_FAILURE_MESG"), null);
        }

        @Override
        protected void onFinally() {
            DataViewerPanel.this.setLoading(false);
            super.onFinally();
        }
    }

    private class LoadUI
    extends ODMrSwingWorker<Void, Void> {
        public LoadUI() {
            super(DataViewerPanel.this, DataViewerPanel.this.overLayPanel);
        }

        @Override
        protected Void doInBackground() throws Exception {
            DataViewerPanel.this.state.load();
            DataViewerPanel.this.state.loadModel();
            return null;
        }

        @Override
        protected void onSuccess(Void void_) throws Exception {
            DataViewerPanel.this.dataTable.setModel(DataViewerPanel.this.state.getResultSetModel());
            DataViewerPanel.this.state.getResultSetModel().fireTableStructureChanged();
            JTable jTable = ((ODMrResultSetTable)DataViewerPanel.this.dataTable).getRowHeader();
            DataViewerPanel.this.viewRows.setView(jTable);
            DataViewerPanel.this.viewRows.setPreferredSize(jTable.getMaximumSize());
            jTable.setFillsViewportHeight(true);
            DataViewerPanel.this.scrollPane.setRowHeader(DataViewerPanel.this.viewRows);
            ((ODMrResultSetTable)DataViewerPanel.this.dataTable).applyDefaultSettings();
            DataViewerPanel.this.setLoaded(true);
        }

        @Override
        protected void onFailureOnSuccess(Exception exception) {
            DataMinerEditor.handleEditorException(DataViewerPanel.this.getEditor().getContext(), exception, DataLrb.get("DATA_VIEWER_FAILURE_TITLE"), DataLrb.get("DATA_VIEWER_FAILURE_MESG"));
        }

        @Override
        protected void onFailure(Throwable throwable) {
            BaseTreeNode baseTreeNode;
            NodeType nodeType;
            DataViewerPanel.this.loadingModel.showError(DataLrb.get("DATA_VIEWER_FAILURE_DS_DOES_NOT_EXIST"));
            if (throwable.getMessage().startsWith("ORA-00942")) {
                DataMinerEditor.handleEditorException(DataViewerPanel.this.getEditor().getContext(), throwable, DataLrb.get("DATA_VIEWER_FAILURE_TITLE"), DataLrb.get("DATA_VIEWER_FAILURE_DS_DOES_NOT_EXIST"));
                return;
            }
            DataViewerPanel.this.loadingModel.showError(DataLrb.get("DATA_VIEWER_FAILURE_MESG_TRY_RERUN"));
            boolean bl = false;
            oracle.ide.model.Node node = DataViewerPanel.this.getContext().getNode();
            if (node instanceof BaseTreeNode && !NodeStatusType.COMPLETE.equals((Object)(nodeType = (NodeType)(baseTreeNode = (BaseTreeNode)node).getRepositoryData()).getStatus()) && !(nodeType instanceof DataSourceNodeType)) {
                TNode tNode = baseTreeNode.getParent();
                WorkflowNode workflowNode = (WorkflowNode)tNode.getAncestor(WorkflowNode.class);
                WorkflowModel workflowModel = workflowNode.getWorkflowModel();
                Node node2 = workflowModel.findNodeByName(node.getShortLabel());
                List<AbstractNode> list = node2.findParentNodes();
                String string = null;
                for (AbstractNode abstractNode : list) {
                    NodeStatusType nodeStatusType = abstractNode.getState();
                    if (NodeStatusType.COMPLETE.equals((Object)nodeStatusType)) continue;
                    string = DataLrb.get("DATA_VIEWER_FAILURE_NOT_COMPLETE_PARENT");
                    break;
                }
                string = string == null ? DataLrb.get("DATA_VIEWER_FAILURE_NOT_COMPLETE_PARENT") : DataLrb.get("DATA_VIEWER_FAILURE_NOT_COMPLETE_THIS_NODE");
                DataMinerEditor.handleEditorException(DataViewerPanel.this.getEditor().getContext(), throwable, DataLrb.get("DATA_VIEWER_FAILURE_TITLE"), string);
                bl = true;
            }
            if (!bl) {
                DataMinerEditor.handleEditorException(DataViewerPanel.this.getEditor().getContext(), throwable, DataLrb.get("DATA_VIEWER_FAILURE_TITLE"), DataLrb.get("DATA_VIEWER_FAILURE_MESG_TRY_RERUN"));
            }
        }

        @Override
        protected void onFinally() {
            DataViewerPanel.this.setLoading(false);
        }
    }

    private class LoadUISync
    extends SwingWorker {
        Exception _ex = null;
        boolean _success = false;
        static final String _syncObject = "SyncObject";
        String _schema;
        String _table;
        String _sqlExpression = null;
        boolean _abandon = false;

        public LoadUISync(String string, String string2) {
            this._schema = string;
            this._table = string2;
        }

        public LoadUISync(String string) {
            this._sqlExpression = string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Object doInBackground() throws Exception {
            try {
                String string = _syncObject;
                synchronized (_syncObject) {
                    if (DataViewerPanel.this.loadFromSQLExpression) {
                        if (this._sqlExpression == null) {
                            this._abandon = true;
                            this._success = false;
                        } else {
                            DataViewerPanel.this.state.setSqlExpression(this._sqlExpression);
                            DataViewerPanel.this.state.load();
                            DataViewerPanel.this.state.reloadModel();
                            this._abandon = false;
                            this._success = true;
                        }
                    } else {
                        Table table = DataViewerPanel.this.getSelectedTable();
                        if (table == null) {
                            this._abandon = true;
                            this._success = false;
                        } else if (table.getSchema().equals(this._schema) && table.getName().equals(this._table)) {
                            DataViewerPanel.this.state.setTableName(this._schema, this._table);
                            DataViewerPanel.this.state.load();
                            DataViewerPanel.this.state.reloadModel();
                            table = DataViewerPanel.this.getSelectedTable();
                            if (table == null) {
                                this._abandon = true;
                            } else if (!table.getSchema().equals(this._schema) || !table.getName().equals(this._table)) {
                                this._abandon = true;
                            } else {
                                this._success = true;
                            }
                        } else {
                            this._abandon = true;
                            this._success = false;
                        }
                    }
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                }
            }
            catch (Exception exception) {
                this._ex = exception;
                this._success = false;
                this._abandon = true;
            }
            {
                return DataViewerPanel.this.state;
            }
        }

        @Override
        protected void done() {
            super.done();
            try {
                if (this._abandon) {
                    if (DataViewerPanel.this.dataTable.getModel() instanceof LoadingTableModel && "".equals(this._table)) {
                        ((LoadingTableModel)((Object)DataViewerPanel.this.dataTable.getModel())).showSelectionRequired();
                    }
                    return;
                }
                if (this._success && this._ex == null) {
                    Object object;
                    if (this._sqlExpression == null && ((object = DataViewerPanel.this.getSelectedTable()).getSchema().compareTo(this._schema) != 0 || object.getName().compareTo(this._table) != 0)) {
                        return;
                    }
                    DataViewerPanel.this.dataTable.setModel(DataViewerPanel.this.state.getResultSetModel());
                    DataViewerPanel.this.state.getResultSetModel().fireTableStructureChanged();
                    object = ((ODMrResultSetTable)DataViewerPanel.this.dataTable).getRowHeader();
                    DataViewerPanel.this.viewRows.setView((Component)object);
                    DataViewerPanel.this.viewRows.setPreferredSize(((JComponent)object).getMaximumSize());
                    ((JTable)object).setFillsViewportHeight(true);
                    DataViewerPanel.this.scrollPane.setRowHeader(DataViewerPanel.this.viewRows);
                    DataViewerPanel.this.setLoaded(true);
                } else if (!this._success && this._table.compareTo("") == 0) {
                    if (DataViewerPanel.this.dataTable.getModel() instanceof LoadingTableModel) {
                        ((LoadingTableModel)((Object)DataViewerPanel.this.dataTable.getModel())).showSelectionRequired();
                    }
                } else {
                    if (DataViewerPanel.this.state.getResultSetModel() != null) {
                        DefaultTableModel defaultTableModel = new DefaultTableModel(new Object[][]{{DataLrb.get("DATA_VIEWER_FAILURE_MESG")}}, new String[]{" "});
                        DataViewerPanel.this.dataTable.setModel(defaultTableModel);
                        DataViewerPanel.this.state.getResultSetModel().fireTableStructureChanged();
                    }
                    if (this._ex != null) {
                        ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)this._ex, (String)DataLrb.get("DATA_VIEWER_FAILURE_TITLE"), (String)DataLrb.get("DATA_VIEWER_FAILURE_MESG"), null);
                    } else {
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)DataLrb.get("DATA_VIEWER_FAILURE_MESG"), (String)DataLrb.get("DATA_VIEWER_FAILURE_TITLE"), null);
                    }
                }
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)DataLrb.get("DATA_VIEWER_FAILURE_TITLE"), (String)DataLrb.get("DATA_VIEWER_FAILURE_MESG"), null);
            }
            finally {
                DataViewerPanel.this.setLoading(false);
            }
        }
    }
}

