/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.teditor.ai;

import java.awt.Component;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.DataMinerViewGUI;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.controls.renderers.FormatTableCellRenderer;
import oracle.dmt.dataminer.controls.renderers.HistogramBarRenderer;
import oracle.dmt.dataminer.core.dal.ConnectionManager;
import oracle.dmt.dataminer.core.dal.ODMrDAOException;
import oracle.dmt.dataminer.core.dal.Query;
import oracle.dmt.dataminer.core.dal.sql.SqlDataAccessObject;
import oracle.dmt.dataminer.core.dal.sql.queries.cf.GetAttributeImportanceQuery;
import oracle.dmt.dataminer.core.model.cf.Statistics;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.wflownodes.ColumnFilterNavNode;
import oracle.dmt.dataminer.teditor.ai.AttrsTableModelEx;
import oracle.dmt.dataminer.teditor.ai.DialogsLrb;
import oracle.dmt.dataminer.utils.Formats;
import oracle.dmt.dataminer.utils.ODMrSwingWorker;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.ColumnFilterAttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.ColumnFilterNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ColumnFilterResultType;
import oracle.ide.Context;
import oracle.ide.editor.Editor;
import oracle.ide.help.HelpInfo;
import oracle.ide.model.Node;
import oracle.ide.util.ResourceUtils;

public class AIViewerPanel
extends DataMinerViewGUI {
    private AttrsTableModelEx tableModel;
    private Map<String, Statistics> statisticLookupMap = new TreeMap<String, Statistics>();
    private Map<String, String> attrTypeLookupMap = new HashMap<String, String>();
    private JLabel jTargetColumnLabel;
    private JLabel jTargetLabel;
    private DataMinerTablePanel tablePanel;

    public AIViewerPanel(Editor editor, Context context) {
        super(editor, context);
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initRes() {
        ResourceUtils.resLabel((JLabel)this.jTargetLabel, (Component)this.jTargetColumnLabel, (String)DialogsLrb.get("AI_EDITOR_TARGET_LABEL"));
    }

    private void initUI() {
        this.setupTableModel(new AttrsTableModelEx());
        this.tablePanel.getTable().setColumnSelectorAvailable(true);
        this.tablePanel.getTable().setShowToolTips(true);
        this.tablePanel.getTable().setUpdateSelectionOnSort(true);
        this.tablePanel.getTable().setRowSelectionAllowed(true);
    }

    private void setupTableModel(AttrsTableModelEx attrsTableModelEx) {
        this.tablePanel.setup((TableModel)((Object)attrsTableModelEx), DialogsLrb.get("AI_EDITOR_TABLE_TITLE"), 0);
        TableCellRenderer tableCellRenderer = FormatTableCellRenderer.getIntegerRenderer();
        HistogramBarRenderer histogramBarRenderer = new HistogramBarRenderer(1.0, true, Formats.ModelViewer.getPercentage());
        TableColumn tableColumn = this.tablePanel.getTable().getColumnModel().getColumn(2);
        tableColumn.setCellRenderer(tableCellRenderer);
        tableColumn = this.tablePanel.getTable().getColumnModel().getColumn(3);
        tableColumn.setCellRenderer(histogramBarRenderer);
        this.tablePanel.getTable().setSortColumn(2, true);
    }

    @Override
    public void load() {
        LoadUI loadUI = new LoadUI();
        loadUI.execute();
    }

    @Override
    public HelpInfo getHelpInfo() {
        String string = "ai_viewer_help";
        return new HelpInfo(string);
    }

    private void initComponents() {
        this.jTargetLabel = new JLabel();
        this.jTargetColumnLabel = new JLabel();
        this.tablePanel = new DataMinerTablePanel();
        this.jTargetLabel.setText("Target:");
        this.jTargetLabel.setName("jTargetLabel");
        this.jTargetColumnLabel.setText("Target Column");
        this.jTargetColumnLabel.setName("jTargetColumnLabel");
        this.tablePanel.setName("tablePanel");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tablePanel, -1, 380, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addComponent(this.jTargetLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTargetColumnLabel, -1, -1, Short.MAX_VALUE))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTargetLabel).addComponent(this.jTargetColumnLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tablePanel, -1, 258, Short.MAX_VALUE).addContainerGap()));
    }

    private class LoadUI
    extends ODMrSwingWorker<Void, Void> {
        public LoadUI() {
            super(AIViewerPanel.this, AIViewerPanel.this.overLayPanel, AIViewerPanel.this.tablePanel.getTable());
        }

        private void loadResults(ColumnFilterNodeType columnFilterNodeType) throws ODMrDAOException {
            for (ColumnFilterAttributeType.Attribute attribute : columnFilterNodeType.getColumnFilterAttributes().getAttribute()) {
                AIViewerPanel.this.attrTypeLookupMap.put(attribute.getName(), attribute.getDataType());
            }
            ColumnFilterResultType columnFilterResultType = columnFilterNodeType.getColumnFilterResults();
            if (columnFilterResultType != null) {
                ColumnFilterAttributeType.Attribute attribute;
                AIViewerPanel.this.statisticLookupMap.clear();
                attribute = columnFilterNodeType.getColumnFilterSettings().getAttrImportantSettings().getTargetAttribute();
                String string = columnFilterResultType.getAttrImportanceOutput();
                ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(AIViewerPanel.this.getContext());
                SqlDataAccessObject sqlDataAccessObject = new SqlDataAccessObject((ConnectionManager)connectionFolder);
                GetAttributeImportanceQuery getAttributeImportanceQuery = new GetAttributeImportanceQuery(connectionFolder.getDbVersion(), string, (AttributeType)attribute, AIViewerPanel.this.attrTypeLookupMap);
                List list = sqlDataAccessObject.readItems((Query)getAttributeImportanceQuery);
                for (Statistics statistics : list) {
                    AIViewerPanel.this.statisticLookupMap.put(statistics.getName(), statistics);
                }
            }
        }

        @Override
        protected Void doInBackground() throws Exception {
            Node node = AIViewerPanel.this.getContext().getNode();
            if (node instanceof ColumnFilterNavNode) {
                ColumnFilterNavNode columnFilterNavNode = (ColumnFilterNavNode)node;
                ColumnFilterNodeType columnFilterNodeType = (ColumnFilterNodeType)columnFilterNavNode.getRepositoryData();
                this.loadResults(columnFilterNodeType);
            }
            return null;
        }

        @Override
        protected void onSuccess(Void void_) {
            if (AIViewerPanel.this.statisticLookupMap.isEmpty()) {
                this.setTableMessage(DialogsLrb.get("AI_EDITOR_TABLE_FAILURE_MESG_TRY_RERUN"));
            } else {
                AIViewerPanel.this.tableModel = new AttrsTableModelEx(AIViewerPanel.this.statisticLookupMap);
                AIViewerPanel.this.setupTableModel(AIViewerPanel.this.tableModel);
                Node node = AIViewerPanel.this.getContext().getNode();
                if (node instanceof ColumnFilterNavNode) {
                    ColumnFilterNavNode columnFilterNavNode = (ColumnFilterNavNode)node;
                    ColumnFilterNodeType columnFilterNodeType = (ColumnFilterNodeType)columnFilterNavNode.getRepositoryData();
                    AIViewerPanel.this.jTargetColumnLabel.setText(columnFilterNodeType.getColumnFilterSettings().getAttrImportantSettings().getTargetAttribute() != null ? columnFilterNodeType.getColumnFilterSettings().getAttrImportantSettings().getTargetAttribute().getName() : DialogsLrb.get("AI_EDITOR_TARGET_NOT_SPECIFIED"));
                }
            }
        }

        @Override
        protected void onFailure(Throwable throwable) {
            if (throwable instanceof SQLException && ((SQLException)throwable).getErrorCode() == 942) {
                this.setTableMessage(DialogsLrb.get("AI_EDITOR_TABLE_FAILURE_MESG_TRY_RERUN"));
                return;
            }
            super.onFailure(throwable);
        }
    }
}

