/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.server.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.dmt.dataminer.core.model.CoreServerConstantsLrb;
import oracle.dmt.dataminer.core.utils.comparator.ToStringComparator;
import oracle.dmt.dataminer.server.model.MiningFunctions;

public enum MiningDetailsModelType {
    ASSOCIATION(CoreServerConstantsLrb.get((String)"MODEL_DETAILS_MODEL_TYPE_ASSOCIATION")),
    ANOMALY_DETECTION(CoreServerConstantsLrb.get((String)"MODEL_DETAILS_MODEL_TYPE_ANOMALY_DETECTION")),
    CLUSTERING(CoreServerConstantsLrb.get((String)"MODEL_DETAILS_MODEL_TYPE_CLUSTERING")),
    EM_CLUSTERING(CoreServerConstantsLrb.get((String)"MODEL_DETAILS_MODEL_TYPE_CLUSTERING")),
    DECISION_TREE(CoreServerConstantsLrb.get((String)"MODEL_DETAILS_MODEL_TYPE_DECISION_TREE")),
    NAIVE_BAYES(CoreServerConstantsLrb.get((String)"MODEL_DETAILS_MODEL_TYPE_NAIVE_BAYES")),
    SVM_CLASSIFICATION(CoreServerConstantsLrb.get((String)"MODEL_DETAILS_MODEL_TYPE_SUPPORT_VECTOR_MACHINES_CLASSIFICAION")),
    SVM_REGRESSION(CoreServerConstantsLrb.get((String)"MODEL_DETAILS_MODEL_TYPE_SUPPORT_VECTOR_MACHINES_REGRESSION")),
    GLM_CLASSIFICATION(CoreServerConstantsLrb.get((String)"MODEL_DETAILS_MODEL_TYPE_GENERALIZED_LINEAR_CLASSIFICATION")),
    GLM_REGRESSION(CoreServerConstantsLrb.get((String)"MODEL_DETAILS_MODEL_TYPE_GENERALIZED_LINEAR_REGRESSION")),
    FEATURE_EXTRACTION(CoreServerConstantsLrb.get((String)"MODEL_DETAILS_MODEL_TYPE_FEATURE_EXTRACTION")),
    SVD_FEATURE_EXTRACTION(CoreServerConstantsLrb.get((String)"MODEL_DETAILS_MODEL_TYPE_FEATURE_EXTRACTION")),
    SCORING_MODELS(CoreServerConstantsLrb.get((String)"MODEL_DETAILS_MODEL_TYPE_SCORING_MODELS")),
    EXPLICIT_SEMANTIC_ANALYSIS(CoreServerConstantsLrb.get((String)"MODEL_DETAILS_MODEL_TYPE_EXPLICIT_FEATURE_EXTRACTION")),
    R_EXTENSIBLE(CoreServerConstantsLrb.get((String)"MODEL_DETAILS_MODEL_TYPE_R_EXTENSIBLE"));

    private final String translation;
    private static final Map<String, MiningDetailsModelType> stringToEnum;

    private MiningDetailsModelType(String string2) {
        this.translation = string2;
    }

    public static MiningDetailsModelType fromString(String string) {
        return stringToEnum.get(string);
    }

    public String toString() {
        return this.translation;
    }

    public static List<MiningDetailsModelType> getMiningDetailsTypeType(MiningFunctions miningFunctions) {
        ArrayList<MiningDetailsModelType> arrayList = new ArrayList<MiningDetailsModelType>();
        if (miningFunctions.equals((Object)MiningFunctions.ANOMALY_DETECTION)) {
            arrayList.add(ANOMALY_DETECTION);
        } else if (miningFunctions.equals((Object)MiningFunctions.ASSOCIATION_RULES)) {
            arrayList.add(ASSOCIATION);
        } else if (miningFunctions.equals((Object)MiningFunctions.CLASSIFICATION)) {
            arrayList.add(DECISION_TREE);
            arrayList.add(GLM_CLASSIFICATION);
            arrayList.add(NAIVE_BAYES);
            arrayList.add(SVM_CLASSIFICATION);
            arrayList.add(SCORING_MODELS);
        } else if (miningFunctions.equals((Object)MiningFunctions.REGRESSION)) {
            arrayList.add(GLM_REGRESSION);
            arrayList.add(SVM_REGRESSION);
            arrayList.add(SCORING_MODELS);
        } else if (miningFunctions.equals((Object)MiningFunctions.CLUSTERING)) {
            arrayList.add(CLUSTERING);
        } else if (miningFunctions.equals((Object)MiningFunctions.FEATURE_EXTRACTION)) {
            arrayList.add(FEATURE_EXTRACTION);
            arrayList.add(EXPLICIT_SEMANTIC_ANALYSIS);
        }
        Collections.sort(arrayList, ToStringComparator.getComparator());
        return arrayList;
    }

    static {
        stringToEnum = new HashMap<String, MiningDetailsModelType>();
        for (MiningDetailsModelType miningDetailsModelType : MiningDetailsModelType.values()) {
            stringToEnum.put(miningDetailsModelType.toString(), miningDetailsModelType);
        }
    }
}

