/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.server.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dmt.dataminer.core.model.filter.SortDirection;
import oracle.dmt.dataminer.core.model.filter.SortSpec;
import oracle.dmt.dataminer.mviewer.ModelViewerPreferenceSettings;
import oracle.dmt.dataminer.mviewer.arrules.ARPreferences;

public class ItemSetsFilterSetting {
    private Double _minSupport;
    private int _maxItemSetLength;
    private int _fetchSize;
    private boolean bUseFilterSpec;
    private List<SortSpec> _sortSpecs;
    private ARPreferences arPreferences;

    public ItemSetsFilterSetting() {
        ModelViewerPreferenceSettings modelViewerPreferenceSettings = ModelViewerPreferenceSettings.getInstance();
        this.arPreferences = ARPreferences.getInstance();
        this._fetchSize = modelViewerPreferenceSettings.getFetchSizeARModel();
        this._minSupport = this.arPreferences.getItemSetMinSupport();
        this._maxItemSetLength = this.arPreferences.getItemSetMaxItems();
        this._sortSpecs = new ArrayList<SortSpec>(3);
        this._sortSpecs.add(new SortSpec("SUPPORT", SortDirection.DESCENDING, true));
        this._sortSpecs.add(new SortSpec("NUMBER_OF_ITEMS", SortDirection.DESCENDING, true));
    }

    public ItemSetsFilterSetting(int n, Double d, int n2, List<SortSpec> list) {
        this._fetchSize = n;
        this._minSupport = d;
        this._maxItemSetLength = n2;
        this._sortSpecs = list;
    }

    public boolean isFirstSortColumnSupport() {
        SortSpec sortSpec = this._sortSpecs.get(0);
        return "SUPPORT".equalsIgnoreCase(sortSpec.getAttributeName());
    }

    public int getFetchSize() {
        return this._fetchSize;
    }

    public void setFetchSize(int n) {
        this._fetchSize = n;
    }

    public List<SortSpec> getSortSpecification() {
        return this._sortSpecs;
    }

    public void setSortSpecification(List<SortSpec> list) {
        this._sortSpecs = list;
    }

    private List<SortSpec> getIsUsedSortSpecItems() {
        Iterator<SortSpec> iterator = this._sortSpecs.iterator();
        ArrayList<SortSpec> arrayList = new ArrayList<SortSpec>();
        SortSpec sortSpec = null;
        while (iterator.hasNext()) {
            sortSpec = iterator.next();
            if (!sortSpec.isUseIt()) continue;
            arrayList.add(sortSpec);
        }
        return arrayList;
    }

    public String getSortString() {
        List<SortSpec> list = this.getIsUsedSortSpecItems();
        Iterator<SortSpec> iterator = list.iterator();
        SortSpec sortSpec = null;
        StringBuilder stringBuilder = new StringBuilder();
        while (iterator.hasNext()) {
            sortSpec = iterator.next();
            if (iterator.hasNext()) {
                stringBuilder.append(sortSpec.getSortSQLString() + ",");
                continue;
            }
            stringBuilder.append(sortSpec.getSortSQLString() + " ");
        }
        return stringBuilder.toString();
    }

    public void setMaxItemSetLength(int n) {
        this._maxItemSetLength = n;
    }

    public int getMaxItemSetLength() {
        return this._maxItemSetLength;
    }

    public void setMinSupport(Double d) {
        this._minSupport = d;
    }

    public Double getMinSupport() {
        return this._minSupport;
    }

    public void setUseFilterSpecification(boolean bl) {
        this.bUseFilterSpec = bl;
    }

    public boolean isUseFilterSpecification() {
        return this.bUseFilterSpec;
    }

    public void updatePreferences() {
        this.arPreferences.setItemSetMaxItems(this._maxItemSetLength);
        this.arPreferences.setItemSetMinSupport(this._minSupport);
    }
}

