/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.partition;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dmt.dataminer.CommonLrb;
import oracle.dmt.dataminer.DataminerGUIPanel;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.partition.PartitionsLrb;
import oracle.dmt.dataminer.partition.ValueCellEditor;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.utils.ODMrSwingWorker;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.ui.ghost.GhostPointingPalette;
import oracle.javatools.ui.ghost.UIConstants;

public class ValueSelectorPanel
extends JPanel
implements DataminerGUIPanel {
    private static final Logger LOGGER = Logger.getLogger(ValueSelectorPanel.class.getName());
    private ValueCellEditor editor;
    private DefaultListModel<String> listModel;
    private DefaultListModel<String> messageModel;
    private GhostPointingPalette ownerDialog;
    private ButtonGroup buttonGroup;
    private JButton jCancelBtn;
    private JRadioButton jContainsRadio;
    private JButton jOkBtn;
    private JScrollPane jScrollPane1;
    private JButton jSearchBtn;
    private JRadioButton jStartsWithRadio;
    private JLabel jValueLabel;
    private JTextField jValueTxt;
    private JList<String> jValuesList;

    public ValueSelectorPanel(ValueCellEditor valueCellEditor) {
        this.editor = valueCellEditor;
        this.listModel = new DefaultListModel();
        this.messageModel = new DefaultListModel();
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.buttonGroup = new ButtonGroup();
        this.jValueLabel = new JLabel();
        this.jValueTxt = new JTextField();
        this.jSearchBtn = new JButton();
        this.jStartsWithRadio = new JRadioButton();
        this.jContainsRadio = new JRadioButton();
        this.jScrollPane1 = new JScrollPane();
        this.jValuesList = new JList();
        this.jOkBtn = new JButton();
        this.jCancelBtn = new JButton();
        this.jValueLabel.setText("Value:");
        this.jSearchBtn.setText("Find");
        this.buttonGroup.add(this.jStartsWithRadio);
        this.jStartsWithRadio.setSelected(true);
        this.jStartsWithRadio.setText("Starts With");
        this.buttonGroup.add(this.jContainsRadio);
        this.jContainsRadio.setText("Contains");
        this.jValuesList.setSelectionMode(0);
        this.jScrollPane1.setViewportView(this.jValuesList);
        this.jOkBtn.setText("OK");
        this.jOkBtn.setPreferredSize(new Dimension(65, 25));
        this.jCancelBtn.setText("Cancel");
        this.jCancelBtn.setPreferredSize(new Dimension(65, 25));
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 250, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addComponent(this.jStartsWithRadio).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jContainsRadio).addGap(0, 0, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jCancelBtn, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jOkBtn, -2, 65, -2)).addGroup(groupLayout.createSequentialGroup().addComponent(this.jValueLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jValueTxt).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSearchBtn, -2, 65, -2))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jValueLabel).addComponent(this.jValueTxt, -2, -1, -2).addComponent(this.jSearchBtn)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jStartsWithRadio).addComponent(this.jContainsRadio)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jScrollPane1, -2, 172, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCancelBtn, -2, -1, -2).addComponent(this.jOkBtn, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    @Override
    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.jValueLabel, (Component)this.jValueTxt, (String)PartitionsLrb.get("VALUE_SELECTOR_VALUE"));
        ResourceUtils.resButton((AbstractButton)this.jStartsWithRadio, (String)PartitionsLrb.get("VALUE_SELECTOR_STARTS"));
        ResourceUtils.resButton((AbstractButton)this.jContainsRadio, (String)PartitionsLrb.get("VALUE_SELECTOR_CONTAINS"));
        ResourceUtils.resButton((AbstractButton)this.jSearchBtn, (String)CommonLrb.get("FIND"));
    }

    @Override
    public void initUI() {
        this.jOkBtn.setEnabled(false);
        String string = this.editor.getCellEditorValue().toString();
        this.jValueTxt.setText(string);
        this.jOkBtn.addActionListener(new OkActionListener());
        this.jCancelBtn.addActionListener(new CancelActionListener());
        this.jValuesList.getSelectionModel().addListSelectionListener(new ValuesListSelectionListener());
        SearchActionListener searchActionListener = new SearchActionListener();
        this.jValueTxt.addActionListener(searchActionListener);
        this.jSearchBtn.addActionListener(searchActionListener);
        SearchWorker searchWorker = new SearchWorker();
        searchWorker.execute();
    }

    public void showAsTooltipDialog(JComponent jComponent) {
        this.ownerDialog = new GhostPointingPalette();
        this.ownerDialog.setTitle(PartitionsLrb.get("PARTITION_DETAILS_TITLE"));
        int n = jComponent.getSize().height - 2;
        this.ownerDialog.setPointing(jComponent, new Point(2, n));
        this.ownerDialog.setLook(UIConstants.Look.LIGHT);
        this.ownerDialog.setHideOnLoseFocus(true);
        this.ownerDialog.add((Component)this);
        this.ownerDialog.setCloseVisible(false);
        this.ownerDialog.setReceivesFocus(true);
        this.ownerDialog.pack();
        this.ownerDialog.show(true, true);
        Point point = jComponent.getLocation();
        Point point2 = this.ownerDialog.getLocation();
        int n2 = point.x - this.getWidth() - 5;
        this.ownerDialog.setLocation(n2, point2.y);
    }

    private class SearchActionListener
    implements ActionListener {
        private SearchActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SearchWorker searchWorker = new SearchWorker();
            searchWorker.execute();
        }
    }

    private class ValuesListSelectionListener
    implements ListSelectionListener {
        private ValuesListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            ValueSelectorPanel.this.jOkBtn.setEnabled(this.isValidSelection(listSelectionEvent));
        }

        private boolean isValidSelection(ListSelectionEvent listSelectionEvent) {
            return listSelectionEvent.getFirstIndex() >= 0 && ValueSelectorPanel.this.jValuesList.getModel() == ValueSelectorPanel.this.listModel;
        }
    }

    private class CancelActionListener
    implements ActionListener {
        private CancelActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ValueSelectorPanel.this.editor.cancelCellEditing();
            ValueSelectorPanel.this.ownerDialog.hidePanel();
        }
    }

    private class OkActionListener
    implements ActionListener {
        private OkActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ValueSelectorPanel.this.editor.commitValue(ValueSelectorPanel.this.jValuesList.getSelectedValue());
            ValueSelectorPanel.this.ownerDialog.hidePanel();
        }
    }

    private class SearchWorker
    extends ODMrSwingWorker<DefaultListModel<String>, Void> {
        private static final String QUERY = "SELECT column_value FROM\n  (SELECT DISTINCT(column_value)\n   FROM all_mining_model_partitions\n   WHERE model_name IN ({MODEL})\n   AND column_name = ? \n   AND UPPER(column_value) LIKE ? \n   ORDER BY column_value)\nWHERE ROWNUM <= 15";
        private SQLHelper helper;

        private SearchWorker() {
            super(ValueSelectorPanel.this);
            ValueSelectorPanel.this.messageModel.clear();
            ValueSelectorPanel.this.messageModel.addElement(CommonLrb.get("LOADING"));
            ValueSelectorPanel.this.jValuesList.setModel(ValueSelectorPanel.this.messageModel);
        }

        @Override
        protected DefaultListModel<String> doInBackground() throws Exception {
            this.helper = new SQLHelper();
            try {
                DefaultListModel<String> defaultListModel = this.executeAndProcessQuery();
                return defaultListModel;
            }
            finally {
                this.helper.close();
            }
        }

        private DefaultListModel<String> executeAndProcessQuery() throws SQLException {
            this.helper.rs = this.executeQuery();
            return this.processResultSet(this.helper.rs);
        }

        private ResultSet executeQuery() throws SQLException {
            String string = StringUtils.getReplacedString(QUERY, "{MODEL}", ValueSelectorPanel.this.editor.getModelSqlList());
            this.helper.conn = ConnectionFolder.getConnection(ValueSelectorPanel.this.editor.getContext());
            this.helper.pstmt = this.helper.conn.prepareStatement(string);
            this.helper.pstmt.setString(1, ValueSelectorPanel.this.editor.getPartitionColumName());
            this.helper.pstmt.setString(2, this.getSQLFilter());
            return this.helper.pstmt.executeQuery();
        }

        private DefaultListModel<String> processResultSet(ResultSet resultSet) throws SQLException {
            ValueSelectorPanel.this.listModel.clear();
            while (resultSet.next()) {
                ValueSelectorPanel.this.listModel.addElement(resultSet.getString(1));
            }
            if (ValueSelectorPanel.this.listModel.isEmpty()) {
                ValueSelectorPanel.this.messageModel.clear();
                ValueSelectorPanel.this.messageModel.addElement(PartitionsLrb.get("VALUE_SELECTOR_NO_MATCH"));
                return ValueSelectorPanel.this.messageModel;
            }
            return ValueSelectorPanel.this.listModel;
        }

        @Override
        protected void onSuccess(DefaultListModel<String> defaultListModel) throws Exception {
            ValueSelectorPanel.this.jValuesList.setModel(defaultListModel);
        }

        @Override
        protected void onFailure(Throwable throwable) {
            LOGGER.log(Level.SEVERE, throwable.getLocalizedMessage(), throwable);
            ValueSelectorPanel.this.messageModel.clear();
            ValueSelectorPanel.this.messageModel.addElement(PartitionsLrb.get("VALUE_SELECTOR_NO_MATCH"));
            ValueSelectorPanel.this.jValuesList.setModel(ValueSelectorPanel.this.messageModel);
        }

        private String getSQLFilter() {
            StringBuilder stringBuilder = new StringBuilder();
            if (ValueSelectorPanel.this.jContainsRadio.isSelected()) {
                stringBuilder.append("%");
            }
            stringBuilder.append(ValueSelectorPanel.this.jValueTxt.getText().toUpperCase());
            stringBuilder.append("%");
            return stringBuilder.toString();
        }
    }
}

