/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.partition;

import java.awt.Component;
import java.awt.event.MouseMotionListener;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.LayoutStyle;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.CommonLrb;
import oracle.dmt.dataminer.DataminerGUIPanel;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.controls.models.ODMrTableModel;
import oracle.dmt.dataminer.core.model.common.build.partition.PartitionColumn;
import oracle.dmt.dataminer.core.model.common.build.partition.PartitionVO;
import oracle.dmt.dataminer.partition.PartitionsLrb;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.infotip.InfoTip;
import oracle.javatools.ui.infotip.InfoTipStyles;
import oracle.javatools.ui.infotip.templates.BalloonTemplate;
import oracle.javatools.ui.infotip.templates.Template;

public class PartitionDetailsPanel
extends JPanel
implements DataminerGUIPanel {
    private PartitionVO partition;
    private DataMinerTablePanel dataMinerTablePanel;
    private JPanel jParitionIDPanel;
    private JLabel jPartitionIDLbl;
    private JLabel jPartitionIDValue;
    private JLabel jPartitionNameLbl;
    private JLabel jPartitionNameValue;
    private JSeparator jSeparator2;

    public PartitionDetailsPanel(PartitionVO partitionVO) {
        this.partition = partitionVO;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    @Override
    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.jPartitionIDLbl, (Component)this.jPartitionIDValue, (String)(PartitionsLrb.get("PARTITIONS_TABLE_COL_ID") + ":"));
        ResourceUtils.resLabel((JLabel)this.jPartitionNameLbl, (Component)this.jPartitionNameValue, (String)(PartitionsLrb.get("PARTITIONS_TABLE_COL_NAME") + ":"));
        ResourceUtils.resLabel((JLabel)this.jPartitionIDValue, null, (String)this.partition.getPartitionID());
        ResourceUtils.resLabel((JLabel)this.jPartitionNameValue, null, (String)this.partition.getPartitionName());
    }

    @Override
    public void initUI() {
        if (this.partition.getPartitionID() == null) {
            this.jParitionIDPanel.setVisible(false);
        }
        this.dataMinerTablePanel.setup((TableModel)((Object)new PartitionTableModel(this.partition.getColumns())), null, 0, true);
        DataMinerTable dataMinerTable = this.dataMinerTablePanel.getTable();
        for (MouseMotionListener mouseMotionListener : dataMinerTable.getMouseMotionListeners()) {
            dataMinerTable.removeMouseMotionListener(mouseMotionListener);
        }
        for (MouseMotionListener mouseMotionListener : dataMinerTable.getTableHeader().getMouseMotionListeners()) {
            dataMinerTable.getTableHeader().removeMouseMotionListener(mouseMotionListener);
        }
    }

    private void initComponents() {
        this.jPartitionNameLbl = new JLabel();
        this.jPartitionNameValue = new JLabel();
        this.jParitionIDPanel = new JPanel();
        this.jPartitionIDValue = new JLabel();
        this.jPartitionIDLbl = new JLabel();
        this.jSeparator2 = new JSeparator();
        this.dataMinerTablePanel = new DataMinerTablePanel();
        this.jPartitionNameLbl.setText("Partition Name:");
        this.jPartitionNameValue.setText("MEX_JAL_FEM_23");
        this.jPartitionIDValue.setText("ODM$$_1");
        this.jPartitionIDLbl.setText("Partition ID:");
        GroupLayout groupLayout = new GroupLayout(this.jParitionIDPanel);
        this.jParitionIDPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.jPartitionIDLbl).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPartitionIDValue).addContainerGap(-1, Short.MAX_VALUE)).addComponent(this.jSeparator2));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(6, 6, 6).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jPartitionIDLbl).addComponent(this.jPartitionIDValue)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator2, -2, 5, -2)));
        GroupLayout groupLayout2 = new GroupLayout(this);
        this.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addComponent(this.jPartitionNameLbl).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPartitionNameValue).addGap(0, 128, Short.MAX_VALUE)).addGroup(groupLayout2.createSequentialGroup().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.dataMinerTablePanel, -1, -1, Short.MAX_VALUE).addComponent(this.jParitionIDPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addContainerGap()))));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addComponent(this.jParitionIDPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jPartitionNameLbl).addComponent(this.jPartitionNameValue)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.dataMinerTablePanel, -1, 150, Short.MAX_VALUE).addContainerGap()));
    }

    public void showAsTooltipDialog(JComponent jComponent) {
        BalloonTemplate balloonTemplate = new BalloonTemplate();
        balloonTemplate.setContent((JComponent)this);
        balloonTemplate.setTitle(OracleIcons.getIcon((String)"info.png"), PartitionsLrb.get("PARTITION_DETAILS_TITLE"));
        InfoTip infoTip = new InfoTip((Template)balloonTemplate, InfoTipStyles.DEFAULT);
        infoTip.show(jComponent);
    }

    private static class PartitionTableModel
    extends ODMrTableModel<PartitionColumn> {
        private static final int NAME = 0;
        private static final int DATA_TYPE = 1;
        private static final int VALUE = 2;
        private static final String[] COLUMNS = new String[]{CommonLrb.get("NAME"), CommonLrb.get("DATA_TYPE"), CommonLrb.get("VALUE")};

        public PartitionTableModel(List<PartitionColumn> list) {
            super(COLUMNS, list);
        }

        public Object getValueAt(int n, int n2) {
            PartitionColumn partitionColumn = (PartitionColumn)this.srcData.get(n);
            switch (n2) {
                case 0: {
                    return partitionColumn.getColumnName();
                }
                case 1: {
                    return partitionColumn.getDataType();
                }
                case 2: {
                    return partitionColumn.getValue();
                }
            }
            assert (false) : "Invalid column number " + n2;
            return null;
        }
    }
}

