/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.partition;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import oracle.dmt.dataminer.CommonLrb;
import oracle.dmt.dataminer.controls.dialog.DialogHelper;
import oracle.dmt.dataminer.core.model.common.build.partition.PartitionColumn;
import oracle.dmt.dataminer.core.model.common.build.partition.PartitionVO;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.dmt.dataminer.navigator.BaseTreeNode;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.partition.ModelPartitionChooserPanel;
import oracle.dmt.dataminer.partition.PartitionDetailsPanel;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.utils.ODMrSwingWorker;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.ide.Context;
import oracle.ide.editor.Editor;
import oracle.ide.model.Node;
import oracle.ide.model.UpdateMessage;
import oracle.ide.util.ObjectUtils;
import oracle.javatools.ui.HyperlinkButton;
import oracle.javatools.util.Version;

public abstract class AbstractPartitionToolbar<T extends AbstractPartitionToolbar>
extends JPanel {
    private static final int MAX_PARTITION_LINK_WIDTH = 400;
    private VirtualInstance<T> instance;
    protected BaseTreeNode node;
    protected Context context;
    protected HyperlinkButton partitionLink;
    protected int componentsWidth = -1;

    public AbstractPartitionToolbar() {
        this.instance = new VirtualInstance(null, null, null);
    }

    protected AbstractPartitionToolbar(VirtualInstance<T> virtualInstance) {
        this.instance = virtualInstance;
    }

    public void setEditor(Editor editor) {
        if (this.node == null) {
            this.setVisible(false);
            Node node = editor.getContext().getNode();
            assert (node instanceof BaseTreeNode);
            this.node = (BaseTreeNode)node;
            this.context = editor.getContext();
            editor.addPropertyChangeListener((PropertyChangeListener)new EditorPropertyChangeListener());
        }
    }

    public void load(Editor editor) {
        this.setEditor(editor);
        this.initVirtualInstance();
        this.initModelInformation();
        this.checkModelPartitions();
    }

    protected abstract void initVirtualInstance();

    protected abstract void initModelInformation();

    protected void checkModelPartitions() {
        ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(this.context);
        List<PartitionVO> list = Collections.emptyList();
        if (DbVersionHelper.isDB122Up((Version)connectionFolder.getDbVersion())) {
            list = DatabaseMetadataUtils.getModelPartitions(connectionFolder, this.getVirtualInstance().getModelSchema(), this.getVirtualInstance().getModelName());
        }
        if (list.isEmpty()) {
            this.hideToolbar();
        } else {
            this.showToolbar(list);
        }
    }

    protected void hideToolbar() {
        this.getVirtualInstance().setNode(null);
        this.getVirtualInstance().getRelatedToolbars().clear();
        this.getVirtualInstance().setPartition(PartitionVO.createEmpty(), false);
        SwingUtilities.invokeLater(() -> this.setVisible(false));
    }

    protected abstract void showToolbar(List<PartitionVO> var1);

    protected void updatePartitionHyperlink() {
        PartitionVO partitionVO = this.instance.getPartition();
        String string = partitionVO == null ? CommonLrb.get("NONE") : partitionVO.getPartitionName();
        this.partitionLink.setEnabled(partitionVO != null);
        this.partitionLink.setText(string);
        this.partitionLink.setToolTipText(string);
        Font font = this.partitionLink.getFont();
        FontMetrics fontMetrics = this.partitionLink.getFontMetrics(font);
        int n = fontMetrics.stringWidth(string);
        Dimension dimension = this.partitionLink.getSize();
        dimension.width = n = Math.min(n, 400);
        dimension.height = 25;
        this.partitionLink.setPreferredSize(dimension);
        int n2 = 400 + this.getComponentsWidth();
        int n3 = n + this.getComponentsWidth() + 20;
        int n4 = Math.min(n3, n2);
        Dimension dimension2 = new Dimension(n4, 30);
        this.setPreferredSize(dimension2);
    }

    protected abstract int getComponentsWidth();

    public String getSelectedPartitionID() {
        PartitionVO partitionVO = this.instance.getPartition();
        return partitionVO == null ? null : partitionVO.getPartitionID();
    }

    public String getSelectedPartitionName() {
        PartitionVO partitionVO = this.instance.getPartition();
        return partitionVO == null ? null : partitionVO.getPartitionName();
    }

    public String getModelName() {
        return this.instance.models[0];
    }

    protected VirtualInstance<T> getVirtualInstance() {
        return this.instance;
    }

    protected void setVirtualInstance(VirtualInstance<T> virtualInstance) {
        this.instance = virtualInstance;
    }

    protected void displayPartitionDetails() {
        LoadPartitionDetails loadPartitionDetails = new LoadPartitionDetails();
        loadPartitionDetails.execute();
    }

    protected void displayPartitionFilterDialog(Context context, String[] stringArray) {
        ModelPartitionChooserPanel modelPartitionChooserPanel = new ModelPartitionChooserPanel(context, stringArray);
        DialogHelper dialogHelper = new DialogHelper(modelPartitionChooserPanel);
        if (dialogHelper.showAsDialog(this)) {
            PartitionVO partitionVO = modelPartitionChooserPanel.getSelectedPartition();
            this.instance.setPartition(partitionVO, true);
        }
    }

    public class EditorPropertyChangeListener
    implements PropertyChangeListener {
        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (this.wasEditorClosed(propertyChangeEvent)) {
                Set set = AbstractPartitionToolbar.this.getVirtualInstance().getRelatedToolbars();
                set.remove(AbstractPartitionToolbar.this);
            }
        }

        private boolean wasEditorClosed(PropertyChangeEvent propertyChangeEvent) {
            return "EDITOR_STATE".equals(propertyChangeEvent.getPropertyName()) && "CLOSED".equals(propertyChangeEvent.getNewValue());
        }
    }

    public class LoadPartitionDetails
    extends ODMrSwingWorker<PartitionVO, Void> {
        private static final String QUERY_PARTITION = "WITH model_partitions as\n   (SELECT DISTINCT mp.partition_name, mp.position, mp.column_name, ma.data_type,\n           NVL(column_value, '(null)') AS column_value\n           FROM all_mining_model_partitions mp, all_mining_model_attributes ma\n           WHERE mp.model_name = ? AND mp.partition_name = ?\n           AND mp.model_name  = ma.model_name\n           AND mp.column_name = ma.attribute_name)\nSELECT \n  partition_name,\n  LISTAGG(column_name , ',') WITHIN GROUP(ORDER BY partition_name, position) as part_cols,\n  LISTAGG(data_type   , ',') WITHIN GROUP(ORDER BY partition_name, position) as part_types,\n  LISTAGG(column_value, '_') WITHIN GROUP(ORDER BY partition_name, position) as part_values\nFROM model_partitions\nGROUP BY partition_name";

        private LoadPartitionDetails() {
            super(AbstractPartitionToolbar.this);
            AbstractPartitionToolbar.this.partitionLink.setEnabled(false);
        }

        @Override
        protected PartitionVO doInBackground() throws Exception {
            PartitionVO partitionVO = AbstractPartitionToolbar.this.instance.getPartition();
            if (this.partitionColumnsNotLoaded(partitionVO)) {
                List<PartitionColumn> list = this.loadPartitionColumns(partitionVO.getPartitionID());
                partitionVO.setColumns(list);
            }
            return partitionVO;
        }

        private boolean partitionColumnsNotLoaded(PartitionVO partitionVO) {
            return partitionVO.getColumns().size() == 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<PartitionColumn> loadPartitionColumns(String string) throws SQLException {
            try (SQLHelper sQLHelper = new SQLHelper();){
                sQLHelper.rs = this.executeQuery(sQLHelper, string);
                List<PartitionColumn> list = this.processResultSet(sQLHelper.rs);
                return list;
            }
        }

        private ResultSet executeQuery(SQLHelper sQLHelper, String string) throws SQLException {
            sQLHelper.conn = ConnectionFolder.getConnection(AbstractPartitionToolbar.this.context);
            sQLHelper.pstmt = sQLHelper.conn.prepareStatement(QUERY_PARTITION);
            sQLHelper.pstmt.setString(1, AbstractPartitionToolbar.this.getModelName());
            sQLHelper.pstmt.setString(2, string);
            return sQLHelper.pstmt.executeQuery();
        }

        private List<PartitionColumn> processResultSet(ResultSet resultSet) throws SQLException {
            ArrayList<PartitionColumn> arrayList = new ArrayList<PartitionColumn>();
            if (resultSet.next()) {
                String string = resultSet.getString("PART_VALUES");
                String[] stringArray = resultSet.getString("PART_COLS").split(",");
                String[] stringArray2 = resultSet.getString("PART_TYPES").split(",");
                String[] stringArray3 = string.split("_");
                for (int i = 0; i < stringArray3.length; ++i) {
                    PartitionColumn partitionColumn = new PartitionColumn(stringArray[i], stringArray2[i], stringArray3[i]);
                    arrayList.add(partitionColumn);
                }
            }
            return arrayList;
        }

        @Override
        protected void onSuccess(PartitionVO partitionVO) throws Exception {
            PartitionDetailsPanel partitionDetailsPanel = new PartitionDetailsPanel(partitionVO);
            partitionDetailsPanel.showAsTooltipDialog((JComponent)AbstractPartitionToolbar.this.partitionLink);
        }

        @Override
        protected void onFinally() {
            AbstractPartitionToolbar.this.partitionLink.setEnabled(true);
        }
    }

    public class SearchPartitionActionListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AbstractPartitionToolbar.this.displayPartitionFilterDialog(AbstractPartitionToolbar.this.context, AbstractPartitionToolbar.this.getVirtualInstance().getModels());
        }
    }

    public class PartitionDetailsActionListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (this.isPartitionSelected(actionEvent)) {
                AbstractPartitionToolbar.this.displayPartitionDetails();
            }
        }

        private boolean isPartitionSelected(ActionEvent actionEvent) {
            assert (actionEvent.getSource() instanceof HyperlinkButton);
            HyperlinkButton hyperlinkButton = (HyperlinkButton)actionEvent.getSource();
            return hyperlinkButton.isEnabled() && AbstractPartitionToolbar.this.getSelectedPartitionID() != null;
        }
    }

    public static class VirtualInstance<T extends AbstractPartitionToolbar> {
        protected String schema;
        protected String[] models;
        protected PartitionVO partition;
        protected Set<T> relatedToolbars;
        protected BaseTreeNode node;

        public VirtualInstance(String[] stringArray, PartitionVO partitionVO, BaseTreeNode baseTreeNode) {
            this.models = stringArray != null ? Arrays.copyOf(stringArray, stringArray.length) : null;
            this.partition = partitionVO;
            this.node = baseTreeNode;
            this.relatedToolbars = new HashSet<T>();
        }

        public void setPartition(PartitionVO partitionVO, boolean bl) {
            if (!ObjectUtils.equal((Object)this.partition, (Object)partitionVO)) {
                this.partition = partitionVO;
                this.updateToolbars();
                if (bl) {
                    this.sendUpdateMessage();
                }
            }
        }

        private void updateToolbars() {
            for (AbstractPartitionToolbar abstractPartitionToolbar : this.getRelatedToolbars()) {
                abstractPartitionToolbar.updatePartitionHyperlink();
            }
        }

        public void sendUpdateMessage() {
            if (this.node != null) {
                UpdateMessage updateMessage = new UpdateMessage(UpdateMessage.CONTENT_MODIFIED, (Object)this.node);
                updateMessage.setProperty("PARTITION", (Object)this.partition.getPartitionID());
                this.node.notifyObservers(this.node, updateMessage);
            }
        }

        public PartitionVO getPartition() {
            return this.partition;
        }

        public String getModelSchema() {
            return this.schema;
        }

        public void setModelSchema(String string) {
            this.schema = string;
        }

        public String getModelName() {
            return this.models[0];
        }

        public void setModelName(String string) {
            this.models = new String[1];
            this.models[0] = string;
        }

        public String[] getModels() {
            return Arrays.copyOf(this.models, this.models.length);
        }

        public void setModels(String[] stringArray) {
            this.models = Arrays.copyOf(stringArray, stringArray.length);
        }

        public BaseTreeNode getNode() {
            return this.node;
        }

        public void setNode(BaseTreeNode baseTreeNode) {
            this.node = baseTreeNode;
        }

        public Set<T> getRelatedToolbars() {
            return this.relatedToolbars;
        }
    }
}

