/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.navigator.modelnodes;

import ilog.views.sdm.IlvSDMException;
import ilog.views.sdm.IlvSDMModel;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dmt.dataminer.core.model.clus.ClusteringDetailRow;
import oracle.dmt.dataminer.core.model.common.build.MiningModelSettings;
import oracle.dmt.dataminer.core.model.common.build.ModelGeneralDescription;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.dmt.dataminer.mviewer.clustering.ClusterDetails;
import oracle.dmt.dataminer.mviewer.clustering.tree.ClusteringTreePreferencesSettings;
import oracle.dmt.dataminer.mviewer.clustering.tree.model.ClusterTreeSDMModel;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.modelnodes.AbstractDiagramModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.EMClusterModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.KMModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.OCModelNode;
import oracle.dmt.dataminer.server.model.Clustering;
import oracle.dmt.dataminer.server.model.ClusteringDetailRowShort;
import oracle.dmt.dataminer.server.model.ClusteringEM;
import oracle.dmt.dataminer.server.model.ClusteringKM;
import oracle.dmt.dataminer.server.model.ClusteringOC;
import oracle.dmt.dataminer.workflow.xmlschema.ModelNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.dmt.dataminer.workflow.xmlschema.TestModelType;
import oracle.javatools.util.Version;

public class ClusteringModelNode
extends AbstractDiagramModelNode {
    private static final Logger theLogger = Logger.getLogger(ClusteringModelNode.class.getName());
    private static final String CLUSTER_DETAILS_LOADED = "oracle.dmt.dataminer.navigator.modelnodes.ClusteringNodelNode.clusterdetails";
    private static final String CLUSTER_DETAILS = "oracle.dmt.dataminer.navigator.modelnodes.ClusteringNodelNode.clusterdetailsloaded";
    private Map<String, Object> _hash = new HashMap<String, Object>();
    private List<ClusteringDetailRow> clusterRowDetails;
    private int topNAttributes;
    private boolean statsEnabled = true;
    private boolean kmNoneOption = false;
    private boolean modelEmpty;

    public ClusteringModelNode() {
        ClusteringTreePreferencesSettings clusteringTreePreferencesSettings = ClusteringTreePreferencesSettings.getInstance();
        this.topNAttributes = clusteringTreePreferencesSettings.getTopNCentroidAttributes();
    }

    public Object getProperty(String string) {
        return this._hash.get(string);
    }

    public void setProperty(String string, Object object) {
        this._hash.put(string, object);
    }

    public void setClusterDetailsLoaded() {
        this._hash.put(CLUSTER_DETAILS_LOADED, Boolean.TRUE);
    }

    public boolean isClusterDetailsLoaded() {
        Boolean bl = (Boolean)this._hash.get(CLUSTER_DETAILS_LOADED);
        if (bl == null) {
            return false;
        }
        return bl;
    }

    public void setClusterDetails(ClusterDetails clusterDetails) {
        this._hash.put(CLUSTER_DETAILS, clusterDetails);
    }

    public ClusterDetails getClusterDetails() {
        return (ClusterDetails)this._hash.get(CLUSTER_DETAILS);
    }

    public void setClusterCountsMap(String string, String string2, Map<String, ClusteringDetailRowShort> map) {
        this._hash.put(string + "." + string2, map);
    }

    public Map<String, ClusteringDetailRowShort> getClusterCountsMap(String string, String string2) {
        return (Map)this._hash.get(string + "." + string2);
    }

    public Clustering getModelLoader() {
        return (Clustering)this._odmModel;
    }

    public void setTopNAttributes(int n) {
        this.topNAttributes = n;
    }

    @Override
    protected void closeImpl() throws IOException {
        super.closeImpl();
        ClusteringTreePreferencesSettings clusteringTreePreferencesSettings = ClusteringTreePreferencesSettings.getInstance();
        this.topNAttributes = clusteringTreePreferencesSettings.getTopNCentroidAttributes();
        if (this._hash != null) {
            this._hash.clear();
        }
    }

    @Override
    protected void loadImpl() {
        ConnectionFolder connectionFolder = (ConnectionFolder)this.getParent().getAncestor(ConnectionFolder.class, true);
        Version version = connectionFolder.getDbVersion();
        try {
            String string;
            Object object;
            String string2 = this.getSchema();
            Object object2 = this.getRepositoryData();
            if (object2 instanceof ModelType) {
                object = (ModelType)object2;
                string = object.getName();
            } else if (object2 instanceof TestModelType.Model) {
                object = (TestModelType.Model)object2;
                string = object.getName();
            } else if (object2 instanceof ModelNodeType.Models.Model) {
                object = (ModelNodeType.Models.Model)object2;
                string = object.getName();
            } else {
                throw new RuntimeException("Invalid state detected");
            }
            if (this instanceof OCModelNode) {
                this._odmModel = new ClusteringOC(connectionFolder, string2, string);
            } else if (this instanceof KMModelNode) {
                this._odmModel = new ClusteringKM(connectionFolder, string2, string);
            } else if (this instanceof EMClusterModelNode) {
                this._odmModel = new ClusteringEM(connectionFolder, string2, string);
            }
            this._odmModel.load();
            boolean bl = this._exists = false == this._odmModel.getModelGeneralDescription().equals(ModelGeneralDescription._NONE);
            if (this._exists) {
                this._odmModel.setPartitionId(this.getPartitionId());
                if (this instanceof OCModelNode) {
                    this.statsEnabled = true;
                } else if (this instanceof KMModelNode) {
                    if (DbVersionHelper.isDB122Up((Version)version)) {
                        object = new ArrayList(1);
                        object.add("KMNS_DETAILS");
                        List<MiningModelSettings> list = this._odmModel.getModelSetting((List<String>)object);
                        MiningModelSettings miningModelSettings = list.get(0);
                        if ("KMNS_DETAILS_ALL".equals(miningModelSettings.getSettingValue())) {
                            this.statsEnabled = true;
                            this.kmNoneOption = false;
                        } else if ("KMNS_DETAILS_HIERARCHY".equals(miningModelSettings.getSettingValue())) {
                            this.statsEnabled = false;
                            this.kmNoneOption = false;
                        } else if ("KMNS_DETAILS_NONE".equals(miningModelSettings.getSettingValue())) {
                            this.kmNoneOption = true;
                            return;
                        }
                    }
                } else if (this instanceof EMClusterModelNode) {
                    object = new ArrayList(1);
                    object.add("EMCS_CLUSTER_STATISTICS");
                    this.modelEmpty = ((ClusteringEM)this._odmModel).isModelEmpty();
                    List<MiningModelSettings> list = this._odmModel.getModelSetting((List<String>)object);
                    MiningModelSettings miningModelSettings = list.get(0);
                    this.statsEnabled = "EMCS_CLUS_STATS_ENABLE".equals(miningModelSettings.getSettingValue());
                }
                this.clusterRowDetails = ((Clustering)this._odmModel).getClusterModelDetails(this.topNAttributes, this.statsEnabled);
            }
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
    }

    public List<ClusteringDetailRow> getClusterRowDetails() {
        return this.clusterRowDetails;
    }

    @Override
    protected IlvSDMModel createModel() {
        if (this._model == null) {
            this._model = new ClusterTreeSDMModel();
        }
        return this._model;
    }

    @Override
    protected void loadEngine() {
        try {
            String[] stringArray = new String[1];
            URL uRL = this.getClass().getResource("/oracle/dmt/dataminer/navigator/css/clust.css");
            stringArray[0] = uRL.toString();
            this.getEngine().setStyleSheets(stringArray);
        }
        catch (IlvSDMException ilvSDMException) {
            theLogger.log(Level.SEVERE, ilvSDMException.getMessage(), ilvSDMException);
        }
    }

    public boolean isStatsEnabled() {
        return this.statsEnabled;
    }

    public boolean isKMnoneOptionEnabled() {
        return this.kmNoneOption;
    }

    public boolean isModelEmpty() {
        return this.modelEmpty;
    }
}

