/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.navigator;

import java.beans.PropertyChangeEvent;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import oracle.dbtools.raptor.connections.AbstractConnectionListener;
import oracle.dbtools.raptor.connections.ConnectionEvent;
import oracle.dbtools.raptor.connections.ConnectionListener;
import oracle.dbtools.raptor.navigator.DatabaseOverlayClient;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.RaptorHashStructureAdapter;
import oracle.dmt.dataminer.navigator.BaseTreeNode;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.ConnectionsFilter;
import oracle.dmt.dataminer.navigator.DataminerNavigatorLrb;
import oracle.dmt.dataminer.utils.DataMinerConnections;
import oracle.ide.config.Preferences;
import oracle.ide.explorer.IconOverlayTracker;
import oracle.ide.model.Element;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.ModelUtil;

public class Connections
extends BaseTreeNode {
    private static Connections s_instance;
    private static String s_immutableName;
    private static String s_toolTip;
    private static final String STORE_ID;
    private static List<ConnectionListener> _privateListeners;
    private ConnectionListener _listener = new AbstractConnectionListener(){

        public void connectionRemoved(ConnectionEvent connectionEvent) {
            String string = connectionEvent.getConnectionName();
            Connections.this.removeConnection(string);
            for (ConnectionListener connectionListener : _privateListeners) {
                connectionListener.connectionRemoved(connectionEvent);
            }
        }

        public void connectionModified(ConnectionEvent connectionEvent) {
            String string = connectionEvent.getOldName();
            String string2 = oracle.dbtools.raptor.utils.Connections.getStoreName((String)string);
            if (ModelUtil.areEqual((Object)string2, (Object)STORE_ID)) {
                Object object;
                String string3 = connectionEvent.getConnectionName();
                if (ModelUtil.areDifferent((Object)string, (Object)string3)) {
                    object = ConnectionsFilter.getConnectionFolder(string, false);
                    if (object != null) {
                        URL uRL = DBURLFormatHelper.getURL((String)"dm", (String)string3);
                        object.setURL(uRL);
                        UpdateMessage.fireObjectRenamed((Subject)object);
                    }
                } else {
                    object = ConnectionsFilter.getConnectionFolder(string3, false);
                    if (object != null) {
                        UpdateMessage.firePropertiesChanged((Subject)object, (PropertyChangeEvent[])new PropertyChangeEvent[0], null);
                    }
                }
            }
            for (Object object : _privateListeners) {
                object.connectionModified(connectionEvent);
            }
        }
    };

    private Connections() {
    }

    public static synchronized Connections getInstance() {
        if (s_instance == null) {
            s_instance = new Connections();
        }
        return s_instance;
    }

    public Icon getIcon() {
        return OracleIcons.getIcon((String)"dbconn.png");
    }

    public String getToolTipText() {
        return s_toolTip;
    }

    @Override
    public String getShortLabel() {
        return s_immutableName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void openImpl() throws IOException {
        oracle.dbtools.raptor.utils.Connections connections = oracle.dbtools.raptor.utils.Connections.getInstance();
        ArrayList arrayList = this._children;
        synchronized (arrayList) {
            Settings settings = Settings.getInstance();
            for (String string : settings.getConnections(STORE_ID)) {
                String string2 = DataMinerConnections.getUnqualifiedName(string);
                ConnectionFolder connectionFolder = ConnectionsFilter.getConnectionFolder(string2, true);
                connectionFolder.setParent(this.getParent());
                this.updateOverlaysForNode(connectionFolder);
                this._children.add(connectionFolder);
            }
        }
        connections.addConnectionListener(this._listener);
    }

    public void addListener(ConnectionListener connectionListener) {
        _privateListeners.add(connectionListener);
    }

    public void removeListener(ConnectionListener connectionListener) {
        _privateListeners.remove(connectionListener);
    }

    protected void closeImpl() throws IOException {
        oracle.dbtools.raptor.utils.Connections.getInstance().removeConnectionListener(this._listener);
    }

    public boolean addConnection(String string) {
        String string2;
        boolean bl = false;
        String string3 = DataMinerConnections.getUnqualifiedName(string);
        if (!oracle.dbtools.raptor.utils.Connections.isPrivateConnection((String)string) && ModelUtil.areEqual((Object)(string2 = oracle.dbtools.raptor.utils.Connections.getStoreName((String)string)), (Object)STORE_ID)) {
            if (Connections.getInstance().exists(string3)) {
                return false;
            }
            ConnectionFolder connectionFolder = ConnectionsFilter.getConnectionFolder(DataMinerConnections.getUnqualifiedName(string), true);
            if (connectionFolder != null) {
                this.updateOverlaysForNode(connectionFolder);
                bl = this.add((Element)connectionFolder, true);
                this.markDirty(false);
                Settings settings = Settings.getInstance();
                settings.addConnection(string2, oracle.dbtools.raptor.utils.Connections.getConnectionName((String)string));
                ConnectionEvent connectionEvent = new ConnectionEvent(0, string);
                for (ConnectionListener connectionListener : _privateListeners) {
                    connectionListener.connectionAdded(connectionEvent);
                }
            }
        }
        return bl;
    }

    public boolean removeConnection(String string) {
        String string2;
        ConnectionFolder connectionFolder;
        boolean bl = false;
        String string3 = oracle.dbtools.raptor.utils.Connections.getStoreName((String)string);
        if (ModelUtil.areEqual((Object)string3, (Object)STORE_ID) && (connectionFolder = ConnectionsFilter.getConnectionFolder(string2 = DataMinerConnections.getUnqualifiedName(string), false)) != null) {
            if (connectionFolder.isConnected()) {
                this.closeNode();
            }
            bl = this.remove((Element)connectionFolder, true);
            this.markDirty(false);
            Settings settings = Settings.getInstance();
            settings.removeConnection(string3, oracle.dbtools.raptor.utils.Connections.getConnectionName((String)string));
            ConnectionEvent connectionEvent = new ConnectionEvent(0, string2);
            for (ConnectionListener connectionListener : _privateListeners) {
                connectionListener.connectionRemoved(connectionEvent);
            }
        }
        return bl;
    }

    public List<String> getConnections() {
        List<String> list = Settings.getInstance().getConnections(STORE_ID);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : list) {
            arrayList.add(DataMinerConnections.getUnqualifiedName(string));
        }
        return arrayList;
    }

    public boolean exists(String string) {
        String string2 = DataMinerConnections.getQualifiedName(string);
        List<String> list = Settings.getInstance().getConnections(STORE_ID);
        return list.contains(string2);
    }

    private void updateOverlaysForNode(ConnectionFolder connectionFolder) {
        IconOverlayTracker iconOverlayTracker = DatabaseOverlayClient.getTracker();
        if (iconOverlayTracker != null) {
            iconOverlayTracker.validateOverlay((Element)connectionFolder);
            iconOverlayTracker.repaintOverlays();
        }
    }

    static {
        s_immutableName = DataminerNavigatorLrb.get("ROOT_FOLDER_LABEL");
        s_toolTip = DataminerNavigatorLrb.get("ROOT_FOLDER_TIP");
        STORE_ID = "IdeConnections";
        _privateListeners = new ArrayList<ConnectionListener>();
    }

    private static class Settings
    extends RaptorHashStructureAdapter {
        private static final String DATA_KEY = "DM.Databases.Settings";

        static Settings getInstance() {
            return new Settings(Settings.findOrCreate((PropertyStorage)Preferences.getPreferences(), (String)DATA_KEY));
        }

        private Settings(HashStructure hashStructure) {
            super(hashStructure);
        }

        protected String getRootKey() {
            return "DM_ACTIVE_CONNS";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        List<String> getConnections(String string) {
            ArrayList<String> arrayList = new ArrayList<String>();
            ListStructure listStructure = this.getRootHash().getOrCreateListStructure(Settings.encode((String)string));
            Object object = listStructure.iteratorLock();
            synchronized (object) {
                Iterator iterator = listStructure.iterator();
                while (iterator.hasNext()) {
                    String string2 = Settings.decode((String)((String)iterator.next()));
                    Connections.ConnectionKey connectionKey = Connections.ConnectionKey.createConnectionKey((String)string, (String)string2);
                    arrayList.add(connectionKey.getQualifiedName());
                }
            }
            return arrayList;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean addConnection(String string, String string2) {
            ListStructure listStructure = this.getRootHash().getOrCreateListStructure(Settings.encode((String)string));
            Object object = listStructure.iteratorLock();
            synchronized (object) {
                Iterator iterator = listStructure.iterator();
                while (iterator.hasNext()) {
                    if (!string2.equals(Settings.decode((String)((String)iterator.next())))) continue;
                    return false;
                }
            }
            return listStructure.add((Object)Settings.encode((String)string2));
        }

        boolean removeConnection(String string, String string2) {
            ListStructure listStructure = this.getRootHash().getOrCreateListStructure(Settings.encode((String)string));
            return listStructure.remove((Object)Settings.encode((String)string2));
        }
    }
}

