/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.navigator;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.dmt.dataminer.core.dal.ODMrDAOException;
import oracle.dmt.dataminer.core.dal.Query;
import oracle.dmt.dataminer.core.dal.sql.queries.clas.common.GetBuildRowsCountQuery;
import oracle.dmt.dataminer.core.model.common.build.ModelDescriptor;
import oracle.dmt.dataminer.navigator.AbstractHiddenNode;
import oracle.dmt.dataminer.repository.TestResult;

public abstract class AbstractTestNode
extends AbstractHiddenNode {
    protected boolean isClassification = true;
    protected Map<String, Integer> buildRows = new HashMap<String, Integer>();

    public void setClassificationTest(boolean bl) {
        this.isClassification = bl;
    }

    public void setRegressionTest(boolean bl) {
        this.isClassification = !bl;
    }

    public boolean isRegressionTest() {
        return !this.isClassification;
    }

    public boolean isClassificationTest() {
        return this.isClassification;
    }

    public void prepareForRefresh() {
        this.buildRows.clear();
    }

    public abstract List<TestResult> getTestResults();

    public Map<String, Integer> getBuildRowsCount(String string, boolean bl) throws ODMrDAOException {
        boolean bl2 = this.buildRows.isEmpty();
        if (bl2 && bl) {
            for (TestResult testResult : this.getTestResults()) {
                ModelDescriptor modelDescriptor = new ModelDescriptor(null, testResult.getName(), string);
                GetBuildRowsCountQuery getBuildRowsCountQuery = new GetBuildRowsCountQuery(this.getDatabaseVersion(), modelDescriptor);
                Integer n = this.getDao().readItem((Query)getBuildRowsCountQuery).orElse(0);
                this.buildRows.put(testResult.getName(), n);
            }
        }
        return this.buildRows;
    }
}

