/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.svd;

import java.awt.Component;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import oracle.dmt.dataminer.controls.TextFieldLimit;
import oracle.dmt.dataminer.controls.dialog.DialogDisplayable;
import oracle.dmt.dataminer.controls.dialog.DialogExecutionException;
import oracle.dmt.dataminer.controls.dialog.Dialogable;
import oracle.dmt.dataminer.controls.dialog.DialogableExecutableAdapter;
import oracle.dmt.dataminer.mviewer.svd.SVDLrb;
import oracle.dmt.dataminer.mviewer.svd.SingularValuesState;
import oracle.ide.util.ResourceUtils;

public class RenameFeaturePanel
extends JPanel
implements DialogDisplayable {
    private String _currentName;
    private SingularValuesState state;
    private JLabel _jRenameLabel;
    private JTextField _jRenameValue;

    public RenameFeaturePanel(SingularValuesState singularValuesState, String string) {
        this._currentName = string;
        this.state = singularValuesState;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this._jRenameLabel = new JLabel();
        this._jRenameValue = new JTextField();
        this._jRenameLabel.setText("Rename To:");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this._jRenameLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._jRenameValue, -1, 193, Short.MAX_VALUE).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._jRenameLabel).addComponent(this._jRenameValue, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void initRes() {
        ResourceUtils.resLabel((JLabel)this._jRenameLabel, (Component)this._jRenameValue, (String)SVDLrb.get("FEATURE_RENAME_TO_LABEL"));
        this._jRenameLabel.getAccessibleContext().setAccessibleDescription(SVDLrb.get("FEATURE_RENAME_TO_LABEL_ADA"));
        this._jRenameValue.setDocument(new TextFieldLimit(30));
    }

    private void initUI() {
        this._jRenameValue.setText(this._currentName);
    }

    @Override
    public Dialogable asDialog() {
        return new DialogableExecutableAdapter(){

            @Override
            public void onOK() throws DialogExecutionException {
                RenameFeaturePanel.this.doWork();
            }

            @Override
            public String getTitle() {
                StringBuilder stringBuilder = new StringBuilder(SVDLrb.get("FEATURE_RENAME_FEATURE"));
                stringBuilder.append(": ");
                stringBuilder.append(RenameFeaturePanel.this._currentName);
                return stringBuilder.toString();
            }

            @Override
            public String getHelpTopic() {
                return "renameFeature.htm";
            }

            @Override
            public JComponent getContent() {
                return RenameFeaturePanel.this;
            }
        };
    }

    private void doWork() throws DialogExecutionException {
        String string = this._jRenameValue.getText().trim();
        if (string.isEmpty()) {
            throw new DialogExecutionException(SVDLrb.get("FEATURE_ERROR_TITLE"), SVDLrb.get("FEATURE_NAME_EMPTY"), null);
        }
        if (string.length() > 4000) {
            throw new DialogExecutionException(SVDLrb.get("FEATURE_ERROR_TITLE"), SVDLrb.get("FEATURE_NAME_TOO_LONG"), null);
        }
        if (string.equals(this._currentName) || !this.state.isFeatureLabelUnique(string)) {
            throw new DialogExecutionException(SVDLrb.get("FEATURE_ERROR_TITLE"), SVDLrb.get("FEATURE_NAME_ALEADY_USED"), null);
        }
        this._currentName = string;
    }

    public String getCurrentName() {
        return this._currentName;
    }
}

