/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.compare;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import oracle.dmt.dataminer.core.dal.ODMrDAOException;
import oracle.dmt.dataminer.core.model.common.build.AttributeBiCoefficient;
import oracle.dmt.dataminer.core.model.common.build.partition.PartitionVO;
import oracle.dmt.dataminer.exception.DataMinerException;
import oracle.dmt.dataminer.mviewer.BaseViewerState;
import oracle.dmt.dataminer.mviewer.compare.CompareGLMItemSetsSettings;
import oracle.dmt.dataminer.mviewer.compare.CompareLrb;
import oracle.dmt.dataminer.mviewer.compare.CompareNBItemSetsSettings;
import oracle.dmt.dataminer.mviewer.compare.CompareSVMItemSetsSettings;
import oracle.dmt.dataminer.mviewer.compare.CompareTableModel;
import oracle.dmt.dataminer.mviewer.compare.NBProbabilitiesCompareTableModel;
import oracle.dmt.dataminer.mviewer.compare.SVMCPropensitiesCompareTableModel;
import oracle.dmt.dataminer.server.model.CompareFilterSetting;
import oracle.dmt.dataminer.server.model.TargetPriorsPredictionSet;
import oracle.dmt.dataminer.utils.ObjectComparator;
import oracle.ide.Context;
import oracle.ide.help.HelpInfo;

public class CompareState
extends BaseViewerState {
    private List<TargetPriorsPredictionSet> _targetValuePriors;
    private CompareFilterSetting _filterSetting;
    private CompareTableModel tableModel;
    private Object _selectedTargetClass;
    private Object _secondSelectedTargetClass;
    private int _totalDetailCount;
    private boolean _queryForTotalDetailCount = true;
    private double maxCoefficient1;
    private double maxCoefficient2;
    private CompareSVMItemSetsSettings compareSVMItemSetsSettings = CompareSVMItemSetsSettings.getInstance();
    private CompareGLMItemSetsSettings compareGLMItemSetsSettings = CompareGLMItemSetsSettings.getInstance();
    private CompareNBItemSetsSettings compareNBItemSetsSettings = CompareNBItemSetsSettings.getInstance();

    CompareState(Context context) {
        super(context);
    }

    public CompareState reloadPropensities(PartitionVO partitionVO) throws Exception {
        if (this._queryForTotalDetailCount) {
            LoadTotalCount loadTotalCount = new LoadTotalCount(this._filterSetting, partitionVO.getPartitionID());
            loadTotalCount.run();
            this._totalDetailCount = loadTotalCount.getCount();
            this._queryForTotalDetailCount = false;
        }
        this.loadPropensities(partitionVO.getPartitionID());
        return this;
    }

    CompareState load(PartitionVO partitionVO) throws Exception {
        Object object;
        this._filterSetting = new CompareFilterSetting(this);
        if (this.isSVM() || this.isAnomaly()) {
            this.getSvmC().setPartitionId(partitionVO.getPartitionID());
            object = null;
            object = this.getSvmC().getAbsMaxValue();
            this._filterSetting.setMinCoefficient(new BigDecimal((Double)object * -1.0));
            this._filterSetting.setMaxCoefficient(new BigDecimal((Double)object));
            this._filterSetting.setFilterByAbsolute(this.compareSVMItemSetsSettings.getSortByAbsoluteValue());
            this._filterSetting.setFetchSize(this.compareSVMItemSetsSettings.getFetchSizeValue());
        } else if (this.isGLM()) {
            this.getGlmC().setPartitionId(partitionVO.getPartitionID());
            object = this.getGlmC().getMinMaxValue();
            this._filterSetting.setMinCoefficient(new BigDecimal(object[0]));
            this._filterSetting.setMaxCoefficient(new BigDecimal(object[1]));
            this._filterSetting.setFilterByAbsolute(this.compareGLMItemSetsSettings.getSortByAbsoluteValue());
            this._filterSetting.setFetchSize(this.compareGLMItemSetsSettings.getFetchSizeValue());
        } else if (this.isNB()) {
            this._filterSetting.setFilterByAbsolute(this.compareNBItemSetsSettings.getSortByAbsoluteValue());
            this._filterSetting.setFetchSize(this.compareNBItemSetsSettings.getFetchSizeValue());
        }
        this.initInternalTable();
        this._targetValuePriors = this.getClassification().getTargetValuePredictionSet(partitionVO);
        if (this._targetValuePriors.size() < 2) {
            throw new DataMinerException(CompareLrb.get("COEFFICIENT_VIEWER_NO_TARGET_PRIORS_VALUES"));
        }
        this._filterSetting.setTargetValuePriors(this._targetValuePriors);
        this.loadDefaultTargetValue();
        object = new LoadTotalCount(this._filterSetting, partitionVO.getPartitionID());
        ((LoadTotalCount)object).run();
        this._totalDetailCount = ((LoadTotalCount)object).getCount();
        this._queryForTotalDetailCount = false;
        this.loadPropensities(partitionVO.getPartitionID());
        return this;
    }

    private void initInternalTable() {
        if (this.isSVM() || this.isAnomaly()) {
            this.tableModel = new SVMCPropensitiesCompareTableModel();
        } else if (this.isGLM()) {
            this.tableModel = new SVMCPropensitiesCompareTableModel();
        } else if (this.isNB()) {
            this.tableModel = new NBProbabilitiesCompareTableModel();
        } else assert (false) : "Invalid node type.";
    }

    private void loadDefaultTargetValue() {
        if (this.isClassification()) {
            if (this.isSVM() || this.isAnomaly()) {
                TargetPriorsPredictionSet targetPriorsPredictionSet = this.getSvmC().findMostCommonTargetValue(this._targetValuePriors);
                this.setSelectedTargetClass(targetPriorsPredictionSet.getPrediction());
                this.setSecondSelectedTargetClass(this.getSvmC().findSecondMostCommonTargetValue(this._targetValuePriors, targetPriorsPredictionSet).getPrediction());
            } else if (this.isGLM()) {
                TargetPriorsPredictionSet targetPriorsPredictionSet = this.getGlmC().findMostCommonTargetValue(this._targetValuePriors);
                this.setSelectedTargetClass(targetPriorsPredictionSet.getPrediction());
                this.setSecondSelectedTargetClass(this.getGlmC().findSecondMostCommonTargetValue(this._targetValuePriors, targetPriorsPredictionSet).getPrediction());
            } else if (this.isNB()) {
                TargetPriorsPredictionSet targetPriorsPredictionSet = this.getNb().findMostCommonTargetValue(this._targetValuePriors);
                this.setSelectedTargetClass(targetPriorsPredictionSet.getPrediction());
                this.setSecondSelectedTargetClass(this.getNb().findSecondMostCommonTargetValue(this._targetValuePriors, targetPriorsPredictionSet).getPrediction());
            }
        }
    }

    private void loadPropensities(String string) throws ODMrDAOException {
        List<Object> list = new ArrayList();
        if (this.isSVM() || this.isAnomaly()) {
            this.getSvmC().setPartitionId(string);
            list = this.getSvmC().getPropensities(this._filterSetting);
        } else if (this.isGLM()) {
            this.getGlmC().setPartitionId(string);
            list = this.getGlmC().getPropensities(this._filterSetting);
        } else if (this.isNB()) {
            this.getNb().setPartitionId(string);
            list = this.getNb().getPropensities(this._filterSetting);
        } else assert (false) : "CompareState not loaded.";
        this.maxCoefficient1 = list.stream().filter(attributeBiCoefficient -> attributeBiCoefficient.getCoefficient1() != null).mapToDouble(AttributeBiCoefficient::getCoefficient1).max().orElse(1.0);
        this.maxCoefficient2 = list.stream().filter(attributeBiCoefficient -> attributeBiCoefficient.getCoefficient2() != null).mapToDouble(AttributeBiCoefficient::getCoefficient2).max().orElse(1.0);
        this.tableModel.setSrcData(list);
    }

    double getMaxCoefficient1() {
        return this.maxCoefficient1;
    }

    double getMaxCoefficient2() {
        return this.maxCoefficient2;
    }

    HelpInfo getHelpInfo() {
        String string = "Help Topic Not Specified";
        if (this.isSVM() && this.isClassification()) {
            string = "svmc_compare";
        } else if (this.isSVM() && this.isRegression()) {
            string = "svmr_compare";
        } else if (this.isGLM() && this.isClassification()) {
            string = "glmc_compare";
        } else if (this.isGLM() && this.isRegression()) {
            string = "glmr_compare";
        } else if (this.isNB()) {
            string = "nb_view_compare";
        }
        if (this.isAnomaly() && this.isClassification()) {
            string = "svmc_compare";
        }
        return new HelpInfo(string);
    }

    void setFilterSetting(CompareFilterSetting compareFilterSetting) {
        this._filterSetting = compareFilterSetting;
        if (this.getSelectedTargetClass() != null) {
            this._filterSetting.setTargetValue(this.getSelectedTargetClass());
        }
        if (this.getSecondSelectedTargetClass() != null) {
            this._filterSetting.setSecondTargetValue(this.getSecondSelectedTargetClass());
        }
    }

    CompareFilterSetting getFilterSetting() {
        return this._filterSetting;
    }

    void setSelectedTargetClass(Object object) {
        this._selectedTargetClass = object;
        this._queryForTotalDetailCount = true;
        this._filterSetting.setTargetValue(object);
    }

    Object getSelectedTargetClass() {
        return this._selectedTargetClass;
    }

    void setSecondSelectedTargetClass(Object object) {
        this._secondSelectedTargetClass = object;
        this._queryForTotalDetailCount = true;
        this._filterSetting.setSecondTargetValue(this._secondSelectedTargetClass);
    }

    Object getSecondSelectedTargetClass() {
        return this._secondSelectedTargetClass;
    }

    CompareTableModel getTableModel() {
        assert (this.isValidState()) : "Invalid state";
        return this.tableModel;
    }

    private boolean isValidState() {
        boolean bl = this.isSVM() || this.isAnomaly() || this.isGLM() || this.isNB();
        return bl;
    }

    void setSortByAbsoluteValue(boolean bl) {
        if (this.isSVM() || this.isAnomaly()) {
            this.compareSVMItemSetsSettings.setSortByAbsoluteValue(bl);
        } else if (this.isGLM()) {
            this.compareGLMItemSetsSettings.setSortByAbsoluteValue(bl);
        } else if (this.isNB()) {
            this.compareNBItemSetsSettings.setSortByAbsoluteValue(bl);
        } else assert (false) : "CoefViewerState not loaded.";
        this.tableModel.setAbsoluteValueSort(bl);
    }

    boolean getSortByAbsoluteValue() {
        assert (this.isValidState()) : "Invalid state";
        boolean bl = this.tableModel.getAbsoluteValueSort();
        return bl;
    }

    int getFetchSizeValue() {
        int n = 1000;
        if (this.isSVM() || this.isAnomaly()) {
            n = this.compareSVMItemSetsSettings.getFetchSizeValue();
        } else if (this.isGLM()) {
            n = this.compareGLMItemSetsSettings.getFetchSizeValue();
        } else if (this.isNB()) {
            n = this.compareNBItemSetsSettings.getFetchSizeValue();
        } else assert (false) : "CoefViewerState not loaded.";
        return n;
    }

    void setFetchSizeValue(int n) {
        if (this.isSVM() || this.isAnomaly()) {
            this.compareSVMItemSetsSettings.setFetchSizeValue(n);
        } else if (this.isGLM()) {
            this.compareGLMItemSetsSettings.setFetchSizeValue(n);
        } else if (this.isNB()) {
            this.compareNBItemSetsSettings.setFetchSizeValue(n);
        } else assert (false) : "CoefViewerState not loaded.";
    }

    List<Object> getTargetPredictions() {
        return ObjectComparator.getTargetPredictions(this._targetValuePriors);
    }

    Integer getTotalDetailCount() {
        return this._totalDetailCount;
    }

    private class LoadTotalCount {
        String _partitionId;
        private CompareFilterSetting _filterSetting;
        private Integer _count;

        private LoadTotalCount(CompareFilterSetting compareFilterSetting, String string) {
            this._filterSetting = compareFilterSetting;
            this._partitionId = string;
        }

        private void run() throws SQLException, ODMrDAOException {
            Integer n = 0;
            if (CompareState.this.isSVM() || CompareState.this.isAnomaly()) {
                if (CompareState.this.isClassification()) {
                    CompareState.this.getSvmC().setPartitionId(this._partitionId);
                    n = CompareState.this.getSvmC().getTotalCountPropensities(this._filterSetting);
                } else if (CompareState.this.isRegression()) {
                    n = 0;
                }
            } else if (CompareState.this.isGLM()) {
                if (CompareState.this.isClassification()) {
                    CompareState.this.getGlmC().setPartitionId(this._partitionId);
                    n = CompareState.this.getGlmC().getTotalCountPropensities(this._filterSetting);
                } else if (CompareState.this.isRegression()) {
                    n = 0;
                } else assert (false) : "Invalid type";
            } else if (CompareState.this.isNB()) {
                CompareState.this.getNb().setPartitionId(this._partitionId);
                n = CompareState.this.getNb().getTotalCountPropensities(this._filterSetting);
            } else assert (false) : "CompareViewerState not loaded. ";
            this._count = n;
        }

        private Integer getCount() {
            return this._count;
        }
    }
}

