/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.coefficients;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dmt.dataminer.DataMinerViewGUI;
import oracle.dmt.dataminer.mviewer.ModelMessagePanel;
import oracle.dmt.dataminer.mviewer.ModelViewerLrb;
import oracle.dmt.dataminer.mviewer.coefficients.CoefViewer;
import oracle.dmt.dataminer.mviewer.coefficients.CoefViewerState;
import oracle.dmt.dataminer.mviewer.coefficients.CoefficientFilterPanel;
import oracle.dmt.dataminer.mviewer.coefficients.ESACoefficientFilterPanel;
import oracle.dmt.dataminer.mviewer.coefficients.GeneralCoeffViewer;
import oracle.dmt.dataminer.mviewer.coefficients.GeneralCoefficientFilterPanel;
import oracle.dmt.dataminer.mviewer.coefficients.PCACoefficientFilterPanel;
import oracle.dmt.dataminer.mviewer.coefficients.RegrCoefViewer;
import oracle.dmt.dataminer.mviewer.coefficients.RegrCoefficientFilterPanel;
import oracle.dmt.dataminer.mviewer.coefficients.SVDCoefficientFilterPanel;
import oracle.dmt.dataminer.navigator.modelnodes.ModelNode;
import oracle.dmt.dataminer.server.model.CoefficientFilterSetting;
import oracle.ide.Context;
import oracle.ide.editor.Editor;
import oracle.ide.help.HelpInfo;
import oracle.javatools.ui.BlockingComponent;

public class CoefViewerMainPanel
extends DataMinerViewGUI {
    private static final Logger LOGGER = Logger.getLogger(CoefViewerMainPanel.class.getName());
    private GeneralCoefficientFilterPanel filterPanel;
    private GeneralCoeffViewer viewerPanel;
    private CoefViewerState state;

    public CoefViewerMainPanel(Editor editor, Context context) {
        super(editor, context);
        ModelNode modelNode = (ModelNode)context.getNode();
        if (modelNode == null) {
            LOGGER.log(Level.FINEST, "null node");
        }
        if (!modelNode.exists()) {
            this.add((Component)new ModelMessagePanel(ModelViewerLrb.get("MODEL_DOES_NOT_EXIST")), "Center");
            return;
        }
        this.state = new CoefViewerState(context);
        this.initComponents();
    }

    public void initComponents() {
        this.setLayout(new BorderLayout());
        if (this.state.isClassification()) {
            this.filterPanel = new CoefficientFilterPanel(this, this.state);
            this.viewerPanel = new CoefViewer(this, this.state);
        } else if (this.state.isSVD()) {
            this.filterPanel = new SVDCoefficientFilterPanel(this, this.state);
            this.viewerPanel = new CoefViewer(this, this.state);
        } else if (this.state.isPCA()) {
            this.filterPanel = new PCACoefficientFilterPanel(this, this.state);
            this.viewerPanel = new CoefViewer(this, this.state);
        } else if (this.state.isFeatureExtraction()) {
            this.viewerPanel = new CoefViewer(this, this.state);
            this.filterPanel = this.state.isESA() ? new ESACoefficientFilterPanel(this, this.state) : new CoefficientFilterPanel(this, this.state);
        } else {
            this.filterPanel = new RegrCoefficientFilterPanel(this, this.state);
            this.viewerPanel = new RegrCoefViewer(this, this.state);
        }
        this.add((Component)this.filterPanel.getUIComponent(), "North");
        this.add((Component)this.viewerPanel.getUIComponent(), "Center");
    }

    @Override
    public void setBlockingComponent(BlockingComponent blockingComponent) {
        super.setBlockingComponent(blockingComponent);
        this.viewerPanel.setBlockingComponent(blockingComponent);
        this.filterPanel.setBlockingComponent(blockingComponent);
    }

    @Override
    public void load() {
        this.viewerPanel.load();
    }

    @Override
    public void reload() {
        if (this.state.isSVD()) {
            ((SVDCoefficientFilterPanel)this.filterPanel).reload();
        } else if (this.state.isPCA()) {
            ((PCACoefficientFilterPanel)this.filterPanel).reload();
        } else if (this.state.isClassification() || this.state.isFeatureExtraction() || this.state.isGLM()) {
            if (this.filterPanel instanceof ESACoefficientFilterPanel) {
                ((ESACoefficientFilterPanel)this.filterPanel).refreshFindValuesQueryPartitionId();
            }
            this.viewerPanel.prepareReload();
        } else {
            this.filterPanel.prepareReload();
        }
    }

    public void reload(String string, String string2) {
        if (this.state.getUserName().equals(string) && this.state.getModelName().equals(string2)) {
            this.reload();
        }
    }

    @Override
    public HelpInfo getHelpInfo() {
        return this.viewerPanel.getHelpInfo();
    }

    public GeneralCoefficientFilterPanel getViewerFilterPanel() {
        return this.filterPanel;
    }

    protected void updateLoaded(boolean bl) {
        this.setLoaded(bl);
    }

    protected void updateLoading(boolean bl) {
        this.setLoading(bl);
    }

    public void setFilterState(CoefficientFilterSetting coefficientFilterSetting) {
        this.viewerPanel.setFilterState(coefficientFilterSetting);
    }

    public void setFilterPanelInitialState(CoefficientFilterSetting coefficientFilterSetting) {
        this.filterPanel.setupUI(coefficientFilterSetting);
    }

    public Object getCachedFilterState() {
        return this.viewerPanel.getCachedFilterState();
    }

    public void setCachedFilterState(CoefficientFilterSetting coefficientFilterSetting) {
        this.viewerPanel.setCachedFilterState(coefficientFilterSetting);
    }

    public void updateTarget() {
        this.filterPanel.updateTarget();
    }

    public void prepareReload() {
        this.viewerPanel.prepareReload();
    }
}

