/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.clustering.component;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.dmt.dataminer.controls.GraphPanel;
import oracle.dmt.dataminer.mviewer.clustering.component.ClusterComponentDataTabPanel;
import oracle.dmt.dataminer.mviewer.clustering.component.ClusterComponentProjections;
import oracle.dmt.dataminer.mviewer.clustering.component.ClusterComponentViewerState;
import oracle.dmt.dataminer.mviewer.clustering.component.ComponentLrb;
import oracle.ide.Context;

public class ClusterComponentDetailPane
extends JTabbedPane
implements ChangeListener {
    private static int index = 0;
    private JPanel _jGraphMainPanel;
    private JPanel _jGraphPanel;
    private ClusterComponentProjections _jProjections;
    private ClusterComponentDataTabPanel _jData;
    private static String _chart_tab = ComponentLrb.get("CLUSTER_COMPONENT_DATA_TAB");
    private static String _projections_tab = ComponentLrb.get("CLUSTER_COMPONENT_PROJ_TAB");

    public void initialize(ClusterComponentViewerState clusterComponentViewerState, Context context) {
        this._jGraphPanel = new JPanel();
        this._jGraphPanel.setLayout(new BorderLayout());
        this._jGraphPanel.setPreferredSize(new Dimension(300, 300));
        this._jGraphMainPanel = new JPanel();
        this._jGraphMainPanel.setLayout(new BorderLayout());
        this._jGraphMainPanel.setPreferredSize(new Dimension(300, 300));
        this._jGraphMainPanel.add((Component)this._jGraphPanel, "Center");
        this._jProjections = new ClusterComponentProjections(clusterComponentViewerState, context);
        this._jData = new ClusterComponentDataTabPanel(clusterComponentViewerState, context);
        this.addTab(ComponentLrb.get("CLUSTER_COMPONENT_CHART_TAB"), null, this._jGraphMainPanel, ComponentLrb.get("CLUSTER_COMPONENT_CHART_TAB_TIP"));
        if (index < 0 || index >= this.getTabCount()) {
            index = this.getTabCount() - 1;
        }
        this.setSelectedIndex(index);
        this.addChangeListener(this);
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        index = this.getSelectedIndex();
    }

    public void createMessagePanel(String string) {
        this._jGraphPanel.removeAll();
        this._jGraphPanel.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 2));
        JLabel jLabel = new JLabel(string);
        Font font = jLabel.getFont();
        Font font2 = font.deriveFont((float)font.getSize() * 2.0f);
        jLabel.setFont(font2);
        int n = this._jGraphPanel.getGraphics() != null ? this._jGraphPanel.getGraphics().getFontMetrics(font2).stringWidth(string) : 400;
        Dimension dimension = this._jGraphPanel.getSize();
        jPanel.add(Box.createHorizontalStrut((dimension.width - n) / 2));
        jPanel.add(jLabel);
        this._jGraphPanel.add(jPanel);
        this._jGraphPanel.updateUI();
    }

    public void layoutCharts(int n, GraphPanel[] graphPanelArray) {
        this._jGraphPanel.removeAll();
        if (n == 1) {
            this._jGraphPanel.setLayout(new BorderLayout());
            this._jGraphPanel.add((Component)graphPanelArray[0], "Center");
        } else if (n % 3 == 0) {
            this._jGraphPanel.setLayout(new GridLayout(0, 3));
        } else {
            this._jGraphPanel.setLayout(new GridLayout(0, 2));
        }
        for (int i = 0; i < n; ++i) {
            this._jGraphPanel.add(graphPanelArray[i]);
        }
        this._jGraphPanel.updateUI();
        this._jGraphMainPanel.updateUI();
    }

    public void updateProjections() {
        this._jProjections.setupTable();
    }

    public void showProjections() {
        int n = this.indexOfTab(_projections_tab);
        if (n > 0) {
            this._jProjections.setupTable();
        }
    }

    public void showFrequency() {
        int n = this.indexOfTab(_chart_tab);
        if (n > 0) {
            this._jData.setupTable();
        }
    }

    public void reset() {
        this._jData.clearTable();
        this._jGraphPanel.removeAll();
        this._jGraphPanel.invalidate();
    }

    public void showDataTab(boolean bl) {
        if (bl) {
            this.insertTab(_chart_tab, null, this._jData, ComponentLrb.get("CLUSTER_COMPONENT_DATA_TAB_TIP"), 1);
        } else {
            int n = this.indexOfTab(_chart_tab);
            if (n > 0) {
                this.removeTabAt(n);
            }
        }
    }

    public void showProjectionsTab(boolean bl) {
        if (bl) {
            this.addTab(_projections_tab, null, this._jProjections, ComponentLrb.get("CLUSTER_COMPONENT_PROJ_TAB_TIP"));
        } else {
            int n = this.indexOfTab(_projections_tab);
            if (n > 0) {
                this.removeTabAt(n);
            }
        }
    }
}

