/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.clustering;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.DataMinerEditor;
import oracle.dmt.dataminer.DataMinerViewGUI;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.controls.GraphModelProvider;
import oracle.dmt.dataminer.controls.GraphPanel;
import oracle.dmt.dataminer.controls.renderers.FormatTableCellRenderer;
import oracle.dmt.dataminer.controls.renderers.HistogramBarRenderer;
import oracle.dmt.dataminer.controls.renderers.MiniHistogramCellRenderer;
import oracle.dmt.dataminer.core.model.common.build.partition.PartitionVO;
import oracle.dmt.dataminer.core.model.graph.GraphDataModel;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.dmt.dataminer.core.utils.format.NumericFormat;
import oracle.dmt.dataminer.mviewer.clustering.ClusterDetailsModel;
import oracle.dmt.dataminer.mviewer.clustering.ClusterDetailsModelRow;
import oracle.dmt.dataminer.mviewer.clustering.ClusterLrb;
import oracle.dmt.dataminer.mviewer.clustering.SingleClusterMainPanel;
import oracle.dmt.dataminer.mviewer.clustering.SingleClusterViewerState;
import oracle.dmt.dataminer.mviewer.clustering.tree.ClusteringTreeEditorLrb;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.modelnodes.AbstractDiagramModelNode;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.server.model.ClusteringFilterSetting;
import oracle.dmt.dataminer.utils.Formats;
import oracle.dmt.dataminer.utils.ODMrSwingWorker;
import oracle.ide.editor.Editor;
import oracle.ide.help.HelpInfo;
import oracle.ide.model.Node;
import oracle.javatools.ui.BlockingComponent;
import oracle.javatools.util.Version;

public class SingleClusterViewer
extends DataMinerViewGUI {
    private static final String NO_SELECTED_ATTRS = ClusterLrb.get("NO_HISTOGRAM_TO_DISPLAY");
    private static final String TOO_MANY_ATTRS = ClusterLrb.get("CLUSTER_DETAIL_SELECTED_ATTRIBUTES_LIMIT");
    private SingleClusterViewerState state;
    private SingleClusterMainPanel mainPanel;
    private JPanel jGraphMainPanel;
    private JPanel jGraphPanel;
    private GraphPanel[] graphPanel;
    private boolean loadedFilterSetting;
    private Dimension histogramRowDimension;
    private boolean _external;
    private boolean _reload;
    private JPanel _jDetailPanel;
    private JSplitPane _jMasterSplitPanel;
    private DataMinerTablePanel dataMinerTablePanel;

    public SingleClusterViewer(Editor editor, SingleClusterMainPanel singleClusterMainPanel, SingleClusterViewerState singleClusterViewerState) {
        super(editor, singleClusterViewerState.getContext());
        this.mainPanel = singleClusterMainPanel;
        this.state = singleClusterViewerState;
        this.histogramRowDimension = new Dimension(120, 25);
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this._jMasterSplitPanel = new JSplitPane();
        this._jDetailPanel = new JPanel();
        this.dataMinerTablePanel = new DataMinerTablePanel();
        this._jMasterSplitPanel.setDividerLocation(300);
        this._jMasterSplitPanel.setOrientation(0);
        this._jMasterSplitPanel.setResizeWeight(0.8);
        this._jMasterSplitPanel.setLastDividerLocation(400);
        GroupLayout groupLayout = new GroupLayout(this._jDetailPanel);
        this._jDetailPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 544, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 279, Short.MAX_VALUE));
        this._jMasterSplitPanel.setRightComponent(this._jDetailPanel);
        this._jMasterSplitPanel.setLeftComponent(this.dataMinerTablePanel);
        GroupLayout groupLayout2 = new GroupLayout(this);
        this.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addComponent(this._jMasterSplitPanel).addContainerGap()));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this._jMasterSplitPanel, -1, 585, Short.MAX_VALUE));
    }

    private void initRes() {
        this.loadRowsOutOfTotalLabel(0, 0);
    }

    private void initUI() {
        this.jGraphPanel = new JPanel();
        this.jGraphPanel.setLayout(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane(this.jGraphPanel);
        this.jGraphMainPanel = new JPanel();
        this.jGraphMainPanel.setLayout(new BorderLayout());
        this.jGraphMainPanel.setPreferredSize(new Dimension(300, 300));
        this.jGraphMainPanel.add((Component)jScrollPane, "Center");
        this._jMasterSplitPanel.setResizeWeight(0.8);
        this._jMasterSplitPanel.setDividerLocation(400);
        this._jMasterSplitPanel.setOneTouchExpandable(true);
        this._jMasterSplitPanel.setRightComponent(this.jGraphMainPanel);
        this.dataMinerTablePanel.getTable().setFillsViewportHeight(true);
        this.dataMinerTablePanel.getTable().setShowGrid(true);
        this.dataMinerTablePanel.getTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                SingleClusterViewer.this.handleSelectionChanged();
            }
        });
        this.setLoading(true);
        this.initializeControls();
        this._jMasterSplitPanel.updateUI();
    }

    public JPanel createMessagePanel(String string) {
        this.jGraphPanel.removeAll();
        this.jGraphPanel.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 2));
        JLabel jLabel = new JLabel(string);
        Font font = jLabel.getFont();
        Font font2 = font.deriveFont((float)font.getSize() * 2.0f);
        jLabel.setFont(font2);
        int n = this.jGraphPanel.getGraphics() != null ? this.jGraphPanel.getGraphics().getFontMetrics(font2).stringWidth(string) : 400;
        Dimension dimension = this.jGraphPanel.getSize();
        jPanel.add(Box.createHorizontalStrut((dimension.width - n) / 2));
        jPanel.add(jLabel);
        this.jGraphPanel.add(jPanel);
        this.jGraphPanel.updateUI();
        return this.jGraphPanel;
    }

    public void setFilterState(ClusteringFilterSetting clusteringFilterSetting, boolean bl) {
        if (this.isLoading()) {
            return;
        }
        this.state.setFilterSetting(clusteringFilterSetting);
        if (this.overLayPanel != null) {
            this.overLayPanel.setState(BlockingComponent.State.BLOCKED);
        }
        this.prepareReload(bl);
    }

    @Override
    public void setLoading(boolean bl) {
        this.mainPanel.updateLoading(bl);
    }

    @Override
    public void setLoaded(boolean bl) {
        if (!this.loadedFilterSetting) {
            this.mainPanel.setFilterPanelInitialState(this.state.getFilterSetting());
            this.loadedFilterSetting = true;
        }
        this.mainPanel.updateLoaded(bl);
    }

    @Override
    public boolean isLoading() {
        return this.mainPanel.isLoading();
    }

    private void initializeControls() {
        this.setupTable(new ClusterDetailsModel(true));
        this.enableControls(false);
    }

    private void enableControls(boolean bl) {
        this.dataMinerTablePanel.getSearchField().setEnabled(bl);
    }

    private void setupTable(ClusterDetailsModel clusterDetailsModel) {
        this.dataMinerTablePanel.setup((TableModel)((Object)clusterDetailsModel), null, new String[]{ClusterDetailsModel.COL_NAMES[0], ClusterDetailsModel.COL_NAMES[4]}, 0);
        this.dataMinerTablePanel.getTable().setSelectionMode(2);
        this.dataMinerTablePanel.getTable().setRowHeight((int)this.histogramRowDimension.getHeight());
        TableColumnModel tableColumnModel = this.dataMinerTablePanel.getTable().getColumnModel();
        NumberFormat numberFormat = Formats.ModelViewer.getPercentage();
        HistogramBarRenderer histogramBarRenderer = new HistogramBarRenderer(100.0, true, numberFormat);
        MiniHistogramCellRenderer miniHistogramCellRenderer = new MiniHistogramCellRenderer((GraphModelProvider)this.state, this.histogramRowDimension);
        TableCellRenderer tableCellRenderer = FormatTableCellRenderer.getModelViewerNumericRenderer();
        TableCellRenderer tableCellRenderer2 = FormatTableCellRenderer.getIntegerRenderer();
        tableColumnModel.getColumn(1).setCellRenderer(miniHistogramCellRenderer);
        tableColumnModel.getColumn(2).setCellRenderer(histogramBarRenderer);
        tableColumnModel.getColumn(3).setCellRenderer(tableCellRenderer2);
        tableColumnModel.getColumn(5).setCellRenderer(tableCellRenderer);
        tableColumnModel.getColumn(6).setCellRenderer(tableCellRenderer);
        tableColumnModel.getColumn(0).setPreferredWidth(200);
        tableColumnModel.getColumn(1).setPreferredWidth(150);
        tableColumnModel.getColumn(2).setPreferredWidth(110);
        tableColumnModel.getColumn(5).setPreferredWidth(90);
        tableColumnModel.getColumn(4).setPreferredWidth(150);
        tableColumnModel.getColumn(3).setPreferredWidth(90);
        tableColumnModel.getColumn(6).setPreferredWidth(90);
    }

    void prepareReload(boolean bl) {
        this.setLoading(true);
        this.enableControls(false);
        this.state.clearRows();
        this.dataMinerTablePanel.getTable().repaint();
        if (this.state.getLevelDetails()) {
            this.createMessagePanel(ClusterLrb.get("NO_HISTOGRAM_TO_DISPLAY"));
        } else {
            this.createMessagePanel(ClusteringTreeEditorLrb.get("KM_NOMODEL_DETAILS_MESSAGE"));
        }
        this.load();
        this._external = bl;
    }

    private void loadRowsOutOfTotalLabel(Integer n, Integer n2) {
        String string = ClusterLrb.get("ATTRIBUTES_ROWS_OUT_OF_TOTAL");
        String string2 = NumericFormat.format((int)(n != null ? n : 0));
        String string3 = NumericFormat.format((int)(n2 != null ? n2 : 0));
        String string4 = MessageFormat.format(string, string2, string3);
        this.dataMinerTablePanel.setTitle(string4);
    }

    private void handleSelectionChanged() {
        boolean bl = true;
        int[] nArray = this.dataMinerTablePanel.getTable().getSelectedRowsInModel();
        String string = null;
        if (null == nArray || nArray.length == 0) {
            bl = false;
            string = NO_SELECTED_ATTRS;
        } else if (nArray.length > 12) {
            bl = false;
            string = TOO_MANY_ATTRS;
        }
        if (!bl) {
            this.createMessagePanel(string);
            return;
        }
        LoadGraphPanel loadGraphPanel = new LoadGraphPanel(nArray);
        loadGraphPanel.execute();
    }

    @Override
    public HelpInfo getHelpInfo() {
        return this.state.getHelpInfo();
    }

    @Override
    public void load() {
        LoadUI loadUI = new LoadUI();
        loadUI.execute();
    }

    private class LoadGraphPanel
    extends ODMrSwingWorker<Void, Void> {
        private GraphDataModel[] localGraphModel;
        private int[] selectedRowsInModel;

        private LoadGraphPanel(int[] nArray) {
            super(SingleClusterViewer.this, SingleClusterViewer.this.overLayPanel);
            this.selectedRowsInModel = nArray;
            this.localGraphModel = new GraphDataModel[nArray.length];
        }

        @Override
        protected Void doInBackground() throws Exception {
            ClusterDetailsModel clusterDetailsModel = (ClusterDetailsModel)((Object)SingleClusterViewer.this.dataMinerTablePanel.getTable().getModel());
            Vector vector = clusterDetailsModel.getDataVector();
            for (int i = 0; i < this.selectedRowsInModel.length; ++i) {
                ClusterDetailsModelRow clusterDetailsModelRow = (ClusterDetailsModelRow)vector.get(this.selectedRowsInModel[i]);
                String string = clusterDetailsModelRow.getFullAttributeName();
                this.localGraphModel[i] = SingleClusterViewer.this.state.createGraphDataModelForAttribute(string);
                this.localGraphModel[i].setTitle(string);
            }
            return null;
        }

        @Override
        protected void onSuccess(Void void_) throws Exception {
            int n;
            int n2 = this.selectedRowsInModel.length;
            SingleClusterViewer.this.graphPanel = new GraphPanel[n2];
            for (n = 0; n < n2; ++n) {
                SingleClusterViewer.this.graphPanel[n] = new GraphPanel(this.localGraphModel[n]);
                this.localGraphModel[n].setDepthRadius(Integer.valueOf(SingleClusterViewer.this.state.getDepthRadius()));
                boolean bl = false;
                if (n2 == 1) {
                    bl = true;
                    this.localGraphModel[n].setLegendSeriesCount(Integer.valueOf(2));
                }
                this.localGraphModel[n].setLegendVisible(bl);
                SingleClusterViewer.this.graphPanel[n].initGraph();
                this.localGraphModel[n].setStyleSelection(SingleClusterViewer.this.state.getStyleSelection());
                SingleClusterViewer.this.graphPanel[n].updateGraphStyle();
            }
            SingleClusterViewer.this.jGraphPanel.removeAll();
            if (n2 == 1) {
                SingleClusterViewer.this.jGraphPanel.setLayout(new BorderLayout());
                SingleClusterViewer.this.jGraphPanel.add((Component)SingleClusterViewer.this.graphPanel[0], "Center");
            } else if (n2 % 3 == 0) {
                SingleClusterViewer.this.jGraphPanel.setLayout(new GridLayout(0, 3));
            } else {
                SingleClusterViewer.this.jGraphPanel.setLayout(new GridLayout(0, 2));
            }
            for (n = 0; n < n2; ++n) {
                SingleClusterViewer.this.jGraphPanel.add(SingleClusterViewer.this.graphPanel[n]);
            }
            SingleClusterViewer.this.jGraphPanel.updateUI();
            SingleClusterViewer.this.jGraphMainPanel.updateUI();
        }

        @Override
        protected void onFailure(Throwable throwable) {
            DataMinerEditor.handleEditorException(SingleClusterViewer.this.getEditor().getContext(), throwable, ClusterLrb.get("DETAIL_CLUSTER_FAILURE_TITLE"), ClusterLrb.get("DETAIL_CLUSTER_FAILURE_MESG"));
        }
    }

    private class LoadUI
    extends ODMrSwingWorker<Boolean, Void> {
        public LoadUI() {
            super(SingleClusterViewer.this, SingleClusterViewer.this.overLayPanel);
        }

        @Override
        protected void onSuccess(Boolean bl) throws Exception {
            if (!SingleClusterViewer.this.state.getLevelDetails()) {
                SingleClusterViewer.this.setupTable(new ClusterDetailsModel(false));
                boolean bl2 = DbVersionHelper.isDB122Up((Version)ConnectionFolder.getConnectionFolder(SingleClusterViewer.this.state.getContext()).getDbVersion());
                if (bl2) {
                    SingleClusterViewer.this.createMessagePanel(ClusteringTreeEditorLrb.get("KM_NOMODEL_DETAILS_MESSAGE"));
                }
            } else {
                SingleClusterViewer.this.setupTable(SingleClusterViewer.this.state.getTableModel());
                SingleClusterViewer.this.dataMinerTablePanel.trySearch();
                SingleClusterViewer.this.loadRowsOutOfTotalLabel(SingleClusterViewer.this.state.getTableModel().getRowCount(), SingleClusterViewer.this.state.getTotalNumberOfModelAttributes());
                SingleClusterViewer.this.enableControls(true);
                if (SingleClusterViewer.this.dataMinerTablePanel.getTable().getRowCount() > 0) {
                    int n = SingleClusterViewer.this.dataMinerTablePanel.getTable().convertRowIndexToModel(0);
                    SingleClusterViewer.this.dataMinerTablePanel.getTable().setSelectedRowsInModel(new int[]{n});
                }
                if (!SingleClusterViewer.this._reload || SingleClusterViewer.this._external) {
                    SingleClusterViewer.this.mainPanel.updateClusterIDs();
                }
            }
            SingleClusterViewer.this.setLoaded(true);
            SingleClusterViewer.this.setLoading(false);
        }

        @Override
        protected Boolean doInBackground() throws Exception {
            PartitionVO partitionVO;
            String string = "";
            Node node = SingleClusterViewer.this.getContext().getNode();
            AbstractDiagramModelNode abstractDiagramModelNode = (AbstractDiagramModelNode)node;
            String string2 = abstractDiagramModelNode.getOdmModel().getUserName();
            String string3 = abstractDiagramModelNode.getOdmModel().getModelName();
            ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(SingleClusterViewer.this.getContext());
            boolean bl = DatabaseMetadataUtils.isModelPartitioned(connectionFolder, string2, string3, partitionVO = new PartitionVO("", ""));
            if (bl) {
                string = partitionVO.getPartitionID();
            }
            SingleClusterViewer.this.state.load(string);
            return SingleClusterViewer.this.state.isLoaded();
        }
    }
}

