/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.clustering;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import oracle.dmt.dataminer.mviewer.ModelViewerPartitionToolbar;
import oracle.dmt.dataminer.mviewer.ModelViewerPreferenceSettings;
import oracle.dmt.dataminer.mviewer.clustering.ClusterLrb;
import oracle.dmt.dataminer.mviewer.clustering.SingleClusterMainPanel;
import oracle.dmt.dataminer.mviewer.clustering.SingleClusterViewerState;
import oracle.dmt.dataminer.server.model.ClusteringDetailRowShort;
import oracle.dmt.dataminer.server.model.ClusteringFilterSetting;
import oracle.ide.Ide;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.icons.OracleIcons;

public class ClusterFilterPanel
extends JPanel {
    private static final ModelViewerPreferenceSettings modelPrefences = ModelViewerPreferenceSettings.getInstance();
    private boolean reloadingClusterCombo;
    private ClusteringFilterSetting clusterFilterSetting;
    SingleClusterMainPanel mainPanel;
    SingleClusterViewerState state;
    private JLabel _jClusterComboLabel;
    private JPanel fetchLabelPanel;
    private JPanel fetchSizePanel;
    private JButton jApplyFilterButton;
    private JComboBox<Object> jClusterCombo;
    private JSpinner jFetchSize;
    private JLabel jFetchSizeLabel;
    private JCheckBox jLeafsOnlyCheckBox;
    private ModelViewerPartitionToolbar modelViewerPartitionToolbar1;
    private JPanel topPanel;

    public ClusterFilterPanel(SingleClusterMainPanel singleClusterMainPanel, SingleClusterViewerState singleClusterViewerState) {
        this.mainPanel = singleClusterMainPanel;
        this.state = singleClusterViewerState;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.topPanel = new JPanel();
        this._jClusterComboLabel = new JLabel();
        this.jClusterCombo = new JComboBox();
        this.jLeafsOnlyCheckBox = new JCheckBox();
        this.fetchSizePanel = new JPanel();
        this.fetchLabelPanel = new JPanel();
        this.jFetchSizeLabel = new JLabel();
        this.jFetchSize = new JSpinner();
        this.jApplyFilterButton = new JButton();
        this.modelViewerPartitionToolbar1 = new ModelViewerPartitionToolbar();
        this.topPanel.setLayout(new FlowLayout(0, 12, 0));
        this._jClusterComboLabel.setText("Cluster:");
        this._jClusterComboLabel.setToolTipText("");
        this.topPanel.add(this._jClusterComboLabel);
        this.jClusterCombo.setMaximumSize(new Dimension(150, 20));
        this.jClusterCombo.setMinimumSize(new Dimension(150, 20));
        this.jClusterCombo.setPreferredSize(new Dimension(170, 23));
        this.topPanel.add(this.jClusterCombo);
        this.jLeafsOnlyCheckBox.setText("Leafs Only");
        this.topPanel.add(this.jLeafsOnlyCheckBox);
        this.fetchSizePanel.setLayout(new FlowLayout(0, 0, 0));
        this.jFetchSizeLabel.setText("Fetch Size:");
        this.fetchLabelPanel.add(this.jFetchSizeLabel);
        this.fetchSizePanel.add(this.fetchLabelPanel);
        this.jFetchSize.setMaximumSize(new Dimension(87, 20));
        this.jFetchSize.setMinimumSize(new Dimension(87, 20));
        this.jFetchSize.setPreferredSize(new Dimension(85, 20));
        this.fetchSizePanel.add(this.jFetchSize);
        this.jApplyFilterButton.setText("Query");
        this.jApplyFilterButton.setMaximumSize(new Dimension(87, 23));
        this.jApplyFilterButton.setMinimumSize(new Dimension(87, 23));
        this.jApplyFilterButton.setPreferredSize(new Dimension(87, 23));
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addComponent(this.topPanel, -1, 446, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fetchSizePanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jApplyFilterButton, -2, 110, -2)).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.modelViewerPartitionToolbar1, -1, -1, Short.MAX_VALUE))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(6, 6, 6).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.topPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jApplyFilterButton, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.fetchSizePanel, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.modelViewerPartitionToolbar1, -2, -1, -2).addGap(6, 6, 6)));
    }

    public void initRes() {
        ResourceUtils.resLabel((JLabel)this._jClusterComboLabel, this.jClusterCombo, (String)ClusterLrb.get("DETAIL_CLUSTER"));
        this._jClusterComboLabel.getAccessibleContext().setAccessibleName(ClusterLrb.get("DETAIL_CLUSTER"));
        this._jClusterComboLabel.getAccessibleContext().setAccessibleDescription(ClusterLrb.get("DETAIL_CLUSTER_ADA"));
        this._jClusterComboLabel.setLabelFor(this.jClusterCombo);
        ResourceUtils.resButton((AbstractButton)this.jApplyFilterButton, (String)ClusterLrb.get("QUERY"));
        this.jApplyFilterButton.getAccessibleContext().setAccessibleName(ClusterLrb.get("QUERY"));
        this.jApplyFilterButton.getAccessibleContext().setAccessibleDescription(ClusterLrb.get("QUERY_ADA"));
        this.jApplyFilterButton.setIcon(OracleIcons.getIcon((String)"run.png"));
        this.jApplyFilterButton.setToolTipText(ClusterLrb.get("QUERY_ADA"));
        ResourceUtils.resLabel((JLabel)this.jFetchSizeLabel, (Component)this.jFetchSize, (String)ClusterLrb.get("FETCH_SIZE"));
        this.jFetchSizeLabel.getAccessibleContext().setAccessibleName(ClusterLrb.get("FETCH_SIZE"));
        this.jFetchSizeLabel.getAccessibleContext().setAccessibleDescription(ClusterLrb.get("FETCH_SIZE_ADA"));
        this.jFetchSizeLabel.setLabelFor(this.jFetchSize);
        this.jFetchSize.setToolTipText(ClusterLrb.get("FETCH_SIZE_ADA") + "\n" + ClusterLrb.get("FETCH_SIZE_RANGE"));
        this.jFetchSize.setModel(new SpinnerNumberModel(1000, 1, Integer.MAX_VALUE, 100));
        ResourceUtils.resButton((AbstractButton)this.jLeafsOnlyCheckBox, (String)ClusterLrb.get("LEAVES_ONLY"));
        this.jLeafsOnlyCheckBox.getAccessibleContext().setAccessibleName(ClusterLrb.get("LEAVES_ONLY"));
        this.jLeafsOnlyCheckBox.getAccessibleContext().setAccessibleDescription(ClusterLrb.get("LEAVES_ONLY_ADA"));
        this.jLeafsOnlyCheckBox.setToolTipText(ClusterLrb.get("LEAVES_ONLY_ADA"));
    }

    public void initUI() {
        this.setLocale(this.jFetchSize, Locale.getDefault());
        this.jLeafsOnlyCheckBox.setSelected(false);
        this.jLeafsOnlyCheckBox.setEnabled(false);
        this.jLeafsOnlyCheckBox.addActionListener(new LeafsOnlyActionListener());
        this.jApplyFilterButton.addActionListener(new ApplyFilterActionListener());
        this.jClusterCombo.addActionListener(new ClusterComboActionListener());
        this.jClusterCombo.setModel(new DefaultComboBoxModel());
        this.enableControls(true);
        ((GroupLayout)this.getLayout()).invalidateLayout(this);
    }

    public void load() {
        this.modelViewerPartitionToolbar1.load(this.mainPanel.getEditor());
    }

    public String getSelectedPartitionName() {
        return this.modelViewerPartitionToolbar1.getSelectedPartitionName();
    }

    public String getSelectedParitionId() {
        return this.modelViewerPartitionToolbar1.getSelectedPartitionID();
    }

    public void loadClusterCombo() {
        this.reloadingClusterCombo = true;
        this.jClusterCombo.setModel(new DefaultComboBoxModel<Object>(this.state.getClusterLabels()));
        this.jClusterCombo.setSelectedItem(this.state.getClusterLabel());
        this.reloadingClusterCombo = false;
    }

    public void setupClusterCombo() {
        this.reloadingClusterCombo = true;
        this.jClusterCombo.setModel(new DefaultComboBoxModel<Object>(this.state.getClusterLabels()));
        boolean bl = this.state.getClusterLabels().length > 1;
        this.jLeafsOnlyCheckBox.setEnabled(bl);
        this.jLeafsOnlyCheckBox.setSelected(bl);
        this.jClusterCombo.setSelectedItem(this.state.getClusterLabel());
        this.reloadingClusterCombo = false;
    }

    private void enableControls(boolean bl) {
        this.jApplyFilterButton.setEnabled(bl);
        this.jFetchSize.setEnabled(bl);
        this.jFetchSizeLabel.setEnabled(bl);
        this._jClusterComboLabel.setEnabled(bl);
        this.jClusterCombo.setEnabled(bl);
    }

    private void setNumber(JSpinner jSpinner, Number number) {
        jSpinner.setValue(number);
    }

    public void setLoading(boolean bl) {
        this.enableControls(!bl);
    }

    private void prepareReload() {
        this.enableControls(false);
        this.mainPanel.prepareReload(false);
    }

    public boolean isLoading() {
        return this.mainPanel.isLoading();
    }

    public void executeAppy() {
        try {
            this.jApplyFilterButton.setEnabled(false);
            if (this.validateSettings()) {
                this.mainPanel.setFilterState(this.clusterFilterSetting, true);
            }
            this.jApplyFilterButton.setEnabled(true);
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)ClusterLrb.get("FILTER_PROCESS_FAILURE_TITLE"), (String)ClusterLrb.get("FILTER_PROCESS_FAILURE_MESG"), null);
            this.jApplyFilterButton.setEnabled(true);
        }
    }

    private boolean validateSettings() throws Exception {
        boolean bl = false;
        bl = true;
        Number number = this.getNumber(this.jFetchSize);
        this.clusterFilterSetting.setFetchSize(number.intValue());
        this.clusterFilterSetting.setUseFilterSpecification(false);
        return bl;
    }

    private void setLocale(JSpinner jSpinner, Locale locale) {
        jSpinner.setLocale(locale);
    }

    private Number getNumber(JSpinner jSpinner) {
        return (Number)jSpinner.getValue();
    }

    public void setupUI(ClusteringFilterSetting clusteringFilterSetting) {
        this.clusterFilterSetting = clusteringFilterSetting;
        this.loadStateAttributes();
        this.enableControls(true);
    }

    private void loadStateAttributes() {
        if (this.clusterFilterSetting != null) {
            this.setNumber(this.jFetchSize, modelPrefences.getFetchSizeClusteringModel());
        }
    }

    private void applyFilter() {
        try {
            this.jApplyFilterButton.setEnabled(false);
            if (this.validateSettings()) {
                this.mainPanel.setFilterState(this.clusterFilterSetting, false);
            }
            this.jApplyFilterButton.setEnabled(true);
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)ClusterLrb.get("FILTER_PROCESS_FAILURE_TITLE"), (String)ClusterLrb.get("FILTER_PROCESS_FAILURE_MESG"), null);
            this.jApplyFilterButton.setEnabled(true);
        }
    }

    private class ApplyFilterActionListener
    implements ActionListener {
        private ApplyFilterActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ClusterFilterPanel.this.applyFilter();
        }
    }

    private class ClusterComboActionListener
    implements ActionListener {
        private ClusterComboActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                if (ClusterFilterPanel.this.isLoading() || ClusterFilterPanel.this.reloadingClusterCombo) {
                    return;
                }
                ClusterFilterPanel.this.setLoading(true);
                String string = (String)ClusterFilterPanel.this.jClusterCombo.getSelectedItem();
                ClusteringDetailRowShort clusteringDetailRowShort = ClusterFilterPanel.this.state.getClusterLabelToIDMap().get(string);
                ClusterFilterPanel.this.state.setCluster_id(clusteringDetailRowShort.getId());
                ClusterFilterPanel.this.state.setClusterLabel(string);
                if (!ClusterFilterPanel.this.validateSettings()) {
                    return;
                }
                ClusterFilterPanel.this.prepareReload();
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)ClusterLrb.get("FILTER_PROCESS_FAILURE_TITLE"), (String)ClusterLrb.get("FILTER_PROCESS_FAILURE_MESG"), null);
                ClusterFilterPanel.this.jApplyFilterButton.setEnabled(true);
            }
        }
    }

    private class LeafsOnlyActionListener
    implements ActionListener {
        private LeafsOnlyActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (ClusterFilterPanel.this.isLoading()) {
                return;
            }
            String string = ClusterFilterPanel.this.state.getClusterLabel();
            boolean bl = ClusterFilterPanel.this.jLeafsOnlyCheckBox.isSelected();
            ClusterFilterPanel.this.state.setLeafsOnly(bl);
            ClusterFilterPanel.this.loadClusterCombo();
            if (!string.equals(ClusterFilterPanel.this.state.getClusterLabel())) {
                ClusterFilterPanel.this.applyFilter();
            }
        }
    }
}

