/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.arrules.formatters;

import java.text.NumberFormat;
import java.util.HashMap;
import oracle.dmt.dataminer.core.model.ar.Rule;
import oracle.dmt.dataminer.core.utils.StringUtils;
import oracle.dmt.dataminer.core.utils.res.ARLrb;
import oracle.dmt.dataminer.mviewer.ModelViewerPreferenceSettings;
import oracle.dmt.dataminer.mviewer.arrules.ARRulesLrb;
import oracle.dmt.dataminer.mviewer.arrules.formatters.ARRuleAbstractFormatter;
import oracle.dmt.dataminer.utils.FileHelper;
import oracle.dmt.dataminer.utils.Formats;
import oracle.ide.config.Preferences;
import oracle.javatools.data.PropertyStorage;

public class ARRuleStandardFormatter
extends ARRuleAbstractFormatter {
    private String ruleHTMLTemplate = FileHelper.loadFile("/oracle/dmt/dataminer/mviewer/res/ARRuleTemplate.html");
    private ModelViewerPreferenceSettings preferences = ModelViewerPreferenceSettings.getInstance((PropertyStorage)Preferences.getPreferences());

    @Override
    public String formatBody(Rule rule) {
        NumberFormat numberFormat = Formats.ModelViewer.getPercentage();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("STANDARD_METRICS", ARRulesLrb.get("METRIC_DETAILS_STANDARD"));
        hashMap.put("LIFT_LABEL", ARLrb.get((String)"LIFT"));
        hashMap.put("LIFT_VALUE", numberFormat.format(rule.getLift()));
        hashMap.put("CONFIDENCE_LABEL", ARLrb.get((String)"CONFIDENCE_PERCENT"));
        hashMap.put("CONFIDENCE_VALUE", numberFormat.format(rule.getConfidence() * 100.0));
        hashMap.put("SUPPORT_LABEL", ARLrb.get((String)"SUPPORT_PERCENT"));
        hashMap.put("SUPPORT_VALUE", numberFormat.format(rule.getSupport() * 100.0));
        hashMap.put("ANTECEDENT_SUPPORT_LABEL", ARLrb.get((String)"ANTECENT_SUPPORT_PERCENT"));
        hashMap.put("ANTECEDENT_SUPPORT_VALUE", numberFormat.format(rule.getAntecedentSupport() * 100.0));
        hashMap.put("CONSEQUENT_SUPPORT_LABEL", ARLrb.get((String)"CONSEQUENT_SUPPORT_PERCENT"));
        hashMap.put("CONSEQUENT_SUPPORT_VALUE", numberFormat.format(rule.getConsequentSupport() * 100.0));
        hashMap.put("LENGTH_LABEL", ARLrb.get((String)"ITEMS_IN_RULE"));
        hashMap.put("LENGTH_VALUE", Integer.toString(rule.getNumberOfItems()));
        String string = StringUtils.getReplacedString((String)this.ruleHTMLTemplate, hashMap);
        return string;
    }
}

