/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer;

import java.awt.Container;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import oracle.dmt.dataminer.mviewer.ModelViewerLrb;
import oracle.dmt.dataminer.mviewer.ModelViewerPreferenceSettings;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.ResourceUtils;

public class ModelViewerPreferencesPanel
extends DefaultTraversablePanel {
    private Integer _percentagePrecisionLevel = 4;
    private Integer _numericalPrecisionLevel = 4;
    private Integer _fetchSizeARModel = 10000;
    private Integer _fetchSizeOtherModels = 10000;
    private Integer _fetchSizeClusteringModel = 100;
    private JSpinner jFetchSizeARValueSpinner;
    private JSpinner jFetchSizeClusteringValueSpinner;
    private JLabel jFetchSizeForARLabel;
    private JLabel jFetchSizeForClusteringLabel;
    private JLabel jFetchSizeForOthersLabel;
    private JSpinner jFetchSizeForOthersValueSpinner;
    private JLabel jFetchSizeGroupDescription;
    private JSpinner jNumericalPrecisionValueSpinner;
    private JLabel jNumericalValuesPrecisionLabel;
    private JSpinner jPercentagePrecisionValueSpinner;
    private JLabel jPercentageValuesPrecisionLabel;
    private JLabel jPrecisionGroupDescription;

    public ModelViewerPreferencesPanel() {
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.jPercentageValuesPrecisionLabel = new JLabel();
        this.jPercentagePrecisionValueSpinner = new JSpinner();
        this.jPrecisionGroupDescription = new JLabel();
        this.jNumericalValuesPrecisionLabel = new JLabel();
        this.jNumericalPrecisionValueSpinner = new JSpinner();
        this.jFetchSizeGroupDescription = new JLabel();
        this.jFetchSizeForARLabel = new JLabel();
        this.jFetchSizeARValueSpinner = new JSpinner();
        this.jFetchSizeForOthersLabel = new JLabel();
        this.jFetchSizeForOthersValueSpinner = new JSpinner();
        this.jFetchSizeForClusteringLabel = new JLabel();
        this.jFetchSizeClusteringValueSpinner = new JSpinner();
        this.jPercentageValuesPrecisionLabel.setText("Percentage Based Values:");
        this.jPrecisionGroupDescription.setText("Precision Settings:");
        this.jNumericalValuesPrecisionLabel.setText("Numerical Values:");
        this.jFetchSizeGroupDescription.setText("Fetch Size Settings:");
        this.jFetchSizeForARLabel.setText("Association Rules Model:");
        this.jFetchSizeForOthersLabel.setText("All Other Models:");
        this.jFetchSizeForClusteringLabel.setText("Clustering Model:");
        GroupLayout groupLayout = new GroupLayout((Container)((Object)this));
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(10, 10, 10).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jNumericalValuesPrecisionLabel, -1, -1, Short.MAX_VALUE).addComponent(this.jPercentageValuesPrecisionLabel, -1, 195, Short.MAX_VALUE)).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jFetchSizeForOthersLabel, -1, -1, Short.MAX_VALUE).addComponent(this.jFetchSizeForClusteringLabel, -1, -1, Short.MAX_VALUE).addComponent(this.jFetchSizeForARLabel, -1, 148, Short.MAX_VALUE))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jFetchSizeARValueSpinner, GroupLayout.Alignment.TRAILING, -1, 128, Short.MAX_VALUE).addComponent(this.jFetchSizeClusteringValueSpinner, GroupLayout.Alignment.TRAILING, -1, 128, Short.MAX_VALUE).addComponent(this.jFetchSizeForOthersValueSpinner, GroupLayout.Alignment.TRAILING, -1, 128, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jNumericalPrecisionValueSpinner, GroupLayout.Alignment.TRAILING, -2, 47, -2).addComponent(this.jPercentagePrecisionValueSpinner, GroupLayout.Alignment.TRAILING, -2, 47, -2)))).addGap(64, 64, 64)).addGroup(groupLayout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.jFetchSizeGroupDescription, -1, 240, Short.MAX_VALUE).addContainerGap(150, Short.MAX_VALUE)).addGroup(groupLayout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.jPrecisionGroupDescription, -1, 366, Short.MAX_VALUE).addContainerGap(24, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jPrecisionGroupDescription).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addGroup(groupLayout.createSequentialGroup().addComponent(this.jPercentageValuesPrecisionLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jNumericalValuesPrecisionLabel)).addGroup(groupLayout.createSequentialGroup().addComponent(this.jPercentagePrecisionValueSpinner, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jNumericalPrecisionValueSpinner, -2, -1, -2))).addGap(18, 18, 18).addComponent(this.jFetchSizeGroupDescription).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jFetchSizeForARLabel).addComponent(this.jFetchSizeARValueSpinner, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jFetchSizeClusteringValueSpinner, -2, -1, -2).addComponent(this.jFetchSizeForClusteringLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jFetchSizeForOthersValueSpinner, -2, -1, -2).addComponent(this.jFetchSizeForOthersLabel)).addContainerGap(117, Short.MAX_VALUE)));
    }

    public void initRes() {
        this.jPrecisionGroupDescription.setText(ModelViewerLrb.get("MODEL_VIEWER_PREF_PRECISION_SETTING"));
        this.jPrecisionGroupDescription.getAccessibleContext().setAccessibleName(ModelViewerLrb.get("MODEL_VIEWER_PREF_PRECISION_SETTING"));
        this.jPrecisionGroupDescription.getAccessibleContext().setAccessibleDescription(ModelViewerLrb.get("MODEL_VIEWER_PREF_PRECISION_SETTING_ADA"));
        ResourceUtils.resSpinner((JLabel)this.jPercentageValuesPrecisionLabel, (JSpinner)this.jPercentagePrecisionValueSpinner, (String)ModelViewerLrb.get("MODEL_VIEWER_PREF_PRECISION_PERCENTAGE_SETTING"));
        this.jPercentageValuesPrecisionLabel.getAccessibleContext().setAccessibleName(ModelViewerLrb.get("MODEL_VIEWER_PREF_PRECISION_PERCENTAGE_SETTING"));
        this.jPercentageValuesPrecisionLabel.getAccessibleContext().setAccessibleDescription(ModelViewerLrb.get("MODEL_VIEWER_PREF_PRECISION_PERCENTAGE_SETTING_ADA"));
        ResourceUtils.resSpinner((JLabel)this.jNumericalValuesPrecisionLabel, (JSpinner)this.jNumericalPrecisionValueSpinner, (String)ModelViewerLrb.get("MODEL_VIEWER_PREF_PRECISION_NUMERICAL_SETTING"));
        this.jNumericalValuesPrecisionLabel.getAccessibleContext().setAccessibleName(ModelViewerLrb.get("MODEL_VIEWER_PREF_PRECISION_NUMERICAL_SETTING"));
        this.jNumericalValuesPrecisionLabel.getAccessibleContext().setAccessibleDescription(ModelViewerLrb.get("MODEL_VIEWER_PREF_PRECISION_NUMERICAL_SETTING_ADA"));
        this.jPercentagePrecisionValueSpinner.setModel(new SpinnerNumberModel(this._percentagePrecisionLevel, 0, 12, 1));
        this.jNumericalPrecisionValueSpinner.setModel(new SpinnerNumberModel(this._numericalPrecisionLevel, 0, 12, 1));
        this.jFetchSizeGroupDescription.setText(ModelViewerLrb.get("MODEL_VIEWER_PREF_FETCH_SIZE_SETTING"));
        this.jFetchSizeGroupDescription.getAccessibleContext().setAccessibleName(ModelViewerLrb.get("MODEL_VIEWER_PREF_FETCH_SIZE_SETTING"));
        this.jFetchSizeGroupDescription.getAccessibleContext().setAccessibleDescription(ModelViewerLrb.get("MODEL_VIEWER_PREF_FETCH_SIZE_SETTING_ADA"));
        ResourceUtils.resSpinner((JLabel)this.jFetchSizeForARLabel, (JSpinner)this.jFetchSizeARValueSpinner, (String)ModelViewerLrb.get("MODEL_VIEWER_PREF_FETCH_SIZE_AR_SETTING"));
        this.jFetchSizeForARLabel.getAccessibleContext().setAccessibleName(ModelViewerLrb.get("MODEL_VIEWER_PREF_FETCH_SIZE_AR_SETTING"));
        this.jFetchSizeForARLabel.getAccessibleContext().setAccessibleDescription(ModelViewerLrb.get("MODEL_VIEWER_PREF_FETCH_SIZE_AR_SETTING_ADA"));
        ResourceUtils.resSpinner((JLabel)this.jFetchSizeForClusteringLabel, (JSpinner)this.jFetchSizeClusteringValueSpinner, (String)ModelViewerLrb.get("MODEL_VIEWER_PREF_FETCH_SIZE_CLUSTERING_SETTING"));
        this.jFetchSizeForClusteringLabel.getAccessibleContext().setAccessibleName(ModelViewerLrb.get("MODEL_VIEWER_PREF_FETCH_SIZE_CLUSTERING_SETTING"));
        this.jFetchSizeForClusteringLabel.getAccessibleContext().setAccessibleDescription(ModelViewerLrb.get("MODEL_VIEWER_PREF_FETCH_SIZE_CLUSTERING_SETTING_ADA"));
        ResourceUtils.resSpinner((JLabel)this.jFetchSizeForOthersLabel, (JSpinner)this.jFetchSizeForOthersValueSpinner, (String)ModelViewerLrb.get("MODEL_VIEWER_PREF_FETCH_SIZE_OTHER_MODELS_SETTING"));
        this.jFetchSizeForOthersLabel.getAccessibleContext().setAccessibleName(ModelViewerLrb.get("MODEL_VIEWER_PREF_FETCH_SIZE_OTHER_MODELS_SETTING"));
        this.jFetchSizeForOthersLabel.getAccessibleContext().setAccessibleDescription(ModelViewerLrb.get("MODEL_VIEWER_PREF_FETCH_SIZE_OTHER_MODELS_SETTING_ADA"));
        this.jFetchSizeARValueSpinner.setModel(new SpinnerNumberModel(this._fetchSizeARModel, 1, Integer.MAX_VALUE, 100));
        this.jFetchSizeClusteringValueSpinner.setModel(new SpinnerNumberModel(this._fetchSizeClusteringModel, 1, Integer.MAX_VALUE, 100));
        this.jFetchSizeForOthersValueSpinner.setModel(new SpinnerNumberModel(this._fetchSizeOtherModels, 1, Integer.MAX_VALUE, 100));
        this.setHelpID("preferences_model_viewer");
    }

    public void initUI() {
    }

    private Number getNumber(JSpinner jSpinner) {
        return (Number)jSpinner.getValue();
    }

    public void onEntry(TraversableContext traversableContext) {
        ModelViewerPreferenceSettings modelViewerPreferenceSettings = ModelViewerPreferencesPanel.getCoolFeaturePrefs(traversableContext);
        this._percentagePrecisionLevel = modelViewerPreferenceSettings.getPercentagePrecisionLevel();
        this.jPercentagePrecisionValueSpinner.setValue(this._percentagePrecisionLevel);
        this._numericalPrecisionLevel = modelViewerPreferenceSettings.getNumericalPrecisionLevel();
        this.jNumericalPrecisionValueSpinner.setValue(this._numericalPrecisionLevel);
        this._fetchSizeARModel = modelViewerPreferenceSettings.getFetchSizeARModel();
        this.jFetchSizeARValueSpinner.setValue(this._fetchSizeARModel);
        this._fetchSizeClusteringModel = modelViewerPreferenceSettings.getFetchSizeClusteringModel();
        this.jFetchSizeClusteringValueSpinner.setValue(this._fetchSizeClusteringModel);
        this._fetchSizeOtherModels = modelViewerPreferenceSettings.getFetchSizeOtherModels();
        this.jFetchSizeForOthersValueSpinner.setValue(this._fetchSizeOtherModels);
    }

    public void onExit(TraversableContext traversableContext) {
        Number number;
        Number number2;
        Number number3;
        Number number4;
        ModelViewerPreferenceSettings modelViewerPreferenceSettings = ModelViewerPreferencesPanel.getCoolFeaturePrefs(traversableContext);
        Number number5 = this.getNumber(this.jPercentagePrecisionValueSpinner);
        if (number5 != null) {
            modelViewerPreferenceSettings.setPercentagePrecisionLevel(number5.intValue());
        }
        if ((number4 = this.getNumber(this.jNumericalPrecisionValueSpinner)) != null) {
            modelViewerPreferenceSettings.setNumericalPrecisionLevel(number4.intValue());
        }
        if ((number3 = this.getNumber(this.jFetchSizeARValueSpinner)) != null) {
            modelViewerPreferenceSettings.setFetchSizeARModel(number3.intValue());
        }
        if ((number2 = this.getNumber(this.jFetchSizeClusteringValueSpinner)) != null) {
            modelViewerPreferenceSettings.setFetchSizeClusteringModel(number2.intValue());
        }
        if ((number = this.getNumber(this.jFetchSizeForOthersValueSpinner)) != null) {
            modelViewerPreferenceSettings.setFetchSizeOtherModels(number.intValue());
        }
    }

    private static ModelViewerPreferenceSettings getCoolFeaturePrefs(TraversableContext traversableContext) {
        return ModelViewerPreferenceSettings.getInstance(traversableContext.getPropertyStorage());
    }
}

