/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.legend;

import java.util.ArrayList;
import javax.swing.JPanel;
import oracle.dmt.dataminer.DataMinerViewEvent;
import oracle.dmt.dataminer.DataMinerViewListener;
import oracle.dmt.dataminer.DataminerGUIPanel;
import oracle.dmt.dataminer.legend.LegendEvent;
import oracle.dmt.dataminer.legend.LegendImplementer;
import oracle.dmt.dataminer.legend.LegendListener;

public abstract class LegendWindowGUI
extends JPanel
implements LegendImplementer,
DataminerGUIPanel,
DataMinerViewListener {
    private Object _legendListenerLock = new Object();
    protected ArrayList<LegendListener> _legendListeners = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLegendListener(LegendListener legendListener) {
        Object object = this._legendListenerLock;
        synchronized (object) {
            if (this._legendListeners == null) {
                this._legendListeners = new ArrayList();
            }
            this._legendListeners.add(legendListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLegendListener(LegendListener legendListener) {
        Object object = this._legendListenerLock;
        synchronized (object) {
            this._legendListeners.remove(legendListener);
        }
    }

    private void fireEvent(LegendListenerHandler legendListenerHandler, LegendEvent legendEvent) {
        ArrayList<LegendListener> arrayList = this.cloneToAvoidConcurrentModificationException(this._legendListeners);
        for (LegendListener legendListener : arrayList) {
            legendListenerHandler.handle(legendListener, legendEvent);
        }
    }

    private ArrayList<LegendListener> cloneToAvoidConcurrentModificationException(ArrayList<LegendListener> arrayList) {
        return (ArrayList)arrayList.clone();
    }

    protected void fireLegendEvent(LegendEvent legendEvent) {
        try {
            this.fireEvent(new LegendListenerHandler(){

                @Override
                public void handle(LegendListener legendListener, LegendEvent legendEvent) {
                    legendListener.addEvent(legendEvent);
                }
            }, legendEvent);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void viewPropertySelectionChange(DataMinerViewEvent dataMinerViewEvent) {
    }

    private static interface LegendListenerHandler {
        public void handle(LegendListener var1, LegendEvent var2);
    }
}

