/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.expressionbuilder2;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import java.util.concurrent.ExecutionException;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.RowFilter;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SwingWorker;
import javax.swing.TransferHandler;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import oracle.dmt.dataminer.CommonLrb;
import oracle.dmt.dataminer.controls.models.SimpleBaseTableModel;
import oracle.dmt.dataminer.expressionbuilder2.DialogsLrb;
import oracle.dmt.dataminer.expressionbuilder2.SQLContext;
import oracle.dmt.dataminer.expressionbuilder2.SQLExpressionBuilderPanel;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.workflow.dialog.AbstractPanel;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.ide.Ide;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.search.SearchCategory;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;

public class PLSQLFunctionsPanel
extends AbstractPanel<AbstractNode>
implements SearchListener {
    private JComboBox<String> _usersComboBox;
    private JLabel _userslabel;
    private JButton _refreshButton = new JButton();
    private JTable _functionTable;
    private FunctionTableModel _functionTableModel;
    private transient FunctionDetails _functionDetails = new FunctionDetails();
    private SearchField _searchField;
    private String _searchText;
    private transient SearchCategory _searchCategory;
    private transient RowFilter<FunctionTableModel, Integer> _functionFilter;
    private SQLExpressionBuilderPanel _parent;
    private transient SQLContext _context;
    private String _currentUser;
    private static final String LOADING = CommonLrb.get("LOADING");
    private static final String NO_FUNCTION = DialogsLrb.get("SQLQUERY_PLSQL_NO_FUNCTION");
    private JPanel jFunctionPanel;
    private JToolBar jToolBar;
    private static String[] _functionColumnNames = new String[]{DialogsLrb.get("SQLQUERY_PLSQL_TABLE_NAME")};
    private static final int FUNCTION_NAME = 0;
    private static final int FUNCTION_COLUMN_COUNT = 1;

    public PLSQLFunctionsPanel(SQLExpressionBuilderPanel sQLExpressionBuilderPanel, SQLContext sQLContext) {
        super(sQLContext.getContext(), sQLContext.getNode());
        this._parent = sQLExpressionBuilderPanel;
        this._context = sQLContext;
        this._currentUser = ConnectionFolder.getUserAccountName(this._context.getContext());
        this._currentUser = StringUtils.trimDoubleQuotes(this._currentUser);
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    @Override
    public void initRes() {
    }

    @Override
    public void initUI() {
        this.installFunctionsFilterActions(this.jToolBar);
        this._functionTable = new JTable(){

            @Override
            public boolean getScrollableTracksViewportHeight() {
                Container container = this.getParent();
                if (container instanceof JViewport) {
                    return container.getHeight() > this.getPreferredSize().height;
                }
                return false;
            }
        };
        this._functionTableModel = new FunctionTableModel(null);
        JScrollPane jScrollPane = new JScrollPane(this._functionTable);
        this.jFunctionPanel.add((Component)jScrollPane, "Center");
        this._functionTable.setModel((TableModel)((Object)this._functionTableModel));
        this._functionTable.setAutoResizeMode(4);
        this._functionTable.setSelectionMode(0);
        this._functionTable.setShowGrid(false);
        this._functionTable.setUpdateSelectionOnSort(true);
        this._functionTable.setRowSelectionAllowed(true);
        this._functionTable.setTransferHandler(new FromTransferHandler());
        this._functionTable.setDragEnabled(true);
        this._functionFilter = new RowFilter<FunctionTableModel, Integer>(){

            @Override
            public boolean include(RowFilter.Entry<? extends FunctionTableModel, ? extends Integer> entry) {
                String string;
                boolean bl = true;
                boolean bl2 = PLSQLFunctionsPanel.this._searchText != null && PLSQLFunctionsPanel.this._searchCategory != null;
                Integer n = entry.getIdentifier();
                FunctionTableModel functionTableModel = entry.getModel();
                String string2 = string = PLSQLFunctionsPanel.this._searchText != null ? PLSQLFunctionsPanel.this._searchText.toLowerCase() : null;
                if (bl2 && PLSQLFunctionsPanel.this._searchCategory.getLabel().equals(DialogsLrb.get("SQLQUERY_PLSQL_TABLE_NAME"))) {
                    String string3 = (String)functionTableModel.getValueAt(n, 0);
                    bl = string3.toLowerCase().contains(string);
                }
                return bl;
            }
        };
        this.configureSorting();
        this._functionTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                DefaultListSelectionModel defaultListSelectionModel = (DefaultListSelectionModel)listSelectionEvent.getSource();
                if (defaultListSelectionModel != null && defaultListSelectionModel.getValueIsAdjusting()) {
                    return;
                }
                PLSQLFunctionsPanel.this.enableControls();
            }
        });
        this._functionTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    JTable jTable = (JTable)mouseEvent.getSource();
                    int n = jTable.getSelectedRow();
                    n = jTable.convertRowIndexToModel(n);
                    String string = PLSQLFunctionsPanel.this._functionDetails.get(PLSQLFunctionsPanel.this._currentUser, n).toSQLString();
                    PLSQLFunctionsPanel.this._parent.insertSQLExpression(string);
                }
            }
        });
        LoadUsers loadUsers = new LoadUsers();
        loadUsers.execute();
        this.enableControls();
    }

    private void installFunctionsFilterActions(JToolBar jToolBar) {
        SearchCategory[] searchCategoryArray;
        this._refreshButton.setIcon(OracleIcons.getIcon((String)"refresh.png"));
        this._refreshButton.getAccessibleContext().setAccessibleDescription(DialogsLrb.get("SQLQUERY_PLSQL_REFRESH_ADA"));
        this._refreshButton.setToolTipText(DialogsLrb.get("SQLQUERY_PLSQL_REFRESH_ADA"));
        this._refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PLSQLFunctionsPanel.this._functionDetails.clearAll();
                PLSQLFunctionsPanel.this._currentUser = (String)PLSQLFunctionsPanel.this._usersComboBox.getSelectedItem();
                if (PLSQLFunctionsPanel.this._currentUser != null) {
                    LoadFunctions loadFunctions = new LoadFunctions(PLSQLFunctionsPanel.this._currentUser);
                    loadFunctions.execute();
                }
            }
        });
        jToolBar.add(this._refreshButton);
        jToolBar.addSeparator();
        this._userslabel = new JLabel();
        this._usersComboBox = new JComboBox();
        ResourceUtils.resLabel((JLabel)this._userslabel, this._usersComboBox, (String)DialogsLrb.get("SQLQUERY_PLSQL_USER"));
        this._userslabel.getAccessibleContext().setAccessibleDescription(DialogsLrb.get("SQLQUERY_PLSQL_USER_ADA"));
        this._usersComboBox.setToolTipText(DialogsLrb.get("SQLQUERY_PLSQL_USER_ADA"));
        jToolBar.add(this._userslabel);
        jToolBar.add(this._usersComboBox);
        jToolBar.addSeparator();
        this._usersComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PLSQLFunctionsPanel.this._currentUser = (String)PLSQLFunctionsPanel.this._usersComboBox.getSelectedItem();
                if (PLSQLFunctionsPanel.this._currentUser != null) {
                    LoadFunctions loadFunctions = new LoadFunctions(PLSQLFunctionsPanel.this._currentUser);
                    loadFunctions.execute();
                }
            }
        });
        this._searchField = new SearchField(SearchField.Style.FILTER);
        this._searchField.setPreferredSize(new Dimension(100, 10));
        for (SearchCategory searchCategory : searchCategoryArray = new SearchCategory[]{new SearchCategory(DialogsLrb.get("SQLQUERY_PLSQL_TABLE_NAME"))}) {
            this._searchField.addCategory(searchCategory);
        }
        jToolBar.add((Component)this._searchField);
        this._searchField.addSearchListener((SearchListener)this);
    }

    private void resetFunctionTableModel(FunctionTableModel functionTableModel) {
        functionTableModel.fireTableDataChanged();
        this._functionTable.clearSelection();
        this._functionTable.updateUI();
        this.configureSorting();
    }

    private void enableControls() {
    }

    public void configureSorting() {
        TableRowSorter<FunctionTableModel> tableRowSorter = (TableRowSorter<FunctionTableModel>)this._functionTable.getRowSorter();
        if (tableRowSorter == null) {
            tableRowSorter = new TableRowSorter<FunctionTableModel>(this._functionTableModel);
            ArrayList<RowSorter.SortKey> arrayList = new ArrayList<RowSorter.SortKey>();
            arrayList.add(new RowSorter.SortKey(0, SortOrder.ASCENDING));
            tableRowSorter.setSortKeys(arrayList);
            tableRowSorter.setSortsOnUpdates(true);
        }
        tableRowSorter.setRowFilter(this._functionFilter);
        this._functionTable.setRowSorter(tableRowSorter);
    }

    public void searchPerformed(SearchEvent searchEvent) {
        this._searchCategory = searchEvent.getSearchCategory();
        this._searchText = searchEvent.getSearchText();
        this.configureSorting();
    }

    public void searchCategoryChanged(SearchEvent searchEvent) {
        this._searchCategory = searchEvent.getSearchCategory();
        this._searchText = searchEvent.getSearchText();
        this.configureSorting();
    }

    private void initComponents() {
        this.jFunctionPanel = new JPanel();
        this.jToolBar = new JToolBar();
        this.jFunctionPanel.setLayout(new BorderLayout());
        this.jToolBar.setRollover(true);
        this.jFunctionPanel.add((Component)this.jToolBar, "North");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jFunctionPanel, -1, 322, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jFunctionPanel, GroupLayout.Alignment.TRAILING, -1, 440, Short.MAX_VALUE));
    }

    class FromTransferHandler
    extends TransferHandler {
        FromTransferHandler() {
        }

        @Override
        public int getSourceActions(JComponent jComponent) {
            return 1;
        }

        @Override
        public Transferable createTransferable(JComponent jComponent) {
            int n = PLSQLFunctionsPanel.this._functionTable.getSelectedRow();
            if ((n = PLSQLFunctionsPanel.this._functionTable.convertRowIndexToModel(n)) >= 0) {
                String string = PLSQLFunctionsPanel.this._functionDetails.get(PLSQLFunctionsPanel.this._currentUser, n).toSQLString();
                return new StringSelection(string);
            }
            return null;
        }
    }

    private class LoadFunctions
    extends SwingWorker<Void, Void> {
        private String _user = null;

        public LoadFunctions(String string) {
            this._user = string;
            PLSQLFunctionsPanel.this._functionTableModel.resetModel(null);
            PLSQLFunctionsPanel.this.resetFunctionTableModel(PLSQLFunctionsPanel.this._functionTableModel);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Void doInBackground() throws Exception {
            if (PLSQLFunctionsPanel.this._functionDetails.size(this._user) == null) {
                try (SQLHelper sQLHelper = new SQLHelper();){
                    String string = "  with\n  func as (select * from all_procedures where object_type = 'FUNCTION' AND OWNER = ?),\n  arg as (select * from all_arguments)\n  select func.owner, func.object_name, arg.position, arg.data_type, arg.argument_name \n  from func, arg where func.object_id = arg.object_id order by func.object_name, arg.position\n";
                    sQLHelper.conn = ConnectionFolder.getConnection(PLSQLFunctionsPanel.this._context.getContext());
                    sQLHelper.pstmt = sQLHelper.conn.prepareStatement(string);
                    sQLHelper.pstmt.setString(1, this._user);
                    sQLHelper.pstmt.setFetchSize(100);
                    sQLHelper.rs = sQLHelper.pstmt.executeQuery();
                    String string2 = null;
                    FunctionDetail functionDetail = null;
                    String string3 = null;
                    String string4 = null;
                    ArrayList<Integer> arrayList = new ArrayList<Integer>();
                    ArrayList<String> arrayList2 = new ArrayList<String>();
                    ArrayList<String> arrayList3 = new ArrayList<String>();
                    while (sQLHelper.rs.next()) {
                        string3 = sQLHelper.rs.getString(1);
                        string4 = sQLHelper.rs.getString(2);
                        if (string2 == null) {
                            string2 = string4;
                        } else if (string2.compareToIgnoreCase(string4) != 0) {
                            functionDetail = new FunctionDetail(string3, string2, arrayList.toArray(new Integer[arrayList.size()]), arrayList2.toArray(new String[arrayList2.size()]), arrayList3.toArray(new String[arrayList3.size()]));
                            PLSQLFunctionsPanel.this._functionDetails.add(this._user, functionDetail);
                            string2 = string4;
                            arrayList.clear();
                            arrayList2.clear();
                            arrayList3.clear();
                        }
                        Integer n = sQLHelper.rs.getInt(3);
                        arrayList.add(n);
                        String string5 = sQLHelper.rs.getString(4);
                        arrayList2.add(string5);
                        String string6 = sQLHelper.rs.getString(5);
                        arrayList3.add(string6);
                    }
                    if (arrayList3.size() > 0) {
                        functionDetail = new FunctionDetail(string3, string4, arrayList.toArray(new Integer[arrayList.size()]), arrayList2.toArray(new String[arrayList2.size()]), arrayList3.toArray(new String[arrayList3.size()]));
                        PLSQLFunctionsPanel.this._functionDetails.add(this._user, functionDetail);
                    }
                    if (PLSQLFunctionsPanel.this._functionDetails.get(this._user) == null) {
                        PLSQLFunctionsPanel.this._functionDetails.add(this._user, null);
                    }
                }
            }
            return null;
        }

        @Override
        protected void done() {
            try {
                this.get();
                PLSQLFunctionsPanel.this._functionTableModel.resetModel(PLSQLFunctionsPanel.this._functionDetails.get(this._user));
                PLSQLFunctionsPanel.this.resetFunctionTableModel(PLSQLFunctionsPanel.this._functionTableModel);
            }
            catch (InterruptedException | ExecutionException exception) {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)DialogsLrb.get("ERROR_TITLE"), (String)DialogsLrb.get("UNEXPECTED_ERROR_MSG"), null);
            }
            finally {
                PLSQLFunctionsPanel.this.enableControls();
            }
        }
    }

    private class LoadUsers
    extends SwingWorker<Vector<String>, Void> {
        public LoadUsers() {
            PLSQLFunctionsPanel.this._usersComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{LOADING}));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Vector<String> doInBackground() throws Exception {
            Vector<String> vector = new Vector<String>();
            try (SQLHelper sQLHelper = new SQLHelper();){
                String string = "select * from\n(\nselect distinct(owner) from all_procedures where object_type = 'FUNCTION'\nunion\nselect '" + StringUtils.escapeSingleQuotesForSQL(PLSQLFunctionsPanel.this._currentUser) + "' FROM dual\n) order by owner";
                sQLHelper.conn = ConnectionFolder.getConnection(PLSQLFunctionsPanel.this._context.getContext());
                sQLHelper.pstmt = sQLHelper.conn.prepareStatement(string);
                sQLHelper.pstmt.setFetchSize(100);
                sQLHelper.rs = sQLHelper.pstmt.executeQuery();
                String string2 = null;
                while (sQLHelper.rs.next()) {
                    string2 = sQLHelper.rs.getString(1);
                    vector.add(string2);
                }
            }
            return vector;
        }

        @Override
        protected void done() {
            try {
                Vector vector = (Vector)this.get();
                PLSQLFunctionsPanel.this._usersComboBox.setModel(new DefaultComboBoxModel(vector));
                if (!vector.contains(PLSQLFunctionsPanel.this._currentUser)) {
                    PLSQLFunctionsPanel.this._currentUser = (String)vector.get(0);
                }
                PLSQLFunctionsPanel.this._usersComboBox.setSelectedItem(PLSQLFunctionsPanel.this._currentUser);
            }
            catch (InterruptedException | ExecutionException exception) {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)DialogsLrb.get("ERROR_TITLE"), (String)DialogsLrb.get("UNEXPECTED_ERROR_MSG"), null);
            }
            finally {
                PLSQLFunctionsPanel.this.enableControls();
            }
        }
    }

    private static class FunctionTableModel
    extends SimpleBaseTableModel {
        private transient Vector<FunctionDetail> _functions;

        public FunctionTableModel(Vector<FunctionDetail> vector) {
            this._functions = vector;
            this.setColumnIdentifiers(_functionColumnNames);
            this.setRowCount(this.getRowCount());
            this.setColumnCount(1);
        }

        public void resetModel(Vector<FunctionDetail> vector) {
            this._functions = vector;
        }

        public int getRowCount() {
            if (this._functions == null || this._functions.size() == 0) {
                return 1;
            }
            return this._functions.size();
        }

        public Object getValueAt(int n, int n2) {
            assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
            assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds";
            if (this._functions == null) {
                return LOADING;
            }
            if (this._functions.size() == 0) {
                return NO_FUNCTION;
            }
            FunctionDetail functionDetail = this._functions.get(n);
            String string = null;
            switch (n2) {
                case 0: {
                    string = functionDetail.toString();
                    break;
                }
                default: {
                    assert (false) : "Out of bounds column";
                    break;
                }
            }
            return string;
        }
    }

    private static class FunctionDetails {
        HashMap<String, Vector<FunctionDetail>> _data = new HashMap();

        FunctionDetails() {
        }

        Integer size(String string) {
            Vector<FunctionDetail> vector = this._data.get(string);
            if (vector != null) {
                return vector.size();
            }
            return null;
        }

        void clearAll() {
            this._data.clear();
        }

        void add(String string, FunctionDetail functionDetail) {
            Vector<FunctionDetail> vector = this._data.get(string);
            if (vector == null) {
                vector = new Vector();
                this._data.put(string, vector);
            }
            if (functionDetail != null) {
                vector.add(functionDetail);
            }
        }

        FunctionDetail get(String string, int n) {
            Vector<FunctionDetail> vector = this._data.get(string);
            if (vector == null) {
                return null;
            }
            return vector.get(n);
        }

        Vector<FunctionDetail> get(String string) {
            return this._data.get(string);
        }
    }

    private static class FunctionDetail {
        String _owner;
        String _name;
        Integer[] _argPos;
        String[] _argTypes;
        String[] _argNames;
        String _format;
        String _format2;

        FunctionDetail(String string, String string2, Integer[] integerArray, String[] stringArray, String[] stringArray2) {
            this._owner = string;
            this._name = string2;
            this._argPos = integerArray;
            this._argTypes = stringArray;
            this._argNames = stringArray2;
            StringBuffer stringBuffer = new StringBuffer();
            String string3 = null;
            Integer[] integerArray2 = this._argPos;
            int n = integerArray2.length;
            for (int i = 0; i < n; ++i) {
                int n2 = integerArray2[i];
                if (n2 == 0) {
                    string3 = this._argTypes[n2];
                    continue;
                }
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(this._argTypes[n2]);
            }
            this._format = this._name + " (" + stringBuffer.toString() + ") : " + string3;
            this._format2 = this._owner + "." + this._name + " (" + stringBuffer.toString() + ")";
        }

        public String toString() {
            return this._format;
        }

        public String toSQLString() {
            return this._format2;
        }
    }
}

