/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.controls.renderers;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JProgressBar;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.plaf.metal.MetalProgressBarUI;
import javax.swing.table.TableCellRenderer;

public class HistogramBarRenderer
extends JComponent
implements TableCellRenderer {
    private Color positiveColor;
    private Color negativeColor;
    private Border unselectedBorder;
    private Border selectedBorder;
    private boolean bordered;
    private boolean showLabel;
    private NumberFormat labelFormat;
    private JProgressBar bar;
    private double maximumValue;

    public HistogramBarRenderer(double d, boolean bl, NumberFormat numberFormat) {
        assert (d > 0.0) : "Bar maximum value must be greater than 0";
        assert (numberFormat != null) : "NumberFormat can not be null.";
        this.maximumValue = d;
        this.showLabel = bl;
        this.labelFormat = numberFormat;
        this.positiveColor = new Color(195, 212, 232);
        this.negativeColor = new Color(232, 72, 0);
        this.bordered = true;
        this.bar = new JProgressBar();
        MetalProgressBarUI metalProgressBarUI = (MetalProgressBarUI)MetalProgressBarUI.createUI(this);
        this.bar.setUI(metalProgressBarUI);
        this.bar.setMinimum(0);
        this.bar.setStringPainted(true);
        this.setLayout(new BorderLayout());
        this.add("Center", this.bar);
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        Object object2;
        Number number;
        int n3 = 0;
        if (object instanceof Number) {
            number = (Number)object;
            object2 = Math.abs(number.doubleValue());
            Double d = (Double)object2 / this.maximumValue;
            Double d2 = d * 100.0;
            n3 = d2.intValue();
        } else {
            n3 = 0;
            number = 0.0;
        }
        this.bar.setMaximum(100);
        this.bar.setValue(n3);
        this.bar.setBackground(Color.white);
        this.bar.setBorderPainted(false);
        if (this.showLabel) {
            object2 = this.labelFormat.format(number.doubleValue());
            this.bar.setString((String)object2);
            this.bar.setToolTipText((String)object2);
        }
        if (this.bordered) {
            this.setBorder(this.getBorder(jTable, bl));
        }
        if (bl) {
            this.bar.setBackground(jTable.getSelectionBackground());
        } else {
            this.bar.setBackground(jTable.getBackground());
        }
        if (number.doubleValue() < 0.0) {
            this.bar.setForeground(this.negativeColor);
        } else {
            this.bar.setForeground(this.positiveColor);
        }
        return this;
    }

    private Border getBorder(JTable jTable, boolean bl) {
        Border border = bl ? this.getSelectedBorder(jTable) : this.getUnselectedBorder(jTable);
        return border;
    }

    private Border getSelectedBorder(JTable jTable) {
        if (this.selectedBorder == null) {
            this.selectedBorder = BorderFactory.createMatteBorder(2, 5, 2, 5, jTable.getSelectionBackground());
        }
        return this.selectedBorder;
    }

    private Border getUnselectedBorder(JTable jTable) {
        if (this.unselectedBorder == null) {
            this.unselectedBorder = BorderFactory.createMatteBorder(2, 5, 2, 5, jTable.getBackground());
        }
        return this.unselectedBorder;
    }

    public String getText() {
        return this.bar.getString();
    }

    public void setBordered(boolean bl) {
        this.bordered = bl;
    }

    public void setPositiveColor(Color color) {
        assert (color != null) : "Color must not be null";
        this.positiveColor = color;
    }

    public void setNegativeColor(Color color) {
        assert (color != null) : "Color must not be null";
        this.negativeColor = color;
    }

    public void setMaximumValue(double d) {
        if (d <= 0.0) {
            return;
        }
        this.maximumValue = d;
    }

    public void setShowLabel(boolean bl) {
        assert (bl && this.labelFormat != null) : "Can not set show label to true if NumberFormat is null.";
        this.showLabel = bl;
    }

    public void setLabelFormat(NumberFormat numberFormat) {
        assert (numberFormat != null) : "NumberFormat must not be null";
        this.labelFormat = numberFormat;
    }
}

