/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.controls.renderers;

import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.table.DefaultTableCellRenderer;
import oracle.dmt.dataminer.res.DataMinerIcons;
import oracle.dmt.dataminer.res.Icons;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAttributeType;
import oracle.javatools.icons.OracleIcons;

public class AttributeNameCellRenderer
extends DefaultTableCellRenderer {
    private Icon validIcon;
    private Icon invalidIcon;
    private List<String> targets;
    private List<String> keyNames;
    private List<String> partitions;

    public AttributeNameCellRenderer(Icon icon, Icon icon2) {
        this.validIcon = icon;
        this.invalidIcon = icon2;
        this.targets = new ArrayList<String>();
        this.keyNames = new ArrayList<String>();
        this.partitions = new ArrayList<String>();
    }

    public void setTargetNames(List<MiningAttributeType> list) {
        for (MiningAttributeType miningAttributeType : list) {
            this.targets.add(miningAttributeType.getName());
        }
    }

    public void setKeyNames(List<String> list) {
        this.keyNames = list;
    }

    public void setPartitions(List<String> list) {
        this.partitions = list;
    }

    @Override
    public void setValue(Object object) {
        AttributeType attributeType = (AttributeType)object;
        this.setText(attributeType.getName());
        if (AttributeStatus.VALID.equals((Object)attributeType.getStatus())) {
            if (this.targets.contains(attributeType.getName())) {
                this.setIcon(OracleIcons.getIcon((String)"target.png"));
            } else if (this.keyNames.contains(attributeType.getName())) {
                this.setIcon(OracleIcons.getIcon((String)"key.png"));
            } else if (this.partitions.contains(attributeType.getName())) {
                this.setIcon(DataMinerIcons.get(Icons.PARTITION_KEY_ICON));
            } else {
                this.setIcon(this.validIcon);
            }
        } else {
            this.setIcon(this.invalidIcon);
        }
    }
}

