/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.controls;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import oracle.dmt.dataminer.controls.MiningTypeUIHelper;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAttributeType;

public abstract class MiningTypeEditor
extends AbstractCellEditor
implements TableCellEditor,
ActionListener {
    private String currentValue;
    private JComboBox comboComponent;
    private static final String EDIT = "edit";
    private boolean isDb12andUp;

    public MiningTypeEditor(boolean bl) {
        this.isDb12andUp = bl;
        this.comboComponent = new JComboBox();
        this.comboComponent.setActionCommand(EDIT);
        this.comboComponent.addActionListener(this);
        this.comboComponent.setRenderer(new MiningTypeUIHelper.MiningTypeComboRenderer());
    }

    @Override
    public Object getCellEditorValue() {
        return this.currentValue;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (EDIT.equals(actionEvent.getActionCommand())) {
            this.currentValue = (String)this.comboComponent.getSelectedItem();
            this.fireEditingStopped();
        }
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.currentValue = (String)object;
        boolean bl2 = this.currentValue.equals(MiningTypeUIHelper.MULTI_SELECT_RES);
        int n3 = jTable.convertRowIndexToModel(n);
        int n4 = jTable.convertColumnIndexToModel(n2);
        MiningAttributeType miningAttributeType = this.getRowData(n3, n4);
        this.comboComponent.removeAllItems();
        String string = DatabaseMetadataUtils.getDefaultMiningType(miningAttributeType.getDataType());
        if (string.equals("Numerical")) {
            this.comboComponent.addItem(MiningTypeUIHelper.NUMERICAL);
            this.comboComponent.addItem(MiningTypeUIHelper.CATEGORICAL);
        } else if (string.equals("Categorical")) {
            this.comboComponent.addItem(MiningTypeUIHelper.CATEGORICAL);
            if (this.isDb12andUp) {
                this.comboComponent.addItem(MiningTypeUIHelper.TEXT);
            }
        }
        if (bl2) {
            this.comboComponent.addItem(MiningTypeUIHelper.MULTI_SELECT_RES);
        }
        return this.comboComponent;
    }

    public abstract MiningAttributeType getRowData(int var1, int var2);
}

