/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.controls;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JTextField;
import javax.swing.plaf.basic.BasicTextFieldUI;
import javax.swing.text.JTextComponent;

public class HintTextField
extends JTextField
implements FocusListener {
    private String hint;

    public HintTextField() {
        this("");
    }

    public HintTextField(String string) {
        this.setHint(string);
        super.addFocusListener(this);
    }

    public void setHint(String string) {
        this.hint = string;
        this.setUI(new HintTextFieldUI(string, false));
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (this.getText().length() == 0) {
            super.setText("");
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        if (this.getText().length() == 0) {
            this.setHint(this.hint);
        }
    }

    @Override
    public String getText() {
        String string = super.getText();
        return string;
    }

    class HintTextFieldUI
    extends BasicTextFieldUI
    implements FocusListener {
        private String hint;
        private boolean hideOnFocus;
        private Color color;

        public Color getColor() {
            return this.color;
        }

        public void setColor(Color color) {
            this.color = color;
            this.repaint();
        }

        private void repaint() {
            if (this.getComponent() != null) {
                this.getComponent().repaint();
            }
        }

        public boolean isHideOnFocus() {
            return this.hideOnFocus;
        }

        public void setHideOnFocus(boolean bl) {
            this.hideOnFocus = bl;
            this.repaint();
        }

        public String getHint() {
            return this.hint;
        }

        public void setHint(String string) {
            this.hint = string;
            this.repaint();
        }

        public HintTextFieldUI(String string) {
            this(string, false);
        }

        public HintTextFieldUI(String string, boolean bl) {
            this(string, bl, null);
        }

        public HintTextFieldUI(String string, boolean bl, Color color) {
            this.hint = string;
            this.hideOnFocus = bl;
            this.color = color;
        }

        @Override
        protected void paintSafely(Graphics graphics) {
            super.paintSafely(graphics);
            JTextComponent jTextComponent = this.getComponent();
            if (!(this.hint == null || jTextComponent.getText().length() != 0 || this.hideOnFocus && jTextComponent.hasFocus())) {
                if (this.color != null) {
                    graphics.setColor(this.color);
                } else {
                    graphics.setColor(Color.gray);
                }
                int n = (jTextComponent.getHeight() - jTextComponent.getFont().getSize()) / 2;
                graphics.drawString(this.hint, 5, jTextComponent.getHeight() - n - 1);
            }
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            if (this.hideOnFocus) {
                this.repaint();
            }
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            if (this.hideOnFocus) {
                this.repaint();
            }
        }

        @Override
        protected void installListeners() {
            super.installListeners();
            this.getComponent().addFocusListener(this);
        }

        @Override
        protected void uninstallListeners() {
            super.uninstallListeners();
            this.getComponent().removeFocusListener(this);
        }
    }
}

