/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.controls;

import oracle.dmt.dataminer.utils.AttributeTypeHelper;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeExType;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.JSONAttributeType;

public class GroupByAttributeSelectionRowData {
    JSONAttributeType jsonAttribute;
    AttributeExType relationalAttribute;
    boolean selected;

    public GroupByAttributeSelectionRowData(JSONAttributeType jSONAttributeType, boolean bl) {
        this.jsonAttribute = new JSONAttributeType();
        this.jsonAttribute.setDBDataType(jSONAttributeType.getDBDataType());
        this.jsonAttribute.setDBName(jSONAttributeType.getDBName());
        this.jsonAttribute.setDataType(jSONAttributeType.getDataType());
        this.jsonAttribute.setPath(jSONAttributeType.getPath());
        this.jsonAttribute.setStatus(jSONAttributeType.getStatus());
        this.jsonAttribute.setUnnest(jSONAttributeType.isUnnest());
        this.selected = bl;
    }

    public JSONAttributeType createJSONAttributeType() {
        JSONAttributeType jSONAttributeType = new JSONAttributeType();
        jSONAttributeType.setDBDataType(this.jsonAttribute.getDBDataType());
        jSONAttributeType.setDBName(this.jsonAttribute.getDBName());
        jSONAttributeType.setDataType(this.jsonAttribute.getDataType());
        jSONAttributeType.setPath(this.jsonAttribute.getPath());
        jSONAttributeType.setStatus(this.jsonAttribute.getStatus());
        jSONAttributeType.setUnnest(this.jsonAttribute.isUnnest());
        return jSONAttributeType;
    }

    public AttributeExType createAttributeExType() {
        AttributeExType attributeExType = new AttributeExType();
        AttributeTypeHelper.copyAttribute((AttributeType)attributeExType, (AttributeType)this.relationalAttribute);
        attributeExType.setNewDataType(this.relationalAttribute.getNewDataType());
        return attributeExType;
    }

    public boolean isJSON() {
        return this.jsonAttribute != null;
    }

    public String getFullPath() {
        String string = this.jsonAttribute != null ? this.jsonAttribute.getPath() : this.relationalAttribute.getName();
        return string;
    }

    public String getShortPath() {
        String string;
        if (this.jsonAttribute != null) {
            String string2 = this.jsonAttribute.getPath();
            int n = string2.lastIndexOf(".");
            string = string2.substring(n + 1, string2.length());
        } else {
            string = this.relationalAttribute.getName();
        }
        return string;
    }

    public String getDataType() {
        String string = this.jsonAttribute != null ? this.jsonAttribute.getDataType() : this.relationalAttribute.getNewDataType();
        return string;
    }

    public GroupByAttributeSelectionRowData(AttributeExType attributeExType, boolean bl) {
        this.relationalAttribute = new AttributeExType();
        AttributeTypeHelper.copyAttribute((AttributeType)this.relationalAttribute, (AttributeType)attributeExType);
        this.relationalAttribute.setNewDataType(attributeExType.getNewDataType());
        this.selected = bl;
    }

    public boolean isSelected() {
        return this.selected;
    }
}

