/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.sybase15;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.migration.capture.AbstractOfflineCapturer;
import oracle.dbtools.migration.capture.CaptureContext;
import oracle.dbtools.migration.capture.CaptureException;
import oracle.dbtools.migration.capture.offline.OfflineCaptureException;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationObjectFilter;
import oracle.dbtools.migration.workbench.core.MigrationStorer;
import oracle.dbtools.migration.workbench.plugin.sybaseofflinecapture.ObjectStatusList;
import oracle.dbtools.migration.workbench.sybase12.Sybase12AbstractCapturer;
import oracle.dbtools.migration.workbench.sybase12.Sybase12Messages;
import oracle.dbtools.migration.workbench.sybase12.Sybase12OfflineCaptureTables;
import oracle.dbtools.migration.workbench.sybase15.Sybase15CaptureObjectsOfflineCapturer;
import oracle.dbtools.migration.workbench.sybase15.Sybase15DoOfflineCaptureLoad;
import oracle.dbtools.migration.workbench.sybase15.Sybase15OfflineCaptureTables;
import oracle.dbtools.util.Resource;

public class Sybase15OfflineCapturer
extends AbstractOfflineCapturer {
    protected Sybase15DoOfflineCaptureLoad dsml = null;
    protected Connection m_repositoryConnection = null;
    protected MigrationStorer m_storer = null;
    protected Sybase15CaptureObjectsOfflineCapturer m_captureObjectsOfflineCapturer = null;

    protected String captureInitializeImpl(String string, Properties properties) throws OfflineCaptureException {
        Object object;
        this.setRepositoryConnection(MigrationAddin.getPersistenceManager().getConn());
        this.m_captureObjectsOfflineCapturer = new Sybase15CaptureObjectsOfflineCapturer(this.getStorer(), MigrationAddin.getPersistenceManager().getConn());
        HashMap<File, ObjectStatusList> hashMap = new HashMap();
        Object var4_4 = null;
        ArrayList arrayList = this.getSelectedDatabaseList();
        Connection connection = this.getRepositoryConnection();
        Statement statement = null;
        try {
            String[] stringArray;
            try {
                object = new Sybase15OfflineCaptureTables();
                stringArray = ((Sybase12OfflineCaptureTables)object).getTruncateTmpStatements();
                statement = connection.createStatement();
                for (String string2 : stringArray) {
                    try {
                        statement.executeUpdate(string2);
                    }
                    catch (SQLException sQLException) {
                        throw new OfflineCaptureException((Exception)sQLException);
                    }
                }
            }
            catch (SQLException sQLException) {
                throw new OfflineCaptureException((Exception)sQLException);
            }
            finally {
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
            object = new Sybase15OfflineCaptureTables();
            stringArray = ((Sybase12OfflineCaptureTables)object).getCreateStatements();
            statement = connection.createStatement();
            for (String string2 : stringArray) {
                try {
                    statement.executeUpdate(string2);
                }
                catch (SQLException sQLException) {
                    throw new OfflineCaptureException((Exception)sQLException);
                }
            }
        }
        catch (SQLException sQLException) {
            throw new OfflineCaptureException((Exception)sQLException);
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        hashMap = this.getSelectedDatabaseDirectoryStructure(string, arrayList);
        this.dsml = new Sybase15DoOfflineCaptureLoad(connection);
        Sybase15DoOfflineCaptureLoad.setEncoding(this.getEncoding());
        this.dsml.sourceModelIndexCreate(this.getRepositoryConnection());
        try {
            this.dsml.convertBcpDumpToXML(hashMap);
        }
        catch (Exception exception) {
            throw new OfflineCaptureException(exception);
        }
        object = new Date();
        return "Sybase15" + DateFormat.getDateTimeInstance().format((Date)object);
    }

    protected HashMap<File, ObjectStatusList> getSelectedDatabaseDirectoryStructure(String string, ArrayList<String> arrayList) {
        File file = new File(string);
        String[] stringArray = file.list();
        HashMap<File, ObjectStatusList> hashMap = new HashMap<File, ObjectStatusList>();
        ObjectStatusList objectStatusList = null;
        for (String string2 : stringArray) {
            String[] stringArray2;
            if (!new File(string + File.separator + string2).isDirectory()) continue;
            if (!"master".equals(string2.toLowerCase()) && arrayList.contains(string2)) {
                this.addDatabaseToCapture(string2);
            }
            File file2 = new File(string + File.separator + string2);
            objectStatusList = new ObjectStatusList();
            for (String string3 : stringArray2 = file2.list()) {
                if (!string3.endsWith(".dat") && !string3.endsWith(".DAT")) continue;
                objectStatusList.add(new File(string + File.separator + string2 + File.separator + string3), Sybase12Messages.getString("Sybase12OfflineCapturer.2"));
            }
            hashMap.put(file2, objectStatusList);
        }
        return hashMap;
    }

    public void cleanUp() throws OfflineCaptureException {
        Connection connection = this.getRepositoryConnection();
        Statement statement = null;
        try {
            Sybase15OfflineCaptureTables sybase15OfflineCaptureTables = new Sybase15OfflineCaptureTables();
            String[] stringArray = sybase15OfflineCaptureTables.getTruncateTmpStatements();
            statement = connection.createStatement();
            for (String string : stringArray) {
                try {
                    statement.executeUpdate(string);
                }
                catch (SQLException sQLException) {
                    throw new OfflineCaptureException((Exception)sQLException);
                }
            }
        }
        catch (SQLException sQLException) {
            throw new OfflineCaptureException((Exception)sQLException);
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    public String[] generateScripts(String string, int n) throws OfflineCaptureException {
        String string2 = "/oracle/dbtools/migration/workbench/plugin/";
        this.writeFile(string, string2 + "Sybase15Files", "properties.sql");
        this.writeFile(string, string2 + "Sybase15Files", "get_indexes.sql");
        this.writeFile(string, string2 + "Sybase15Files", "get_constraints.sql");
        this.writeFile(string, string2 + "Sybase15Files", "sybase15.ocp");
        this.writeFile(string, string2 + "Sybase15Files", "ROW.TXT");
        this.writeFile(string, string2 + "Sybase15Files", "COLUMN.TXT");
        if (n == 1) {
            this.writeFile(string, string2 + "Sybase15Files", "SYB15_OFFLINE_CAPTURE.BAT");
            this.writeFile(string, string2 + "Sybase15Files", "SYB15_BCP_SCRIPT.BAT");
            String[] stringArray = new String[]{"SYB15_OFFLINE_CAPTURE.BAT", "sybase15.ocp", "properties.sql", "SYB15_BCP_SCRIPT.BAT", "ROW.TXT", "COLUMN.TXT", "get_indexes.sql", "get_constraints.sql"};
            return stringArray;
        }
        this.writeFile(string, string2 + "Sybase15Files", "SYB15_OFFLINE_CAPTURE.sh");
        String[] stringArray = new String[]{"SYB15_OFFLINE_CAPTURE.sh", "sybase15.ocp", "properties.sql", "ROW.TXT", "COLUMN.TXT", "get_indexes.sql", "get_constraints.sql"};
        return stringArray;
    }

    public Connection getRepositoryConnection() {
        return this.m_repositoryConnection;
    }

    public void setRepositoryConnection(Connection connection) {
        this.m_repositoryConnection = connection;
    }

    public void setStorer(MigrationStorer migrationStorer) {
        this.m_storer = migrationStorer;
    }

    public MigrationStorer getStorer() {
        return this.m_storer;
    }

    public String[] getScriptFiles(int n) throws OfflineCaptureException {
        return null;
    }

    public void captureObjects(String string, CaptureContext captureContext, MigrationObjectFilter migrationObjectFilter) throws PersistenceException, CaptureException {
        this.m_captureObjectsOfflineCapturer.captureObjects(string, captureContext, migrationObjectFilter);
    }

    public String getModelName() throws CaptureException {
        return "Sybase15";
    }

    public String getSourceURL() throws CaptureException {
        return "/tmp/sybase15";
    }

    public Sybase15OfflineCapturer(MigrationStorer migrationStorer, Connection connection) {
    }

    public String writeFile(String string, String string2, String string3) throws OfflineCaptureException {
        InputStream inputStream = null;
        FilterOutputStream filterOutputStream = null;
        try {
            Object object;
            inputStream = new BufferedInputStream(Resource.getResourceAsStream(((Object)((Object)this)).getClass(), (String)(string2 + "/" + string3)));
            File file = null;
            file = new File(string + File.separator + string3);
            if (!file.exists()) {
                filterOutputStream = new BufferedOutputStream(new FileOutputStream(file));
                object = new byte[10000];
                int n = 0;
                while ((n = inputStream.read((byte[])object)) > -1) {
                    ((BufferedOutputStream)filterOutputStream).write((byte[])object, 0, n);
                }
                ((BufferedOutputStream)filterOutputStream).flush();
                inputStream.close();
            }
            object = file.getPath();
            String string4 = object;
            return string4;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new OfflineCaptureException((Exception)fileNotFoundException);
        }
        catch (IOException iOException) {
            throw new OfflineCaptureException((Exception)iOException);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (filterOutputStream != null) {
                try {
                    filterOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void captureStarting() {
        try {
            int n;
            File file = this.dsml.getDbFile("MASTER");
            Connection connection = this.getRepositoryConnection();
            this.dsml.populateSourceModel(connection, file, 1);
            String string = this.getNextDatabase();
            File file2 = this.dsml.getDbFile(string);
            Sybase12AbstractCapturer.OfflineDbId = n = this.dsml.getDbId(connection, string);
            this.dsml.populateSourceModel(connection, file2, n);
            connection.commit();
        }
        catch (Exception exception) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    public String getEnterpriseCaptureFileName() {
        return "SybaseEnterpriseCapture.xml";
    }
}

