/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.sybase15;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import oracle.dbtools.migration.capture.OnlineCapturer;
import oracle.dbtools.migration.workbench.core.MigrationStorer;
import oracle.dbtools.migration.workbench.core.ThirdPartyDbProvider;
import oracle.dbtools.migration.workbench.sybase15.Sybase15Capturer;

public class Sybase15DbProvider
extends ThirdPartyDbProvider {
    private String m_label;
    private Sybase15Capturer m_capturer;

    public Sybase15DbProvider(Connection connection) {
        super(connection);
    }

    public OnlineCapturer getCapturer(MigrationStorer migrationStorer) {
        if (this.m_capturer == null) {
            this.m_capturer = new Sybase15Capturer(migrationStorer, this._conn);
        }
        return this.m_capturer;
    }

    public String getConnectionLabel() {
        if (this.m_label == null) {
            try {
                DatabaseMetaData databaseMetaData = this.getConnection().getMetaData();
                String string = databaseMetaData.getURL();
                String[] stringArray = string.split("/");
                this.m_label = "\\\\" + stringArray[2] + "\\" + this.getConnection().getCatalog() + " (" + databaseMetaData.getDatabaseProductName() + ")";
            }
            catch (SQLException sQLException) {
                this.m_label = null;
            }
        }
        return this.m_label;
    }
}

