/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.deferredupdate.task;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import oracle.ideimpl.deferredupdate.UpdateArb;
import oracle.ideimpl.deferredupdate.task.AtomicTask;
import oracle.ideimpl.deferredupdate.task.BundleDetails;
import oracle.ideimpl.deferredupdate.task.TaskContext;
import oracle.ideimpl.deferredupdate.task.TaskFailedException;
import oracle.ideimpl.deferredupdate.task.TaskUtil;

final class UnzipTask
extends AtomicTask {
    private static final Logger LOG = Logger.getLogger(UnzipTask.class.getName());
    private final File _zipFile;
    private final File _destinationDir;
    private final List<File[]> _backedUpFiles = new ArrayList<File[]>();
    private final List<File> _createdDirectories = new ArrayList<File>();
    private final List<File> _createdFiles = new ArrayList<File>();
    private final List<Pattern> _skipPatterns = new ArrayList<Pattern>();
    private final List<String> _skipEntries = new ArrayList<String>();
    private List<BundleDetails> _osgiBundleDetails;
    private List<String> _extensionNames;

    UnzipTask(File zipFile, File destinationDir, List<BundleDetails> osgiBundleDetails, List<String> extensionNames) {
        this._zipFile = zipFile;
        this._destinationDir = destinationDir;
        this._osgiBundleDetails = osgiBundleDetails;
        this._extensionNames = extensionNames;
    }

    void addSkipPattern(String regexp) {
        this._skipPatterns.add(Pattern.compile(regexp.toLowerCase()));
    }

    private void addSkipEntry(String skipEntry) {
        this._skipEntries.add(skipEntry.toLowerCase());
    }

    private boolean isSkipped(ZipEntry entry) {
        String name = entry.getName().toLowerCase();
        if (this._skipEntries.contains(name = name.replace('\\', '/'))) {
            return true;
        }
        for (Pattern p : this._skipPatterns) {
            if (!p.matcher(name).matches()) continue;
            return true;
        }
        return false;
    }

    private void processPatchManifest(TaskContext tc, ZipFile zip) {
        try {
            ZipEntry entry = zip.getEntry("META-INF/ofcp-patch.mf");
            if (entry == null) {
                return;
            }
            HashMap patchManifestEntries = new HashMap();
            this.loadManifest(zip, entry, patchManifestEntries);
            HashMap<String, Boolean> extensionExistMap = new HashMap<String, Boolean>();
            for (Map.Entry e : patchManifestEntries.entrySet()) {
                String extId = (String)e.getKey();
                Boolean b = (Boolean)extensionExistMap.get(extId);
                if (b == null) {
                    b = this.isExtensionInstalled(tc, extId);
                    extensionExistMap.put(extId, b);
                }
                if (b.booleanValue()) continue;
                LOG.fine("Extension " + extId + " is not installed.");
                List values = (List)e.getValue();
                for (String skipEntry : values) {
                    LOG.fine("  Skipping zip entry " + skipEntry);
                    this.addSkipEntry(skipEntry);
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadManifest(ZipFile zip, ZipEntry entry, Map patchManifestEntries) throws IOException {
        String extensionId = null;
        try (BufferedReader reader = null;){
            reader = new BufferedReader(new InputStreamReader(zip.getInputStream(entry)));
            String line = reader.readLine();
            while (line != null) {
                if (line.endsWith(":")) {
                    if (line.length() > 1) {
                        extensionId = line.substring(0, line.length() - 2);
                        if (patchManifestEntries.get(extensionId) == null) {
                            patchManifestEntries.put(extensionId, new ArrayList());
                        }
                    } else {
                        LOG.severe("Bad line in META-INF/ofcp-patch.mf: " + line);
                    }
                } else if (extensionId == null) {
                    LOG.severe("File entry before extension id in META-INF/ofcp-patch.mf: " + line);
                } else {
                    List entries = (List)patchManifestEntries.get(extensionId);
                    entries.add(line);
                }
                line = reader.readLine();
            }
        }
    }

    private boolean isExtensionInstalled(TaskContext tc, String extensionId) {
        String extHomeGlobal = tc.getDirectories().getGlobalExtensionsHome();
        File f = new File(extHomeGlobal);
        String[] files = f.list();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].startsWith(extensionId)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void perform(TaskContext tc) throws TaskFailedException {
        ZipFile zip;
        try {
            zip = new ZipFile(this._zipFile);
        }
        catch (IOException ioe) {
            throw new TaskFailedException(UpdateArb.format("READ_FAILED", this._zipFile.getPath()), ioe);
        }
        this.processPatchManifest(tc, zip);
        try {
            int i = 0;
            Random random = new Random();
            Enumeration<? extends ZipEntry> e = zip.entries();
            while (e.hasMoreElements()) {
                File outFile;
                block29: {
                    ZipEntry entry = e.nextElement();
                    double pctProgress = (double)i / (double)zip.size();
                    tc.getProgress().setPercentProgress(pctProgress);
                    ++i;
                    if (this.isSkipped(entry)) continue;
                    outFile = new File(this._destinationDir + File.separator + entry.getName());
                    if (outFile.exists() && !outFile.isDirectory()) {
                        if (!tc.confirmOverwrite(outFile)) {
                            throw new TaskFailedException(UpdateArb.get("INSTALL_CANCELLED"));
                        }
                        File backupFile = new File(outFile + ".backup");
                        while (backupFile.exists()) {
                            int suffix = random.nextInt(99999);
                            backupFile = new File(outFile + ".backup." + suffix);
                        }
                        if (!outFile.renameTo(backupFile)) {
                            throw new TaskFailedException(UpdateArb.format("BACKUP_FAILED", outFile.getPath(), backupFile.getPath()));
                        }
                        this._backedUpFiles.add(new File[]{outFile, backupFile});
                    } else if (!outFile.exists() && entry.isDirectory() && !this.mkdirs(outFile)) {
                        throw new TaskFailedException(UpdateArb.format("CREATE_DIR_FAILED", outFile.getPath()));
                    }
                    if (entry.isDirectory()) continue;
                    if (!this.mkdirs(outFile.getParentFile())) {
                        throw new TaskFailedException(UpdateArb.format("CREATE_DIR_FAILED", outFile.getParentFile().getPath()));
                    }
                    try {
                        if (!outFile.createNewFile()) {
                            throw new TaskFailedException(UpdateArb.format("CREATE_FILE_FAILED", outFile.getPath()));
                        }
                        this._createdFiles.add(outFile);
                    }
                    catch (IOException ioe) {
                        throw new TaskFailedException(UpdateArb.format("CREATE_FILE_FAILED", outFile.getPath()), ioe);
                    }
                    FileOutputStream fos = null;
                    try {
                        fos = new FileOutputStream(outFile);
                        this.copy(zip.getInputStream(entry), fos);
                        if (fos == null) break block29;
                    }
                    catch (IOException ioe) {
                        try {
                            throw new TaskFailedException(UpdateArb.format("EXTRACT_FAILED", outFile.getPath()), ioe);
                        }
                        catch (Throwable throwable) {
                            if (fos == null) throw throwable;
                            try {
                                fos.close();
                                throw throwable;
                            }
                            catch (IOException ioe2) {
                                throw new TaskFailedException(UpdateArb.format("EXTRACT_FAILED", outFile.getPath()), ioe2);
                            }
                        }
                    }
                    try {
                        fos.close();
                    }
                    catch (IOException ioe) {
                        throw new TaskFailedException(UpdateArb.format("EXTRACT_FAILED", outFile.getPath()), ioe);
                    }
                }
                this.markIfOsgiBundle(outFile);
            }
            tc.getProgress().setPercentProgress(1.0);
            LOG.log(Level.FINE, "Extracted " + this._zipFile + " to " + this._destinationDir);
        }
        finally {
            if (zip != null) {
                try {
                    zip.close();
                }
                catch (IOException ioe) {
                    throw new TaskFailedException(UpdateArb.get("IO_EXCEPTION"), ioe);
                }
            }
        }
        this.writeOutChangedFiles(tc);
    }

    private void writeOutChangedFiles(TaskContext tc) throws TaskFailedException {
        File uninstallInfo;
        File parent = TaskUtil.findBundlesHome(tc);
        File updates = new File(parent, "updates");
        if (!updates.exists()) {
            updates.mkdirs();
        }
        ArrayList<String> lines = new ArrayList<String>();
        for (BundleDetails bundleDetails : this._osgiBundleDetails) {
            lines.add("bundle_name=" + bundleDetails.getBundleSymbolicName());
        }
        for (String string : this._extensionNames) {
            lines.add("extension_name=" + string);
        }
        StringBuilder builder = new StringBuilder();
        for (File[] files : this._backedUpFiles) {
            builder.append("backed_up_file=");
            builder.append("ORIGINAL:");
            builder.append(files[0].getPath());
            builder.append(",BACKUP:");
            builder.append(files[1].getPath());
            lines.add(builder.toString());
            builder.setLength(0);
        }
        this.addFileList(lines, "directory_created", this._createdDirectories);
        this.addFileList(lines, "file_created", this._createdFiles);
        if (this._extensionNames.size() == 1) {
            String string = this._extensionNames.get(0);
            uninstallInfo = new File(updates, string + ".installinfo");
            TaskUtil.writeFile(lines, uninstallInfo);
        } else {
            String string2 = this._zipFile.getName();
            string2 = string2.substring(0, string2.lastIndexOf(".zip"));
            uninstallInfo = new File(updates, string2 + ".installinfo");
            TaskUtil.writeFile(lines, uninstallInfo);
        }
    }

    private void addFileList(List<String> lines, String key, List<File> list) {
        StringBuilder builder = new StringBuilder();
        for (File file : list) {
            builder.append(key + "=");
            builder.append(file.getPath());
            lines.add(builder.toString());
            builder.setLength(0);
        }
    }

    private void markIfOsgiBundle(File file) throws TaskFailedException {
        BundleDetails bundleDetails = BundleDetails.getOsgiBundleDetails(file);
        if (bundleDetails != null) {
            this._osgiBundleDetails.add(bundleDetails);
        }
    }

    private void copy(InputStream is, OutputStream os) throws IOException {
        byte[] buffer = new byte[4096];
        int bytesRead;
        while ((bytesRead = is.read(buffer)) >= 0) {
            os.write(buffer, 0, bytesRead);
        }
        return;
    }

    private boolean mkdirs(File dir) {
        boolean result;
        if (dir.isDirectory()) {
            return true;
        }
        File parentDir = dir.getParentFile();
        if (!parentDir.exists() && !(result = this.mkdirs(parentDir))) {
            return false;
        }
        if (dir.mkdir()) {
            this._createdDirectories.add(dir);
            return true;
        }
        return false;
    }

    @Override
    public void rollback(TaskContext tc) throws TaskFailedException {
        for (File file : this._createdFiles) {
            if (file.delete()) continue;
            throw new TaskFailedException(UpdateArb.format("DELETE_FAILED", file.getPath()));
        }
        Collections.reverse(this._createdDirectories);
        for (File file : this._createdDirectories) {
            if (file.delete()) continue;
            throw new TaskFailedException(UpdateArb.format("DELETE_FAILED", file.getPath()));
        }
        for (File[] files : this._backedUpFiles) {
            File original;
            File backup = files[1];
            if (backup.renameTo(original = files[0])) continue;
            throw new TaskFailedException(UpdateArb.format("RESTORE_FAILED", backup.getPath(), original.getPath()));
        }
    }
}

