/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.deferredupdate.task;

import java.io.File;
import oracle.ideimpl.deferredupdate.UpdateArb;
import oracle.ideimpl.deferredupdate.task.AtomicTask;
import oracle.ideimpl.deferredupdate.task.TaskContext;
import oracle.ideimpl.deferredupdate.task.TaskFailedException;

class DeleteFile
extends AtomicTask {
    private final File _fileToDelete;
    private File _backupFile;

    DeleteFile(File file) {
        this._fileToDelete = file;
    }

    @Override
    public void perform(TaskContext tc) throws TaskFailedException {
        String suffix = ".DeleteFile";
        File backupFile = new File(this._fileToDelete.getPath() + suffix);
        int i = 0;
        while (backupFile.exists()) {
            backupFile = new File(this._fileToDelete.getPath() + suffix + "." + ++i);
        }
        if (!this._fileToDelete.renameTo(backupFile)) {
            throw new TaskFailedException(UpdateArb.format("DELETE_FAILED_BACKUP", this._fileToDelete.getPath(), backupFile.getPath()));
        }
        this._backupFile = backupFile;
    }

    @Override
    public void rollback(TaskContext tc) throws TaskFailedException {
        if (this._fileToDelete.exists()) {
            throw new TaskFailedException(UpdateArb.format("RESTORE_DELETED_FILE_FAILED_1", this._fileToDelete));
        }
        if (!this._backupFile.renameTo(this._fileToDelete)) {
            throw new TaskFailedException(UpdateArb.format("RESTORE_DELETED_FILE_FAILED_2", this._fileToDelete, this._backupFile));
        }
    }

    @Override
    public void commit(TaskContext tc) throws TaskFailedException {
        if (!this._backupFile.delete()) {
            throw new TaskFailedException(UpdateArb.format("BACKUP_DELETE_FAILED", this._backupFile));
        }
    }
}

