/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.osgi.boot;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.SequenceInputStream;
import java.io.StringBufferInputStream;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.StringTokenizer;
import java.util.logging.ConsoleHandler;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import oracle.ide.osgi.boot.JavaVersion;
import oracle.ide.osgi.boot.LauncherBundle;
import oracle.ide.osgi.boot.OracleIdeLauncher;
import oracle.ide.osgi.boot.api.IdeBootProperties;
import oracle.ide.osgi.boot.api.IdeMacros;
import oracle.ide.osgi.boot.api.OJStartupHook;
import oracle.ideimpl.deferredupdate.DeferredUpdater;
import org.openide.util.Exceptions;

final class LauncherUtil {
    public static final String SHOW_BAD_JDK_WARNING = "showBadJdkWarning";
    private static String jdevSystemDirectory;
    private static boolean isFirstStartUp;

    LauncherUtil() {
    }

    public static void initialize(String[] args) {
        boolean assertsEnabled = false;
        if (!$assertionsDisabled) {
            assertsEnabled = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (!IdeBootProperties.hasAssertTracingDisabled()) {
            IdeBootProperties.setAssertTracingDisabled(!assertsEnabled);
        }
        LauncherUtil.registerArgs(args);
        LauncherUtil.handleHeadlessArgument(args);
        LauncherUtil.initBootstrapStartTime();
        LauncherUtil.determineRunMode(args);
        String oracleHome = LauncherUtil.initOracleHome();
        String fmwHome = LauncherUtil.initFusionMiddlewareHome();
        LauncherUtil.initProductHome();
        LauncherUtil.loadProductProperties();
        LauncherUtil.initUserDir(args);
        LauncherUtil.checkLaunchPrerequisites(args);
        LauncherUtil.setupLogging(args);
        LauncherUtil.initFCPAndJRFHome(oracleHome, fmwHome);
        LauncherUtil.throttleLocale();
        LauncherUtil.processOJStartupHook(args);
        LauncherUtil.loadMacros();
        LauncherUtil.setOSGiConfigurationArea();
        LauncherUtil.setOSGiFrameworkLibraryExtensions();
    }

    public static void registerArgs(String[] args) {
        if (args.length > 0) {
            IdeBootProperties.setIdeArguments(LauncherUtil.flattenOutArgs(args));
        }
    }

    private static void handleHeadlessArgument(String[] args) {
        boolean hasHeadlessArgument = LauncherUtil.containsArgument(args, "-headless");
        if (hasHeadlessArgument) {
            IdeBootProperties.setHeadlessMode("true");
        }
    }

    private static void checkLaunchPrerequisites(String[] args) {
        LauncherUtil.verifyJdkVersion(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void verifyJdkVersion(String[] args) {
        block22: {
            JavaVersion javaVersion;
            block23: {
                boolean isWarningSuppressed;
                String showBadJdkWarningProperty = System.getProperty(SHOW_BAD_JDK_WARNING, Boolean.TRUE.toString());
                String launchedFromJDev = System.getProperty("launched.from.jdev", Boolean.FALSE.toString());
                if (!Boolean.valueOf(showBadJdkWarningProperty).booleanValue() || Boolean.valueOf(launchedFromJDev).booleanValue() || (javaVersion = new JavaVersion()).isSupported()) break block22;
                if (GraphicsEnvironment.isHeadless()) break block23;
                if (LauncherUtil.containsArgument(args, "-nonag")) break block22;
                String confFilePath = IdeBootProperties.getUserConfPath();
                if (confFilePath == null) {
                    confFilePath = LauncherUtil.getConfFilePath();
                }
                String msg = LauncherBundle.format("BAD_JDK_VER", javaVersion.currentVersion(), javaVersion.minVersion(), javaVersion.maxVersion(), confFilePath);
                String title = LauncherBundle.get("BAD_JDK_VER_TITLE");
                String bootPreferencesPath = LauncherUtil.getSystemDirectory() + "fcpboot_persistence.boot";
                File bootPreferences = new File(bootPreferencesPath);
                String suppressedPropName = "oracle.ide.badJdkWarning";
                if (bootPreferences.exists()) {
                    LauncherUtil.loadBootProperties(bootPreferencesPath);
                }
                if (isWarningSuppressed = Boolean.getBoolean("oracle.ide.badJdkWarning")) break block22;
                JCheckBox checkBox = new JCheckBox();
                checkBox.setText(LauncherBundle.get("JDK_CHECKBOX_TEXT"));
                checkBox.setMnemonic(LauncherBundle.get("JDK_CHECKBOX_MNEMONIC").charAt(0));
                boolean res = LauncherUtil.showMessageDialog(title, msg, checkBox);
                if (res) {
                    if (checkBox.isSelected()) {
                        bootPreferences.getParentFile().mkdirs();
                        BufferedWriter out = null;
                        try {
                            out = new BufferedWriter(new FileWriter(bootPreferences));
                            String suppressedPropText = "oracle.ide.badJdkWarning = true";
                            out.write("oracle.ide.badJdkWarning = true");
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                        }
                        catch (IOException iOException) {
                        }
                        finally {
                            try {
                                if (out != null) {
                                    out.close();
                                }
                            }
                            catch (IOException iOException) {}
                        }
                    }
                } else {
                    System.exit(1);
                }
                break block22;
            }
            String msg = LauncherBundle.format("BAD_JDK_VER_NO_PROMPT", javaVersion.minVersion(), javaVersion.currentVersion());
            System.err.println(msg);
        }
    }

    private static boolean showMessageDialog(String title, Object message, JCheckBox optionalCheckBox) {
        int ret;
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout(0, 10));
        if (message instanceof Component) {
            panel.add((Component)message, "Center");
        } else {
            int width;
            JTextArea textArea = new JTextArea(message.toString());
            textArea.setEnabled(false);
            textArea.setEditable(false);
            textArea.setOpaque(true);
            textArea.setWrapStyleWord(true);
            textArea.setFont(UIManager.getFont("Label.font"));
            textArea.setForeground(UIManager.getColor("Label.foreground"));
            textArea.setDisabledTextColor(UIManager.getColor("Label.foreground"));
            textArea.setBackground(UIManager.getColor("Label.background"));
            textArea.setBorder(UIManager.getBorder("Label.border"));
            Dimension d = textArea.getPreferredSize();
            textArea.setLineWrap(true);
            d.width = width = (int)Math.sqrt(d.getHeight() * d.getWidth() * 3.0) + 1;
            d.height = 100000;
            textArea.setSize(d);
            d = textArea.getPreferredSize();
            textArea.setPreferredSize(d);
            panel.add((Component)textArea, "Center");
        }
        if (optionalCheckBox != null) {
            panel.add((Component)optionalCheckBox, "South");
        }
        return (ret = JOptionPane.showConfirmDialog(null, panel, title, 0)) == 0;
    }

    static boolean containsArgument(String[] args, String argName) {
        for (String arg : args) {
            if (!argName.equalsIgnoreCase(arg)) continue;
            return true;
        }
        return false;
    }

    private static String flattenOutArgs(String[] args) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < args.length; ++i) {
            buf.append(args[i]);
            if (i >= args.length - 1) continue;
            buf.append("\t");
        }
        return buf.toString();
    }

    protected static void initBootstrapStartTime() {
        long start = System.nanoTime();
        System.setProperty("ide.bootstrap.start", Long.toString(start));
    }

    static String[] checkForDeferredUpdates(String[] args) {
        if (new DeferredUpdater().update()) {
            LinkedHashSet<String> argSet = new LinkedHashSet<String>();
            for (String arg : args) {
                argSet.add(arg);
            }
            argSet.add("-clean");
            if (jdevSystemDirectory != null) {
                argSet.add("-migrate:" + jdevSystemDirectory);
            }
            if (argSet.size() != args.length) {
                args = argSet.toArray(new String[argSet.size()]);
            }
            LauncherUtil.registerArgs(args);
        }
        return args;
    }

    public static void throttleLocale() {
        if (!Boolean.valueOf(IdeBootProperties.getIdeThrottleLocale("false")).booleanValue()) {
            return;
        }
        String supportedLanguages = IdeBootProperties.getSupportedLocales("en,ja");
        String language = IdeBootProperties.getUserLanguage();
        String country = IdeBootProperties.getUserCountry();
        if (Arrays.asList(supportedLanguages.split(",")).contains(language)) {
            return;
        }
        Logger.getLogger(OracleIdeLauncher.class.getName()).info("Locale " + language + "_" + country + " is not supported by this product. Forcing locale to en_US.");
        System.setProperty("ide.old.user.country", country);
        System.setProperty("ide.old.user.language", language);
        IdeBootProperties.setUserCountry("US");
        IdeBootProperties.setUserLanguage("en");
        Locale.setDefault(new Locale("en", "US"));
    }

    private static void processOJStartupHook(String[] args) {
        OJStartupHook theHook;
        ServiceLoader<OJStartupHook> loader;
        Iterator<OJStartupHook> iter;
        String startupHook = System.getProperty(OJStartupHook.class.getName());
        if (startupHook != null && (iter = (loader = ServiceLoader.load(OJStartupHook.class)).iterator()).hasNext() && startupHook.equals((theHook = iter.next()).getClass().getName())) {
            theHook.onStartup(args);
        }
    }

    public static void loadProductProperties() {
        String confFilePath = LauncherUtil.getConfFilePath();
        if (confFilePath != null) {
            LauncherUtil.loadBootProperties(LauncherUtil.getBootFileName(confFilePath, ""));
        }
        if (!IdeBootProperties.isAssertTracingDisabled().booleanValue() && IdeBootProperties.isDebugBuild().booleanValue()) {
            System.out.println("Oracle IDE is in DEBUG mode. Class loading optimizations are switched off.");
        }
        if (confFilePath != null && IdeBootProperties.isDebugBuild().booleanValue()) {
            LauncherUtil.loadBootProperties(LauncherUtil.getBootFileName(confFilePath, "-debug"));
        }
    }

    protected static String getConfFilePath() {
        Properties systemProperties = System.getProperties();
        String confFilePath = systemProperties.getProperty("ide.conf");
        if (confFilePath == null) {
            confFilePath = systemProperties.getProperty("ide.config_pathname");
            if (confFilePath == null) {
                return null;
            }
            systemProperties.setProperty("ide.conf", confFilePath);
        } else {
            systemProperties.setProperty("ide.config_pathname", confFilePath);
        }
        confFilePath = confFilePath.replaceFirst("^[\\\"\\']+", "");
        confFilePath = confFilePath.replaceFirst("[\\\"\\']+$", "");
        IdeBootProperties.setIdeConfPath(confFilePath);
        return confFilePath;
    }

    protected static String getBootFileName(String confFilePath, String suffix) {
        return confFilePath.replaceFirst("(.conf)?$", suffix + ".boot");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadBootProperties(String bootFilePath) {
        Properties props;
        File bootFile = new File(bootFilePath);
        if (!bootFile.isFile()) {
            return;
        }
        HashSet<File> seen = new HashSet<File>();
        LinkedList<File> queue = new LinkedList<File>();
        LinkedList<Properties> result = new LinkedList<Properties>();
        queue.add(bootFile);
        while (!queue.isEmpty()) {
            File propsFile = (File)queue.removeFirst();
            if (seen.contains(propsFile)) continue;
            seen.add(propsFile);
            props = new Properties();
            FileInputStream in = null;
            try {
                in = new FileInputStream(propsFile);
                props.load(in);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            result.add(props);
            String includes = props.getProperty("include");
            if (includes == null) continue;
            props.remove("include");
            StringTokenizer st = new StringTokenizer(includes, ",");
            File relativeTo = propsFile.getParentFile();
            while (st.hasMoreTokens()) {
                File nextFile = new File(relativeTo, st.nextToken());
                if (!nextFile.isFile()) continue;
                queue.add(nextFile);
            }
        }
        Properties allProps = new Properties();
        while (!result.isEmpty()) {
            props = (Properties)result.removeLast();
            allProps.putAll((Map<?, ?>)props);
        }
        Properties systemProperties = System.getProperties();
        allProps.putAll((Map<?, ?>)systemProperties);
        systemProperties.putAll((Map<?, ?>)allProps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Properties getVersionProperties() {
        File confFile = new File(LauncherUtil.getConfFilePath());
        File vp = new File(confFile.getParentFile(), "version.properties");
        Properties p = new Properties();
        BufferedInputStream is = null;
        try {
            is = new BufferedInputStream(new FileInputStream(vp));
            p.load(is);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        return p;
    }

    public static void initUserDir(String[] args) {
        boolean singleUser = false;
        for (String arg : args) {
            if (!"-su".equalsIgnoreCase(arg) && !"-singleuser".equalsIgnoreCase(arg)) continue;
            singleUser = true;
            break;
        }
        if (singleUser) {
            String oracleHome = IdeBootProperties.getProductHome();
            LauncherUtil.setPrefAndWorkDirs(oracleHome, oracleHome);
            return;
        }
        String ideUserDir = IdeBootProperties.getIdeUserDir();
        if (LauncherUtil.hasLength(ideUserDir)) {
            LauncherUtil.setPrefAndWorkDirs(ideUserDir, ideUserDir);
            return;
        }
        String ideUserDirVar = System.getProperty("ide.user.dir.var");
        if (LauncherUtil.hasLength(ideUserDirVar)) {
            StringTokenizer st = new StringTokenizer(ideUserDirVar, ",");
            while (st.hasMoreTokens()) {
                String varName = st.nextToken();
                String ideUserDir2 = System.getenv(varName);
                if (!LauncherUtil.hasLength(ideUserDir2)) continue;
                LauncherUtil.setPrefAndWorkDirs(ideUserDir2, ideUserDir2);
                return;
            }
        }
        String sysDir = IdeBootProperties.getSystemDirectory();
        String workDir = IdeBootProperties.getIdeWorkDir();
        if (LauncherUtil.hasLength(sysDir) && LauncherUtil.hasLength(workDir)) {
            LauncherUtil.setPrefAndWorkDirs(sysDir, workDir);
            return;
        }
        String app = LauncherUtil.getApplicationName();
        String prefDirBase = System.getProperty("ide.pref.dir.base");
        String workDirBase = System.getProperty("ide.work.dir.base");
        if (LauncherUtil.hasLength(prefDirBase) && LauncherUtil.hasLength(workDirBase)) {
            if ("oracle.jdeveloper".equals(IdeBootProperties.getProductName()) && !Boolean.getBoolean("ide.mydocs") && !"6.0".equals(IdeBootProperties.getOsVersion())) {
                File baseDir = new File(workDirBase);
                File parent = baseDir.getParentFile();
                while (parent != null) {
                    baseDir = parent;
                    parent = baseDir.getParentFile();
                }
                workDirBase = baseDir.getAbsolutePath();
            }
            LauncherUtil.setPrefAndWorkDirs(prefDirBase + File.separator + app, workDirBase + File.separator + app);
            return;
        }
        StringBuilder dirname = new StringBuilder();
        for (int i = 0; i < app.length(); ++i) {
            char c = app.charAt(i);
            if (Character.isWhitespace(c)) continue;
            if (Character.isUpperCase(c)) {
                dirname.append(Character.toLowerCase(c));
                continue;
            }
            dirname.append(c);
        }
        String userHome = IdeBootProperties.getUserHome();
        String sysDir2 = IdeBootProperties.getSystemDirectory();
        String workDir2 = IdeBootProperties.getIdeWorkDir();
        String prefsLoc = LauncherUtil.hasLength(sysDir2) ? sysDir2 : userHome + File.separator + "." + dirname;
        String workLoc = LauncherUtil.hasLength(workDir2) ? workDir2 : userHome + File.separator + dirname;
        LauncherUtil.setPrefAndWorkDirs(prefsLoc, workLoc);
    }

    private static void setOSGiConfigurationArea() {
        String passedInOSGiArea = IdeBootProperties.getOsgiConfigurationArea();
        if (passedInOSGiArea != null) {
            return;
        }
        String oracleHome = IdeBootProperties.getProductHome();
        File configurationFileSource = new File(oracleHome + File.separator + "configuration" + File.separator + "bundles.info");
        IdeBootProperties.setOsgiConfigurationArea("file:" + configurationFileSource.getParent());
    }

    private static void setOSGiFrameworkLibraryExtensions() {
        String passedInOSGiExts = IdeBootProperties.getOsgiFrameworkLibraryExtensions();
        if (passedInOSGiExts != null) {
            return;
        }
        String osName = System.getProperty("os.name");
        if (osName != null && osName.toLowerCase().startsWith("mac os x")) {
            IdeBootProperties.setOsgiFrameworkLibraryExtensions("dylib");
        }
    }

    static String getApplicationName() {
        String confName = new File(LauncherUtil.getConfFilePath()).getName();
        if (confName.length() > 5) {
            confName = confName.substring(0, confName.length() - 5);
        }
        return LauncherUtil.getVersionProperties().getProperty("PRODUCT", confName);
    }

    static Image getHiddenFrameIcon() {
        String iconImgPath = IdeBootProperties.getHiddenFrameIcon();
        if (iconImgPath == null) {
            return null;
        }
        ImageIcon iconImg = new ImageIcon(iconImgPath);
        if (iconImg == null) {
            return null;
        }
        return iconImg.getImage();
    }

    private static void setPrefAndWorkDirs(String prefDir, String workDir) {
        IdeBootProperties.setIdePrefDir(prefDir);
        IdeBootProperties.setIdeWorkDir(workDir);
        IdeBootProperties.setIdeUserDir(prefDir);
    }

    final String getOracleHome() {
        try {
            return LauncherUtil.initOracleHomeImpl();
        }
        catch (Exception e) {
            return null;
        }
    }

    protected static String initOracleHomeImpl() {
        URL url;
        String oracleHome = IdeBootProperties.getMiddlewareHome();
        if (oracleHome == null && (url = LauncherUtil.getBootCodeSource()) != null) {
            String protocol;
            URI uri = null;
            try {
                uri = url.toURI();
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
            String string = protocol = uri != null ? uri.getScheme() : url.getProtocol();
            if ("file".equals(protocol)) {
                String path = uri != null ? uri.getPath() : url.getPath();
                String suffixToRemove = "/ide/lib/fcpboot.jar";
                if (!(path.endsWith(suffixToRemove) || path.endsWith(suffixToRemove = "/built/ide-boot/classes/") || path.endsWith(suffixToRemove = "/jdev/lib/jdev-loader.jar") || path.endsWith(suffixToRemove = "/jdev/plugins/ide-boot.jar"))) {
                    suffixToRemove = null;
                }
                if (suffixToRemove != null) {
                    int oracleHomeEnd = path.length() - suffixToRemove.length();
                    String oracleHomeStr = path.substring(0, oracleHomeEnd);
                    if (uri == null && oracleHomeStr.indexOf(37) >= 0) {
                        System.out.println("**** WARNING: Possible under-decoded pathname for Oracle Home: " + oracleHomeStr);
                    }
                    File oracleHomeDir = new File(oracleHomeStr + File.separatorChar);
                    oracleHome = oracleHomeDir.getAbsolutePath();
                }
            }
            if (oracleHome != null) {
                IdeBootProperties.setOracleHome(oracleHome);
            }
        }
        return oracleHome;
    }

    protected static URL getBootCodeSource() {
        return OracleIdeLauncher.class.getProtectionDomain().getCodeSource().getLocation();
    }

    public static String initOracleHome() {
        String oracleHome = LauncherUtil.initOracleHomeImpl();
        if (oracleHome == null) {
            System.out.println("**** WARNING: could not determine oracle.home automatically.  This means the IDE bootstrap could not recognize the build configuration.  Launcher.class location is " + LauncherUtil.getBootCodeSource());
        }
        return oracleHome;
    }

    private static String initFusionMiddlewareHome() {
        String oracleDotHome = IdeBootProperties.getOracleHome();
        String middlewareHome = IdeBootProperties.getMiddlewareHome();
        if (oracleDotHome != null && middlewareHome == null) {
            File f = new File(oracleDotHome);
            String mwHomeRelative = System.getProperty("ide.mw.relative.home");
            middlewareHome = mwHomeRelative != null ? new File(f, mwHomeRelative).getPath() : f.getParent();
            IdeBootProperties.setMiddlewareHome(middlewareHome);
        }
        return middlewareHome;
    }

    private static void initProductHome() {
        String fmwHome = IdeBootProperties.getFMWRelativeHome();
        String mwHome = IdeBootProperties.getMiddlewareHome();
        File productFMWHome = fmwHome != null ? new File(new File(mwHome), fmwHome) : new File(IdeBootProperties.getOracleHome());
        IdeBootProperties.setProductHome(productFMWHome.getAbsolutePath());
    }

    private static void loadMacros() {
        String oracleHome = IdeBootProperties.getOracleHome();
        LauncherUtil.loadMacroFiles(Paths.get(oracleHome, "ide/macros"));
        String productHome = IdeBootProperties.getProductHome();
        if (!oracleHome.equals(productHome)) {
            LauncherUtil.loadMacroFiles(Paths.get(productHome, "ide/macros"));
        }
    }

    private static void loadMacroFiles(Path directory) {
        if (!Files.isDirectory(directory, new LinkOption[0])) {
            return;
        }
        try (DirectoryStream<Path> paths = Files.newDirectoryStream(directory, "{*.properties,*.xml}");){
            for (Path path : paths) {
                try {
                    for (Map.Entry<String, String> entry : IdeMacros.loadMacroFile(path).entrySet()) {
                        if (System.getProperty(entry.getKey()) != null) continue;
                        System.setProperty(entry.getKey(), entry.getValue());
                    }
                }
                catch (IOException e) {
                    System.err.println("IDE macro property file " + path + " not read: " + e);
                }
            }
        }
        catch (IOException e) {
            System.err.println("IDE macro directory " + directory + " not read: " + e);
        }
    }

    public static String loadVersion() {
        Properties props = new Properties();
        FileInputStream in = null;
        try {
            in = new FileInputStream("version.properties");
            props.load(in);
        }
        catch (IOException iOException) {
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
        return props.getProperty("VER_FULL", "11.0.0.0.0");
    }

    static String getSystemDirectory() {
        String ideUserDir;
        String userHome;
        String ideHome;
        if (jdevSystemDirectory != null) {
            return jdevSystemDirectory;
        }
        String VER_FULL = LauncherUtil.loadVersion();
        String binDir = LauncherUtil.canonicalize(IdeBootProperties.getUserDir("."));
        if (!binDir.endsWith(File.separator)) {
            binDir = binDir + File.separator;
        }
        if (!LauncherUtil.hasLength(ideHome = LauncherUtil.canonicalize(System.getProperty("ide.home", null)))) {
            File f = new File(binDir);
            ideHome = f.getParent();
        }
        if (!ideHome.endsWith(File.separator)) {
            ideHome = ideHome + File.separator;
        }
        if (!LauncherUtil.hasLength(userHome = LauncherUtil.canonicalize(ideUserDir = IdeBootProperties.getIdePrefDir())) && !LauncherUtil.hasLength(userHome = LauncherUtil.canonicalize(ideUserDir = IdeBootProperties.getIdeUserDir()))) {
            userHome = ideHome;
        }
        if (!userHome.endsWith(File.separator)) {
            userHome = userHome + File.separator;
        }
        String systemDirectory = LauncherUtil.systemFolderName(userHome, VER_FULL);
        IdeBootProperties.setSystemDirectory(systemDirectory);
        if (IdeBootProperties.getDiagnosticsDirectory() == null) {
            IdeBootProperties.setDiagnosticsDirectory(systemDirectory + ".diagnostics" + File.separator);
        }
        jdevSystemDirectory = systemDirectory;
        LauncherUtil.mkdirSystemDirectoryIfItDoesNotExist();
        return systemDirectory;
    }

    private static String systemFolderName(String userHome, String version) {
        StringBuilder sb = new StringBuilder();
        sb.append(userHome).append(userHome.endsWith(File.separator) ? "" : File.separator).append("system").append(version).append(File.separator);
        return sb.toString();
    }

    private static final boolean hasLength(String str) {
        return str != null && !str.isEmpty();
    }

    private static String canonicalize(String dir) {
        if (dir == null || dir.trim().isEmpty()) {
            return dir;
        }
        File f = new File(LauncherUtil.stripDoubleQuotes(dir));
        try {
            f = f.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return f.toString();
    }

    private static String stripDoubleQuotes(String dir) {
        String[] tokens;
        StringBuffer sb = new StringBuffer();
        for (String token : tokens = dir.split("[\\\"]")) {
            if ("".equals(token)) continue;
            sb.append(token);
        }
        return sb.toString();
    }

    private static void mkdirSystemDirectoryIfItDoesNotExist() {
        File systemDirectoryFile;
        String systemDirectory = IdeBootProperties.getSystemDirectory();
        if (systemDirectory != null && !(systemDirectoryFile = new File(systemDirectory)).exists()) {
            systemDirectoryFile.mkdirs();
            LauncherUtil.setFirstStartUp(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private static void setupLogging(String[] args) {
        block81: {
            block79: {
                block80: {
                    block78: {
                        block82: {
                            block77: {
                                block76: {
                                    block75: {
                                        if (IdeBootProperties.getLoggingConfigClass() != null) {
                                            return;
                                        }
                                        if (IdeBootProperties.getLoggingConfigFile() != null) {
                                            return;
                                        }
                                        if (Boolean.getBoolean("ide.standard.logging")) {
                                            return;
                                        }
                                        logPropsFilePath = null;
                                        custom = null;
                                        if (IdeBootProperties.getIdeLoggingProperties() != null) {
                                            custom = new StringBufferInputStream(IdeBootProperties.getIdeLoggingProperties().replace(';', '\n'));
                                        }
                                        logPropsFilePath = LauncherUtil.getSystemDirectory() + "jdev-custom-logging.conf";
                                        path = IdeBootProperties.getIdeLoggingConfigFile();
                                        if (path == null || !LauncherUtil.load(new File(path), custom, logPropsFilePath)) break block75;
                                        IdeBootProperties.setLoggingConfigFile(logPropsFilePath);
                                        logManager = LogManager.getLogManager();
                                        try {
                                            logManager.readConfiguration();
                                        }
                                        catch (IOException e) {
                                            System.err.println("WARNING: Cannot read logging configuration.");
                                            logManager = null;
                                        }
                                        if (logManager != null) {
                                            IdeBootProperties.setLoggingConfigClass("java.lang.Object");
                                            s = logManager.getProperty("java.util.logging.FileHandler.pattern");
                                            if (s != null) {
                                                new File(s).getParentFile().mkdirs();
                                            }
                                            if ((s = logManager.getProperty("java.util.logging.ConsoleHandler.NetBeansLevel")) != null) {
                                                nbLevel = null;
                                                try {
                                                    nbLevel = Level.parse(s);
                                                }
                                                catch (IllegalArgumentException var7_15) {
                                                    // empty catch block
                                                }
                                                if (nbLevel != null) {
                                                    for (Handler h : Logger.getLogger("").getHandlers()) {
                                                        if (!(h instanceof ConsoleHandler)) continue;
                                                        h.setFilter(new NetBeansLogConsoleFilter(nbLevel));
                                                        break;
                                                    }
                                                }
                                            }
                                        }
                                        return;
                                    }
                                    debug = IdeBootProperties.isDebugBuild() != false && IdeBootProperties.isIdeLoggingNondebug() == false;
                                    conf = IdeBootProperties.getIdeConfPath();
                                    if (conf == null) ** GOTO lbl115
                                    file = new File(conf);
                                    directory = file.getParentFile();
                                    name = file.getName();
                                    dot = name.lastIndexOf(46);
                                    if (dot < 0) {
                                        dot = name.length();
                                    }
                                    name = name.substring(0, dot);
                                    if (!debug || !LauncherUtil.load(new File(directory, name + "-logging-debug.conf"), custom, logPropsFilePath)) break block76;
                                    IdeBootProperties.setLoggingConfigFile(logPropsFilePath);
                                    logManager = LogManager.getLogManager();
                                    try {
                                        logManager.readConfiguration();
                                    }
                                    catch (IOException e) {
                                        System.err.println("WARNING: Cannot read logging configuration.");
                                        logManager = null;
                                    }
                                    if (logManager != null) {
                                        IdeBootProperties.setLoggingConfigClass("java.lang.Object");
                                        s = logManager.getProperty("java.util.logging.FileHandler.pattern");
                                        if (s != null) {
                                            new File(s).getParentFile().mkdirs();
                                        }
                                        if ((s = logManager.getProperty("java.util.logging.ConsoleHandler.NetBeansLevel")) != null) {
                                            nbLevel = null;
                                            try {
                                                nbLevel = Level.parse(s);
                                            }
                                            catch (IllegalArgumentException var13_44) {
                                                // empty catch block
                                            }
                                            if (nbLevel != null) {
                                                for (Handler h : Logger.getLogger("").getHandlers()) {
                                                    if (!(h instanceof ConsoleHandler)) continue;
                                                    h.setFilter(new NetBeansLogConsoleFilter(nbLevel));
                                                    break;
                                                }
                                            }
                                        }
                                    }
                                    return;
                                }
                                if (!LauncherUtil.load(new File(directory, name + "-logging.conf"), custom, logPropsFilePath)) break block77;
                                IdeBootProperties.setLoggingConfigFile(logPropsFilePath);
                                logManager = LogManager.getLogManager();
                                try {
                                    logManager.readConfiguration();
                                }
                                catch (IOException e) {
                                    System.err.println("WARNING: Cannot read logging configuration.");
                                    logManager = null;
                                }
                                if (logManager != null) {
                                    IdeBootProperties.setLoggingConfigClass("java.lang.Object");
                                    s = logManager.getProperty("java.util.logging.FileHandler.pattern");
                                    if (s != null) {
                                        new File(s).getParentFile().mkdirs();
                                    }
                                    if ((s = logManager.getProperty("java.util.logging.ConsoleHandler.NetBeansLevel")) != null) {
                                        nbLevel = null;
                                        try {
                                            nbLevel = Level.parse(s);
                                        }
                                        catch (IllegalArgumentException var13_46) {
                                            // empty catch block
                                        }
                                        if (nbLevel != null) {
                                            for (Handler h : Logger.getLogger("").getHandlers()) {
                                                if (!(h instanceof ConsoleHandler)) continue;
                                                h.setFilter(new NetBeansLogConsoleFilter(nbLevel));
                                                break;
                                            }
                                        }
                                    }
                                }
                                return;
                            }
                            break block82;
lbl115:
                            // 1 sources

                            directory = new File(IdeBootProperties.getUserDir());
                        }
                        directory = new File(new File(directory.getParentFile().getParentFile(), "ide"), "bin");
                        if (!GraphicsEnvironment.isHeadless()) ** GOTO lbl152
                        if (!debug || !LauncherUtil.load(new File(directory, "headless-logging-debug.conf"), custom, logPropsFilePath)) break block78;
                        IdeBootProperties.setLoggingConfigFile(logPropsFilePath);
                        logManager = LogManager.getLogManager();
                        try {
                            logManager.readConfiguration();
                        }
                        catch (IOException e) {
                            System.err.println("WARNING: Cannot read logging configuration.");
                            logManager = null;
                        }
                        if (logManager != null) {
                            IdeBootProperties.setLoggingConfigClass("java.lang.Object");
                            s = logManager.getProperty("java.util.logging.FileHandler.pattern");
                            if (s != null) {
                                new File(s).getParentFile().mkdirs();
                            }
                            if ((s = logManager.getProperty("java.util.logging.ConsoleHandler.NetBeansLevel")) != null) {
                                nbLevel = null;
                                try {
                                    nbLevel = Level.parse(s);
                                }
                                catch (IllegalArgumentException var10_30) {
                                    // empty catch block
                                }
                                if (nbLevel != null) {
                                    for (Handler h : Logger.getLogger("").getHandlers()) {
                                        if (!(h instanceof ConsoleHandler)) continue;
                                        h.setFilter(new NetBeansLogConsoleFilter(nbLevel));
                                        break;
                                    }
                                }
                            }
                        }
                        return;
                    }
                    LauncherUtil.load(new File(directory, "headless-logging.conf"), custom, logPropsFilePath);
                    break block79;
lbl152:
                    // 1 sources

                    if (!debug || !LauncherUtil.load(new File(directory, "ide-logging-debug.conf"), custom, logPropsFilePath)) break block80;
                    IdeBootProperties.setLoggingConfigFile(logPropsFilePath);
                    logManager = LogManager.getLogManager();
                    try {
                        logManager.readConfiguration();
                    }
                    catch (IOException e) {
                        System.err.println("WARNING: Cannot read logging configuration.");
                        logManager = null;
                    }
                    if (logManager != null) {
                        IdeBootProperties.setLoggingConfigClass("java.lang.Object");
                        s = logManager.getProperty("java.util.logging.FileHandler.pattern");
                        if (s != null) {
                            new File(s).getParentFile().mkdirs();
                        }
                        if ((s = logManager.getProperty("java.util.logging.ConsoleHandler.NetBeansLevel")) != null) {
                            nbLevel = null;
                            try {
                                nbLevel = Level.parse(s);
                            }
                            catch (IllegalArgumentException var10_32) {
                                // empty catch block
                            }
                            if (nbLevel != null) {
                                for (Handler h : Logger.getLogger("").getHandlers()) {
                                    if (!(h instanceof ConsoleHandler)) continue;
                                    h.setFilter(new NetBeansLogConsoleFilter(nbLevel));
                                    break;
                                }
                            }
                        }
                    }
                    return;
                }
                LauncherUtil.load(new File(directory, "ide-logging.conf"), custom, logPropsFilePath);
            }
            IdeBootProperties.setLoggingConfigFile(logPropsFilePath);
            logManager = LogManager.getLogManager();
            try {
                logManager.readConfiguration();
            }
            catch (IOException e) {
                System.err.println("WARNING: Cannot read logging configuration.");
                logManager = null;
            }
            if (logManager != null) {
                IdeBootProperties.setLoggingConfigClass("java.lang.Object");
                s = logManager.getProperty("java.util.logging.FileHandler.pattern");
                if (s != null) {
                    new File(s).getParentFile().mkdirs();
                }
                if ((s = logManager.getProperty("java.util.logging.ConsoleHandler.NetBeansLevel")) != null) {
                    nbLevel = null;
                    try {
                        nbLevel = Level.parse(s);
                    }
                    catch (IllegalArgumentException var5_11) {
                        // empty catch block
                    }
                    if (nbLevel != null) {
                        for (Handler h : Logger.getLogger("").getHandlers()) {
                            if (!(h instanceof ConsoleHandler)) continue;
                            h.setFilter(new NetBeansLogConsoleFilter(nbLevel));
                            break block81;
                        }
                    }
                }
            }
            break block81;
            catch (Throwable var17_56) {
                IdeBootProperties.setLoggingConfigFile(logPropsFilePath);
                logManager = LogManager.getLogManager();
                try {
                    logManager.readConfiguration();
                }
                catch (IOException e) {
                    System.err.println("WARNING: Cannot read logging configuration.");
                    logManager = null;
                }
                if (logManager != null) {
                    IdeBootProperties.setLoggingConfigClass("java.lang.Object");
                    s = logManager.getProperty("java.util.logging.FileHandler.pattern");
                    if (s != null) {
                        new File(s).getParentFile().mkdirs();
                    }
                    if ((s = logManager.getProperty("java.util.logging.ConsoleHandler.NetBeansLevel")) != null) {
                        nbLevel = null;
                        try {
                            nbLevel = Level.parse(s);
                        }
                        catch (IllegalArgumentException var21_61) {
                            // empty catch block
                        }
                        if (nbLevel != null) {
                            for (Handler h : Logger.getLogger("").getHandlers()) {
                                if (!(h instanceof ConsoleHandler)) continue;
                                h.setFilter(new NetBeansLogConsoleFilter(nbLevel));
                                break;
                            }
                        }
                    }
                }
                throw var17_56;
            }
        }
    }

    private static void setFirstStartUp(boolean first) {
        isFirstStartUp = first;
    }

    static boolean isFirstStartUp() {
        return isFirstStartUp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean load(File file, InputStream cis, String outputLogFilePath) {
        if (file != null && !file.isFile()) {
            return false;
        }
        if (file == null && cis == null) {
            return true;
        }
        InputStream is = null;
        OutputStream out = null;
        try {
            String line;
            if (file != null) {
                BufferedInputStream fis = new BufferedInputStream(new FileInputStream(file));
                is = cis == null ? fis : new SequenceInputStream(fis, cis);
            } else {
                is = cis;
            }
            File f = new File(outputLogFilePath);
            f.getParentFile().mkdirs();
            out = new FileOutputStream(f);
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            OutputStreamWriter writer = new OutputStreamWriter(out);
            while ((line = reader.readLine()) != null) {
                if (line.trim().startsWith("java.util.logging.FileHandler") && line.contains("%d")) {
                    line = LauncherUtil.replaceDiagnosticsDirForConfFile(line);
                }
                writer.write(line);
                writer.write("\n");
            }
            ((Writer)writer).close();
            reader.close();
            f.deleteOnExit();
        }
        catch (IOException e) {
            System.err.println("Exception loading logger configuration: " + file);
            e.printStackTrace();
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        return true;
    }

    private static String replaceDiagnosticsDirForConfFile(String line) {
        String diagDir = IdeBootProperties.getDiagnosticsDirectory().replace("\\", "\\\\");
        line = line.replace("%d/", diagDir);
        line = line.replace("%d", diagDir);
        return line;
    }

    private static void determineRunMode(String[] args) {
        String jdevDebugMode;
        Boolean debugMode = null;
        for (String arg : args) {
            if ("-nondebugmode".equalsIgnoreCase(arg)) {
                debugMode = false;
                continue;
            }
            if (!"-debugmode".equalsIgnoreCase(arg)) continue;
            debugMode = true;
        }
        if (debugMode == null && !(debugMode = Boolean.valueOf("true".equals(jdevDebugMode = System.getenv("JDEV_DEBUG_MODE")))).booleanValue()) {
            Properties versionProperties = LauncherUtil.getVersionProperties();
            debugMode = "1".equals(versionProperties.getProperty("DEBUG_BUILD"));
        }
        String debugModeAsString = debugMode != false ? "true" : "false";
        IdeBootProperties.setDebugBuild(debugModeAsString);
    }

    private static void initFCPAndJRFHome(String oracleHome, String fmwHome) {
        Logger logger = Logger.getLogger(OracleIdeLauncher.class.getName());
        if (IdeBootProperties.getFCPHome() == null) {
            IdeBootProperties.setFCPHome(oracleHome);
            logger.fine("FCP home (to be used in Bundle-ClassPath) was set to " + oracleHome);
        } else {
            logger.info("FCP home pre-set to " + IdeBootProperties.getFCPHome());
        }
        if (IdeBootProperties.getJRFHome() == null) {
            File oracleCommonDir = new File(fmwHome, "oracle_common");
            if (oracleCommonDir.exists()) {
                IdeBootProperties.setJRFHome(oracleCommonDir.getAbsolutePath());
            } else {
                IdeBootProperties.setJRFHome(oracleHome);
            }
            logger.fine("JRF home (to be used in Bundle-ClassPath) was set to " + IdeBootProperties.getJRFHome());
        } else {
            logger.info("JRF home pre-set to " + IdeBootProperties.getJRFHome());
        }
    }

    static {
        isFirstStartUp = false;
    }

    private static class NetBeansLogConsoleFilter
    implements Filter {
        private Level level;

        NetBeansLogConsoleFilter(Level level) {
            this.level = level;
        }

        @Override
        public boolean isLoggable(LogRecord record) {
            String loggerName = record.getLoggerName();
            return loggerName == null || !loggerName.startsWith("org.netbeans") && !loggerName.startsWith("org.openide") || record.getLevel().intValue() >= this.level.intValue() && Exceptions.findLocalizedMessage((Throwable)record.getThrown()) == null;
        }
    }
}

