/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.gallery;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.ide.extension.LazyClassAdapter;
import oracle.ide.gallery.GalleryProvider;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;

class GalleryProviderInfo
extends HashStructureAdapter {
    private static final String PROVIDER_CLASS = "provider-class/#text";
    private static final String FOLDERS = "folders";
    private static final String FOLDER = "folder";
    private Set<String> _folders;
    private GalleryProvider _providerImpl;

    private GalleryProviderInfo(HashStructure hash) {
        super(hash);
    }

    static GalleryProviderInfo getInstance(HashStructure hash) {
        return new GalleryProviderInfo(hash);
    }

    String getId() {
        return this._hash.getString(PROVIDER_CLASS);
    }

    GalleryProvider getGalleryProvider() {
        if (this._providerImpl == null) {
            LazyClassAdapter adapter = LazyClassAdapter.getInstance((HashStructure)this._hash);
            this._providerImpl = (GalleryProvider)adapter.createInstance(GalleryProvider.class, PROVIDER_CLASS);
            this._hash.putBoolean("GalleryProvider_instance_created", true);
        }
        return this._providerImpl;
    }

    Set<String> getFolders() {
        if (this._folders == null) {
            List folderHashes;
            HashSet<String> folders = new HashSet<String>();
            HashStructure foldersHash = this._hash.getHashStructure(FOLDERS);
            if (foldersHash != null && (folderHashes = foldersHash.getAsList(FOLDER)) != null && !folderHashes.isEmpty()) {
                for (HashStructure hash : folderHashes) {
                    folders.add(hash.getString("#text"));
                }
            }
            this._folders = Collections.unmodifiableSet(folders);
        }
        return this._folders;
    }
}

