/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.gallery;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.text.Collator;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import javax.ide.extension.Extension;
import javax.ide.net.URIFactory;
import javax.ide.net.VirtualFileSystem;
import javax.ide.util.MetaResource;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import oracle.ide.Context;
import oracle.ide.ExtensionRegistry;
import oracle.ide.extension.rules.RuleEngine;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.gallery.GalleryFolder;
import oracle.ide.model.Attributes;
import oracle.ide.model.DefaultAttributes;
import oracle.ide.model.Element;
import oracle.ide.util.Assert;
import oracle.ide.wizard.Invokable;
import oracle.ide.wizard.TriggerInvokable;
import oracle.ide.wizard.Wizard;
import oracle.ide.wizard.WizardManager;
import oracle.javatools.controls.WashedIcon;
import oracle.javatools.icons.OracleIcons;

public final class GalleryElement
implements Comparable,
Element {
    private static final Collator COLLATOR = Collator.getInstance();
    static final Comparator<GalleryElement> LABEL_ONLY_COMPARATOR = new LabelOnlyComparator();
    private String _name;
    private String _id;
    private String[] _params;
    private String _iconFile;
    private MetaResource _iconResource;
    private ClassLoader _classLoader;
    private String _invokableClassName;
    private boolean _unsorted;
    private String _description;
    private String[] _technologyKeys;
    private String _ruleId;
    private Invokable _invokable;
    private Icon _icon;
    private Icon _disabledIcon;
    private boolean _canAddToNewMenu;

    public GalleryElement() {
        this(null);
    }

    public GalleryElement(Invokable invokable) {
        this._invokable = invokable;
    }

    public String getDescription() {
        return this._description;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    @Deprecated
    public boolean getUnsorted() {
        return this._unsorted;
    }

    public boolean isUnsorted() {
        return this._unsorted;
    }

    public void setUnsorted(boolean unsorted) {
        this._unsorted = unsorted;
    }

    @Deprecated
    public void setWizardClassLoader(ClassLoader loader) {
        this.setInvokableClassLoader(loader);
    }

    @Deprecated
    public ClassLoader getWizardClassLoader() {
        return this.getInvokableClassLoader();
    }

    public void setInvokableClassLoader(ClassLoader loader) {
        if (loader == null) {
            throw new NullPointerException("loader is null");
        }
        this._classLoader = loader;
    }

    public ClassLoader getInvokableClassLoader() {
        return this._classLoader;
    }

    @Deprecated
    public void setWizardClass(String clazz) {
        this.setInvokableClass(clazz);
    }

    public void setInvokableClass(String clazz) {
        this._invokableClassName = clazz;
    }

    public String getInvokableClass() {
        return this._invokableClassName;
    }

    @Deprecated
    public String getWizardClass() {
        return this.getInvokableClass();
    }

    @Deprecated
    public Wizard getWizard() {
        if (this.getInvokable() instanceof Wizard) {
            return (Wizard)this.getInvokable();
        }
        return null;
    }

    public Invokable getInvokable() {
        if (this._invokable == null && this.getInvokableClass() != null) {
            this._invokable = WizardManager.getInstance().getInvokable(this.getInvokableClassLoader(), this.getInvokableClass());
        }
        return this._invokable;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    @Deprecated
    public void setWizardId(String id) {
        this.setId(id);
    }

    @Deprecated
    public String getWizardId() {
        return this.getId();
    }

    public void setId(String id) {
        this._id = id;
    }

    public String getId() {
        return this._id;
    }

    public String[] getWizardParameters() {
        return this._params != null ? this._params : new String[]{};
    }

    public void setWizardParameters(String[] wizardParams) {
        this._params = wizardParams;
    }

    public void setIconFile(String iconFile) {
        this._iconFile = iconFile;
    }

    public String getIconFile() {
        return this._iconFile;
    }

    public String[] getTechnologyKeys() {
        return this._technologyKeys != null ? this._technologyKeys : new String[]{};
    }

    public void setTechnologyKeys(String[] technologyKeys) {
        this._technologyKeys = technologyKeys;
    }

    @Deprecated
    public String getResClass() {
        return null;
    }

    @Deprecated
    public void setResClass(String resClass) {
    }

    void setRule(String ruleId) {
        this._ruleId = ruleId;
    }

    public Object getData() {
        return this;
    }

    public boolean mayHaveChildren() {
        return false;
    }

    public Iterator getChildren() {
        return null;
    }

    public Attributes getAttributes() {
        return DefaultAttributes.EMPTY_ATTRIBUTES;
    }

    public String getShortLabel() {
        return this.getWizardName();
    }

    public String getLongLabel() {
        if (this._description != null) {
            return this._description;
        }
        StringBuilder b = new StringBuilder("[description undefined");
        if (this._invokableClassName != null) {
            b.append(" - ");
            b.append(this._invokableClassName);
        }
        if (this._invokable != null) {
            b.append(" - ");
            b.append(this._invokable.getClass().getName());
        }
        b.append(']');
        return b.toString();
    }

    public String getToolTipText() {
        return this.getDescription();
    }

    public final void setAddToNewMenu(boolean canAddToNewMenu) {
        this._canAddToNewMenu = canAddToNewMenu;
    }

    public final boolean isAddToNewMenu() {
        return this._canAddToNewMenu;
    }

    void setIcon(Icon icon) {
        this._icon = icon;
    }

    void setIconMetaResource(MetaResource iconResource) {
        this._iconResource = iconResource;
    }

    public Icon getIcon() {
        if (this._icon == null) {
            Icon icon = null;
            if (this._iconResource != null) {
                icon = this.lookupIconFromMetaResource();
                Assert.println((icon == null ? 1 : 0) != 0, (String)("Cannot load icon: " + this._iconResource.getResourcePath()));
            } else if (this._iconFile != null) {
                icon = this.lookupIconFromFileSystem();
                if (icon == null) {
                    icon = this.lookupIconFromClassLoader();
                }
                Assert.println((icon == null ? 1 : 0) != 0, (String)("Cannot load icon: " + this._iconFile));
            } else {
                icon = OracleIcons.getIcon((String)"Empty.gif");
                Assert.println((String)("Missing icon for gallery item " + this.getName()));
            }
            this._icon = icon != null ? icon : OracleIcons.getIcon((String)"warning.png");
        }
        return this._icon;
    }

    private Icon lookupIconFromFileSystem() {
        if (this._iconFile != null) {
            ImageIcon icon;
            String iconFile = this._iconFile;
            URL url = null;
            try {
                URI uri;
                if (iconFile.charAt(0) == '/') {
                    String platformPath = iconFile.replace('/', File.separatorChar);
                    uri = URIFactory.newURI((String)platformPath);
                } else {
                    uri = URIFactory.newURI((String)iconFile);
                }
                if (uri != null) {
                    url = VirtualFileSystem.getVirtualFileSystem().toURL(uri);
                }
            }
            catch (MalformedURLException e) {
                FeedbackManager.reportException((String)"Unexpected MalformedURLException", (Throwable)e);
            }
            if (url != null && ((icon = new ImageIcon(url)).getImageLoadStatus() & 8) != 0) {
                return icon;
            }
        }
        return null;
    }

    private Icon lookupIconFromClassLoader() {
        ImageIcon icon;
        URL url;
        if (this._iconFile != null && (url = this.getInvokableClassLoader().getResource(this._iconFile)) != null && ((icon = new ImageIcon(url)).getImageLoadStatus() & 8) != 0) {
            return icon;
        }
        return null;
    }

    private Icon lookupIconFromMetaResource() {
        URL iconURL;
        ImageIcon icon = null;
        if (this._iconResource != null && (iconURL = this._iconResource.toURL()) != null) {
            icon = new ImageIcon(iconURL);
        }
        return icon;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof GalleryElement)) {
            return false;
        }
        GalleryElement other = (GalleryElement)object;
        if (!(this.getShortLabel() != null ? this.getShortLabel().equals(other.getShortLabel()) : other.getShortLabel() == null)) {
            return false;
        }
        if (!(this._description != null ? this._description.equals(other._description) : other._description == null)) {
            return false;
        }
        return Arrays.equals(this._technologyKeys, other._technologyKeys);
    }

    public int hashCode() {
        int PRIME = 37;
        int result = 1;
        result = 37 * result + (this.getShortLabel() == null ? 0 : this.getShortLabel().hashCode());
        result = 37 * result + (this._description == null ? 0 : this._description.hashCode());
        result = 37 * result + Arrays.hashCode(this._technologyKeys);
        return result;
    }

    public String toString() {
        return this.getShortLabel();
    }

    public int compareTo(Object o) {
        if (o instanceof GalleryFolder) {
            return 1;
        }
        if (o instanceof GalleryElement) {
            GalleryElement e = (GalleryElement)o;
            if (this.isUnsorted() != e.isUnsorted()) {
                return this.isUnsorted() ? -1 : 1;
            }
            if (this.isUnsorted() && e.isUnsorted()) {
                return 0;
            }
            return COLLATOR.compare(this.getShortLabel(), e.getShortLabel());
        }
        return COLLATOR.compare(this.getShortLabel(), o.toString());
    }

    @Deprecated
    protected String getWizardDescription() {
        return this.getLongLabel();
    }

    protected String getWizardName() {
        return this._name != null ? this._name : "[name undefined]";
    }

    public boolean isAvailable(Context context) {
        boolean ruleSuccess = this._ruleId == null || RuleEngine.getInstance().evaluateRule(this._ruleId, context);
        return ruleSuccess && this.checkIsInvokable(context);
    }

    private boolean checkIsInvokable(Context context) {
        Extension x;
        ExtensionRegistry extReg = ExtensionRegistry.getExtensionRegistry();
        if (extReg.isFullyLoaded(x = extReg.findExtensionByClassLoader(this.getInvokableClassLoader())) && this.getInvokable() instanceof TriggerInvokable) {
            Wizard.setWizardId((Context)context, (String)this.getId());
            return ((TriggerInvokable)this.getInvokable()).canInvoke(context);
        }
        return true;
    }

    protected Icon getDisabledIcon() {
        if (this._disabledIcon == null) {
            Icon icon = this.getIcon();
            this._disabledIcon = icon instanceof ImageIcon ? new WashedIcon(icon, 0.35f) : icon;
        }
        return this._disabledIcon;
    }

    private static class LabelOnlyComparator
    implements Comparator<GalleryElement> {
        private LabelOnlyComparator() {
        }

        @Override
        public int compare(GalleryElement o1, GalleryElement o2) {
            int compare = COLLATOR.compare(o1.getShortLabel(), o2.getShortLabel());
            return compare;
        }
    }
}

