/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.compiler;

import javax.swing.SwingUtilities;
import oracle.ide.Addin;
import oracle.ide.Ide;
import oracle.ide.ceditor.saveactions.SaveActionsOptions;
import oracle.ide.config.Preferences;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.IdeAction;
import oracle.ide.editor.EditorListener;
import oracle.ide.editor.EditorManager;
import oracle.ide.log.LogManager;
import oracle.javatools.data.PropertyStorage;
import oracle.jdevimpl.build.BuildAfterSave;
import oracle.jdevimpl.compiler.JCompilerContextMenuListener;
import oracle.jdevimpl.compiler.JCompilerMenuItems;

public class JCompilerUtils
implements Addin {
    public void initialize() {
        JCompilerMenuItems.getInstance();
        BuildAfterSave buildAfterSave = BuildAfterSave.getInstance();
        EditorManager.getEditorManager().addEditorListener((EditorListener)buildAfterSave);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                IdeAction action;
                ContextMenu menu = LogManager.getLogManager().getContextMenu();
                if (menu != null) {
                    menu.addContextMenuListener((ContextMenuListener)new JCompilerContextMenuListener());
                }
                if ((action = IdeAction.find((String)"CANCEL_BUILD")) != null) {
                    action.setEnabled(false);
                }
            }
        });
    }

    public static void invokeAsap(Runnable runnable) {
        if (!Ide.getIdeArgs().getCreateUI() || SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public static boolean isBuildAfterSave() {
        SaveActionsOptions saveOptions = SaveActionsOptions.getInstance((PropertyStorage)Preferences.getPreferences());
        return saveOptions.isExecutableSaveAction("BUILD_PROJECT_AFTER_SAVE") || saveOptions.isExecutableSaveAction("BUILD_PROJECT_AND_DEPENDENTS_AFTER_SAVE");
    }

    public static boolean isBuildProjectAfterSave() {
        SaveActionsOptions saveOptions = SaveActionsOptions.getInstance((PropertyStorage)Preferences.getPreferences());
        return saveOptions.isExecutableSaveAction("BUILD_PROJECT_AFTER_SAVE");
    }

    public static boolean isBuildProjectAndDependentsAfterSave() {
        SaveActionsOptions saveOptions = SaveActionsOptions.getInstance((PropertyStorage)Preferences.getPreferences());
        return saveOptions.isExecutableSaveAction("BUILD_PROJECT_AND_DEPENDENTS_AFTER_SAVE");
    }
}

