/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.compiler;

import java.awt.Component;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeArgs;
import oracle.ide.cmd.ExitCommand;
import oracle.ide.cmd.ShutdownHook;
import oracle.ide.compiler.BuildLog;
import oracle.ide.compiler.BuildSystemListener;
import oracle.ide.compiler.BuildSystemListener2;
import oracle.ide.compiler.BuildSystemVetoException;
import oracle.ide.compiler.CleanArguments;
import oracle.ide.compiler.CompileArguments;
import oracle.ide.compiler.Compiler;
import oracle.ide.compiler.CopyListener;
import oracle.ide.compiler.Diagnostic;
import oracle.ide.compiler.PostBuilder;
import oracle.ide.exception.SingletonClassException;
import oracle.ide.log.LogManager;
import oracle.ide.log.LogPage;
import oracle.ide.model.Attributes;
import oracle.ide.model.Element;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Node;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeListener;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectChangeEvent;
import oracle.ide.model.ProjectChangeListener;
import oracle.ide.model.Workspace;
import oracle.ide.osgi.boot.api.IdeBootProperties;
import oracle.ide.panels.Navigable;
import oracle.ide.performance.PerformanceLogger;
import oracle.ide.util.Assert;
import oracle.ideimpl.compiler.BuildSystemHook;
import oracle.ideimpl.compiler.BuildToolDefinition;
import oracle.javatools.data.ChangeInfo;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.util.PlatformUtils;
import oracle.jdeveloper.compiler.BuildSystemConfiguration;
import oracle.jdeveloper.compiler.CompArb;
import oracle.jdeveloper.compiler.IdeLog;
import oracle.jdeveloper.compiler.IdeStorage;
import oracle.jdeveloper.compiler.OjcConfiguration;
import oracle.jdeveloper.compiler.OutputStreamLogPage;
import oracle.jdeveloper.compiler.ProblemsPage;
import oracle.jdeveloper.compiler.Translator;
import oracle.jdeveloper.compiler.UnifiedBuildSystem;
import oracle.jdeveloper.model.PathsConfiguration;
import oracle.jdevimpl.compiler.JCompilerMenuItems;
import oracle.jdevimpl.compiler.JCompilerUtils;
import oracle.jdevimpl.compiler.MarkerLog;
import oracle.jdevimpl.config.JProjectPaths;
import oracle.ojc.interfaces.Storage;
import org.netbeans.api.progress.ProgressHandle;
import org.openide.util.Cancellable;

public final class JCompiler
extends Compiler
implements ShutdownHook {
    public static final String DISABLE_FILE_NOT_IN_PROJECT_WARNING = "disableFileNotInProjectWarning";
    static final String OLD_DO_NOT_COMPILE_DEPENDENT_PROJECTS = "buildsystem.dont.compile.dependent.projects";
    static final String DO_NOT_COMPILE_DEPENDENCIES = "buildsystem.dont.compile.dependencies";
    public static final int MAKE_SELECTED_CMD_ID = Ide.findOrCreateCmdID((String)"MAKE_SELECTED");
    public static final int BUILD_SELECTED_CMD_ID = Ide.findOrCreateCmdID((String)"REBUILD_SELECTED");
    public static final int MAKE_WORKINGSET_CMD_ID = Ide.findOrCreateCmdID((String)"MAKE_WORKINGSET");
    public static final int BUILD_WORKINGSET_CMD_ID = Ide.findOrCreateCmdID((String)"REBUILD_WORKINGSET");
    public static final int MAKE_PROJECT_CMD_ID = Ide.findOrCreateCmdID((String)"MAKE_PROJECT_ONLY");
    public static final int MAKE_PROJECT_AND_DEPENDENCIES_CMD_ID = Ide.findOrCreateCmdID((String)"MAKE_PROJECT_AND_DEPENDENCIES");
    public static final int BUILD_PROJECT_CMD_ID = Ide.findOrCreateCmdID((String)"REBUILD_PROJECT_ONLY");
    public static final int BUILD_PROJECT_AND_DEPENDENCIES_CMD_ID = Ide.findOrCreateCmdID((String)"REBUILD_PROJECT_AND_DEPENDENCIES");
    public static final int MAKE_WORKSPACE_CMD_ID = Ide.findOrCreateCmdID((String)"MAKE_APPLICATION");
    public static final int BUILD_WORKSPACE_CMD_ID = Ide.findOrCreateCmdID((String)"REBUILD_APPLICATION");
    public static final int CLEAN_PROJECT_CMD_ID = Ide.findOrCreateCmdID((String)"CLEAN_PROJECT");
    public static final int CLEAN_WORKSPACE_CMD_ID = Ide.findOrCreateCmdID((String)"CLEAN_APPLICATION");
    public static final int CLEAN_AND_REFRESH_WORKSPACE_CMD_ID = Ide.findOrCreateCmdID((String)"CLEAN_AND_REFRESH_APPLICATION");
    private static final String msgStart = CompArb.getString(43);
    private static final String cleanCompleted = CompArb.getString(36);
    private static final String cleanAndRefreshCompleted = CompArb.getString(149);
    private static final String cleanCancelled = CompArb.getString(37);
    private static final String cleanAndRefreshCancelled = CompArb.getString(150);
    private static final String msgSuccess = CompArb.getString(44);
    private static final String msgNothingToBuild = CompArb.getString(45);
    private static JCompiler instance;
    private LogPage outputLog;
    private LogPage errorLog;
    private LogPage userDefinedOutputLog;
    private LogPage userDefinedErrorLog;
    private LogPage ideOutputLog;
    private LogPage ideErrorLog;
    private MarkerLog markerLog;
    private HashMap<Project, Boolean> cachedProjects = new HashMap();
    private NodeListener cachedProjectsNL = new NodeListener(){

        public void nodeClosed(NodeEvent ee) {
            JCompiler.this.removeProjectFromCache((Project)ee.getNode());
        }
    };
    private boolean disableProjectUpdates = false;
    private boolean busy = false;
    private Object busyLock = new Object();
    private Context busyContext;
    private Map<Thread, Boolean> waitingThreadStates = new HashMap<Thread, Boolean>();
    private List<BuildSystemListener> buildSystemListeners = new ArrayList<BuildSystemListener>();
    private List<BuildToolDefinition<CopyListener>> copyListeners = new ArrayList<BuildToolDefinition<CopyListener>>();
    private final ProjectChangeListener projectChangeListener = new ProjectChangeListener(){

        public void projectPropertiesChanged(ProjectChangeEvent e) {
            JCompiler.this.projectPropertiesChangedImpl(e);
        }
    };
    private List<QueuedBuildSystemListener> queuedBuildSystemListeners = new ArrayList<QueuedBuildSystemListener>();
    private int makeFolderCmdId;
    private int cleanSelectedCmdId;
    private int cancelBuildCmdId;

    public static JCompiler getInstance() {
        return (JCompiler)Compiler.getCompiler();
    }

    private JCompiler() throws SingletonClassException {
        if (instance != null) {
            throw new SingletonClassException("oracle.jdeveloper.compiler.JCompiler");
        }
        instance = this;
        Compiler.setCompiler((Compiler)this);
        Project.addProjectChangeListener((String)OjcConfiguration.DATA_KEY, (ProjectChangeListener)this.projectChangeListener);
        Project.addProjectChangeListener((String)"oracle.jdevimpl.config.JProjectLibraries", (ProjectChangeListener)this.projectChangeListener);
        Project.addProjectChangeListener((String)JProjectPaths.DATA_KEY, (ProjectChangeListener)this.projectChangeListener);
        Project.addProjectChangeListener((String)PathsConfiguration.DATA_KEY, (ProjectChangeListener)this.projectChangeListener);
        ExitCommand.addShutdownHook((ShutdownHook)this);
    }

    private void projectPropertiesChangedImpl(ProjectChangeEvent e) {
        ChangeInfo[] changes = e.getChangeDetails();
        if (changes != null) {
            for (int i = 0; i < changes.length; ++i) {
                if (changes[i].getChangeType() != 0 && changes[i].getChangeType() != 1) continue;
                Project prj = e.getProject();
                if (prj == null || this.disableProjectUpdates) break;
                if (prj.isDirty()) {
                    if (this.cachedProjects.isEmpty()) {
                        Project.addNodeListenerForType(Project.class, (NodeListener)this.cachedProjectsNL);
                    }
                    this.cachedProjects.put(prj, Boolean.TRUE);
                    break;
                }
                this.removeProjectFromCache(prj);
                break;
            }
        }
    }

    private void removeProjectFromCache(Project prj) {
        this.cachedProjects.remove(prj);
        if (this.cachedProjects.isEmpty()) {
            Project.removeNodeListenerForType(Project.class, (NodeListener)this.cachedProjectsNL);
        }
    }

    public boolean forceRebuildOnProject(Project prj) {
        if (this.cachedProjects.get(prj) == null) {
            return false;
        }
        this.removeProjectFromCache(prj);
        return true;
    }

    public void shutdown() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canShutdown() {
        boolean result = this.canShutdownImpl();
        if (result) {
            Object object = this.busyLock;
            synchronized (object) {
                Set<Map.Entry<Thread, Boolean>> states = this.waitingThreadStates.entrySet();
                for (Map.Entry<Thread, Boolean> state : states) {
                    state.setValue(false);
                    state.getKey().interrupt();
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean canShutdownImpl() {
        Object object = this.busyLock;
        synchronized (object) {
            if (!this.isBusy(this.busyContext)) {
                return true;
            }
            if (this.busyContext != null && this.busyContext.containsProperty("BuildQueueBuilderContext")) {
                UnifiedBuildSystem.getInstance().stopBuildSystem();
                return true;
            }
        }
        int answer = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), CompArb.getString(81), CompArb.getString(80), 0, 3);
        if (answer == 0) {
            UnifiedBuildSystem.getInstance().stopBuildSystem();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBusy(Context context) {
        Object object = this.busyLock;
        synchronized (object) {
            return this.busy || UnifiedBuildSystem.getInstance().isAlive() || UnifiedBuildSystem.getInstance().isLocked(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setBusy(Context context) {
        Object object = this.busyLock;
        synchronized (object) {
            if (this.isBusy(context)) {
                return false;
            }
            this.busy = true;
            this.busyContext = context;
            this.queuedBuildSystemListeners.clear();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitAndSetBusy(Context context) {
        Object object = this.busyLock;
        synchronized (object) {
            Thread thread = Thread.currentThread();
            this.waitingThreadStates.put(thread, true);
            while (this.isBusy(context)) {
                Boolean state;
                try {
                    this.busyLock.wait(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if ((state = this.waitingThreadStates.get(thread)).booleanValue()) continue;
                this.waitingThreadStates.remove(thread);
                return false;
            }
            this.waitingThreadStates.remove(thread);
            return this.setBusy(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setNotBusy() {
        for (QueuedBuildSystemListener listener : this.queuedBuildSystemListeners) {
            listener.finishBuildSystemListener();
        }
        UnifiedBuildSystem ubs = UnifiedBuildSystem.getInstance();
        boolean hasErrors = ubs.getLastErrorCount() != 0;
        this.logOutEndBuild(ubs.getLastFilesBuilt(), ubs.getLastBuildStatus(), ubs.getLastBuildTime());
        Object object = this.busyLock;
        synchronized (object) {
            this.queuedBuildSystemListeners.clear();
            ubs.cleanAfterBuild(this.busyContext);
            this.busy = false;
            this.busyContext = null;
            this.busyLock.notify();
        }
        if (Ide.getIdeArgs().getCreateUI()) {
            JCompilerMenuItems.getInstance().enableCancelBuild(false);
        }
        return hasErrors;
    }

    @Deprecated
    public void stopBuild(Context context) {
        UnifiedBuildSystem.getInstance().stopBuildSystem();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean compile(final CompileArguments compileArguments) {
        if (compileArguments == null) {
            throw new IllegalArgumentException("Need a valid context for compilations");
        }
        if (!this.setBusy(compileArguments.getContext())) {
            boolean isBusy = false;
            if (compileArguments.isThrowOnConcurrentCleanOrCompile()) {
                throw new IllegalStateException(CompArb.getString(165));
            }
            if (compileArguments.isWaitOnConcurrentCleanOrCompile()) {
                isBusy = this.waitAndSetBusy(compileArguments.getContext());
            }
            if (!isBusy) {
                return this.reportNoConcurrentCleanOrBuild(compileArguments.getOutputStream(), compileArguments.getDiagnosticsStream(), CompArb.getString(164), CompArb.getString(165));
            }
        }
        boolean releaseResources = true;
        boolean executePostBuilder = true;
        final UnifiedBuildSystem ubs = UnifiedBuildSystem.getInstance();
        boolean hasErrors = false;
        final BuildLogImpl buildLog = new BuildLogImpl();
        try {
            if (this.outputLog != this.ideOutputLog) {
                this.outputLog = null;
            }
            if (this.errorLog != this.ideErrorLog) {
                this.errorLog = null;
            }
            this.userDefinedOutputLog = compileArguments.getOutputStream() != null ? new OutputStreamLogPage(compileArguments.getOutputStream()) : null;
            this.userDefinedErrorLog = compileArguments.getDiagnosticsStream() != null ? new OutputStreamLogPage(compileArguments.getDiagnosticsStream()) : null;
            this.getErrorLog();
            if (compileArguments.isWaitForTermination() && SwingUtilities.isEventDispatchThread()) {
                hasErrors = !ubs.buildOnUIThread(compileArguments, buildLog);
            } else {
                boolean bl = hasErrors = !ubs.initializeBuild(compileArguments, buildLog);
            }
            if (!compileArguments.isWaitForTermination() && !hasErrors) {
                releaseResources = false;
                executePostBuilder = false;
                Thread thread = new Thread(){
                    private boolean hasErrors;

                    @Override
                    public void run() {
                        try {
                            ubs.join(0L);
                            this.hasErrors = ubs.getLastErrorCount() != 0;
                        }
                        catch (InterruptedException iex) {
                            this.hasErrors = true;
                        }
                        finally {
                            JCompiler.this.userDefinedOutputLog = null;
                            JCompiler.this.userDefinedErrorLog = null;
                            this.hasErrors |= JCompiler.this.setNotBusy();
                            buildLog.allowLogging = false;
                        }
                        if (compileArguments.getPostBuilder() != null) {
                            compileArguments.getPostBuilder().postBuild(!this.hasErrors);
                        }
                    }
                };
                thread.start();
            } else if (compileArguments.isWaitForTermination() && !hasErrors) {
                ubs.join(0L);
                hasErrors = ubs.getLastErrorCount() != 0;
            }
        }
        catch (InterruptedException t) {
            hasErrors = true;
        }
        finally {
            if (releaseResources) {
                this.userDefinedOutputLog = null;
                this.userDefinedErrorLog = null;
                hasErrors |= this.setNotBusy();
                buildLog.allowLogging = false;
            }
        }
        if (executePostBuilder && compileArguments.getPostBuilder() != null) {
            compileArguments.getPostBuilder().postBuild(!hasErrors);
        }
        return !hasErrors;
    }

    private boolean reportNoConcurrentCleanOrBuild(OutputStream stdoutStream, OutputStream stderrStream, String outFailure, String errFailure) {
        if (stdoutStream != null) {
            try {
                stdoutStream.write(10);
                stdoutStream.write(outFailure.getBytes());
                stdoutStream.write(10);
                stdoutStream.write(10);
            }
            catch (IOException iOException) {}
        } else if (IdeBootProperties.isHeadlessMode()) {
            System.out.println();
            System.out.println(outFailure);
            System.out.println();
        }
        if (stderrStream != null) {
            try {
                stderrStream.write(10);
                stderrStream.write(errFailure.getBytes());
                stderrStream.write(10);
                stderrStream.write(10);
            }
            catch (IOException iOException) {}
        } else if (IdeBootProperties.isHeadlessMode()) {
            System.err.println();
            System.err.println(outFailure);
            System.err.println();
        }
        if (!(IdeBootProperties.isHeadlessMode() || stdoutStream != null && stderrStream != null)) {
            LogPage logPage = LogManager.getLogManager().getMsgPage();
            logPage.log((Object)("\n" + errFailure + "\n" + outFailure + "\n\n"));
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelCompileOrClean(Context context) {
        Object object = this.busyLock;
        synchronized (object) {
            if (context == this.busyContext) {
                UnifiedBuildSystem.getInstance().stopBuildSystem();
            }
        }
    }

    @Deprecated
    public boolean compile(Context context, boolean rebuild, boolean wait) {
        CompileArguments compileArguments = new CompileArguments(context);
        compileArguments.setRebuildAllSources(rebuild);
        compileArguments.setSaveBeforeCompiling(false);
        compileArguments.setWaitForTermination(wait);
        return this.compile(compileArguments);
    }

    @Deprecated
    public boolean compile(Context context, boolean rebuild, boolean wait, boolean save) {
        CompileArguments compileArguments = new CompileArguments(context);
        compileArguments.setRebuildAllSources(rebuild);
        compileArguments.setSaveBeforeCompiling(save);
        compileArguments.setWaitForTermination(wait);
        return this.compile(compileArguments);
    }

    @Deprecated
    public void compile(Context context, boolean rebuild, PostBuilder postBuild, boolean save) {
        CompileArguments compileArguments = new CompileArguments(context);
        compileArguments.setRebuildAllSources(rebuild);
        compileArguments.setSaveBeforeCompiling(save);
        compileArguments.setWaitForTermination(false);
        compileArguments.setPostBuilder(postBuild);
        this.compile(compileArguments);
    }

    @Deprecated
    public boolean compile(Context context, boolean rebuild, boolean wait, OutputStream outStream, OutputStream errStream) {
        CompileArguments compileArguments = new CompileArguments(context);
        compileArguments.setRebuildAllSources(rebuild);
        compileArguments.setSaveBeforeCompiling(false);
        compileArguments.setWaitForTermination(wait);
        compileArguments.setOutputStream(outStream);
        compileArguments.setDiagnosticsStream(errStream);
        return this.compile(compileArguments);
    }

    @Deprecated
    public boolean clean(Context context, boolean throwOnFailedDelete, OutputStream outStream, OutputStream errStream) throws IOException {
        CleanArguments arguments = new CleanArguments(context);
        arguments.setDiagnosticsStream(errStream);
        arguments.setOutputStream(outStream);
        arguments.setThrowOnFailedDelete(throwOnFailedDelete);
        return this.clean(arguments);
    }

    public void cleanAll(Context context) {
        this.cleanAll(context, false);
    }

    public void cleanAll(Context context, boolean refreshApplication) {
        try {
            CleanArguments arguments = new CleanArguments(context);
            arguments.setAutoClean(false);
            arguments.setStopOnFailedDelete(true);
            arguments.setWaitForTermination(false);
            arguments.setRefreshApplication(refreshApplication);
            this.clean(arguments);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Deprecated
    public boolean clean(Context context, boolean autoClean, boolean stopOnFailedDelete, boolean throwOnFailedDelete, OutputStream outStream, OutputStream errStream, boolean wait, boolean refreshApplication) throws IOException {
        CleanArguments arguments = new CleanArguments(context);
        arguments.setAutoClean(autoClean);
        arguments.setStopOnFailedDelete(stopOnFailedDelete);
        arguments.setThrowOnFailedDelete(throwOnFailedDelete);
        arguments.setOutputStream(outStream);
        arguments.setDiagnosticsStream(errStream);
        arguments.setWaitForTermination(wait);
        arguments.setRefreshApplication(refreshApplication);
        return this.clean(arguments);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean clean(CleanArguments cleanArguments) throws IOException {
        if (!this.setBusy(cleanArguments.getContext())) {
            boolean isBusy = false;
            if (cleanArguments.isThrowOnConcurrentCleanOrCompile()) {
                throw new IllegalStateException(CompArb.getString(165));
            }
            if (cleanArguments.isWaitOnConcurrentCleanOrCompile()) {
                isBusy = this.waitAndSetBusy(cleanArguments.getContext());
            }
            if (!isBusy) {
                return this.reportNoConcurrentCleanOrBuild(cleanArguments.getOutputStream(), cleanArguments.getDiagnosticsStream(), CompArb.getString(166), CompArb.getString(165));
            }
        }
        boolean releaseResources = true;
        final BuildLogImpl buildLog = new BuildLogImpl();
        try {
            if (this.outputLog != this.ideOutputLog) {
                this.outputLog = null;
            }
            if (this.errorLog != this.ideErrorLog) {
                this.errorLog = null;
            }
            this.userDefinedOutputLog = cleanArguments.getOutputStream() != null ? new OutputStreamLogPage(cleanArguments.getOutputStream()) : null;
            this.userDefinedErrorLog = cleanArguments.getDiagnosticsStream() != null ? new OutputStreamLogPage(cleanArguments.getDiagnosticsStream()) : null;
            final UnifiedBuildSystem ubs = UnifiedBuildSystem.getInstance();
            if (!ubs.initCleanAll(cleanArguments.getContext(), cleanArguments.isAutoClean(), cleanArguments.isStopOnFailedDelete() || cleanArguments.isThrowOnFailedDelete(), buildLog, cleanArguments.isRefreshApplication())) {
                boolean bl = false;
                return bl;
            }
            if (cleanArguments.isWaitForTermination()) {
                IOException failedDeleteException22;
                ubs.join(0L);
                if (cleanArguments.isThrowOnFailedDelete() && (failedDeleteException22 = ubs.getFailedDeleteException()) != null) {
                    throw failedDeleteException22;
                }
                boolean failedDeleteException22 = ubs.getLastErrorCount() == 0;
                return failedDeleteException22;
            }
            releaseResources = false;
            Thread thread = new Thread(){

                @Override
                public void run() {
                    try {
                        ubs.join(0L);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    finally {
                        JCompiler.this.userDefinedOutputLog = null;
                        JCompiler.this.userDefinedErrorLog = null;
                        JCompiler.this.setNotBusy();
                        buildLog.allowLogging = false;
                    }
                }
            };
            thread.start();
            boolean bl = true;
            return bl;
        }
        catch (InterruptedException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (releaseResources) {
                this.userDefinedOutputLog = null;
                this.userDefinedErrorLog = null;
                this.setNotBusy();
                buildLog.allowLogging = false;
            }
        }
    }

    public boolean internalJavaCompile(Context context, final ArrayList<String> messages) throws Exception {
        if (context == null || messages == null) {
            throw new IllegalArgumentException("null argument");
        }
        final boolean[] areThereErrors = new boolean[]{false};
        if (!this.setBusy(context)) {
            throw new IllegalStateException();
        }
        boolean savedValue = UnifiedBuildSystem.showCompileProgress;
        try {
            Translator javaTranslator;
            Project prj;
            UnifiedBuildSystem.showCompileProgress = false;
            Element[] files = context.getSelection();
            ArrayList<Storage> sources = new ArrayList<Storage>();
            for (Element file : files) {
                if (!file.getLongLabel().endsWith(".java")) {
                    throw new IllegalArgumentException();
                }
                sources.add(new IdeStorage((Node)file));
            }
            Workspace ws = context.getWorkspace();
            if (ws == null) {
                ws = Ide.getActiveWorkspace();
            }
            if ((prj = context.getProject()) == null) {
                prj = Ide.getActiveProject();
            }
            if ((javaTranslator = UnifiedBuildSystem.getInstance().getJavaTranslator(ws, prj)) == null) {
                throw new ClassNotFoundException();
            }
            Translator.Log log = new Translator.Log(){
                private int errCnt = 0;
                private int warningCnt = 0;

                @Override
                public void error(Storage source, int line, int col, int errNumber, String errMsg) {
                    areThereErrors[0] = true;
                    messages.add(source.getPath() + '(' + line + ',' + col + "):" + errNumber + ':' + errMsg);
                    ++this.errCnt;
                }

                @Override
                public void warning(Storage source, int line, int col, int errNumber, String errMsg) {
                    messages.add(source.getPath() + '(' + line + ',' + col + "):" + errNumber + ':' + errMsg);
                    ++this.warningCnt;
                }

                @Override
                public void clear(Storage source) {
                }

                @Override
                public int nerrors() {
                    return this.errCnt;
                }

                @Override
                public int nwarnings() {
                    return this.warningCnt;
                }
            };
            javaTranslator.setLog(log);
            javaTranslator.translate(prj, true, sources, new ArrayList<Storage>());
        }
        catch (IllegalStateException e) {
            throw e;
        }
        catch (ClassNotFoundException e) {
            throw e;
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        finally {
            UnifiedBuildSystem.showCompileProgress = savedValue;
            areThereErrors[0] = areThereErrors[0] | this.setNotBusy();
        }
        return !areThereErrors[0];
    }

    public int compileInThread(Thread thread, Project prj, ArrayList<Storage> files, boolean rebuild) {
        UnifiedBuildSystem ubs = UnifiedBuildSystem.getInstance();
        return ubs.compileInThread(thread, prj, files, rebuild);
    }

    private static BuildSystemConfiguration getBuildSysConfig(Project prj) {
        return BuildSystemConfiguration.getInstance((PropertyStorage)prj);
    }

    static boolean getReverseCopyRes(Project prj) {
        BuildSystemConfiguration bsc = JCompiler.getBuildSysConfig(prj);
        if (bsc != null) {
            return bsc.getReverseCopyRes();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<BuildToolDefinition<CopyListener>> getNewCopyListeners(Workspace workspace, Project project) {
        List<BuildToolDefinition<CopyListener>> list = this.copyListeners;
        synchronized (list) {
            if (BuildSystemHook.getCopyListenerCount() == this.copyListeners.size()) {
                return Collections.emptyList();
            }
            Collection newListeners = BuildSystemHook.getNewCopyListeners((Workspace)workspace, (Project)project);
            for (BuildToolDefinition listener : newListeners) {
                this.copyListeners.add((BuildToolDefinition<CopyListener>)listener);
            }
            return newListeners;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<BuildToolDefinition<CopyListener>> getCopyListeners() {
        List<BuildToolDefinition<CopyListener>> list = this.copyListeners;
        synchronized (list) {
            return new ArrayList<BuildToolDefinition<CopyListener>>(this.copyListeners);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeCopyListener(CopyListener cl) {
        boolean removed = super.removeCopyListener(cl);
        List<BuildToolDefinition<CopyListener>> list = this.copyListeners;
        synchronized (list) {
            for (BuildToolDefinition<CopyListener> listenerDef : this.copyListeners) {
                if (listenerDef.retrieveBuildTool() != cl) continue;
                this.copyListeners.remove(listenerDef);
                return true;
            }
        }
        return removed;
    }

    static String[] getCopyRes(Project prj) {
        String[] result = null;
        BuildSystemConfiguration bsc = JCompiler.getBuildSysConfig(prj);
        if (bsc != null) {
            result = bsc.getCopyRes();
        }
        return result;
    }

    static boolean isCopyable(Project project, String name, String[] copyResSpec, boolean reverseCopy) {
        int dotIndex;
        if (name != null && copyResSpec != null) {
            if (!PlatformUtils.isCaseSensitiveFileSystem()) {
                name = name.toLowerCase();
                for (String copyRes : copyResSpec) {
                    if (!name.endsWith(copyRes.toLowerCase())) continue;
                    return !reverseCopy;
                }
            } else {
                for (String copyRes : copyResSpec) {
                    if (!name.endsWith(copyRes)) continue;
                    return !reverseCopy;
                }
            }
        }
        if (name != null && (dotIndex = name.lastIndexOf(46)) < 0) {
            if (project != null) {
                BuildSystemConfiguration buildSysConfig = BuildSystemConfiguration.getInstance((PropertyStorage)project);
                return buildSysConfig.getCopyFilesNoExtension();
            }
            return false;
        }
        return reverseCopy;
    }

    static boolean isCopyable(Project project, Element element, String[] copyResSpec, boolean reverseCopy) {
        if (element != null) {
            URL url;
            String name = element instanceof Node ? ((url = ((Node)element).getURL()) != null ? url.getPath() : element.getShortLabel()) : element.getShortLabel();
            return JCompiler.isCopyable(project, name, copyResSpec, reverseCopy);
        }
        return false;
    }

    public static boolean isCopyable(Element element, Project prj) {
        return JCompiler.isCopyable(prj, element, JCompiler.getCopyRes(prj), JCompiler.getReverseCopyRes(prj));
    }

    public static boolean isBuildable(Element element) {
        if (element == null) {
            return false;
        }
        Attributes attrs = element.getAttributes();
        if (attrs == null) {
            return false;
        }
        return attrs.isSet(ElementAttributes.BUILDABLE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<BuildSystemListener> getNewBuildSystemListeners(Workspace workspace, Project project, BuildLog buildLog) {
        List<BuildSystemListener> list = this.buildSystemListeners;
        synchronized (list) {
            if (BuildSystemHook.getBuildSystemListenerCount() != this.buildSystemListeners.size()) {
                Collection newListeners = BuildSystemHook.getNewBuildSystemListeners((Workspace)workspace, (Project)project);
                for (BuildSystemListener listener : newListeners) {
                    this.buildSystemListeners.add(listener);
                    if (buildLog == null || !(listener instanceof BuildSystemListener2)) continue;
                    ((BuildSystemListener2)listener).setBuildLog(buildLog);
                }
                return newListeners;
            }
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<BuildSystemListener> getBuildSystemListeners() {
        List<BuildSystemListener> list = this.buildSystemListeners;
        synchronized (list) {
            return new ArrayList<BuildSystemListener>(this.buildSystemListeners);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeBuildSystemListener(BuildSystemListener bsl) {
        boolean removed = super.removeBuildSystemListener(bsl);
        List<BuildSystemListener> list = this.buildSystemListeners;
        synchronized (list) {
            this.buildSystemListeners.remove(bsl);
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean lock(Context context) {
        Object object = this.busyLock;
        synchronized (object) {
            if (!this.isBusy(context)) {
                return UnifiedBuildSystem.getInstance().lock(context);
            }
        }
        return false;
    }

    public boolean lock(Context context, boolean wait) {
        return this.lock(context, wait ? 0L : -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean lock(Context context, long waitTimeMsec) {
        if (this.lock(context)) {
            return true;
        }
        if (waitTimeMsec >= 0L) {
            final boolean[] canceled = new boolean[]{false};
            ProgressHandle ph = null;
            try {
                boolean showProgress;
                long currentWaitTime = 50L;
                boolean waitForever = waitTimeMsec == 0L;
                boolean bl = showProgress = !IdeBootProperties.isHeadlessMode();
                while (!canceled[0]) {
                    if (UnifiedBuildSystem.getInstance().isAlive()) {
                        UnifiedBuildSystem.getInstance().join(currentWaitTime);
                    } else {
                        Thread.sleep(currentWaitTime);
                    }
                    if (this.lock(context)) {
                        boolean bl2 = true;
                        return bl2;
                    }
                    if (!waitForever) {
                        if (waitTimeMsec <= 0L) {
                            break;
                        }
                        waitTimeMsec -= currentWaitTime;
                    }
                    if (!showProgress || ph != null) continue;
                    Cancellable cancellable = new Cancellable(){

                        public boolean cancel() {
                            canceled[0] = true;
                            return true;
                        }
                    };
                    String s = CompArb.getString(128);
                    ph = ProgressHandle.createHandle((String)s, (Cancellable)cancellable);
                    ph.start();
                }
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                if (ph != null) {
                    ph.finish();
                }
            }
        }
        return false;
    }

    public boolean unlock(Context context) {
        return UnifiedBuildSystem.getInstance().unlock();
    }

    public LogPage getOutputLog() {
        if (this.userDefinedOutputLog != null) {
            return this.userDefinedOutputLog;
        }
        if (this.outputLog == null) {
            IdeArgs args = Ide.getIdeArgs();
            if (!args.getCreateUI() || args.hasArg("-make") || args.hasArg("-rebuild")) {
                this.outputLog = new OutputStreamLogPage(System.out);
            } else {
                this.ideOutputLog = this.outputLog = LogManager.getLogManager().getMsgPage();
            }
        }
        return this.outputLog;
    }

    public void logOutMsg(final String msg) {
        try {
            JCompilerUtils.invokeAsap(new Runnable(){

                @Override
                public void run() {
                    LogPage log = JCompiler.this.getOutputLog();
                    if (log != null) {
                        log.log((Object)msg);
                    }
                }
            });
        }
        catch (Throwable t) {
            Assert.printStackTrace((Throwable)t);
        }
    }

    void logOutStartBuild(final CompileArguments compileArguments) {
        if (UnifiedBuildSystem.showCompileProgress) {
            this.logOutMsg(msgStart + "\n");
        }
        this.setStatusBarText(msgStart);
        final LogPage log = this.getErrorLog();
        UnifiedBuildSystem.ideLog.registerAsynchronousLogPage(log);
        JCompilerUtils.invokeAsap(new Runnable(){

            @Override
            public void run() {
                try {
                    if (compileArguments.isClearLogBeforeCompile() && (System.getProperty("compiler.log") == null || !System.getProperty("compiler.log").equals("tablestyle"))) {
                        log.clearAll();
                    }
                }
                catch (Throwable t) {
                    JCompiler.this.logOutMsg(CompArb.format(167, t.getMessage()) + "\n");
                }
            }
        });
    }

    private void _logOutEndBuild(int filesBuilt, int buildStatus, Long buildTime) {
        String msg;
        IdeLog ideLog = UnifiedBuildSystem.ideLog;
        if (ideLog == null) {
            return;
        }
        DateFormat timeFormatter = DateFormat.getTimeInstance(2);
        String timeMsg = "[" + timeFormatter.format(new Date()) + "] ";
        if (buildStatus > 0) {
            switch (buildStatus) {
                default: {
                    msg = timeMsg + cleanCompleted;
                    break;
                }
                case 2: {
                    msg = timeMsg + cleanCancelled;
                    break;
                }
                case 3: {
                    msg = timeMsg + cleanAndRefreshCompleted;
                    break;
                }
                case 4: {
                    msg = timeMsg + cleanAndRefreshCancelled;
                }
            }
            if (UnifiedBuildSystem.showCompileProgress) {
                this.logOutMsg(msg + "\n");
            }
            this.setStatusBarText(msg);
        } else if (ideLog.nerrors() + ideLog.nwarnings() > 0) {
            String msgFailure = timeMsg + CompArb.format(62, Integer.toString(ideLog.nerrors()), Integer.toString(ideLog.nwarnings()));
            if (UnifiedBuildSystem.showCompileProgress) {
                this.logOutMsg(msgFailure + "\n");
            }
            this.setStatusBarText(msgFailure);
            ideLog.unregisterAsynchronousLogPage(this.getErrorLog());
        } else {
            msg = timeMsg + (filesBuilt == 0 ? msgNothingToBuild : msgSuccess);
            if (UnifiedBuildSystem.showCompileProgress) {
                this.logOutMsg(msg + "\n");
            }
            this.setStatusBarText(msg);
            ideLog.unregisterAsynchronousLogPage(this.getErrorLog());
        }
        if (UnifiedBuildSystem.showCompileProgress) {
            int msg1 = buildStatus > 0 ? 162 : 161;
            String msg2 = timeMsg + CompArb.format(msg1, buildTime);
            this.logOutMsg(msg2 + "\n");
        }
    }

    private void setStatusBarText(String message) {
        Ide.getStatusBar().setText(message);
    }

    private void logOutEndBuild(final int filesBuilt, final int buildStatus, final long buildTime) {
        JCompilerUtils.invokeAsap(new Runnable(){

            @Override
            public void run() {
                JCompiler.this._logOutEndBuild(filesBuilt, buildStatus, buildTime);
                if (UnifiedBuildSystem.ideLog != null) {
                    UnifiedBuildSystem.ideLog.completed();
                }
            }
        });
    }

    void setDisableProjectUpdates(boolean disableProjectUpdates) {
        this.disableProjectUpdates = disableProjectUpdates;
    }

    boolean getDisableProjectUpdates() {
        return this.disableProjectUpdates;
    }

    public static Logger getLogger() {
        return Logger.getLogger(JCompiler.class.getName());
    }

    private synchronized MarkerLog getMarkerLog() {
        if (this.markerLog == null) {
            this.markerLog = new MarkerLog();
            this.addBuildSystemListener((BuildSystemListener)this.markerLog);
        }
        return this.markerLog;
    }

    public LogPage getErrorLog() {
        if (this.userDefinedErrorLog != null) {
            return this.userDefinedErrorLog;
        }
        if (this.errorLog == null) {
            IdeArgs args = Ide.getIdeArgs();
            if (!Ide.getIdeArgs().getCreateUI()) {
                this.errorLog = new OutputStreamLogPage(System.err);
            } else if (args.hasArg("-make") || args.hasArg("-rebuild")) {
                this.errorLog = new OutputStreamLogPage(System.err);
            } else {
                this.errorLog = System.getProperty("compiler.log") != null && System.getProperty("compiler.log").equals("tablestyle") ? new ProblemsPage() : this.getMarkerLog();
                this.ideErrorLog = this.errorLog;
            }
        }
        return this.errorLog;
    }

    public void registerTranslator(Translator translator) {
        UnifiedBuildSystem.getInstance().registerTranslator(translator);
    }

    public void unregisterTranslator(Translator translator) {
        UnifiedBuildSystem.getInstance().unregisterTranslator(translator);
    }

    @Deprecated
    public void registerNavigable(Navigable navigable) {
    }

    void queueBuildSystemListener(BuildSystemListener listener, Context context, IdeLog ideLog, QueueAction action) {
        this.queuedBuildSystemListeners.add(new QueuedBuildSystemListener(listener, context, ideLog, action));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void finishBuildSystemListener(QueueAction action, BuildSystemListener listener, Context context, IdeLog ideLog) throws BuildSystemVetoException {
        try {
            long startTime = System.nanoTime();
            String title = "";
            try {
                switch (action) {
                    case CLEAN_FINISHED: {
                        listener.cleanFinished(context);
                        title = "BuildSystemListener.cleanFinished";
                        if (!(listener instanceof BuildSystemListener2)) return;
                        ((BuildSystemListener2)listener).setBuildLog(null);
                        return;
                    }
                    case WORKSPACE_CLEAN_FINISHED: {
                        if (!(listener instanceof BuildSystemListener2)) return;
                        ((BuildSystemListener2)listener).workspaceCleanFinished(context.getWorkspace());
                        title = "BuildSystemListener.workspaceCleanFinished";
                        return;
                    }
                    case PROJECT_CLEAN_FINISHED: {
                        if (!(listener instanceof BuildSystemListener2)) return;
                        ((BuildSystemListener2)listener).projectCleanFinished(context.getWorkspace(), context.getProject());
                        title = "BuildSystemListener.projectCleanFinished";
                        return;
                    }
                    case BUILD_FINISHED: {
                        listener.buildFinished(ideLog.nerrors(), ideLog.nwarnings(), 0);
                        title = "BuildSystemListener.buildFinished";
                        if (!(listener instanceof BuildSystemListener2)) return;
                        ((BuildSystemListener2)listener).setBuildLog(null);
                        return;
                    }
                    case WORKSPACE_BUILD_FINISHED: {
                        if (!(listener instanceof BuildSystemListener2)) return;
                        ((BuildSystemListener2)listener).workspaceBuildFinished(context.getWorkspace());
                        title = "BuildSystemListener.workspaceBuildFinished";
                        return;
                    }
                    case PROJECT_BUILD_FINISHED: {
                        if (!(listener instanceof BuildSystemListener2)) return;
                        ((BuildSystemListener2)listener).projectBuildFinished(context.getWorkspace(), context.getProject());
                        title = "BuildSystemListener.projectBuildFinished";
                        return;
                    }
                }
                return;
            }
            finally {
                long endTime = System.nanoTime();
                PerformanceLogger.get().log(title, listener.getClass().getName(), endTime - startTime);
            }
        }
        catch (BuildSystemVetoException bve) {
            ideLog.error(null, 0, 0, 0, "Build System veto exception: " + bve.getMessage());
            throw bve;
        }
        catch (Throwable t) {
            t.printStackTrace();
            ideLog.error(null, 0, 0, 0, "Fatal exception in BuildSystemListener finish calls: " + t.getMessage());
        }
    }

    public int getMakeFolderCmdId() {
        if (this.makeFolderCmdId == 0) {
            Integer cmdId = Ide.findCmdID((String)"MAKE_FOLDER");
            this.makeFolderCmdId = cmdId != null ? cmdId : -1;
        }
        return this.makeFolderCmdId;
    }

    public int getCleanSelectedCmdId() {
        if (this.cleanSelectedCmdId == 0) {
            Integer cmdId = Ide.findCmdID((String)"CLEAN_SELECTED");
            this.cleanSelectedCmdId = cmdId != null ? cmdId : -1;
        }
        return this.cleanSelectedCmdId;
    }

    public int getCancelBuildCmdId() {
        if (this.cancelBuildCmdId == 0) {
            Integer cmdId = Ide.findCmdID((String)"CANCEL_BUILD");
            this.cancelBuildCmdId = cmdId != null ? cmdId : -1;
        }
        return this.cancelBuildCmdId;
    }

    private static class BuildLogImpl
    implements BuildLog {
        boolean allowLogging = true;

        private BuildLogImpl() {
        }

        public void diagnostic(Diagnostic diagnostic) {
            IdeLog ideLog;
            if (this.allowLogging && (ideLog = UnifiedBuildSystem.ideLog) != null) {
                ideLog.diagnostic(diagnostic);
            }
        }
    }

    private static class QueuedBuildSystemListener {
        private BuildSystemListener listener;
        private Context context;
        private IdeLog ideLog;
        private QueueAction action;

        private QueuedBuildSystemListener(BuildSystemListener listener, Context context, IdeLog ideLog, QueueAction action) {
            this.listener = listener;
            this.context = context;
            this.ideLog = ideLog;
            this.action = action;
        }

        private void finishBuildSystemListener() {
            try {
                JCompiler.finishBuildSystemListener(this.action, this.listener, this.context, this.ideLog);
            }
            catch (BuildSystemVetoException buildSystemVetoException) {
                // empty catch block
            }
        }
    }

    static enum QueueAction {
        BUILD_WILL_START,
        BUILD_FINISHED,
        CLEAN_WILL_START,
        CLEAN_FINISHED,
        WORKSPACE_BUILD_WILL_START,
        WORKSPACE_BUILD_FINISHED,
        WORKSPACE_CLEAN_WILL_START,
        WORKSPACE_CLEAN_FINISHED,
        PROJECT_BUILD_WILL_START,
        PROJECT_BUILD_FINISHED,
        PROJECT_CLEAN_WILL_START,
        PROJECT_CLEAN_FINISHED;

    }
}

