/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.compiler;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import javax.swing.text.Segment;
import oracle.ide.natives.NativeHandler;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.buffer.ReadTextBuffer;

@Deprecated
class InputReadTextBuffer
implements ReadTextBuffer {
    public static long readTime = 0L;
    public static int totalLineCount = 0;
    public static int averageLineCount = 0;
    private static int bufferCount = 0;
    private char[] buffer;

    InputReadTextBuffer() {
    }

    private static int countLines(char[] buffer) {
        int line = buffer.length > 0 ? 1 : 0;
        for (int i = 0; i < buffer.length - 1; ++i) {
            if (buffer[i] != '\n') continue;
            ++line;
        }
        return line;
    }

    static char[] resizeCharBuf(char[] buf, int newsize) {
        char[] newbuf = new char[newsize];
        System.arraycopy(buf, 0, newbuf, 0, buf.length < newsize ? buf.length : newsize);
        return newbuf;
    }

    static InputReadTextBuffer init(URL url) {
        try {
            long ms = NativeHandler.getHiPerfTick();
            InputStream fis = URLFileSystem.openInputStream((URL)url);
            InputStreamReader isr = new InputStreamReader(fis);
            InputReadTextBuffer res = new InputReadTextBuffer();
            res.buffer = new char[16384];
            int index = 0;
            while (true) {
                int read;
                if ((read = isr.read(res.buffer, index, 16384)) < 16384) {
                    if (read <= 0) break;
                    res.buffer = InputReadTextBuffer.resizeCharBuf(res.buffer, index + read);
                    break;
                }
                res.buffer = InputReadTextBuffer.resizeCharBuf(res.buffer, (index += read) + 16384);
            }
            readTime += NativeHandler.getHiPerfTick() - ms;
            averageLineCount = (totalLineCount += InputReadTextBuffer.countLines(res.buffer)) / ++bufferCount;
            return res;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public int getLength() {
        return this.buffer.length;
    }

    public char getChar(int offset) throws IndexOutOfBoundsException {
        if (offset < 0 || offset >= this.buffer.length) {
            throw new IndexOutOfBoundsException();
        }
        return this.buffer[offset];
    }

    public char[] getChars(int offset, int length) throws IndexOutOfBoundsException {
        if (offset + length < 0 || offset + length > this.buffer.length) {
            throw new IndexOutOfBoundsException();
        }
        char[] res = new char[length];
        System.arraycopy(this.buffer, offset, res, 0, length);
        return res;
    }

    public String getString(int offset, int length) throws IndexOutOfBoundsException {
        if (offset + length < 0 || offset + length > this.buffer.length) {
            throw new IndexOutOfBoundsException();
        }
        return new String(this.buffer, offset, length);
    }

    public void getText(int offset, int length, Segment segment) throws IndexOutOfBoundsException {
        segment.array = this.buffer;
        segment.offset = offset;
        segment.count = length;
    }

    public void readLock() {
    }

    public void readLockInterruptibly() {
    }

    public boolean tryReadLock() {
        return true;
    }

    public int getLockStatus() {
        return -1;
    }

    public void readUnlock() {
    }
}

