/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.plugin.common;

import oracle.dbtools.migration.workbench.plugin.common.NumericAttrib;
import oracle.dbtools.migration.workbench.plugin.common.PHKey;
import oracle.dbtools.migration.workbench.plugin.common.TextAttrib;

public class MsAccessRegistry {
    public static final int HKEY_CLASSES_ROOT = Integer.MIN_VALUE;
    public static final int HKEY_CURRENT_USER = -2147483647;
    public static final int HKEY_LOCAL_MACHINE = -2147483646;
    public static final int HKEY_USERS = -2147483645;
    public static final int HKEY_PERFORMANCE_DATA = -2147483644;
    public static final int HKEY_CURRENT_CONFIG = -2147483643;
    public static final int HKEY_DYN_DATA = -2147483642;
    public static final int KEY_QUERY_VALUE = 1;
    public static final int KEY_SET_VALUE = 2;
    public static final int KEY_CREATE_SUB_KEY = 4;
    public static final int KEY_ENUMERATE_SUB_KEYS = 8;
    public static final int KEY_NOTIFY = 16;
    public static final int KEY_CREATE_LINK = 32;
    public static final int KEY_WRITE = 131078;
    public static final int KEY_EXECUTE = 131097;
    public static final int KEY_READ = 131097;
    public static final int KEY_ALL_ACCESS = 983103;
    public static final int REG_NONE = 0;
    public static final int REG_SZ = 1;
    public static final int REG_EXPAND_SZ = 2;
    public static final int REG_BINARY = 3;
    public static final int REG_DWORD = 4;
    public static final int REG_DWORD_LITTLE_ENDIAN = 4;
    public static final int REG_DWORD_BIG_ENDIAN = 5;
    public static final int REG_LINK = 6;
    public static int REG_MULTI_SZ = 7;
    public static int REG_RESOURCE_LIST = 8;
    public static int REG_FULL_RESOURCE_DESCRIPTOR = 9;
    public static int REG_RESOURCE_REQUIREMENTS_LIST = 10;
    public static final int REG_OPTION_NON_VOLATILE = 0;
    public static final int REG_OPTION_VOLATILE = 1;
    public static final int REG_OPTION_BACKUP_RESTORE = 4;
    public static final int ERROR_SUCCESS = 0;

    public MsAccessRegistry() throws Exception {
        try {
            System.loadLibrary("registry");
            System.loadLibrary("mfcdao");
        }
        catch (Error error) {
            throw new Exception(error.getMessage());
        }
    }

    private native String _getWindowsDirectory();

    private native String _getWindowsSystemDirectory();

    private native long _regOpenKeyEx(int var1, String var2, long var3, int var5, PHKey var6);

    private native long _regCloseKey(int var1);

    private native long _regDeleteKey(int var1, String var2);

    private native long _regDeleteValue(int var1, String var2);

    private native long _regSetValueEx(int var1, String var2, int var3, int var4, String var5, int var6);

    private native long _regSetValueEx(int var1, String var2, int var3, int var4, int var5);

    private native long _regSetValueEx(int var1, String var2, int var3, int var4, byte var5);

    private native long _regCreateKeyEx(int var1, String var2, int var3, String var4, int var5, int var6, String var7, PHKey var8, NumericAttrib var9);

    private native long _regEnumValue(int var1, int var2, TextAttrib var3, NumericAttrib var4, NumericAttrib var5, NumericAttrib var6, TextAttrib var7, NumericAttrib var8);

    private native long _regEnumKeyEx(int var1, int var2, TextAttrib var3, NumericAttrib var4, NumericAttrib var5, TextAttrib var6, NumericAttrib var7, NumericAttrib var8);

    private native boolean _jni_dao35_installed();

    private native boolean m_MigrationDao36_installed();

    public long regOpenKeyEx(int n, String string, long l, int n2, PHKey pHKey) {
        long l2 = this._regOpenKeyEx(n, string, l, n2, pHKey);
        return l2;
    }

    public long regCloseKey(PHKey pHKey) {
        int n = pHKey.get();
        long l = this._regCloseKey(n);
        return l;
    }

    public long regDeleteKey(PHKey pHKey, String string) {
        int n = pHKey.get();
        long l = this._regDeleteKey(n, string);
        return l;
    }

    public long regDeleteValue(PHKey pHKey, String string) {
        int n = pHKey.get();
        long l = this._regDeleteValue(n, string);
        return l;
    }

    public long regEnumValue(PHKey pHKey, int n, TextAttrib textAttrib, NumericAttrib numericAttrib, NumericAttrib numericAttrib2, NumericAttrib numericAttrib3, TextAttrib textAttrib2, NumericAttrib numericAttrib4) {
        int n2 = pHKey.get();
        long l = this._regEnumValue(n2, n, textAttrib, numericAttrib, numericAttrib2, numericAttrib3, textAttrib2, numericAttrib4);
        return l;
    }

    public long regEnumKeyEx(PHKey pHKey, int n, TextAttrib textAttrib, NumericAttrib numericAttrib, NumericAttrib numericAttrib2, TextAttrib textAttrib2, NumericAttrib numericAttrib3, NumericAttrib numericAttrib4) {
        int n2 = pHKey.get();
        long l = this._regEnumKeyEx(n2, n, textAttrib, numericAttrib, numericAttrib2, textAttrib2, numericAttrib3, numericAttrib4);
        return l;
    }

    public long regSetValueEx(PHKey pHKey, String string, int n, int n2, String string2, int n3) {
        int n4 = pHKey.get();
        long l = this._regSetValueEx(n4, string, n, n2, string2, n3);
        return l;
    }

    public long regSetTextValueEx(PHKey pHKey, String string, int n, String string2, int n2) {
        int n3 = pHKey.get();
        long l = this._regSetValueEx(n3, string, n, 1, string2, n2);
        return l;
    }

    public long regSetNumericValueEx(PHKey pHKey, String string, int n, int n2) {
        int n3 = pHKey.get();
        long l = this._regSetValueEx(n3, string, n, 4, n2);
        return l;
    }

    public long regSetBinaryValueEx(PHKey pHKey, String string, int n, byte by) {
        int n2 = pHKey.get();
        long l = this._regSetValueEx(n2, string, n, 3, by);
        return l;
    }

    public long regCreateKeyEx(int n, String string, int n2, String string2, int n3, int n4, String string3, PHKey pHKey, NumericAttrib numericAttrib) {
        long l = this._regCreateKeyEx(n, string, n2, string2, n3, n4, string3, pHKey, numericAttrib);
        return l;
    }

    public boolean isDao35Installed() {
        boolean bl = false;
        bl = this._jni_dao35_installed();
        return bl;
    }

    public String getWindowsDirectory() {
        String string = this._getWindowsDirectory();
        return string;
    }

    public String getWindowsSystemDirectory() {
        String string = this._getWindowsSystemDirectory();
        return string;
    }

    public boolean isDao36Installed() {
        boolean bl = false;
        bl = this.m_MigrationDao36_installed();
        return bl;
    }
}

