/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.plugin;

import java.text.MessageFormat;
import java.util.logging.Logger;
import oracle.dbtools.metadata.persistence.MdColumn;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.migration.convert.AbstractConverter;
import oracle.dbtools.migration.convert.ConvertException;
import oracle.dbtools.migration.convert.ConvertResult;
import oracle.dbtools.migration.convert.ConvertResultImpl;
import oracle.dbtools.migration.convert.ObjectTranslationList;
import oracle.dbtools.migration.parser.ParserFactoryProvider;
import oracle.dbtools.migration.translation.api.ITranslator;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.plugin.Messages;

public class MSAccessConverter
extends AbstractConverter {
    public ITranslator getPlaformTranslator() {
        return ParserFactoryProvider.getInstance().getParser("oracle.dbtools.migration.parser.msaccess.MSAccessParserMain");
    }

    public String getDefaultValueMappingXML() {
        return "MSAccessDefaultValuesMappingRules.xml";
    }

    public ConvertResult convertObject(PersistableObject persistableObject, String string, PersistenceManager persistenceManager) throws ConvertException {
        ConvertResultImpl convertResultImpl = null;
        if (string.equals("ACCESS_HAS_DEFAULT")) {
            Object object;
            MdColumn mdColumn = (MdColumn)persistableObject;
            if (mdColumn.getColumnType().equals("VARCHAR2") || mdColumn.getColumnType().equals("BLOB")) {
                String string2 = mdColumn.getDefaultValue();
                if (string2 != null) {
                    if (string2.indexOf("'") == -1) {
                        mdColumn.setDefaultValue("'" + string2 + "'");
                    }
                    if (string2.startsWith("=")) {
                        mdColumn.setDefaultValue("");
                        Logger logger = Logger.getLogger("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle");
                        String string3 = MessageFormat.format(Messages.getString("MSAccessConverter.1"), string2, mdColumn.getObjectName());
                        logger.severe(string3);
                    }
                }
            } else if (mdColumn.getColumnType().equals("DATE") && (object = mdColumn.getDefaultValue()) != null && !((String)object).trim().equals("") && ((String)object).indexOf("#") != -1) {
                object = ((String)object).replaceAll("#", "");
                object = ((String)object).replaceAll("=", "");
                object = "'" + ((String)object).trim() + "'";
                String string4 = MigrationAddin.getMigrationConfig().getDateOfflineDateMask();
                object = "TO_DATE(" + (String)object + ",'" + string4 + "')";
                mdColumn.setDefaultValue((String)object);
            }
            convertResultImpl = new ConvertResultImpl(persistableObject);
        }
        return convertResultImpl;
    }

    public String[] getPropertyKeyList() {
        return new String[]{"ACCESS_HAS_DEFAULT"};
    }

    public String getEmulationPkgName() {
        return "msaccess_utilities";
    }

    public ObjectTranslationList getSupportedTranslationObjects() {
        return null;
    }
}

