/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.wizzards.datapump.imp;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.dbtools.extract.models.ExtractListModel;
import oracle.dbtools.raptor.dba.navigator.wizzards.datapump.DpWizCommon;
import oracle.dbtools.raptor.dba.navigator.wizzards.datapump.DpWizardArb;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;

public class ImpRemapUI
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JScrollPane _scrollPane;
    private JComboBox _localCombo = new JComboBox();
    private JTable _table;
    private DefaultTableModel _model = new DefaultTableModel();
    private ExtractListModel _listModel = null;
    private String _storage;
    private String _label;

    public ImpRemapUI(String string, String string2) {
        this._label = string;
        this._storage = string2;
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            ExceptionHandler.handleException((Throwable)exception);
        }
    }

    private String[] getCurrentLHS() {
        List list = null;
        Object var2_2 = null;
        String[] stringArray = null;
        String string = null;
        if (this._storage.equals("IMP_SCHEMAS_STORAGE")) {
            string = "USER";
            list = (List)this._listModel.getPropertyValue("IMP_SCHEMA_RAW");
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Map map : list) {
                arrayList.add((String)map.get("ORIGINAL_OBJECT_NAME"));
            }
            stringArray = new String[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                stringArray[i] = (String)arrayList.get(i);
            }
            return stringArray;
        }
        if (this._storage.equals("IMP_DATAFILES_STORAGE")) {
            string = "DATAFILE";
            return null;
        }
        if (this._storage.equals("IMP_TABLESPACES_STORAGE")) {
            string = "TABLESPACE";
            list = (List)this._listModel.getPropertyValue("IMP_TABLESPACE_RAW");
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Map map : list) {
                arrayList.add((String)map.get("OBJECT_TABLESPACE"));
            }
            stringArray = new String[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                stringArray[i] = (String)arrayList.get(i);
            }
            return stringArray;
        }
        return stringArray;
    }

    private void jbInit() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        this.setLayout(new GridBagLayout());
        this.setBorder(new TitledBorder(null, this._label, 0, 0, null, null));
        this._scrollPane = new JScrollPane();
        this.add((Component)this._scrollPane, new GridBagConstraints(0, 0, 4, 4, 0.0, 0.0, 17, 1, new Insets(3, 3, 0, 0), 0, 3));
        this._model.addColumn(DpWizardArb.getString("IMP_ORIGINAL"));
        this._model.addColumn(DpWizardArb.getString("IMP_ALTER"));
        this._table = new JTable(this._model);
        this._table.setShowGrid(true);
        TableColumn tableColumn = null;
        for (int i = 0; i < 2; ++i) {
            tableColumn = this._table.getColumnModel().getColumn(i);
            tableColumn.setPreferredWidth(100);
        }
        this._scrollPane.setViewportView(this._table);
        this._scrollPane.setPreferredSize(new Dimension(80, 50));
        JButton jButton = new JButton();
        jButton.setText(DpWizardArb.getString("EXP_ADD_ROW"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ImpRemapUI.this._localCombo != null && ImpRemapUI.this._localCombo.getItemCount() > 0) {
                    ImpRemapUI.this.addRow((String)ImpRemapUI.this._localCombo.getItemAt(0), "");
                } else {
                    ImpRemapUI.this.addRow("", "");
                }
                if (ImpRemapUI.this._table.getRowCount() != 0) {
                    ImpRemapUI.this._table.setRowSelectionInterval(ImpRemapUI.this._table.getRowCount() - 1, ImpRemapUI.this._table.getRowCount() - 1);
                }
                ImpRemapUI.this._table.setColumnSelectionInterval(0, 0);
                ImpRemapUI.this.validate();
            }
        });
        this._table.setDefaultRenderer(Object.class, new DefaultTableCellRenderer(){

            @Override
            public void setValue(Object object) {
                super.setValue(object);
                if (object != null) {
                    this.setToolTipText(object.toString());
                }
            }
        });
        this.add((Component)jButton, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 0, 0), 0, 0));
        JButton jButton2 = new JButton();
        jButton2.setText(DpWizardArb.getString("EXP_REMOVE_ROW"));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = ImpRemapUI.this._table.getSelectedRow();
                int n2 = ImpRemapUI.this._table.getSelectedColumn();
                while (n > -1 && n2 > -1) {
                    if (ImpRemapUI.this._table.isEditing()) {
                        ImpRemapUI.this._table.getCellEditor(n, n2).stopCellEditing();
                    }
                    ImpRemapUI.this._model.removeRow(n);
                    n = ImpRemapUI.this._table.getSelectedRow();
                }
            }
        });
        this.add((Component)jButton2, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 5, 0, 120), 0, 0));
        this.add(Box.createHorizontalGlue(), new GridBagConstraints(2, 4, 2, 1, 10.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        int n = 0;
        TableColumn tableColumn2 = this._table.getColumnModel().getColumn(n);
    }

    public void addRow(String string, String string2) {
        this._model.addRow(new String[]{string, string2});
        this._model.fireTableDataChanged();
        this._table.revalidate();
        if (this._model.getRowCount() < 3) {
            this._scrollPane.setViewportView(this._table);
        }
    }

    public void onEntry(TraversableContext traversableContext) {
        this._listModel = (ExtractListModel)traversableContext.get("KEY_EXPORT_OBJECTS");
        ArrayList arrayList = (ArrayList)DpWizCommon.getOrInitializeList(this._listModel, this._storage, new ArrayList());
        boolean bl = false;
        DefaultTableModel defaultTableModel = new DefaultTableModel(new String[]{DpWizardArb.getString("IMP_ORIGINAL"), DpWizardArb.getString("IMP_ALTER")}, 0);
        for (Object[] objectArray : arrayList) {
            defaultTableModel.addRow(objectArray);
        }
        String[] stringArray = null;
        stringArray = this.getCurrentLHS();
        this._localCombo.removeAllItems();
        if (stringArray != null) {
            for (String string : stringArray) {
                this._localCombo.addItem(string.toString());
            }
        }
        int n = 0;
        TableColumn tableColumn = this._table.getColumnModel().getColumn(n);
        if (stringArray != null) {
            tableColumn.setCellEditor(new DefaultCellEditor(this._localCombo));
        } else {
            tableColumn.setCellEditor(new DefaultCellEditor(new JTextField()));
        }
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        if (this._table.getCellEditor() != null) {
            this._table.getCellEditor().stopCellEditing();
        }
        TableModel tableModel = this._table.getModel();
        int n = tableModel.getRowCount();
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        int n2 = -1;
        for (int i = 0; i < n; ++i) {
            if ((String)tableModel.getValueAt(i, 0) == null || ((String)tableModel.getValueAt(i, 0)).equals("")) {
                n2 = i;
                break;
            }
            if ((String)tableModel.getValueAt(i, 1) == null || ((String)tableModel.getValueAt(i, 1)).equals("")) {
                n2 = i;
                break;
            }
            arrayList.add(new String[]{(String)tableModel.getValueAt(i, 0), (String)tableModel.getValueAt(i, 1)});
        }
        if (traversableContext.getDirection() == 1 && n2 != -1) {
            throw new TraversalException(DpWizardArb.format("IMP_EMPTY", n2 + 1), this._label);
        }
        this._listModel.setProperty(this._storage, arrayList);
    }
}

