/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.wizzards.datapump.exp;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import oracle.bali.ewt.border.TitledPane;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.extract.models.ExtractListModel;
import oracle.dbtools.raptor.dba.navigator.wizzards.datapump.DpWizCommon;
import oracle.dbtools.raptor.dba.navigator.wizzards.datapump.DpWizardArb;
import oracle.dbtools.raptor.dba.navigator.wizzards.datapump.exp.CopyFilesPane;
import oracle.dbtools.raptor.dba.navigator.wizzards.datapump.exp.DpExpWizMain;
import oracle.dbtools.raptor.dba.navigator.wizzards.datapump.exp.OutputDirectoriesUI;
import oracle.dbtools.raptor.ui.UiResources;
import oracle.dbtools.raptor.utils.LicenseUtils;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;

public class DpExpWizOutputFiles
extends DefaultTraversablePanel {
    private String[] _gotDirectories = null;
    private static final long serialVersionUID = 1L;
    private OutputDirectoriesUI _oUI = new OutputDirectoriesUI();
    private ExtractListModel _listModel = null;
    protected final JCheckBox _cbGoToSummary = new JCheckBox();
    private JCheckBox _reuse = null;
    private JCheckBox _appendSysdate = null;
    private JCheckBox _ossTransfer = null;
    private JCheckBox _compressionAll = new JCheckBox(DpWizardArb.getString("COMPRESSION_ALL"));
    private JCheckBox _transparent = new JCheckBox(DpWizardArb.getString("EXP_TRANSPARENT"));
    private JCheckBox _encryption = new JCheckBox(DpWizardArb.getString("EXP_ENCRYPTION"));
    private JPasswordField _encryptionPassword = new JPasswordField(20);
    private JLabel _encryptionLabel = new JLabel(DpWizardArb.getString("EXP_PASSWORD"));
    private boolean _isShowGoToSummary = true;
    private JCheckBox _toEnable = new JCheckBox(DpWizardArb.getString("EXP_OSS_TRANSFER_OPTIONS"));
    private CopyFilesPane _cfp = new CopyFilesPane(this._oUI);
    private JLabel _borderLabel = new JLabel(DpWizardArb.getString("EXP_FILE_ACTIONS"));
    private JPanel _addCheckboxes = new JPanel();
    private JPanel _fileActions = this.createFileActions();
    private JPanel _jpe = new JPanel();

    JPanel createFileActions() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        this._addCheckboxes.setLayout(new GridBagLayout());
        jPanel2.add((Component)this._addCheckboxes, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        TitledPane titledPane = new TitledPane((Component)this._borderLabel, (Component)jPanel2);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        jPanel3.add((Component)titledPane, "Center");
        jPanel.add((Component)jPanel3, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 1, new Insets(3, 5, 3, 3), 0, 0));
        jPanel.add(Box.createHorizontalGlue(), new GridBagConstraints(2, 0, 1, 1, 10.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        return jPanel;
    }

    public DpExpWizOutputFiles() {
        this.setLayout(new GridBagLayout());
        this.add(this._oUI, new GridBagConstraints(0, 0, 3, 3, 0.0, 0.0, 18, 1, new Insets(5, 0, 0, 0), 0, 0));
        this._ossTransfer = new JCheckBox(DpWizardArb.getString("EXP_OSS_TRANSFER_OPTIONS"));
        this._ossTransfer.setSelected(false);
        this._reuse = new JCheckBox();
        this._reuse.setSelected(false);
        this._appendSysdate = new JCheckBox();
        this._appendSysdate.setSelected(false);
        this._reuse.setText(DpWizardArb.getString("EXP_OVERWRITE_EXISTING_FILE"));
        this._addCheckboxes.add((Component)this._reuse, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 18, 1, new Insets(5, 5, 0, 0), 0, 0));
        this._appendSysdate.setText(DpWizardArb.getString("EXP_APPEND_SYSDATE_LABEL"));
        this._addCheckboxes.add((Component)this._appendSysdate, new GridBagConstraints(0, 1, 3, 1, 0.0, 0.0, 18, 1, new Insets(5, 5, 0, 0), 0, 0));
        this._addCheckboxes.add((Component)this._compressionAll, new GridBagConstraints(0, 2, 3, 1, 0.0, 0.0, 18, 1, new Insets(5, 5, 0, 0), 0, 0));
        this._compressionAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (DpExpWizOutputFiles.this._compressionAll.isSelected()) {
                    DpExpWizOutputFiles.this._compressionAll.setSelected(LicenseUtils.requiresLicense((String)"AdvancedCompression", (String)((String)DpExpWizOutputFiles.this._listModel.getPropertyValue("KEY_CNAME")), (boolean)false));
                }
            }
        });
        this._encryptionLabel.setLabelFor(this._encryptionPassword);
        this._jpe.removeAll();
        this._jpe.setLayout(new GridBagLayout());
        this._jpe.add((Component)this._encryption, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 1, new Insets(5, 0, 0, 0), 0, 0));
        this._jpe.add((Component)this._encryptionLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 1, new Insets(5, 5, 0, 5), 0, 0));
        this._jpe.add((Component)this._encryptionPassword, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 18, 1, new Insets(5, 0, 0, 0), 0, 0));
        this._encryptionPassword.setMaximumSize(new Dimension(80, 20));
        this._encryptionPassword.setPreferredSize(new Dimension(80, 20));
        this._encryptionPassword.setMinimumSize(new Dimension(50, 15));
        this._jpe.add((Component)this._transparent, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 18, 1, new Insets(5, 5, 0, 0), 10, 0));
        this._jpe.add(Box.createHorizontalGlue(), new GridBagConstraints(4, 0, 1, 1, 10.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this._addCheckboxes.add((Component)this._jpe, new GridBagConstraints(0, 3, 3, 1, 0.0, 0.0, 18, 1, new Insets(0, 5, 5, 0), 0, 0));
        this.add(this._fileActions, new GridBagConstraints(0, 3, 4, 1, 0.0, 0.0, 17, 1, new Insets(5, 0, 0, 0), 0, 0));
        this._encryption.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (DpExpWizOutputFiles.this._encryption.isSelected()) {
                    DpExpWizOutputFiles.this._encryption.setSelected(LicenseUtils.requiresLicense((String)"AdvancedSecurity", (String)((String)DpExpWizOutputFiles.this._listModel.getPropertyValue("KEY_CNAME")), (boolean)false));
                }
                DpExpWizOutputFiles.this.encryptionDo(DpExpWizOutputFiles.this._encryption.isSelected(), DpExpWizOutputFiles.this._encryptionLabel, DpExpWizOutputFiles.this._encryptionPassword, DpExpWizOutputFiles.this._transparent);
            }
        });
        this.add(this._toEnable, new GridBagConstraints(0, 8, 3, 1, 0.0, 0.0, 18, 1, new Insets(5, 0, 0, 0), 0, 0));
        this.add(this._cfp, new GridBagConstraints(0, 9, 3, 1, 0.0, 0.0, 17, 1, new Insets(5, 0, 0, 0), 0, 0));
        this.add(Box.createHorizontalGlue(), new GridBagConstraints(4, 0, 1, 1, 10.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(Box.createVerticalGlue(), new GridBagConstraints(0, 10, 1, 1, 0.0, 10.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        if (this._isShowGoToSummary) {
            ResourceUtils.resButton((AbstractButton)this._cbGoToSummary, (String)StringUtils.stripMnemonic((String)UiResources.getString((String)"GOTO_SUMMARY")));
            this.add(this._cbGoToSummary, new GridBagConstraints(0, 11, 4, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        }
        this._toEnable.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    DpExpWizOutputFiles.this._cfp.setLocalEnabled(true);
                } else {
                    DpExpWizOutputFiles.this._cfp.setLocalEnabled(false);
                }
            }
        });
        this.validate();
    }

    protected void encryptionDo(boolean bl, JLabel jLabel, JPasswordField jPasswordField, JCheckBox jCheckBox) {
        for (JComponent jComponent : new JComponent[]{jLabel, jPasswordField, jCheckBox}) {
            jComponent.setEnabled(bl);
        }
    }

    public String[] getDirectories(TraversableContext traversableContext) {
        this._gotDirectories = (String[])DpWizCommon.getOrInitializeList(this._listModel, "DP_EXP_DIRECTORIES", new String[0]);
        return this._gotDirectories;
    }

    public void onEntry(TraversableContext traversableContext) {
        ExtractListModel extractListModel = (ExtractListModel)DpExpWizMain.getOrInitializeContext(traversableContext, "KEY_EXPORT_OBJECTS", new ExtractListModel());
        if (traversableContext.getDirection() == 1 && ((Boolean)DpWizCommon.getOrInitializeList(extractListModel, "SKIP_TO_OSS", Boolean.FALSE)).booleanValue()) {
            traversableContext.getWizardCallbacks().wizardSkipCurrentStep();
        }
        this._listModel = (ExtractListModel)traversableContext.get("KEY_EXPORT_OBJECTS");
        super.onEntry(traversableContext);
        this._gotDirectories = null;
        this._oUI.setDirectories(this.getDirectories(traversableContext));
        this._oUI.onEntry(traversableContext);
        this._cfp.onEntry(traversableContext);
        if (((Boolean)DpWizCommon.getOrInitializeList(this._listModel, "EXP_EXP_OSSTRANSFER_ENABLED", Boolean.FALSE)).equals(Boolean.TRUE)) {
            this._toEnable.setSelected(true);
            this._cfp.setLocalEnabled(true);
        } else {
            this._toEnable.setSelected(false);
            this._cfp.setLocalEnabled(false);
        }
        Boolean bl = (Boolean)DpWizCommon.getOrInitializeList(this._listModel, "EXP_COMPRESSION_ALL", null);
        if (bl == null) {
            bl = LicenseUtils.requiresLicense((String)"AdvancedCompression", (String)((String)this._listModel.getPropertyValue("KEY_CNAME")), (boolean)false);
            this._listModel.setProperty("EXP_COMPRESSION_ALL", (Object)bl);
        }
        this._compressionAll.setSelected(bl);
        this._reuse.setSelected(((Boolean)DpWizCommon.getOrInitializeList(this._listModel, "DP_REUSEDUMP_FILE", Boolean.FALSE)).equals(Boolean.TRUE));
        this._appendSysdate.setSelected(((Boolean)DpWizCommon.getOrInitializeList(this._listModel, "DP_APPENDSYSDATEDUMPFILE", Boolean.TRUE)).equals(Boolean.TRUE));
        this._cbGoToSummary.setSelected(false);
        Version version = (Version)this._listModel.getPropertyValue("EXP_VERSION");
        this._reuse.setEnabled(true);
        Boolean bl2 = (Boolean)DpWizCommon.getOrInitializeList(this._listModel, "EXP_ENCRYPTION_TRANSPARENT", Boolean.FALSE);
        this._encryptionPassword.setText(String.valueOf((char[])DpWizCommon.getOrInitializeList(this._listModel, "EXP_ENCRYPTION_PASSWORD", new char[0])));
        this._transparent.setSelected(bl2);
        char[] cArray = this._encryptionPassword.getPassword();
        if (cArray == null) {
            cArray = new char[]{};
        }
        this._encryption.setSelected((Boolean)DpWizCommon.getOrInitializeList(this._listModel, "EXP_ENCRYPT_ENABLE", Boolean.FALSE));
        this.encryptionDo((Boolean)DpWizCommon.getOrInitializeList(this._listModel, "EXP_ENCRYPT_ENABLE", Boolean.FALSE), this._encryptionLabel, this._encryptionPassword, this._transparent);
        traversableContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false));
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        super.onExit(traversableContext);
        if (this._appendSysdate.isSelected()) {
            this._listModel.setProperty("DP_APPENDSYSDATEDUMPFILE", (Object)Boolean.TRUE);
        } else {
            this._listModel.setProperty("DP_APPENDSYSDATEDUMPFILE", (Object)Boolean.FALSE);
        }
        this._cfp.onExit(traversableContext);
        this._oUI.onExit(traversableContext);
        Boolean bl = Boolean.FALSE;
        if (this._toEnable.isSelected()) {
            bl = Boolean.TRUE;
        }
        this._listModel.setProperty("EXP_EXP_OSSTRANSFER_ENABLED", (Object)bl);
        if (this._reuse.isSelected()) {
            this._listModel.setProperty("DP_REUSEDUMP_FILE", (Object)Boolean.TRUE);
        } else {
            this._listModel.setProperty("DP_REUSEDUMP_FILE", (Object)Boolean.FALSE);
        }
        this._listModel.setProperty("EXP_COMPRESSION_ALL", (Object)this._compressionAll.isSelected());
        Boolean bl2 = Boolean.FALSE;
        if (this._transparent.isSelected()) {
            bl2 = Boolean.TRUE;
        }
        this._listModel.setProperty("EXP_ENCRYPTION_TRANSPARENT", (Object)bl2);
        char[] cArray = this._encryptionPassword.getPassword();
        if (cArray == null) {
            cArray = new char[]{};
        }
        this._listModel.setProperty("EXP_ENCRYPTION_PASSWORD", (Object)cArray);
        this._listModel.setProperty("EXP_ENCRYPT_ENABLE", (Object)this._encryption.isSelected());
        if (traversableContext.getDirection() == 1 && this._encryption.isSelected() && (bl2.booleanValue() || cArray.length > 0)) {
            this._listModel.setProperty("DP_EXP_RBIMMEDIATE", (Object)Boolean.TRUE);
        }
    }

    private boolean isCopyScreen() {
        return this._toEnable.isSelected();
    }

    public Object getExitTransition() {
        if (this.isCopyScreen()) {
            return "TRANSOSSTransfer";
        }
        if (this._cbGoToSummary.isSelected()) {
            return "Fin";
        }
        return "TRANSScheduleOptions";
    }
}

