/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.metrics.preference;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JSlider;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.dba.navigator.metrics.DbaMetricsArb;
import oracle.dbtools.raptor.metrics.engine.DXIds;
import oracle.dbtools.raptor.metrics.engine.DXService;
import oracle.ide.config.Preferences;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.PropertyStorage;

public class PreferencePanel
extends DefaultTraversablePanel {
    private static final long serialVersionUID = 0L;
    private JComboBox durationCombo = new JComboBox();
    private JSlider poolSizeSlider = new JSlider(1, 5);

    public void onEntry(TraversableContext traversableContext) {
        DBConfig dBConfig = DBConfig.getInstance((TraversableContext)traversableContext);
        GraphDuration graphDuration = GraphDuration.fromMinutes(dBConfig.getInt("INSTANCE_VIEWER_GRAPH_DURATION"));
        this.durationCombo.setSelectedItem((Object)graphDuration);
        EngineHSA engineHSA = new EngineHSA();
        int n = engineHSA.getInt(DXIds.newTypeId((String)"sql", (String)"DbSql"), "connectionCount", 1);
        this.poolSizeSlider.setValue(n);
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        DBConfig dBConfig = DBConfig.getInstance((TraversableContext)traversableContext);
        GraphDuration graphDuration = (GraphDuration)((Object)this.durationCombo.getSelectedItem());
        dBConfig.putInt("INSTANCE_VIEWER_GRAPH_DURATION", graphDuration.toMinutes());
        EngineHSA engineHSA = new EngineHSA();
        engineHSA.putInt(DXIds.newTypeId((String)"sql", (String)"DbSql"), "connectionCount", this.poolSizeSlider.getValue());
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.durationCombo.addItem(GraphDuration.TWO_MINUTES);
        this.durationCombo.addItem(GraphDuration.FIVE_MINUTES);
        this.durationCombo.addItem(GraphDuration.TEN_MINUTES);
        this.durationCombo.addItem(GraphDuration.THIRTY_MINUTES);
        this.durationCombo.addItem(GraphDuration.SIXTY_MINUTES);
        this.poolSizeSlider.setLabelTable(this.poolSizeSlider.createStandardLabels(1));
        this.poolSizeSlider.setPaintLabels(true);
        JLabel jLabel = new JLabel(StringUtils.stripMnemonic((String)DbaMetricsArb.getString("PREFERENCES_GRAPH_DURATION")));
        jLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)DbaMetricsArb.getString("PREFERENCES_GRAPH_DURATION")));
        jLabel.setLabelFor(this.durationCombo);
        this.add(jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add(this.durationCombo, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        JLabel jLabel2 = new JLabel(StringUtils.stripMnemonic((String)DbaMetricsArb.getString("PREFERENCES_GRAPH_POOL_SIZE")));
        jLabel2.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)DbaMetricsArb.getString("PREFERENCES_GRAPH_POOL_SIZE")));
        jLabel2.setLabelFor(this.poolSizeSlider);
        this.add(jLabel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add(this.poolSizeSlider, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add(new JLabel(""), new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public PreferencePanel() {
        this.setHelpID("f1_instanceviewerprefs_html");
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    private static class EngineHSA
    extends HashStructureAdapter {
        EngineHSA() {
            super(EngineHSA.findOrCreate((PropertyStorage)Preferences.getPreferences(), (String)DXService.class.getPackage().getName()));
        }

        int getInt(URI uRI, String string, int n) {
            return this._hash.getInt(this.getHashKey(uRI, string), n);
        }

        void putInt(URI uRI, String string, int n) {
            this._hash.putInt(this.getHashKey(uRI, string), n);
        }

        private String getHashKey(URI uRI, String string) {
            return uRI.toString().replace('/', '+') + "#" + string;
        }
    }

    private static enum GraphDuration {
        TWO_MINUTES(DbaMetricsArb.getString("PREFERENCES_TWO_MINUTES"), 2),
        FIVE_MINUTES(DbaMetricsArb.getString("PREFERENCES_FIVE_MINUTES"), 5),
        TEN_MINUTES(DbaMetricsArb.getString("PREFERENCES_TEN_MINUTES"), 10),
        THIRTY_MINUTES(DbaMetricsArb.getString("PREFERENCES_THIRTY_MINUTES"), 30),
        SIXTY_MINUTES(DbaMetricsArb.getString("PREFERENCES_SIXTY_MINUTES"), 60);

        private final String tag;
        private final int minutes;

        private GraphDuration(String string2, int n2) {
            this.tag = string2;
            this.minutes = n2;
        }

        public String toString() {
            return this.tag;
        }

        int toMinutes() {
            return this.minutes;
        }

        static GraphDuration fromMinutes(int n) {
            switch (n) {
                case 2: {
                    return TWO_MINUTES;
                }
                case 5: {
                    return FIVE_MINUTES;
                }
                case 10: {
                    return TEN_MINUTES;
                }
                case 30: {
                    return THIRTY_MINUTES;
                }
                case 60: {
                    return SIXTY_MINUTES;
                }
            }
            return TWO_MINUTES;
        }
    }
}

